/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.table.Table;

public class Setting
extends DbObjectBase {
    private int intValue;
    private String stringValue;

    public Setting(Database database, int n, String string) {
        super(database, n, string, 10);
    }

    @Override
    public String getSQL(boolean bl) {
        return this.getName();
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return stringBuilder.append(this.getName());
    }

    public void setIntValue(int n) {
        this.intValue = n;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public void setStringValue(String string) {
        this.stringValue = string;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("SET ");
        this.getSQL(stringBuilder, true).append(' ');
        if (this.stringValue != null) {
            stringBuilder.append(this.stringValue);
        } else {
            stringBuilder.append(this.intValue);
        }
        return stringBuilder.toString();
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void removeChildrenAndResources(Session session2) {
        this.database.removeMeta(session2, this.getId());
        this.invalidate();
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("RENAME");
    }
}

