/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectGroups;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.analysis.DataAnalysisOperation;
import org.h2.expression.analysis.WindowFrame;
import org.h2.expression.analysis.WindowFrameBound;
import org.h2.expression.analysis.WindowFrameBoundType;
import org.h2.expression.analysis.WindowFrameExclusion;
import org.h2.expression.analysis.WindowFrameUnits;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public abstract class AbstractAggregate
extends DataAnalysisOperation {
    protected final boolean distinct;
    protected final Expression[] args;
    protected Expression filterCondition;
    protected TypeInfo type;

    AbstractAggregate(Select select, Expression[] expressionArray, boolean bl) {
        super(select);
        this.args = expressionArray;
        this.distinct = bl;
    }

    @Override
    public final boolean isAggregate() {
        return true;
    }

    public void setFilterCondition(Expression expression) {
        this.filterCondition = expression;
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void mapColumnsAnalysis(ColumnResolver columnResolver, int n, int n2) {
        for (Expression expression : this.args) {
            expression.mapColumns(columnResolver, n, n2);
        }
        if (this.filterCondition != null) {
            this.filterCondition.mapColumns(columnResolver, n, n2);
        }
        super.mapColumnsAnalysis(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session2) {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = this.args[i].optimize(session2);
        }
        if (this.filterCondition != null) {
            this.filterCondition = this.filterCondition.optimize(session2);
        }
        return super.optimize(session2);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.args) {
            expression.setEvaluatable(tableFilter, bl);
        }
        if (this.filterCondition != null) {
            this.filterCondition.setEvaluatable(tableFilter, bl);
        }
        super.setEvaluatable(tableFilter, bl);
    }

    @Override
    protected void getOrderedResultLoop(Session session2, HashMap<Integer, Value> hashMap, ArrayList<Value[]> arrayList, int n) {
        int n2;
        boolean bl;
        WindowFrame windowFrame = this.over.getWindowFrame();
        boolean bl2 = bl = windowFrame == null || windowFrame.getUnits() != WindowFrameUnits.ROWS && windowFrame.getExclusion().isGroupOrNoOthers();
        if (windowFrame == null) {
            this.aggregateFastPartition(session2, hashMap, arrayList, n, bl);
            return;
        }
        boolean bl3 = windowFrame.isVariableBounds();
        if (bl3) {
            bl3 = AbstractAggregate.checkVariableBounds(windowFrame, arrayList);
        }
        if (bl3) {
            bl = false;
        } else if (windowFrame.getExclusion() == WindowFrameExclusion.EXCLUDE_NO_OTHERS) {
            WindowFrameBound windowFrameBound = windowFrame.getFollowing();
            int n3 = n2 = windowFrameBound != null && windowFrameBound.getType() == WindowFrameBoundType.UNBOUNDED_FOLLOWING ? 1 : 0;
            if (windowFrame.getStarting().getType() == WindowFrameBoundType.UNBOUNDED_PRECEDING) {
                if (n2 != 0) {
                    this.aggregateWholePartition(session2, hashMap, arrayList, n);
                } else {
                    this.aggregateFastPartition(session2, hashMap, arrayList, n, bl);
                }
                return;
            }
            if (n2 != 0) {
                this.aggregateFastPartitionInReverse(session2, hashMap, arrayList, n, bl);
                return;
            }
        }
        int n4 = arrayList.size();
        n2 = 0;
        while (n2 < n4) {
            Object object = this.createAggregateData();
            Object object2 = WindowFrame.iterator(this.over, session2, arrayList, this.getOverOrderBySort(), n2, false);
            while (object2.hasNext()) {
                this.updateFromExpressions(session2, object, object2.next());
            }
            object2 = this.getAggregatedValue(session2, object);
            n2 = this.processGroup(session2, hashMap, (Value)object2, arrayList, n, n2, n4, object, bl);
        }
    }

    private static boolean checkVariableBounds(WindowFrame windowFrame, ArrayList<Value[]> arrayList) {
        int n;
        Value value;
        int n2;
        int n3 = arrayList.size();
        WindowFrameBound windowFrameBound = windowFrame.getStarting();
        if (windowFrameBound.isVariable()) {
            n2 = windowFrameBound.getExpressionIndex();
            value = arrayList.get(0)[n2];
            for (n = 1; n < n3; ++n) {
                if (value.equals(arrayList.get(n)[n2])) continue;
                return true;
            }
        }
        if ((windowFrameBound = windowFrame.getFollowing()) != null && windowFrameBound.isVariable()) {
            n2 = windowFrameBound.getExpressionIndex();
            value = arrayList.get(0)[n2];
            for (n = 1; n < n3; ++n) {
                if (value.equals(arrayList.get(n)[n2])) continue;
                return true;
            }
        }
        return false;
    }

    private void aggregateFastPartition(Session session2, HashMap<Integer, Value> hashMap, ArrayList<Value[]> arrayList, int n, boolean bl) {
        Object object = this.createAggregateData();
        int n2 = arrayList.size();
        int n3 = -1;
        Value value = null;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = WindowFrame.getEndIndex(this.over, session2, arrayList, this.getOverOrderBySort(), n4);
            assert (n5 >= n3);
            if (n5 > n3) {
                for (int i = n3 + 1; i <= n5; ++i) {
                    this.updateFromExpressions(session2, object, arrayList.get(i));
                }
                n3 = n5;
                value = this.getAggregatedValue(session2, object);
            } else if (value == null) {
                value = this.getAggregatedValue(session2, object);
            }
            n4 = this.processGroup(session2, hashMap, value, arrayList, n, n4, n2, object, bl);
        }
    }

    private void aggregateFastPartitionInReverse(Session session2, HashMap<Integer, Value> hashMap, ArrayList<Value[]> arrayList, int n, boolean bl) {
        Object object = this.createAggregateData();
        int n2 = arrayList.size();
        Value value = null;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            Value[] valueArray;
            int n4 = this.over.getWindowFrame().getStartIndex(session2, arrayList, this.getOverOrderBySort(), n3);
            assert (n4 <= n2);
            if (n4 < n2) {
                for (int i = n2 - 1; i >= n4; --i) {
                    this.updateFromExpressions(session2, object, arrayList.get(i));
                }
                n2 = n4;
                value = this.getAggregatedValue(session2, object);
            } else if (value == null) {
                value = this.getAggregatedValue(session2, object);
            }
            Value[] valueArray2 = valueArray = arrayList.get(n3);
            do {
                hashMap.put(valueArray2[n].getInt(), value);
            } while (--n3 >= 0 && bl && this.overOrderBySort.compare(valueArray, valueArray2 = arrayList.get(n3)) == 0);
        }
    }

    private int processGroup(Session session2, HashMap<Integer, Value> hashMap, Value value, ArrayList<Value[]> arrayList, int n, int n2, int n3, Object object, boolean bl) {
        Value[] valueArray;
        Value[] valueArray2 = valueArray = arrayList.get(n2);
        do {
            hashMap.put(valueArray2[n].getInt(), value);
        } while (++n2 < n3 && bl && this.overOrderBySort.compare(valueArray, valueArray2 = arrayList.get(n2)) == 0);
        return n2;
    }

    private void aggregateWholePartition(Session session2, HashMap<Integer, Value> hashMap, ArrayList<Value[]> arrayList, int n) {
        Object object = this.createAggregateData();
        for (Value[] object2 : arrayList) {
            this.updateFromExpressions(session2, object, object2);
        }
        Value value = this.getAggregatedValue(session2, object);
        for (Value[] valueArray : arrayList) {
            hashMap.put(valueArray[n].getInt(), value);
        }
    }

    protected abstract void updateFromExpressions(Session var1, Object var2, Value[] var3);

    @Override
    protected void updateAggregate(Session session2, SelectGroups selectGroups, int n) {
        ArrayList<SelectOrderBy> arrayList;
        if (this.filterCondition == null || this.filterCondition.getBooleanValue(session2)) {
            if (this.over != null) {
                ArrayList<SelectOrderBy> arrayList2 = this.over.getOrderBy();
                if (arrayList2 != null) {
                    this.updateOrderedAggregate(session2, selectGroups, n, arrayList2);
                } else {
                    this.updateAggregate(session2, this.getWindowData(session2, selectGroups, false));
                }
            } else {
                this.updateAggregate(session2, this.getGroupData(selectGroups, false));
            }
        } else if (this.over != null && (arrayList = this.over.getOrderBy()) != null) {
            this.updateOrderedAggregate(session2, selectGroups, n, arrayList);
        }
    }

    protected abstract void updateAggregate(Session var1, Object var2);

    @Override
    protected void updateGroupAggregates(Session session2, int n) {
        if (this.filterCondition != null) {
            this.filterCondition.updateAggregate(session2, n);
        }
        super.updateGroupAggregates(session2, n);
    }

    @Override
    protected StringBuilder appendTailConditions(StringBuilder stringBuilder, boolean bl) {
        if (this.filterCondition != null) {
            stringBuilder.append(" FILTER (WHERE ");
            this.filterCondition.getSQL(stringBuilder, bl).append(')');
        }
        return super.appendTailConditions(stringBuilder, bl);
    }
}

