/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Subquery;
import org.h2.expression.aggregate.AbstractAggregate;
import org.h2.expression.aggregate.AggregateData;
import org.h2.expression.aggregate.AggregateDataCollecting;
import org.h2.expression.aggregate.AggregateDataDefault;
import org.h2.expression.aggregate.AggregateDataDistinctWithCounts;
import org.h2.expression.aggregate.AggregateDataEnvelope;
import org.h2.expression.aggregate.AggregateType;
import org.h2.expression.aggregate.LongDataCounter;
import org.h2.expression.aggregate.Percentile;
import org.h2.expression.analysis.Window;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVSpatialIndex;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;
import org.h2.value.ValueString;

public class Aggregate
extends AbstractAggregate {
    private static final HashMap<String, AggregateType> AGGREGATES = new HashMap(64);
    private final AggregateType aggregateType;
    private ArrayList<SelectOrderBy> orderByList;
    private SortOrder orderBySort;

    public Aggregate(AggregateType aggregateType, Expression[] expressionArray, Select select, boolean bl) {
        super(select, expressionArray, bl);
        if (bl && aggregateType == AggregateType.COUNT_ALL) {
            throw DbException.throwInternalError();
        }
        this.aggregateType = aggregateType;
    }

    private static void addAggregate(String string, AggregateType aggregateType) {
        AGGREGATES.put(string, aggregateType);
    }

    public static AggregateType getAggregateType(String string) {
        return AGGREGATES.get(string);
    }

    public void setOrderByList(ArrayList<SelectOrderBy> arrayList) {
        this.orderByList = arrayList;
    }

    public AggregateType getAggregateType() {
        return this.aggregateType;
    }

    private void sortWithOrderBy(Value[] valueArray) {
        final SortOrder sortOrder = this.orderBySort;
        if (sortOrder != null) {
            Arrays.sort(valueArray, new Comparator<Value>(){

                @Override
                public int compare(Value value, Value value2) {
                    return sortOrder.compare(((ValueArray)value).getList(), ((ValueArray)value2).getList());
                }
            });
        } else {
            Arrays.sort(valueArray, this.select.getSession().getDatabase().getCompareMode());
        }
    }

    @Override
    protected void updateAggregate(Session session2, Object object) {
        AggregateData aggregateData = (AggregateData)object;
        Value value = this.args.length == 0 ? null : this.args[0].getValue(session2);
        this.updateData(session2, aggregateData, value, null);
    }

    private void updateData(Session session2, AggregateData aggregateData, Value value, Value[] valueArray) {
        switch (this.aggregateType) {
            case LISTAGG: {
                if (value != ValueNull.INSTANCE) {
                    value = this.updateCollecting(session2, value.convertTo(13), valueArray);
                }
                if (this.args.length < 2) break;
                ((AggregateDataCollecting)aggregateData).setSharedArgument(valueArray != null ? valueArray[1] : this.args[1].getValue(session2));
                break;
            }
            case ARRAY_AGG: {
                if (value == ValueNull.INSTANCE) break;
                value = this.updateCollecting(session2, value, valueArray);
                break;
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: {
                int n;
                int n2 = this.args.length;
                Value[] valueArray2 = new Value[n2];
                for (n = 0; n < n2; ++n) {
                    valueArray2[n] = valueArray != null ? valueArray[n] : this.args[n].getValue(session2);
                }
                ((AggregateDataCollecting)aggregateData).setSharedArgument(ValueRow.get(valueArray2));
                valueArray2 = new Value[n2];
                for (n = 0; n < n2; ++n) {
                    valueArray2[n] = valueArray != null ? valueArray[n2 + n] : this.orderByList.get((int)n).expression.getValue(session2);
                }
                value = ValueRow.get(valueArray2);
                break;
            }
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: {
                ((AggregateDataCollecting)aggregateData).setSharedArgument(value);
                value = valueArray != null ? valueArray[1] : this.orderByList.get((int)0).expression.getValue(session2);
                break;
            }
            case MODE: {
                value = valueArray != null ? valueArray[0] : this.orderByList.get((int)0).expression.getValue(session2);
                break;
            }
        }
        aggregateData.add(session2.getDatabase(), value);
    }

    @Override
    protected void updateGroupAggregates(Session session2, int n) {
        super.updateGroupAggregates(session2, n);
        for (Expression expression : this.args) {
            expression.updateAggregate(session2, n);
        }
        if (this.orderByList != null) {
            for (SelectOrderBy selectOrderBy : this.orderByList) {
                selectOrderBy.expression.updateAggregate(session2, n);
            }
        }
    }

    private Value updateCollecting(Session session2, Value value, Value[] valueArray) {
        if (this.orderByList != null) {
            int n = this.orderByList.size();
            Value[] valueArray2 = new Value[1 + n];
            valueArray2[0] = value;
            if (valueArray == null) {
                for (int i = 0; i < n; ++i) {
                    SelectOrderBy selectOrderBy = this.orderByList.get(i);
                    valueArray2[i + 1] = selectOrderBy.expression.getValue(session2);
                }
            } else {
                System.arraycopy(valueArray, 1, valueArray2, 1, n);
            }
            value = ValueArray.get(valueArray2);
        }
        return value;
    }

    @Override
    protected int getNumExpressions() {
        int n = this.args.length;
        if (this.orderByList != null) {
            n += this.orderByList.size();
        }
        if (this.filterCondition != null) {
            ++n;
        }
        return n;
    }

    @Override
    protected void rememberExpressions(Session session2, Value[] valueArray) {
        int n = 0;
        for (Expression expression : this.args) {
            valueArray[n++] = expression.getValue(session2);
        }
        if (this.orderByList != null) {
            for (SelectOrderBy selectOrderBy : this.orderByList) {
                valueArray[n++] = selectOrderBy.expression.getValue(session2);
            }
        }
        if (this.filterCondition != null) {
            valueArray[n] = ValueBoolean.get(this.filterCondition.getBooleanValue(session2));
        }
    }

    @Override
    protected void updateFromExpressions(Session session2, Object object, Value[] valueArray) {
        if (this.filterCondition == null || valueArray[this.getNumExpressions() - 1].getBoolean()) {
            AggregateData aggregateData = (AggregateData)object;
            Value value = this.args.length == 0 ? null : valueArray[0];
            this.updateData(session2, aggregateData, value, valueArray);
        }
    }

    @Override
    protected Object createAggregateData() {
        return AggregateData.create(this.aggregateType, this.distinct, this.type.getValueType());
    }

    @Override
    public Value getValue(Session session2) {
        return this.select.isQuickAggregateQuery() ? this.getValueQuick(session2) : super.getValue(session2);
    }

    private Value getValueQuick(Session session2) {
        switch (this.aggregateType) {
            case COUNT: 
            case COUNT_ALL: {
                Table table = this.select.getTopTableFilter().getTable();
                return ValueLong.get(table.getRowCount(session2));
            }
            case MIN: 
            case MAX: {
                Cursor cursor;
                SearchRow searchRow;
                boolean bl = this.aggregateType == AggregateType.MIN;
                Index index = this.getMinMaxColumnIndex();
                int n = index.getIndexColumns()[0].sortType;
                if ((n & 1) != 0) {
                    bl = !bl;
                }
                Value value = (searchRow = (cursor = index.findFirstOrLast(session2, bl)).getSearchRow()) == null ? ValueNull.INSTANCE : searchRow.getValue(index.getColumns()[0].getColumnId());
                return value;
            }
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: {
                Value value = this.args[0].getValue(session2);
                if (value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                BigDecimal bigDecimal = value.getBigDecimal();
                if (bigDecimal.signum() >= 0 && bigDecimal.compareTo(BigDecimal.ONE) <= 0) {
                    return Percentile.getFromIndex(session2, this.orderByList.get((int)0).expression, this.type.getValueType(), this.orderByList, bigDecimal, this.aggregateType == AggregateType.PERCENTILE_CONT);
                }
                throw DbException.getInvalidValueException(this.aggregateType == AggregateType.PERCENTILE_CONT ? "PERCENTILE_CONT argument" : "PERCENTILE_DISC argument", bigDecimal);
            }
            case MEDIAN: {
                return Percentile.getFromIndex(session2, this.args[0], this.type.getValueType(), this.orderByList, Percentile.HALF, true);
            }
            case ENVELOPE: {
                return ((MVSpatialIndex)AggregateDataEnvelope.getGeometryColumnIndex(this.args[0])).getBounds(session2);
            }
        }
        throw DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
    }

    @Override
    public Value getAggregatedValue(Session session2, Object object) {
        AggregateData aggregateData = (AggregateData)object;
        if (aggregateData == null) {
            aggregateData = (AggregateData)this.createAggregateData();
        }
        switch (this.aggregateType) {
            case COUNT: {
                if (!this.distinct) break;
                return ValueLong.get(((AggregateDataCollecting)aggregateData).getCount());
            }
            case SUM: 
            case AVG: 
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                if (!this.distinct) break;
                AggregateDataCollecting aggregateDataCollecting = (AggregateDataCollecting)aggregateData;
                if (aggregateDataCollecting.getCount() == 0) {
                    return ValueNull.INSTANCE;
                }
                AggregateDataDefault aggregateDataDefault = new AggregateDataDefault(this.aggregateType, this.type.getValueType());
                Database database = session2.getDatabase();
                int n = this.type.getValueType();
                for (Value value : aggregateDataCollecting) {
                    aggregateDataDefault.add(database, value);
                }
                return aggregateDataDefault.getValue(database, n);
            }
            case HISTOGRAM: {
                return this.getHistogram(session2, aggregateData);
            }
            case LISTAGG: {
                return this.getListagg(session2, aggregateData);
            }
            case ARRAY_AGG: {
                Value[] valueArray = ((AggregateDataCollecting)aggregateData).getArray();
                if (valueArray == null) {
                    return ValueNull.INSTANCE;
                }
                if (this.orderByList != null || this.distinct) {
                    this.sortWithOrderBy(valueArray);
                }
                if (this.orderByList != null) {
                    for (int i = 0; i < valueArray.length; ++i) {
                        valueArray[i] = ((ValueArray)valueArray[i]).getList()[0];
                    }
                }
                return ValueArray.get(valueArray);
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: {
                return this.getHypotheticalSet(session2, aggregateData);
            }
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: {
                AggregateDataCollecting aggregateDataCollecting = (AggregateDataCollecting)aggregateData;
                Value[] valueArray = aggregateDataCollecting.getArray();
                if (valueArray == null) {
                    return ValueNull.INSTANCE;
                }
                Value value = aggregateDataCollecting.getSharedArgument();
                if (value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                BigDecimal bigDecimal = value.getBigDecimal();
                if (bigDecimal.signum() >= 0 && bigDecimal.compareTo(BigDecimal.ONE) <= 0) {
                    return Percentile.getValue(session2.getDatabase(), valueArray, this.type.getValueType(), this.orderByList, bigDecimal, this.aggregateType == AggregateType.PERCENTILE_CONT);
                }
                throw DbException.getInvalidValueException(this.aggregateType == AggregateType.PERCENTILE_CONT ? "PERCENTILE_CONT argument" : "PERCENTILE_DISC argument", bigDecimal);
            }
            case MEDIAN: {
                Value[] valueArray = ((AggregateDataCollecting)aggregateData).getArray();
                if (valueArray == null) {
                    return ValueNull.INSTANCE;
                }
                return Percentile.getValue(session2.getDatabase(), valueArray, this.type.getValueType(), this.orderByList, Percentile.HALF, true);
            }
            case MODE: {
                return this.getMode(session2, aggregateData);
            }
        }
        return aggregateData.getValue(session2.getDatabase(), this.type.getValueType());
    }

    private Value getHypotheticalSet(Session session2, AggregateData aggregateData) {
        AggregateDataCollecting aggregateDataCollecting = (AggregateDataCollecting)aggregateData;
        Value value = aggregateDataCollecting.getSharedArgument();
        if (value == null) {
            switch (this.aggregateType) {
                case RANK: 
                case DENSE_RANK: {
                    return ValueInt.get(1);
                }
                case PERCENT_RANK: {
                    return ValueDouble.ZERO;
                }
                case CUME_DIST: {
                    return ValueDouble.ONE;
                }
            }
            throw DbException.getUnsupportedException("aggregateType=" + (Object)((Object)this.aggregateType));
        }
        aggregateDataCollecting.add(session2.getDatabase(), value);
        Value[] valueArray = aggregateDataCollecting.getArray();
        Comparator<Value> comparator = this.orderBySort.getRowValueComparator();
        Arrays.sort(valueArray, comparator);
        return this.aggregateType == AggregateType.CUME_DIST ? Aggregate.getCumeDist(valueArray, value, comparator) : this.getRank(valueArray, value, comparator);
    }

    private Value getRank(Value[] valueArray, Value value, Comparator<Value> comparator) {
        int n = valueArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            Value value2 = valueArray[i];
            if (i == 0) {
                n2 = 1;
            } else if (comparator.compare(valueArray[i - 1], value2) != 0) {
                n2 = this.aggregateType == AggregateType.DENSE_RANK ? ++n2 : i + 1;
            }
            Value value3 = this.aggregateType == AggregateType.PERCENT_RANK ? ((n3 = n2 - 1) == 0 ? ValueDouble.ZERO : ValueDouble.get((double)n3 / (double)(n - 1))) : ValueLong.get(n2);
            if (comparator.compare(value2, value) != 0) continue;
            return value3;
        }
        throw DbException.throwInternalError();
    }

    private static Value getCumeDist(Value[] valueArray, Value value, Comparator<Value> comparator) {
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            Value value2 = valueArray[n2];
            for (n3 = n2 + 1; n3 < n && comparator.compare(value2, valueArray[n3]) == 0; ++n3) {
            }
            ValueDouble valueDouble = ValueDouble.get((double)n3 / (double)n);
            for (int i = n2; i < n3; ++i) {
                if (comparator.compare(valueArray[i], value) != 0) continue;
                return valueDouble;
            }
            n2 = n3;
        }
        throw DbException.throwInternalError();
    }

    private Value getListagg(Session session2, AggregateData aggregateData) {
        AggregateDataCollecting aggregateDataCollecting = (AggregateDataCollecting)aggregateData;
        Value[] valueArray = aggregateDataCollecting.getArray();
        if (valueArray == null) {
            return ValueNull.INSTANCE;
        }
        if (this.orderByList != null || this.distinct) {
            this.sortWithOrderBy(valueArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.args.length < 2 ? "," : aggregateDataCollecting.getSharedArgument().getString();
        int n = valueArray.length;
        for (int i = 0; i < n; ++i) {
            Value value = valueArray[i];
            String string2 = this.orderByList != null ? ((ValueArray)value).getList()[0].getString() : value.getString();
            if (string != null && i > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string2);
        }
        return ValueString.get(stringBuilder.toString());
    }

    private Value getHistogram(Session session2, AggregateData aggregateData) {
        Object object;
        TreeMap<Value, LongDataCounter> treeMap = ((AggregateDataDistinctWithCounts)aggregateData).getValues();
        if (treeMap == null) {
            return ValueArray.getEmpty();
        }
        Value[] valueArray = new ValueArray[treeMap.size()];
        int n = 0;
        for (Map.Entry<Value, LongDataCounter> object22 : treeMap.entrySet()) {
            object = object22.getValue();
            valueArray[n] = ValueArray.get(new Value[]{object22.getKey(), ValueLong.get(this.distinct ? 1L : ((LongDataCounter)object).count)});
            ++n;
        }
        Database database = session2.getDatabase();
        final Mode mode = database.getMode();
        object = database.getCompareMode();
        Arrays.sort(valueArray, new Comparator<ValueArray>((CompareMode)object){
            final /* synthetic */ CompareMode val$compareMode;
            {
                this.val$compareMode = compareMode;
            }

            @Override
            public int compare(ValueArray valueArray, ValueArray valueArray2) {
                Value value = valueArray.getList()[0];
                Value value2 = valueArray2.getList()[0];
                return value.compareTo(value2, mode, this.val$compareMode);
            }
        });
        return ValueArray.get(valueArray);
    }

    private Value getMode(Session session2, AggregateData aggregateData) {
        Value value = ValueNull.INSTANCE;
        TreeMap<Value, LongDataCounter> treeMap = ((AggregateDataDistinctWithCounts)aggregateData).getValues();
        if (treeMap == null) {
            return value;
        }
        long l = 0L;
        if (this.orderByList != null) {
            boolean bl = (this.orderByList.get((int)0).sortType & 1) != 0;
            for (Map.Entry<Value, LongDataCounter> entry2 : treeMap.entrySet()) {
                long l2 = entry2.getValue().count;
                if (l2 > l) {
                    value = entry2.getKey();
                    l = l2;
                    continue;
                }
                if (l2 != l) continue;
                Value value2 = entry2.getKey();
                int n = session2.getDatabase().compareTypeSafe(value, value2);
                if (bl ? n >= 0 : n <= 0) continue;
                value = value2;
            }
        } else {
            for (Map.Entry<Value, LongDataCounter> entry3 : treeMap.entrySet()) {
                long l3 = entry3.getValue().count;
                if (l3 <= l) continue;
                value = entry3.getKey();
                l = l3;
            }
        }
        return value.convertTo(this.type.getValueType());
    }

    @Override
    public void mapColumnsAnalysis(ColumnResolver columnResolver, int n, int n2) {
        if (this.orderByList != null) {
            for (SelectOrderBy selectOrderBy : this.orderByList) {
                selectOrderBy.expression.mapColumns(columnResolver, n, n2);
            }
        }
        super.mapColumnsAnalysis(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session2) {
        int n;
        super.optimize(session2);
        if (this.args.length == 1) {
            this.type = this.args[0].getType();
        }
        if (this.orderByList != null) {
            for (SelectOrderBy selectOrderBy : this.orderByList) {
                selectOrderBy.expression = selectOrderBy.expression.optimize(session2);
            }
            switch (this.aggregateType) {
                case LISTAGG: 
                case ARRAY_AGG: {
                    n = 1;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            this.orderBySort = Aggregate.createOrder(session2, this.orderByList, n);
        }
        switch (this.aggregateType) {
            case LISTAGG: {
                this.type = TypeInfo.TYPE_STRING;
                break;
            }
            case COUNT: 
            case COUNT_ALL: {
                this.type = TypeInfo.TYPE_LONG;
                break;
            }
            case SELECTIVITY: {
                this.type = TypeInfo.TYPE_INT;
                break;
            }
            case HISTOGRAM: {
                this.type = TypeInfo.TYPE_ARRAY;
                break;
            }
            case SUM: {
                n = this.type.getValueType();
                if (n == 1) {
                    this.type = TypeInfo.TYPE_LONG;
                    break;
                }
                if (!DataType.supportsAdd(n)) {
                    throw DbException.get(90015, this.getSQL(false));
                }
                this.type = TypeInfo.getTypeInfo(DataType.getAddProofType(n));
                break;
            }
            case AVG: {
                if (DataType.supportsAdd(this.type.getValueType())) break;
                throw DbException.get(90015, this.getSQL(false));
            }
            case MIN: 
            case MAX: {
                break;
            }
            case RANK: 
            case DENSE_RANK: {
                this.type = TypeInfo.TYPE_LONG;
                break;
            }
            case PERCENT_RANK: 
            case CUME_DIST: {
                this.type = TypeInfo.TYPE_DOUBLE;
                break;
            }
            case PERCENTILE_CONT: {
                this.type = this.orderByList.get((int)0).expression.getType();
            }
            case MEDIAN: {
                switch (this.type.getValueType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.type = TypeInfo.TYPE_DECIMAL_DEFAULT;
                    }
                }
                break;
            }
            case PERCENTILE_DISC: 
            case MODE: {
                this.type = this.orderByList.get((int)0).expression.getType();
                break;
            }
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                this.type = TypeInfo.TYPE_DOUBLE;
                break;
            }
            case EVERY: 
            case ANY: {
                this.type = TypeInfo.TYPE_BOOLEAN;
                break;
            }
            case BIT_AND: 
            case BIT_OR: {
                if (DataType.supportsAdd(this.type.getValueType())) break;
                throw DbException.get(90015, this.getSQL(false));
            }
            case ARRAY_AGG: {
                this.type = TypeInfo.TYPE_ARRAY;
                break;
            }
            case ENVELOPE: {
                this.type = TypeInfo.TYPE_GEOMETRY;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        if (this.orderByList != null) {
            for (SelectOrderBy selectOrderBy : this.orderByList) {
                selectOrderBy.expression.setEvaluatable(tableFilter, bl);
            }
        }
        super.setEvaluatable(tableFilter, bl);
    }

    private StringBuilder getSQLArrayAggregate(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("ARRAY_AGG(");
        if (this.distinct) {
            stringBuilder.append("DISTINCT ");
        }
        this.args[0].getSQL(stringBuilder, bl);
        Window.appendOrderBy(stringBuilder, this.orderByList, bl);
        stringBuilder.append(')');
        return this.appendTailConditions(stringBuilder, bl);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        String string;
        switch (this.aggregateType) {
            case COUNT_ALL: {
                return this.appendTailConditions(stringBuilder.append("COUNT(*)"), bl);
            }
            case COUNT: {
                string = "COUNT";
                break;
            }
            case SELECTIVITY: {
                string = "SELECTIVITY";
                break;
            }
            case HISTOGRAM: {
                string = "HISTOGRAM";
                break;
            }
            case SUM: {
                string = "SUM";
                break;
            }
            case MIN: {
                string = "MIN";
                break;
            }
            case MAX: {
                string = "MAX";
                break;
            }
            case AVG: {
                string = "AVG";
                break;
            }
            case STDDEV_POP: {
                string = "STDDEV_POP";
                break;
            }
            case STDDEV_SAMP: {
                string = "STDDEV_SAMP";
                break;
            }
            case VAR_POP: {
                string = "VAR_POP";
                break;
            }
            case VAR_SAMP: {
                string = "VAR_SAMP";
                break;
            }
            case EVERY: {
                string = "EVERY";
                break;
            }
            case ANY: {
                string = "ANY";
                break;
            }
            case BIT_AND: {
                string = "BIT_AND";
                break;
            }
            case BIT_OR: {
                string = "BIT_OR";
                break;
            }
            case RANK: {
                string = "RANK";
                break;
            }
            case DENSE_RANK: {
                string = "DENSE_RANK";
                break;
            }
            case PERCENT_RANK: {
                string = "PERCENT_RANK";
                break;
            }
            case CUME_DIST: {
                string = "CUME_DIST";
                break;
            }
            case PERCENTILE_CONT: {
                string = "PERCENTILE_CONT";
                break;
            }
            case PERCENTILE_DISC: {
                string = "PERCENTILE_DISC";
                break;
            }
            case MEDIAN: {
                string = "MEDIAN";
                break;
            }
            case LISTAGG: {
                string = "LISTAGG";
                break;
            }
            case ARRAY_AGG: {
                return this.getSQLArrayAggregate(stringBuilder, bl);
            }
            case MODE: {
                string = "MODE";
                break;
            }
            case ENVELOPE: {
                string = "ENVELOPE";
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
        stringBuilder.append(string);
        if (this.distinct) {
            stringBuilder.append("(DISTINCT ");
        } else {
            stringBuilder.append('(');
        }
        for (int i = 0; i < this.args.length; ++i) {
            Expression expression;
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if ((expression = this.args[i]) instanceof Subquery) {
                expression.getSQL(stringBuilder, bl);
                continue;
            }
            expression.getUnenclosedSQL(stringBuilder, bl);
        }
        stringBuilder.append(')');
        if (this.orderByList != null) {
            stringBuilder.append(" WITHIN GROUP (");
            Window.appendOrderBy(stringBuilder, this.orderByList, bl);
            stringBuilder.append(')');
        }
        return this.appendTailConditions(stringBuilder, bl);
    }

    private Index getMinMaxColumnIndex() {
        Expression expression = this.args[0];
        if (expression instanceof ExpressionColumn) {
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            Column column = expressionColumn.getColumn();
            TableFilter tableFilter = expressionColumn.getTableFilter();
            if (tableFilter != null) {
                Table table = tableFilter.getTable();
                return table.getIndexForColumn(column, true, false);
            }
        }
        return null;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (!super.isEverything(expressionVisitor)) {
            return false;
        }
        if (this.filterCondition != null && !this.filterCondition.isEverything(expressionVisitor)) {
            return false;
        }
        if (expressionVisitor.getType() == 1) {
            switch (this.aggregateType) {
                case COUNT: {
                    if (!this.distinct && this.args[0].getNullable() == 0) {
                        return expressionVisitor.getTable().canGetRowCount();
                    }
                    return false;
                }
                case COUNT_ALL: {
                    return expressionVisitor.getTable().canGetRowCount();
                }
                case MIN: 
                case MAX: {
                    Index index = this.getMinMaxColumnIndex();
                    return index != null;
                }
                case PERCENTILE_CONT: 
                case PERCENTILE_DISC: {
                    return this.args[0].isConstant() && Percentile.getColumnIndex(this.orderByList.get((int)0).expression) != null;
                }
                case MEDIAN: {
                    if (this.distinct) {
                        return false;
                    }
                    return Percentile.getColumnIndex(this.args[0]) != null;
                }
                case ENVELOPE: {
                    return AggregateDataEnvelope.getGeometryColumnIndex(this.args[0]) != null;
                }
            }
            return false;
        }
        for (Expression expression : this.args) {
            if (expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        if (this.orderByList != null) {
            for (SelectOrderBy selectOrderBy : this.orderByList) {
                if (selectOrderBy.expression.isEverything(expressionVisitor)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getCost() {
        int n = 1;
        for (Expression expression : this.args) {
            n += expression.getCost();
        }
        if (this.orderByList != null) {
            for (SelectOrderBy selectOrderBy : this.orderByList) {
                n += selectOrderBy.expression.getCost();
            }
        }
        if (this.filterCondition != null) {
            n += this.filterCondition.getCost();
        }
        return n;
    }

    static {
        Aggregate.addAggregate("COUNT", AggregateType.COUNT);
        Aggregate.addAggregate("SUM", AggregateType.SUM);
        Aggregate.addAggregate("MIN", AggregateType.MIN);
        Aggregate.addAggregate("MAX", AggregateType.MAX);
        Aggregate.addAggregate("AVG", AggregateType.AVG);
        Aggregate.addAggregate("LISTAGG", AggregateType.LISTAGG);
        Aggregate.addAggregate("GROUP_CONCAT", AggregateType.LISTAGG);
        Aggregate.addAggregate("STRING_AGG", AggregateType.LISTAGG);
        Aggregate.addAggregate("STDDEV_SAMP", AggregateType.STDDEV_SAMP);
        Aggregate.addAggregate("STDDEV", AggregateType.STDDEV_SAMP);
        Aggregate.addAggregate("STDDEV_POP", AggregateType.STDDEV_POP);
        Aggregate.addAggregate("STDDEVP", AggregateType.STDDEV_POP);
        Aggregate.addAggregate("VAR_POP", AggregateType.VAR_POP);
        Aggregate.addAggregate("VARP", AggregateType.VAR_POP);
        Aggregate.addAggregate("VAR_SAMP", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("VAR", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("VARIANCE", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("ANY", AggregateType.ANY);
        Aggregate.addAggregate("SOME", AggregateType.ANY);
        Aggregate.addAggregate("BOOL_OR", AggregateType.ANY);
        Aggregate.addAggregate("EVERY", AggregateType.EVERY);
        Aggregate.addAggregate("BOOL_AND", AggregateType.EVERY);
        Aggregate.addAggregate("SELECTIVITY", AggregateType.SELECTIVITY);
        Aggregate.addAggregate("HISTOGRAM", AggregateType.HISTOGRAM);
        Aggregate.addAggregate("BIT_OR", AggregateType.BIT_OR);
        Aggregate.addAggregate("BIT_AND", AggregateType.BIT_AND);
        Aggregate.addAggregate("RANK", AggregateType.RANK);
        Aggregate.addAggregate("DENSE_RANK", AggregateType.DENSE_RANK);
        Aggregate.addAggregate("PERCENT_RANK", AggregateType.PERCENT_RANK);
        Aggregate.addAggregate("CUME_DIST", AggregateType.CUME_DIST);
        Aggregate.addAggregate("PERCENTILE_CONT", AggregateType.PERCENTILE_CONT);
        Aggregate.addAggregate("PERCENTILE_DISC", AggregateType.PERCENTILE_DISC);
        Aggregate.addAggregate("MEDIAN", AggregateType.MEDIAN);
        Aggregate.addAggregate("ARRAY_AGG", AggregateType.ARRAY_AGG);
        Aggregate.addAggregate("MODE", AggregateType.MODE);
        Aggregate.addAggregate("STATS_MODE", AggregateType.MODE);
        Aggregate.addAggregate("ENVELOPE", AggregateType.ENVELOPE);
    }
}

