/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.analysis;

import java.util.ArrayList;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.analysis.WindowFrame;
import org.h2.message.DbException;
import org.h2.result.SortOrder;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueRow;

public final class Window {
    private ArrayList<Expression> partitionBy;
    private ArrayList<SelectOrderBy> orderBy;
    private WindowFrame frame;
    private String parent;

    public static void appendOrderBy(StringBuilder stringBuilder, ArrayList<SelectOrderBy> arrayList, boolean bl) {
        if (arrayList != null && !arrayList.isEmpty()) {
            if (stringBuilder.charAt(stringBuilder.length() - 1) != '(') {
                stringBuilder.append(' ');
            }
            stringBuilder.append("ORDER BY ");
            for (int i = 0; i < arrayList.size(); ++i) {
                SelectOrderBy selectOrderBy = arrayList.get(i);
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                selectOrderBy.expression.getSQL(stringBuilder, bl);
                SortOrder.typeToString(stringBuilder, selectOrderBy.sortType);
            }
        }
    }

    public Window(String string, ArrayList<Expression> arrayList, ArrayList<SelectOrderBy> arrayList2, WindowFrame windowFrame) {
        this.parent = string;
        this.partitionBy = arrayList;
        this.orderBy = arrayList2;
        this.frame = windowFrame;
    }

    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.resolveWindows(columnResolver);
        if (this.partitionBy != null) {
            for (Expression object : this.partitionBy) {
                object.mapColumns(columnResolver, n, 1);
            }
        }
        if (this.orderBy != null) {
            for (SelectOrderBy selectOrderBy : this.orderBy) {
                selectOrderBy.expression.mapColumns(columnResolver, n, 1);
            }
        }
        if (this.frame != null) {
            this.frame.mapColumns(columnResolver, n, 1);
        }
    }

    private void resolveWindows(ColumnResolver columnResolver) {
        if (this.parent != null) {
            Window window;
            Select select = columnResolver.getSelect();
            while ((window = select.getWindow(this.parent)) == null) {
                if ((select = select.getParentSelect()) != null) continue;
                throw DbException.get(90136, this.parent);
            }
            window.resolveWindows(columnResolver);
            if (this.partitionBy == null) {
                this.partitionBy = window.partitionBy;
            }
            if (this.orderBy == null) {
                this.orderBy = window.orderBy;
            }
            if (this.frame == null) {
                this.frame = window.frame;
            }
            this.parent = null;
        }
    }

    public void optimize(Session session2) {
        if (this.partitionBy != null) {
            for (int i = 0; i < this.partitionBy.size(); ++i) {
                this.partitionBy.set(i, this.partitionBy.get(i).optimize(session2));
            }
        }
        if (this.orderBy != null) {
            for (SelectOrderBy selectOrderBy : this.orderBy) {
                selectOrderBy.expression = selectOrderBy.expression.optimize(session2);
            }
        }
        if (this.frame != null) {
            this.frame.optimize(session2);
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        if (this.partitionBy != null) {
            for (Expression object : this.partitionBy) {
                object.setEvaluatable(tableFilter, bl);
            }
        }
        if (this.orderBy != null) {
            for (SelectOrderBy selectOrderBy : this.orderBy) {
                selectOrderBy.expression.setEvaluatable(tableFilter, bl);
            }
        }
    }

    public ArrayList<SelectOrderBy> getOrderBy() {
        return this.orderBy;
    }

    public WindowFrame getWindowFrame() {
        return this.frame;
    }

    public Value getCurrentKey(Session session2) {
        if (this.partitionBy == null) {
            return null;
        }
        int n = this.partitionBy.size();
        if (n == 1) {
            return this.partitionBy.get(0).getValue(session2);
        }
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            Expression expression = this.partitionBy.get(i);
            valueArray[i] = expression.getValue(session2);
        }
        return ValueRow.get(valueArray);
    }

    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("OVER (");
        if (this.partitionBy != null) {
            stringBuilder.append("PARTITION BY ");
            for (int i = 0; i < this.partitionBy.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                this.partitionBy.get(i).getUnenclosedSQL(stringBuilder, bl);
            }
        }
        Window.appendOrderBy(stringBuilder, this.orderBy, bl);
        if (this.frame != null) {
            if (stringBuilder.charAt(stringBuilder.length() - 1) != '(') {
                stringBuilder.append(' ');
            }
            this.frame.getSQL(stringBuilder, bl);
        }
        return stringBuilder.append(')');
    }

    public void updateAggregate(Session session2, int n) {
        if (this.partitionBy != null) {
            for (Expression object : this.partitionBy) {
                object.updateAggregate(session2, n);
            }
        }
        if (this.orderBy != null) {
            for (SelectOrderBy selectOrderBy : this.orderBy) {
                selectOrderBy.expression.updateAggregate(session2, n);
            }
        }
        if (this.frame != null) {
            this.frame.updateAggregate(session2, n);
        }
    }

    public String toString() {
        return this.getSQL(new StringBuilder(), false).toString();
    }
}

