/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Condition;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ConditionNot
extends Condition {
    private Expression condition;

    public ConditionNot(Expression expression) {
        this.condition = expression;
    }

    @Override
    public Expression getNotIfPossible(Session session2) {
        return this.condition;
    }

    @Override
    public Value getValue(Session session2) {
        Value value = this.condition.getValue(session2);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        return value.convertTo(1).negate();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.condition.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session2) {
        Expression expression = this.condition.getNotIfPossible(session2);
        if (expression != null) {
            return expression.optimize(session2);
        }
        Expression expression2 = this.condition.optimize(session2);
        if (expression2.isConstant()) {
            Value value = expression2.getValue(session2);
            if (value == ValueNull.INSTANCE) {
                return ValueExpression.getNull();
            }
            return ValueExpression.get(value.convertTo(1).negate());
        }
        this.condition = expression2;
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.condition.setEvaluatable(tableFilter, bl);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(NOT ");
        return this.condition.getSQL(stringBuilder, bl).append(')');
    }

    @Override
    public void updateAggregate(Session session2, int n) {
        this.condition.updateAggregate(session2, n);
    }

    @Override
    public void addFilterConditions(TableFilter tableFilter, boolean bl) {
        if (bl) {
            return;
        }
        super.addFilterConditions(tableFilter, bl);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.condition.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.condition.getCost();
    }

    @Override
    public int getSubexpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubexpression(int n) {
        if (n == 0) {
            return this.condition;
        }
        throw new IndexOutOfBoundsException();
    }
}

