/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.Iterator;
import org.h2.command.dml.AllColumnsForPlan;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SpatialIndex;
import org.h2.message.DbException;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.mvstore.rtree.MVRTreeMap;
import org.h2.mvstore.rtree.SpatialKey;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueNull;

public class SpatialTreeIndex
extends BaseIndex
implements SpatialIndex {
    private static final String MAP_PREFIX = "RTREE_";
    private final MVRTreeMap<Long> treeMap;
    private final MVStore store;
    private boolean closed;
    private boolean needRebuild;

    public SpatialTreeIndex(Table table, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, boolean bl2, Session session2) {
        super(table, n, string, indexColumnArray, indexType);
        if (indexType.isUnique()) {
            throw DbException.getUnsupportedException("not unique");
        }
        if (!bl && !bl2) {
            throw DbException.getUnsupportedException("Non persistent index called with create==false");
        }
        if (indexColumnArray.length > 1) {
            throw DbException.getUnsupportedException("can only do one column");
        }
        if ((indexColumnArray[0].sortType & 1) != 0) {
            throw DbException.getUnsupportedException("cannot do descending");
        }
        if ((indexColumnArray[0].sortType & 2) != 0) {
            throw DbException.getUnsupportedException("cannot do nulls first");
        }
        if ((indexColumnArray[0].sortType & 4) != 0) {
            throw DbException.getUnsupportedException("cannot do nulls last");
        }
        this.needRebuild = bl2;
        if (!this.database.isStarting() && indexColumnArray[0].column.getType().getValueType() != 22) {
            throw DbException.getUnsupportedException("spatial index on non-geometry column, " + indexColumnArray[0].column.getCreateSQL());
        }
        if (!bl) {
            this.store = MVStore.open(null);
            this.treeMap = (MVRTreeMap)this.store.openMap("spatialIndex", new MVRTreeMap.Builder());
        } else {
            if (n < 0) {
                throw DbException.getUnsupportedException("Persistent index with id<0");
            }
            MVTableEngine.init(session2.getDatabase());
            this.store = session2.getDatabase().getStore().getMvStore();
            this.treeMap = (MVRTreeMap)this.store.openMap(MAP_PREFIX + this.getId(), new MVRTreeMap.Builder());
            if (this.treeMap.isEmpty()) {
                this.needRebuild = true;
            }
        }
    }

    @Override
    public void close(Session session2) {
        this.store.close();
        this.closed = true;
    }

    @Override
    public void add(Session session2, Row row) {
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        this.treeMap.add(this.getKey(row), row.getKey());
    }

    private SpatialKey getKey(SearchRow searchRow) {
        double[] dArray;
        if (searchRow == null) {
            return null;
        }
        Value value = searchRow.getValue(this.columnIds[0]);
        if (value == ValueNull.INSTANCE || (dArray = ((ValueGeometry)value.convertTo(22)).getEnvelopeNoCopy()) == null) {
            return new SpatialKey(searchRow.getKey(), new float[0]);
        }
        return new SpatialKey(searchRow.getKey(), (float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3]);
    }

    @Override
    public void remove(Session session2, Row row) {
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        if (!this.treeMap.remove(this.getKey(row), row.getKey())) {
            throw DbException.throwInternalError("row not found");
        }
    }

    @Override
    public Cursor find(TableFilter tableFilter, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(tableFilter.getSession());
    }

    @Override
    public Cursor find(Session session2, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(session2);
    }

    private Cursor find(Session session2) {
        return new SpatialCursor(this.treeMap.keySet().iterator(), this.table, session2);
    }

    @Override
    public Cursor findByGeometry(TableFilter tableFilter, SearchRow searchRow, SearchRow searchRow2, SearchRow searchRow3) {
        if (searchRow3 == null) {
            return this.find(tableFilter.getSession(), searchRow, searchRow2);
        }
        return new SpatialCursor(this.treeMap.findIntersectingKeys(this.getKey(searchRow3)), this.table, tableFilter.getSession());
    }

    public static long getCostRangeIndex(int[] nArray, Column[] columnArray) {
        if (columnArray.length == 0) {
            return Long.MAX_VALUE;
        }
        for (Column column : columnArray) {
            int n = column.getColumnId();
            int n2 = nArray[n];
            if ((n2 & 0x10) == 16) continue;
            return Long.MAX_VALUE;
        }
        return 2L;
    }

    @Override
    public double getCost(Session session2, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        return SpatialTreeIndex.getCostRangeIndex(nArray, this.columns);
    }

    @Override
    public void remove(Session session2) {
        if (!this.treeMap.isClosed()) {
            this.store.removeMap(this.treeMap);
        }
    }

    @Override
    public void truncate(Session session2) {
        this.treeMap.clear();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return this.needRebuild;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session2, boolean bl) {
        if (this.closed) {
            throw DbException.throwInternalError(this.toString());
        }
        if (!bl) {
            throw DbException.throwInternalError("Spatial Index can only be fetch by ascending order");
        }
        return this.find(session2);
    }

    @Override
    public long getRowCount(Session session2) {
        return this.treeMap.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation() {
        return this.treeMap.sizeAsLong();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    private static final class SpatialCursor
    implements Cursor {
        private final Iterator<SpatialKey> it;
        private SpatialKey current;
        private final Table table;
        private final Session session;

        public SpatialCursor(Iterator<SpatialKey> iterator, Table table, Session session2) {
            this.it = iterator;
            this.table = table;
            this.session = session2;
        }

        @Override
        public Row get() {
            return this.table.getRow(this.session, this.current.getId());
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean next() {
            if (!this.it.hasNext()) {
                return false;
            }
            this.current = this.it.next();
            return true;
        }

        @Override
        public boolean previous() {
            return false;
        }
    }
}

