/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.command.dml.AllColumnsForPlan;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.TreeCursor;
import org.h2.index.TreeNode;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.PageStoreTable;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class TreeIndex
extends BaseIndex {
    private TreeNode root;
    private final PageStoreTable tableData;
    private long rowCount;
    private boolean closed;

    public TreeIndex(PageStoreTable pageStoreTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(pageStoreTable, n, string, indexColumnArray, indexType);
        this.tableData = pageStoreTable;
        if (!this.database.isStarting()) {
            TreeIndex.checkIndexColumnTypes(indexColumnArray);
        }
    }

    @Override
    public void close(Session session2) {
        this.root = null;
        this.closed = true;
    }

    @Override
    public void add(Session session2, Row row) {
        TreeNode treeNode;
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        TreeNode treeNode2 = new TreeNode(row);
        TreeNode treeNode3 = treeNode = this.root;
        boolean bl = true;
        while (true) {
            if (treeNode == null) {
                if (treeNode3 == null) {
                    this.root = treeNode2;
                    ++this.rowCount;
                    return;
                }
                break;
            }
            Row row2 = treeNode.row;
            int n = this.compareRows(row, row2);
            if (n == 0) {
                if (this.indexType.isUnique() && !this.mayHaveNullDuplicates(row)) {
                    throw this.getDuplicateKeyException(row.toString());
                }
                n = this.compareKeys(row, row2);
            }
            bl = n < 0;
            treeNode3 = treeNode;
            treeNode = TreeIndex.child(treeNode3, bl);
        }
        TreeIndex.set(treeNode3, bl, treeNode2);
        this.balance(treeNode3, bl);
        ++this.rowCount;
    }

    private void balance(TreeNode treeNode, boolean bl) {
        while (true) {
            int n = bl ? 1 : -1;
            switch (treeNode.balance * n) {
                case 1: {
                    treeNode.balance = 0;
                    return;
                }
                case 0: {
                    treeNode.balance = -n;
                    break;
                }
                case -1: {
                    TreeNode treeNode2 = TreeIndex.child(treeNode, bl);
                    if (treeNode2.balance == -n) {
                        this.replace(treeNode, treeNode2);
                        TreeIndex.set(treeNode, bl, TreeIndex.child(treeNode2, !bl));
                        TreeIndex.set(treeNode2, !bl, treeNode);
                        treeNode.balance = 0;
                        treeNode2.balance = 0;
                    } else {
                        TreeNode treeNode3 = TreeIndex.child(treeNode2, !bl);
                        this.replace(treeNode, treeNode3);
                        TreeIndex.set(treeNode2, !bl, TreeIndex.child(treeNode3, bl));
                        TreeIndex.set(treeNode3, bl, treeNode2);
                        TreeIndex.set(treeNode, bl, TreeIndex.child(treeNode3, !bl));
                        TreeIndex.set(treeNode3, !bl, treeNode);
                        int n2 = treeNode3.balance;
                        treeNode.balance = n2 == -n ? n : 0;
                        treeNode2.balance = n2 == n ? -n : 0;
                        treeNode3.balance = 0;
                    }
                    return;
                }
                default: {
                    DbException.throwInternalError("b:" + treeNode.balance * n);
                }
            }
            if (treeNode == this.root) {
                return;
            }
            bl = treeNode.isFromLeft();
            treeNode = treeNode.parent;
        }
    }

    private static TreeNode child(TreeNode treeNode, boolean bl) {
        return bl ? treeNode.left : treeNode.right;
    }

    private void replace(TreeNode treeNode, TreeNode treeNode2) {
        if (treeNode == this.root) {
            this.root = treeNode2;
            if (treeNode2 != null) {
                treeNode2.parent = null;
            }
        } else {
            TreeIndex.set(treeNode.parent, treeNode.isFromLeft(), treeNode2);
        }
    }

    private static void set(TreeNode treeNode, boolean bl, TreeNode treeNode2) {
        if (bl) {
            treeNode.left = treeNode2;
        } else {
            treeNode.right = treeNode2;
        }
        if (treeNode2 != null) {
            treeNode2.parent = treeNode;
        }
    }

    @Override
    public void remove(Session session2, Row row) {
        TreeNode treeNode;
        int n;
        TreeNode treeNode2;
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        TreeNode treeNode3 = this.findFirstNode(row, true);
        if (treeNode3 == null) {
            throw DbException.throwInternalError("not found!");
        }
        if (treeNode3.left == null) {
            treeNode2 = treeNode3.right;
        } else if (treeNode3.right == null) {
            treeNode2 = treeNode3.left;
        } else {
            TreeNode treeNode4 = treeNode3;
            TreeNode treeNode5 = treeNode3 = treeNode3.left;
            while ((treeNode5 = treeNode5.right) != null) {
                treeNode3 = treeNode5;
            }
            treeNode2 = treeNode3.left;
            n = treeNode3.balance;
            treeNode3.balance = treeNode4.balance;
            treeNode4.balance = n;
            treeNode = treeNode3.parent;
            TreeNode treeNode6 = treeNode4.parent;
            if (treeNode4 == this.root) {
                this.root = treeNode3;
            }
            treeNode3.parent = treeNode6;
            if (treeNode6 != null) {
                if (treeNode6.right == treeNode4) {
                    treeNode6.right = treeNode3;
                } else {
                    treeNode6.left = treeNode3;
                }
            }
            if (treeNode == treeNode4) {
                treeNode4.parent = treeNode3;
                if (treeNode4.left == treeNode3) {
                    treeNode3.left = treeNode4;
                    treeNode3.right = treeNode4.right;
                } else {
                    treeNode3.right = treeNode4;
                    treeNode3.left = treeNode4.left;
                }
            } else {
                treeNode4.parent = treeNode;
                treeNode.right = treeNode4;
                treeNode3.right = treeNode4.right;
                treeNode3.left = treeNode4.left;
            }
            if (treeNode3.right == null) {
                DbException.throwInternalError("tree corrupted");
            }
            treeNode3.right.parent = treeNode3;
            treeNode3.left.parent = treeNode3;
            treeNode4.left = treeNode2;
            if (treeNode2 != null) {
                treeNode2.parent = treeNode4;
            }
            treeNode4.right = null;
            treeNode3 = treeNode4;
        }
        --this.rowCount;
        boolean bl = treeNode3.isFromLeft();
        this.replace(treeNode3, treeNode2);
        treeNode2 = treeNode3.parent;
        while (treeNode2 != null) {
            treeNode3 = treeNode2;
            n = bl ? 1 : -1;
            switch (treeNode3.balance * n) {
                case -1: {
                    treeNode3.balance = 0;
                    break;
                }
                case 0: {
                    treeNode3.balance = n;
                    return;
                }
                case 1: {
                    treeNode = TreeIndex.child(treeNode3, !bl);
                    int n2 = treeNode.balance;
                    if (n2 * n >= 0) {
                        this.replace(treeNode3, treeNode);
                        TreeIndex.set(treeNode3, !bl, TreeIndex.child(treeNode, bl));
                        TreeIndex.set(treeNode, bl, treeNode3);
                        if (n2 == 0) {
                            treeNode3.balance = n;
                            treeNode.balance = -n;
                            return;
                        }
                        treeNode3.balance = 0;
                        treeNode.balance = 0;
                        treeNode3 = treeNode;
                        break;
                    }
                    TreeNode treeNode7 = TreeIndex.child(treeNode, bl);
                    this.replace(treeNode3, treeNode7);
                    n2 = treeNode7.balance;
                    TreeIndex.set(treeNode, bl, TreeIndex.child(treeNode7, !bl));
                    TreeIndex.set(treeNode7, !bl, treeNode);
                    TreeIndex.set(treeNode3, !bl, TreeIndex.child(treeNode7, bl));
                    TreeIndex.set(treeNode7, bl, treeNode3);
                    treeNode3.balance = n2 == n ? -n : 0;
                    treeNode.balance = n2 == -n ? n : 0;
                    treeNode7.balance = 0;
                    treeNode3 = treeNode7;
                    break;
                }
                default: {
                    DbException.throwInternalError("b: " + treeNode3.balance * n);
                }
            }
            bl = treeNode3.isFromLeft();
            treeNode2 = treeNode3.parent;
        }
    }

    private TreeNode findFirstNode(SearchRow searchRow, boolean bl) {
        TreeNode treeNode;
        TreeNode treeNode2 = treeNode = this.root;
        while (treeNode != null) {
            treeNode2 = treeNode;
            int n = this.compareRows(treeNode.row, searchRow);
            if (n == 0 && bl) {
                n = this.compareKeys(treeNode.row, searchRow);
            }
            if (n == 0) {
                if (bl) {
                    return treeNode;
                }
                treeNode = treeNode.left;
                continue;
            }
            if (n > 0) {
                treeNode = treeNode.left;
                continue;
            }
            treeNode = treeNode.right;
        }
        return treeNode2;
    }

    @Override
    public Cursor find(TableFilter tableFilter, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(searchRow, searchRow2);
    }

    @Override
    public Cursor find(Session session2, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(searchRow, searchRow2);
    }

    private Cursor find(SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == null) {
            TreeNode treeNode;
            TreeNode treeNode2 = this.root;
            while (treeNode2 != null && (treeNode = treeNode2.left) != null) {
                treeNode2 = treeNode;
            }
            return new TreeCursor(this, treeNode2, null, searchRow2);
        }
        TreeNode treeNode = this.findFirstNode(searchRow, false);
        return new TreeCursor(this, treeNode, searchRow, searchRow2);
    }

    @Override
    public double getCost(Session session2, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        return this.getCostRangeIndex(nArray, this.tableData.getRowCountApproximation(), tableFilterArray, n, sortOrder, false, allColumnsForPlan);
    }

    @Override
    public void remove(Session session2) {
        this.truncate(session2);
    }

    @Override
    public void truncate(Session session2) {
        this.root = null;
        this.rowCount = 0L;
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session2, boolean bl) {
        SearchRow searchRow;
        TreeNode treeNode;
        if (this.closed) {
            throw DbException.throwInternalError(this.toString());
        }
        if (bl) {
            Cursor cursor = this.find(session2, null, null);
            while (cursor.next()) {
                SearchRow searchRow2 = cursor.getSearchRow();
                Value value = searchRow2.getValue(this.columnIds[0]);
                if (value == ValueNull.INSTANCE) continue;
                return cursor;
            }
            return cursor;
        }
        TreeNode treeNode2 = this.root;
        while (treeNode2 != null && (treeNode = treeNode2.right) != null) {
            treeNode2 = treeNode;
        }
        TreeCursor treeCursor = new TreeCursor(this, treeNode2, null, null);
        if (treeNode2 == null) {
            return treeCursor;
        }
        while ((searchRow = treeCursor.getSearchRow()) != null) {
            Value value = searchRow.getValue(this.columnIds[0]);
            if (value != ValueNull.INSTANCE) {
                return treeCursor;
            }
            if (treeCursor.previous()) continue;
        }
        return treeCursor;
    }

    @Override
    public long getRowCount(Session session2) {
        return this.rowCount;
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

