/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.aiff.AiffFileHeader;
import org.jaudiotagger.audio.aiff.chunk.AiffChunkReader;
import org.jaudiotagger.audio.aiff.chunk.ChunkType;
import org.jaudiotagger.audio.aiff.chunk.ID3Chunk;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.tag.aiff.AiffTag;
import org.jaudiotagger.tag.id3.ID3v22Tag;

public class AiffTagReader
extends AiffChunkReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.aiff");

    public AiffTag read(RandomAccessFile raf) throws CannotReadException, IOException {
        AiffAudioHeader aiffAudioHeader = new AiffAudioHeader();
        AiffTag aiffTag = new AiffTag();
        AiffFileHeader fileHeader = new AiffFileHeader();
        fileHeader.readHeader(raf, aiffAudioHeader);
        while (raf.getFilePointer() < raf.length()) {
            if (this.readChunk(raf, aiffTag)) continue;
            logger.severe("UnableToReadProcessChunk");
            break;
        }
        if (aiffTag.getID3Tag() == null) {
            aiffTag.setID3Tag(new ID3v22Tag());
        }
        return aiffTag;
    }

    private boolean readChunk(RandomAccessFile raf, AiffTag aiffTag) throws IOException {
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.BIG_ENDIAN);
        if (!chunkHeader.readHeader(raf)) {
            return false;
        }
        long startLocationOfId3TagInFile = raf.getFilePointer();
        ChunkType chunkType = ChunkType.get(chunkHeader.getID());
        if (chunkType != null && chunkType == ChunkType.TAG) {
            ByteBuffer chunkData = this.readChunkDataIntoBuffer(raf, chunkHeader);
            ID3Chunk chunk = new ID3Chunk(chunkHeader, chunkData, aiffTag);
            ((Chunk)chunk).readChunk();
            aiffTag.setExistingId3Tag(true);
            aiffTag.getID3Tag().setStartLocationInFile(startLocationOfId3TagInFile);
            aiffTag.getID3Tag().setEndLocationInFile(raf.getFilePointer());
        } else {
            raf.skipBytes((int)chunkHeader.getSize());
        }
        IffHeaderChunk.ensureOnEqualBoundary(raf, chunkHeader);
        return true;
    }
}

