/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.aiff.AiffTagReader;
import org.jaudiotagger.audio.aiff.chunk.ChunkType;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.generic.TagWriter;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.aiff.AiffTag;

public class AiffTagWriter
implements TagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.aiff");

    private AiffTag getExistingMetadata(RandomAccessFile raf) throws IOException, CannotWriteException {
        try {
            AiffTagReader im = new AiffTagReader();
            return im.read(raf);
        }
        catch (CannotReadException ex) {
            throw new CannotWriteException("Failed to read file");
        }
    }

    private ChunkHeader seekToStartOfListInfoMetadata(RandomAccessFile raf, AiffTag existingTag) throws IOException, CannotWriteException {
        raf.seek(existingTag.getStartLocationInFileOfId3Chunk());
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.BIG_ENDIAN);
        chunkHeader.readHeader(raf);
        raf.seek(raf.getFilePointer() - 8L);
        if (!ChunkType.TAG.getCode().equals(chunkHeader.getID())) {
            throw new CannotWriteException("Unable to find ID3 chunk at expected location");
        }
        return chunkHeader;
    }

    @Override
    public void delete(Tag tag, RandomAccessFile raf, RandomAccessFile tempRaf) throws IOException, CannotWriteException {
        logger.config("Deleting tag from file");
        AiffTag existingTag = this.getExistingMetadata(raf);
        if (existingTag.isExistingId3Tag() && existingTag.getID3Tag().getStartLocationInFile() != null) {
            ChunkHeader chunkHeader = this.seekToStartOfListInfoMetadata(raf, existingTag);
            if (existingTag.getID3Tag().getEndLocationInFile().longValue() == raf.length()) {
                logger.config("Setting new length to:" + existingTag.getStartLocationInFileOfId3Chunk());
                raf.setLength(existingTag.getStartLocationInFileOfId3Chunk());
            } else {
                this.deleteTagChunk(raf, existingTag, chunkHeader);
            }
            this.rewriteRiffHeaderSize(raf);
        }
    }

    private void deleteTagChunk(RandomAccessFile raf, AiffTag existingTag, ChunkHeader tagChunkHeader) throws IOException {
        int lengthTagChunk = (int)tagChunkHeader.getSize() + 8;
        long newLength = raf.length() - (long)lengthTagChunk;
        raf.seek(existingTag.getStartLocationInFileOfId3Chunk() + (long)lengthTagChunk);
        FileChannel channel = raf.getChannel();
        this.deleteTagChunkUsingSmallByteBufferSegments(existingTag, channel, newLength, lengthTagChunk);
        logger.config("Setting new length to:" + newLength);
        raf.setLength(newLength);
    }

    private void deleteTagChunkUsingChannelTransfer(AiffTag existingTag, FileChannel channel, long newLength) throws IOException {
        long read;
        long position = existingTag.getStartLocationInFileOfId3Chunk();
        while ((read = channel.transferFrom(channel, position, newLength - position)) < newLength - position) {
            position += read;
        }
    }

    private void deleteTagChunkUsingSmallByteBufferSegments(AiffTag existingTag, FileChannel channel, long newLength, long lengthTagChunk) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect((int)TagOptionSingleton.getInstance().getWriteChunkSize());
        while (channel.read(buffer) >= 0 || buffer.position() != 0) {
            buffer.flip();
            long readPosition = channel.position();
            channel.position(readPosition - lengthTagChunk - (long)buffer.limit());
            channel.write(buffer);
            channel.position(readPosition);
            buffer.compact();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(AudioFile af, Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotWriteException, IOException {
        logger.severe("Writing tag to file");
        AiffTag existingTag = this.getExistingMetadata(raf);
        try {
            AiffTag aiffTag = (AiffTag)tag;
            ByteBuffer bb = this.convert(aiffTag);
            long newTagSize = bb.limit();
            if (existingTag.isExistingId3Tag() && existingTag.getID3Tag().getStartLocationInFile() != null) {
                ChunkHeader chunkHeader = this.seekToStartOfListInfoMetadata(raf, existingTag);
                logger.info("Current Space allocated:" + aiffTag.getSizeOfID3TagOnly() + ":NewTagRequires:" + newTagSize);
                if (existingTag.getID3Tag().getEndLocationInFile().longValue() == raf.length()) {
                    if (existingTag.getSizeOfID3TagOnly() >= newTagSize) {
                        this.writeDataToFile(raf, bb, aiffTag.getSizeOfID3TagOnly());
                        if (aiffTag.getSizeOfID3TagOnly() > newTagSize) {
                            this.writePaddingToFile(raf, (int)(aiffTag.getSizeOfID3TagOnly() - newTagSize));
                        }
                    } else {
                        this.writeDataToFile(raf, bb, newTagSize);
                    }
                } else {
                    this.deleteTagChunk(raf, existingTag, chunkHeader);
                    raf.seek(raf.length());
                    this.writeDataToFile(raf, bb, newTagSize);
                }
            } else {
                raf.seek(raf.length());
                this.writeDataToFile(raf, bb, newTagSize);
            }
            this.rewriteRiffHeaderSize(raf);
        }
        finally {
            raf.close();
        }
    }

    private void rewriteRiffHeaderSize(RandomAccessFile raf) throws IOException {
        raf.seek(IffHeaderChunk.SIGNATURE_LENGTH);
        raf.write(Utils.getSizeBEInt32((int)raf.length() - IffHeaderChunk.SIGNATURE_LENGTH - IffHeaderChunk.SIZE_LENGTH));
    }

    private void writeDataToFile(RandomAccessFile raf, ByteBuffer bb, long chunkSize) throws IOException {
        ChunkHeader ch = new ChunkHeader(ByteOrder.BIG_ENDIAN);
        ch.setID(ChunkType.TAG.getCode());
        ch.setSize(chunkSize);
        raf.getChannel().write(ch.writeHeader());
        raf.getChannel().write(bb);
    }

    private void writePaddingToFile(RandomAccessFile raf, int paddingSize) throws IOException {
        raf.write(new byte[paddingSize]);
    }

    public ByteBuffer convert(AiffTag tag) throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            tag.getID3Tag().write(baos);
            ByteBuffer buf = ByteBuffer.wrap(baos.toByteArray());
            buf.rewind();
            return buf;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

