/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3Tags;

public class NumberVariableLength
extends AbstractDataType {
    private static final int MINIMUM_NO_OF_DIGITS = 1;
    private static final int MAXIMUM_NO_OF_DIGITS = 8;
    int minLength = 1;

    public NumberVariableLength(String identifier, AbstractTagFrameBody frameBody, int minimumSize) {
        super(identifier, frameBody);
        this.minLength = minimumSize;
    }

    public NumberVariableLength(NumberVariableLength copy) {
        super(copy);
        this.minLength = copy.minLength;
    }

    public int getMaximumLenth() {
        return 8;
    }

    public int getMinimumLength() {
        return this.minLength;
    }

    public void setMinimumSize(int minimumSize) {
        if (minimumSize > 0) {
            this.minLength = minimumSize;
        }
    }

    @Override
    public int getSize() {
        if (this.value == null) {
            return 0;
        }
        long temp = ID3Tags.getWholeNumber(this.value);
        int size = 0;
        for (int i = 1; i <= 8; ++i) {
            int current = (byte)temp & 0xFF;
            if (current != 0) {
                size = i;
            }
            temp >>= 8;
        }
        return this.minLength > size ? this.minLength : size;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof NumberVariableLength)) {
            return false;
        }
        NumberVariableLength object = (NumberVariableLength)obj;
        return this.minLength == object.minLength && super.equals(obj);
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        if (arr == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("negativer offset into an array offset:" + offset);
        }
        if (offset >= arr.length) {
            if (this.minLength == 0) {
                this.value = 0L;
                return;
            }
            throw new InvalidDataTypeException("Offset to byte array is out of bounds: offset = " + offset + ", array.length = " + arr.length);
        }
        long lvalue = 0L;
        for (int i = offset; i < arr.length; ++i) {
            lvalue <<= 8;
            lvalue += (long)(arr[i] & 0xFF);
        }
        this.value = lvalue;
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    @Override
    public byte[] writeByteArray() {
        byte[] arr;
        int size = this.getSize();
        if (size == 0) {
            arr = new byte[]{};
        } else {
            long temp = ID3Tags.getWholeNumber(this.value);
            arr = new byte[size];
            for (int i = size - 1; i >= 0; --i) {
                arr[i] = (byte)(temp & 0xFFL);
                temp >>= 8;
            }
        }
        return arr;
    }
}

