/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.ArrayList;
import java.util.Collection;
import org.limewire.setting.SettingsGroup;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.setting.evt.SettingsGroupEvent;
import org.limewire.setting.evt.SettingsGroupListener;

public abstract class AbstractSettingsGroup
implements SettingsGroup {
    private Collection<SettingsGroupListener> listeners;
    private volatile boolean shouldSave = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSettingsGroupListener(SettingsGroupListener l) {
        if (l == null) {
            throw new NullPointerException("SettingsGroupListener is null");
        }
        AbstractSettingsGroup abstractSettingsGroup = this;
        synchronized (abstractSettingsGroup) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<SettingsGroupListener>();
            }
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSettingsGroupListener(SettingsGroupListener l) {
        if (l == null) {
            throw new NullPointerException("SettingsGroupListener is null");
        }
        AbstractSettingsGroup abstractSettingsGroup = this;
        synchronized (abstractSettingsGroup) {
            if (this.listeners != null) {
                this.listeners.remove(l);
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsGroupListener[] getSettingsGroupListeners() {
        AbstractSettingsGroup abstractSettingsGroup = this;
        synchronized (abstractSettingsGroup) {
            if (this.listeners == null) {
                return null;
            }
            return this.listeners.toArray(new SettingsGroupListener[0]);
        }
    }

    @Override
    public void setShouldSave(boolean shouldSave) {
        if (this.shouldSave != shouldSave) {
            this.shouldSave = shouldSave;
            this.fireSettingsEvent(SettingsGroupEvent.EventType.SHOULD_SAVE);
        }
    }

    @Override
    public boolean getShouldSave() {
        return this.shouldSave;
    }

    protected void fireSettingsEvent(SettingsGroupEvent.EventType type) {
        this.fireSettingsEvent(new SettingsGroupEvent(type, this));
    }

    protected void fireSettingsEvent(final SettingsGroupEvent evt) {
        if (evt == null) {
            throw new NullPointerException("SettingsEvent is null");
        }
        final SettingsGroupListener[] listeners = this.getSettingsGroupListeners();
        if (listeners != null) {
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    for (SettingsGroupListener l : listeners) {
                        l.settingsGroupChanged(evt);
                    }
                }
            };
            SettingsGroupManager.instance().execute(command);
        }
    }
}

