/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.Properties;
import org.limewire.setting.AbstractSetting;
import org.limewire.util.StringUtils;

public class StringArraySetting
extends AbstractSetting {
    public static final char SEPARATOR = ';';
    private String[] value;

    StringArraySetting(Properties defaultProps, Properties props, String key, String[] defaultValue) {
        super(defaultProps, props, key, StringArraySetting.encode(defaultValue));
    }

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String[] value) {
        this.setValueInternal(StringArraySetting.encode(value));
    }

    @Override
    protected void loadValue(String sValue) {
        this.value = StringArraySetting.decode(sValue);
    }

    public static final String[] decode(String src) {
        if (src == null || src.length() == 0) {
            return new String[0];
        }
        return StringUtils.split(src, ';');
    }

    public static final String encode(String[] src) {
        if (src == null || src.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (String str : src) {
            buffer.append(str).append(';');
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    @Override
    public String toString() {
        return StringArraySetting.encode(this.getValue());
    }
}

