/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.Result;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.SslChannel;

final class RemoteConnection {
    private final Pool<ByteBuffer> messageBufferPool;
    private final ConnectedMessageChannel channel;
    private final ConnectedStreamChannel underlyingChannel;
    private final OptionMap optionMap;
    private final RemoteWriteListener writeListener = new RemoteWriteListener();
    private final Executor executor;
    private volatile Result<ConnectionHandlerFactory> result;
    private final AtomicBoolean closeSent = new AtomicBoolean(false);

    RemoteConnection(Pool<ByteBuffer> messageBufferPool, ConnectedStreamChannel underlyingChannel, ConnectedMessageChannel channel, OptionMap optionMap, Executor executor) {
        this.messageBufferPool = messageBufferPool;
        this.underlyingChannel = underlyingChannel;
        this.channel = channel;
        this.optionMap = optionMap;
        this.executor = executor;
    }

    Pooled<ByteBuffer> allocate() {
        return this.messageBufferPool.allocate();
    }

    void setReadListener(ChannelListener<? super ConnectedMessageChannel> listener) {
        RemoteLogger.log.tracef("Setting read listener to %s", listener);
        this.channel.getReadSetter().set(listener);
        if (listener != null) {
            this.channel.resumeReads();
        }
    }

    void setWriteListener(ChannelListener<? super ConnectedMessageChannel> listener) {
        RemoteLogger.log.tracef("Setting write listener to %s", listener);
        this.channel.getWriteSetter().set(listener);
        if (listener != null) {
            this.channel.resumeWrites();
        }
    }

    Result<ConnectionHandlerFactory> getResult() {
        return this.result;
    }

    void setResult(Result<ConnectionHandlerFactory> result) {
        this.result = result;
    }

    void handleException(IOException e) {
        this.handleException(e, true);
    }

    void handleException(IOException e, boolean log) {
        if (log) {
            RemoteLogger.log.connectionError(e);
        } else {
            RemoteLogger.log.tracef(e, "Unlogworthy connection error", new Object[0]);
        }
        IoUtils.safeClose((Closeable)this.channel);
        Result<ConnectionHandlerFactory> result = this.result;
        if (result != null) {
            result.setException(e);
            this.result = null;
        }
    }

    void send(Pooled<ByteBuffer> pooled) {
        this.writeListener.send(pooled, false);
    }

    void send(Pooled<ByteBuffer> pooled, boolean close) {
        this.writeListener.send(pooled, close);
    }

    OptionMap getOptionMap() {
        return this.optionMap;
    }

    ConnectedMessageChannel getChannel() {
        return this.channel;
    }

    ChannelListener<ConnectedMessageChannel> getWriteListener() {
        return this.writeListener;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public SslChannel getSslChannel() {
        return this.underlyingChannel instanceof SslChannel ? (SslChannel)this.underlyingChannel : null;
    }

    void handleIncomingCloseRequest() {
        RemoteLogger.log.tracef("Received connection close request", new Object[0]);
        try {
            this.channel.shutdownReads();
        }
        catch (IOException e) {
            RemoteLogger.log.debugf("Failed to shut down reads: %s", e);
        }
        this.sendCloseRequest();
    }

    boolean handleOutboundCloseRequest() {
        RemoteLogger.log.trace("Initiating connection close request");
        return this.sendCloseRequest();
    }

    void handleChannelClose() {
        this.closeSent.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendCloseRequest() {
        if (this.closeSent.compareAndSet(false, true)) {
            Pooled<ByteBuffer> pooled = this.allocate();
            boolean ok = false;
            try {
                ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                buffer.put((byte)-1);
                buffer.flip();
                this.writeListener.send(pooled, true);
                ok = true;
            }
            finally {
                if (!ok) {
                    pooled.free();
                }
            }
            return true;
        }
        return false;
    }

    final class RemoteWriteListener
    implements ChannelListener<ConnectedMessageChannel> {
        private final Queue<Pooled<ByteBuffer>> queue = new ArrayDeque<Pooled<ByteBuffer>>();
        private boolean closed;

        RemoteWriteListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            RemoteConnection remoteConnection = RemoteConnection.this;
            synchronized (remoteConnection) {
                block10: {
                    assert (channel == RemoteConnection.this.getChannel());
                    Queue<Pooled<ByteBuffer>> queue = this.queue;
                    try {
                        Pooled<ByteBuffer> pooled;
                        while ((pooled = queue.peek()) != null) {
                            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                            if (channel.send(buffer)) {
                                RemoteLogger.log.tracef("Sent message %s (via queue)", buffer);
                                queue.poll().free();
                                continue;
                            }
                            channel.suspendWrites();
                            return;
                        }
                        if (!channel.flush()) break block10;
                        RemoteLogger.log.tracef("Flushed channel", new Object[0]);
                        if (this.closed) {
                            channel.shutdownWrites();
                            return;
                        }
                        channel.suspendWrites();
                    }
                    catch (IOException e) {
                        Pooled<ByteBuffer> pooled;
                        RemoteConnection.this.handleException(e, false);
                        while ((pooled = queue.poll()) != null) {
                            pooled.free();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownWrites() {
            RemoteConnection remoteConnection = RemoteConnection.this;
            synchronized (remoteConnection) {
                block7: {
                    this.closed = true;
                    ConnectedMessageChannel channel = RemoteConnection.this.getChannel();
                    try {
                        if (!this.queue.isEmpty()) break block7;
                        if (!channel.flush()) {
                            channel.resumeWrites();
                            return;
                        }
                        RemoteLogger.log.tracef("Flushed channel", new Object[0]);
                    }
                    catch (IOException e) {
                        Pooled<ByteBuffer> unqueued;
                        RemoteConnection.this.handleException(e, false);
                        while ((unqueued = this.queue.poll()) != null) {
                            unqueued.free();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void send(Pooled<ByteBuffer> pooled, boolean close) {
            RemoteConnection remoteConnection = RemoteConnection.this;
            // MONITORENTER : remoteConnection
            if (this.closed) {
                pooled.free();
                // MONITOREXIT : remoteConnection
                return;
            }
            if (close) {
                this.closed = true;
            }
            ConnectedMessageChannel channel = RemoteConnection.this.getChannel();
            boolean free = true;
            try {
                if (this.queue.isEmpty()) {
                    ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                    if (!channel.send(buffer)) {
                        RemoteLogger.log.tracef("Can't directly send message %s, enqueued", buffer);
                        this.queue.add(pooled);
                        free = false;
                        channel.resumeWrites();
                        return;
                    }
                    RemoteLogger.log.tracef("Sent message %s (direct)", buffer);
                    if (!channel.flush()) {
                        channel.resumeWrites();
                        return;
                    }
                    RemoteLogger.log.tracef("Flushed channel", new Object[0]);
                    if (!close) return;
                    if (channel.shutdownWrites()) {
                        RemoteLogger.log.trace("Shut down writes on channel");
                        return;
                    }
                    channel.resumeWrites();
                    return;
                }
                this.queue.add(pooled);
                free = false;
                return;
            }
            catch (IOException e) {
                Pooled<ByteBuffer> unqueued;
                RemoteConnection.this.handleException(e, false);
                while ((unqueued = this.queue.poll()) != null) {
                    unqueued.free();
                }
                return;
            }
            finally {
                if (free) {
                    pooled.free();
                }
            }
        }
    }
}

