/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.File;

public class DefaultJvmUtils {
    public static String getCurrentJvmHome() {
        return System.getProperty("java.home");
    }

    public static String findJavaExecutable(String javaHome) {
        File file = new File(javaHome);
        if (!file.exists()) {
            throw new IllegalStateException("Java home '" + file.getAbsolutePath() + "' does not exist.");
        }
        if (!(file = new File(file, "bin")).exists()) {
            throw new IllegalStateException("Java home's bin '" + file.getAbsolutePath() + "' does not exist. The home directory was determined to be " + file.getParentFile().getAbsolutePath() + ".");
        }
        File java = new File(file, "java");
        if (!java.exists()) {
            java = new File(file, "java.exe");
        }
        if (!java.exists()) {
            throw new IllegalStateException("Could not find java executable under " + file.getAbsolutePath());
        }
        return java.getAbsolutePath();
    }
}

