/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBViewConfiguration;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.msc.service.ServiceName;

public final class EJBViewDescription
extends ViewDescription {
    private final MethodIntf methodIntf;
    private final boolean hasJNDIBindings;

    public EJBViewDescription(ComponentDescription componentDescription, String viewClassName, MethodIntf methodIntf) {
        super(componentDescription, viewClassName);
        this.methodIntf = methodIntf;
        this.hasJNDIBindings = this.initHasJNDIBindings(methodIntf);
    }

    public MethodIntf getMethodIntf() {
        return this.methodIntf;
    }

    public ViewConfiguration createViewConfiguration(Class<?> viewClass, ComponentConfiguration componentConfiguration, ProxyFactory<?> proxyFactory) {
        return new EJBViewConfiguration(viewClass, componentConfiguration, this.getServiceName(), proxyFactory, this.getMethodIntf());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EJBViewDescription that = (EJBViewDescription)((Object)o);
        if (this.hasJNDIBindings != that.hasJNDIBindings) {
            return false;
        }
        if (this.methodIntf != that.methodIntf) {
            return false;
        }
        return this.getViewClassName().equals(that.getViewClassName());
    }

    public ServiceName getServiceName() {
        return super.getServiceName().append(new String[]{this.methodIntf.toString()});
    }

    public int hashCode() {
        int result = this.methodIntf.hashCode();
        result = 31 * result + (this.hasJNDIBindings ? 1 : 0);
        result = 31 * result + this.getViewClassName().hashCode();
        return result;
    }

    public boolean hasJNDIBindings() {
        return this.hasJNDIBindings;
    }

    private boolean initHasJNDIBindings(MethodIntf methodIntf) {
        if (methodIntf == MethodIntf.MESSAGE_ENDPOINT) {
            return false;
        }
        if (methodIntf == MethodIntf.SERVICE_ENDPOINT) {
            return false;
        }
        return methodIntf != MethodIntf.TIMER;
    }
}

