/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.util.concurrent.locks.ReentrantLock;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.EJBException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ejb3.component.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulComponentInstanceInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.ejb3.cache.Identifiable;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;

public class StatefulSessionSynchronizationInterceptor
extends AbstractEJBInterceptor {
    private static final Logger log = Logger.getLogger(StatefulSessionSynchronizationInterceptor.class);
    private final ReentrantLock lock = new ReentrantLock(true);
    private Object transactionKey = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Error handleThrowableInTxSync(StatefulSessionComponentInstance statefulSessionComponentInstance, Throwable t) {
        log.error((Object)("Discarding stateful component instance: " + (Object)((Object)statefulSessionComponentInstance) + " due to exception"), t);
        try {
            statefulSessionComponentInstance.discard();
        }
        finally {
            this.transactionKey = null;
            this.releaseLock();
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw (EJBException)new EJBException().initCause(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        boolean acquired;
        StatefulSessionComponent component = StatefulSessionSynchronizationInterceptor.getComponent(context, StatefulSessionComponent.class);
        StatefulSessionComponentInstance instance = StatefulComponentInstanceInterceptor.getComponentInstance(context);
        TransactionSynchronizationRegistry transactionSynchronizationRegistry = component.getTransactionSynchronizationRegistry();
        AccessTimeout timeout = component.getAccessTimeout(context.getMethod());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Trying to acquire lock: " + this.lock + " for stateful component instance: " + (Object)((Object)instance) + " during invocation: " + context));
        }
        if (!(acquired = this.lock.tryLock(timeout.value(), timeout.unit()))) {
            throw new ConcurrentAccessTimeoutException("EJB 3.1 FR 4.3.14.1 concurrent access timeout on " + context + " - could not obtain lock within " + timeout.value() + (Object)((Object)timeout.unit()));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Acquired lock: " + this.lock + " for stateful component instance: " + (Object)((Object)instance) + " during invocation: " + context));
        }
        Object currentTransactionKey = null;
        boolean wasTxSyncRegistered = false;
        try {
            currentTransactionKey = transactionSynchronizationRegistry.getTransactionKey();
            if (this.transactionKey != null) {
                if (!this.transactionKey.equals(currentTransactionKey)) {
                    throw new EJBException("EJB 3.1 FR 4.6 Stateful instance " + (Object)((Object)instance) + " is already associated with tx " + this.transactionKey + " (current tx " + currentTransactionKey + ")");
                }
            } else if (currentTransactionKey != null) {
                this.transactionKey = currentTransactionKey;
                StatefulSessionSynchronization statefulSessionSync = new StatefulSessionSynchronization(instance);
                transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)statefulSessionSync);
                wasTxSyncRegistered = true;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Registered tx synchronization: " + statefulSessionSync + " for tx: " + currentTransactionKey + " associated with stateful component instance: " + (Object)((Object)instance)));
                }
                instance.afterBegin();
            }
            Object object = context.proceed();
            return object;
        }
        finally {
            if (!wasTxSyncRegistered) {
                this.releaseInstance(instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInstance(StatefulSessionComponentInstance instance) {
        try {
            instance.getComponent().getCache().release((Identifiable)instance);
        }
        finally {
            this.releaseLock();
        }
    }

    private void releaseLock() {
        this.lock.unlock();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Released lock: " + this.lock));
        }
    }

    private class StatefulSessionSynchronization
    implements Synchronization {
        private StatefulSessionComponentInstance statefulSessionComponentInstance;

        StatefulSessionSynchronization(StatefulSessionComponentInstance statefulSessionComponentInstance) {
            this.statefulSessionComponentInstance = statefulSessionComponentInstance;
        }

        public void beforeCompletion() {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Before completion callback invoked on Transaction synchronization: " + this + " of stateful component instance: " + (Object)((Object)this.statefulSessionComponentInstance)));
                }
                this.statefulSessionComponentInstance.beforeCompletion();
            }
            catch (Throwable t) {
                throw StatefulSessionSynchronizationInterceptor.this.handleThrowableInTxSync(this.statefulSessionComponentInstance, t);
            }
        }

        public void afterCompletion(int status) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("After completion callback invoked on Transaction synchronization: " + this + " of stateful component instance: " + (Object)((Object)this.statefulSessionComponentInstance)));
                }
                this.statefulSessionComponentInstance.afterCompletion(status == 3);
            }
            catch (Throwable t) {
                throw StatefulSessionSynchronizationInterceptor.this.handleThrowableInTxSync(this.statefulSessionComponentInstance, t);
            }
            StatefulSessionSynchronizationInterceptor.this.transactionKey = null;
            StatefulSessionSynchronizationInterceptor.this.releaseInstance(this.statefulSessionComponentInstance);
        }
    }
}

