/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JacORBLogFormatter
extends Formatter {
    private static final DateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public String format(LogRecord logRecord) {
        long l = logRecord.getMillis();
        String string = logRecord.getLoggerName();
        Level level = logRecord.getLevel();
        String string2 = logRecord.getMessage();
        Throwable throwable = logRecord.getThrown();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(timeFormat.format(new Long(l)));
        stringBuffer.append(" ");
        stringBuffer.append(level);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append("\n");
        return throwable == null ? stringBuffer.toString() : stringBuffer.toString() + this.getStackTrace(throwable);
    }

    private String getStackTrace(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuffer.append("    ");
            stringBuffer.append(stackTraceElementArray[i].toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

