/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.UnregisterWebAppVisitorWC;
import org.ops4j.pax.web.extender.war.internal.WebAppVisitor;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppConstraintMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppLoginConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.osgi.service.http.HttpService;

class UnregisterWebAppVisitorHS
implements WebAppVisitor {
    private static final Log LOG = LogFactory.getLog(UnregisterWebAppVisitorWC.class);
    private final HttpService m_httpService;

    UnregisterWebAppVisitorHS(HttpService httpService) {
        NullArgumentException.validateNotNull((Object)httpService, (String)"Http Service");
        this.m_httpService = httpService;
    }

    public void visit(WebApp webApp) {
        try {
            this.m_httpService.unregister("/");
        }
        catch (Exception ignore) {
            LOG.error((Object)"Unregistration exception. Skipping.", (Throwable)ignore);
        }
    }

    public void visit(WebAppServlet webAppServlet) {
        NullArgumentException.validateNotNull((Object)webAppServlet, (String)"Web app servlet");
        String[] aliases = webAppServlet.getAliases();
        if (aliases != null && aliases.length > 0) {
            for (String alias : aliases) {
                try {
                    this.m_httpService.unregister(alias);
                }
                catch (Exception ignore) {
                    LOG.error((Object)"Unregistration exception. Skipping.", (Throwable)ignore);
                }
            }
        } else {
            LOG.warn((Object)("Servlet [" + webAppServlet + "] does not have any alias. Skipped."));
        }
    }

    public void visit(WebAppFilter webAppFilter) {
        LOG.info((Object)("Pax Web not available. Skipping filter unregistration for [" + webAppFilter + "]"));
    }

    public void visit(WebAppListener webAppListener) {
        LOG.info((Object)("Pax Web not available. Skipping listener unregistration for [" + webAppListener + "]"));
    }

    public void visit(WebAppErrorPage webAppErrorPage) {
        LOG.info((Object)("Pax Web not available. Skipping error page unregistration for [" + webAppErrorPage + "]"));
    }

    public void visit(WebAppLoginConfig loginConfig) {
        LOG.info((Object)("Pax Web not available. Skipping listener unregistration for [" + loginConfig + "]"));
    }

    public void visit(WebAppConstraintMapping constraintMapping) {
        LOG.info((Object)("Pax Web not available. Skipping listener unregistration for [" + constraintMapping + "]"));
    }
}

