/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PropertyValueException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.WrongClassException;
import org.hibernate.bytecode.instrumentation.internal.FieldInterceptionHelper;
import org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractSaveEventListener;
import org.hibernate.event.internal.EventCache;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.jboss.logging.Logger;

public class DefaultMergeEventListener
extends AbstractSaveEventListener
implements MergeEventListener {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)DefaultMergeEventListener.class.getName());

    @Override
    protected Map getMergeMap(Object anything) {
        return ((EventCache)anything).invertMap();
    }

    @Override
    public void onMerge(MergeEvent event) throws HibernateException {
        EventCache copyCache = new EventCache();
        this.onMerge(event, copyCache);
        EventCache transientCopyCache = this.getTransientCopyCache(event, copyCache);
        if (transientCopyCache.size() > 0) {
            this.retryMergeTransientEntities(event, transientCopyCache, copyCache, true);
            transientCopyCache = this.getTransientCopyCache(event, copyCache);
            if (transientCopyCache.size() > 0) {
                HashSet<String> transientEntityNames = new HashSet<String>();
                Iterator it = transientCopyCache.entrySet().iterator();
                while (it.hasNext()) {
                    Object transientEntity = it.next().getKey();
                    String transientEntityName = event.getSession().guessEntityName(transientEntity);
                    transientEntityNames.add(transientEntityName);
                    LOG.trace("Transient instance could not be processed by merge when checking nullability: " + transientEntityName + "[" + transientEntity + "]");
                }
                if (this.isNullabilityCheckedGlobal(event.getSession())) {
                    throw new TransientObjectException("one or more objects is an unsaved transient instance - save transient instance(s) before merging: " + transientEntityNames);
                }
                LOG.trace("Retry saving transient instances without checking nullability");
                this.retryMergeTransientEntities(event, transientCopyCache, copyCache, false);
            }
        }
        copyCache.clear();
        copyCache = null;
    }

    protected EventCache getTransientCopyCache(MergeEvent event, EventCache copyCache) {
        EventCache transientCopyCache = new EventCache();
        for (Map.Entry mapEntry : copyCache.entrySet()) {
            EntityEntry copyEntry;
            Object entity = mapEntry.getKey();
            Object copy = mapEntry.getValue();
            if (copy instanceof HibernateProxy) {
                copy = ((HibernateProxy)copy).getHibernateLazyInitializer().getImplementation();
            }
            if ((copyEntry = event.getSession().getPersistenceContext().getEntry(copy)) == null) {
                LOG.trace("Transient instance could not be processed by merge: " + event.getSession().guessEntityName(copy) + "[" + entity + "]");
                if (!this.isNullabilityCheckedGlobal(event.getSession())) continue;
                throw new TransientObjectException("object is an unsaved transient instance - save the transient instance before merging: " + event.getSession().guessEntityName(copy));
            }
            if (copyEntry.getStatus() == Status.SAVING) {
                transientCopyCache.put(entity, copy, copyCache.isOperatedOn(entity));
                continue;
            }
            if (copyEntry.getStatus() == Status.MANAGED || copyEntry.getStatus() == Status.READ_ONLY) continue;
            throw new AssertionFailure("Merged entity does not have status set to MANAGED or READ_ONLY; " + copy + " status=" + (Object)((Object)copyEntry.getStatus()));
        }
        return transientCopyCache;
    }

    protected void retryMergeTransientEntities(MergeEvent event, Map transientCopyCache, EventCache copyCache, boolean isNullabilityChecked) {
        for (Map.Entry mapEntry : transientCopyCache.entrySet()) {
            Object entity = mapEntry.getKey();
            Object copy = transientCopyCache.get(entity);
            EntityEntry copyEntry = event.getSession().getPersistenceContext().getEntry(copy);
            this.mergeTransientEntity(entity, copyEntry.getEntityName(), entity == event.getEntity() ? event.getRequestedId() : copyEntry.getId(), event.getSession(), copyCache, isNullabilityChecked);
        }
    }

    @Override
    public void onMerge(MergeEvent event, Map copiedAlready) throws HibernateException {
        EventCache copyCache = (EventCache)copiedAlready;
        EventSource source = event.getSession();
        Object original = event.getOriginal();
        if (original != null) {
            Object entity;
            if (original instanceof HibernateProxy) {
                LazyInitializer li = ((HibernateProxy)original).getHibernateLazyInitializer();
                if (li.isUninitialized()) {
                    LOG.trace("Ignoring uninitialized proxy");
                    event.setResult(source.load(li.getEntityName(), li.getIdentifier()));
                    return;
                }
                entity = li.getImplementation();
            } else {
                entity = original;
            }
            if (copyCache.containsKey(entity) && copyCache.isOperatedOn(entity)) {
                LOG.trace("Already in merge process");
                event.setResult(entity);
            } else {
                EntityPersister persister;
                Serializable id;
                if (copyCache.containsKey(entity)) {
                    LOG.trace("Already in copyCache; setting in merge process");
                    copyCache.setOperatedOn(entity, true);
                }
                event.setEntity(entity);
                Enum entityState = null;
                EntityEntry entry = source.getPersistenceContext().getEntry(entity);
                if (entry == null && (id = (persister = source.getEntityPersister(event.getEntityName(), entity)).getIdentifier(entity, source)) != null) {
                    EntityKey key = source.generateEntityKey(id, persister);
                    Object managedEntity = source.getPersistenceContext().getEntity(key);
                    entry = source.getPersistenceContext().getEntry(managedEntity);
                    if (entry != null) {
                        entityState = AbstractSaveEventListener.EntityState.DETACHED;
                    }
                }
                if (entityState == null) {
                    entityState = this.getEntityState(entity, event.getEntityName(), entry, source);
                }
                switch (1.$SwitchMap$org$hibernate$event$internal$AbstractSaveEventListener$EntityState[entityState.ordinal()]) {
                    case 1: {
                        this.entityIsDetached(event, copyCache);
                        break;
                    }
                    case 2: {
                        this.entityIsTransient(event, copyCache);
                        break;
                    }
                    case 3: {
                        this.entityIsPersistent(event, copyCache);
                        break;
                    }
                    default: {
                        throw new ObjectDeletedException("deleted instance passed to merge", null, this.getLoggableName(event.getEntityName(), entity));
                    }
                }
            }
        }
    }

    protected void entityIsPersistent(MergeEvent event, Map copyCache) {
        LOG.trace("Ignoring persistent instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        ((EventCache)copyCache).put(entity, entity, true);
        this.cascadeOnMerge(source, persister, entity, copyCache);
        this.copyValues(persister, entity, entity, source, copyCache);
        event.setResult(entity);
    }

    protected void entityIsTransient(MergeEvent event, Map copyCache) {
        LOG.trace("Merging transient instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        String entityName = persister.getEntityName();
        event.setResult(this.mergeTransientEntity(entity, entityName, event.getRequestedId(), source, copyCache, true));
    }

    protected Object mergeTransientEntity(Object entity, String entityName, Serializable requestedId, EventSource source, Map copyCache) {
        return this.mergeTransientEntity(entity, entityName, requestedId, source, copyCache, true);
    }

    private Object mergeTransientEntity(Object entity, String entityName, Serializable requestedId, EventSource source, Map copyCache, boolean isNullabilityChecked) {
        Object copy;
        EntityPersister persister;
        block9: {
            Serializable id;
            LOG.trace("Merging transient instance");
            persister = source.getEntityPersister(entityName, entity);
            Serializable serializable = id = persister.hasIdentifierProperty() ? persister.getIdentifier(entity, source) : null;
            if (copyCache.containsKey(entity)) {
                persister.setIdentifier(copyCache.get(entity), id, source);
            } else {
                ((EventCache)copyCache).put(entity, source.instantiate(persister, id), true);
            }
            copy = copyCache.get(entity);
            super.cascadeBeforeSave(source, persister, entity, copyCache);
            this.copyValues(persister, entity, copy, source, copyCache, ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT);
            try {
                this.saveTransientEntity(copy, entityName, requestedId, source, copyCache, isNullabilityChecked);
            }
            catch (PropertyValueException ex) {
                String propertyName = ex.getPropertyName();
                Object propertyFromCopy = persister.getPropertyValue(copy, propertyName);
                Object propertyFromEntity = persister.getPropertyValue(entity, propertyName);
                Type propertyType = persister.getPropertyType(propertyName);
                EntityEntry copyEntry = source.getPersistenceContext().getEntry(copy);
                if (propertyFromCopy == null || propertyFromEntity == null || !propertyType.isEntityType() || !copyCache.containsKey(propertyFromEntity)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Property '" + copyEntry.getEntityName() + "." + propertyName + "' in copy is " + (propertyFromCopy == null ? "null" : propertyFromCopy));
                        LOG.trace("Property '" + copyEntry.getEntityName() + "." + propertyName + "' in original is " + (propertyFromCopy == null ? "null" : propertyFromCopy));
                        LOG.trace("Property '" + copyEntry.getEntityName() + "." + propertyName + "' is" + (propertyType.isEntityType() ? "" : " not") + " an entity type");
                        if (propertyFromEntity != null && !copyCache.containsKey(propertyFromEntity)) {
                            LOG.tracef("Property '%s.%s' is not in copy cache", copyEntry.getEntityName(), propertyName);
                        }
                    }
                    if (this.isNullabilityCheckedGlobal(source)) {
                        throw ex;
                    }
                    this.saveTransientEntity(copy, entityName, requestedId, source, copyCache, false);
                }
                if (!LOG.isTraceEnabled() || propertyFromEntity == null) break block9;
                if (((EventCache)copyCache).isOperatedOn(propertyFromEntity)) {
                    LOG.trace("Property '" + copyEntry.getEntityName() + "." + propertyName + "' from original entity is in copyCache and is in the process of being merged; " + propertyName + " =[" + propertyFromEntity + "]");
                }
                LOG.trace("Property '" + copyEntry.getEntityName() + "." + propertyName + "' from original entity is in copyCache and is not in the process of being merged; " + propertyName + " =[" + propertyFromEntity + "]");
            }
        }
        super.cascadeAfterSave(source, persister, entity, copyCache);
        this.copyValues(persister, entity, copy, source, copyCache, ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        return copy;
    }

    private boolean isNullabilityCheckedGlobal(EventSource source) {
        return source.getFactory().getSettings().isCheckNullability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTransientEntity(Object entity, String entityName, Serializable requestedId, EventSource source, Map copyCache, boolean isNullabilityChecked) {
        boolean isNullabilityCheckedOrig = source.getFactory().getSettings().isCheckNullability();
        try {
            source.getFactory().getSettings().setCheckNullability(isNullabilityChecked);
            if (requestedId == null) {
                this.saveWithGeneratedId(entity, entityName, copyCache, source, false);
            } else {
                this.saveWithRequestedId(entity, requestedId, entityName, copyCache, source);
            }
        }
        finally {
            source.getFactory().getSettings().setCheckNullability(isNullabilityCheckedOrig);
        }
    }

    protected void entityIsDetached(MergeEvent event, Map copyCache) {
        LOG.trace("Merging detached instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        String entityName = persister.getEntityName();
        Serializable id = event.getRequestedId();
        if (id == null) {
            id = persister.getIdentifier(entity, source);
        } else {
            Serializable entityId = persister.getIdentifier(entity, source);
            if (!persister.getIdentifierType().isEqual(id, entityId, source.getFactory())) {
                throw new HibernateException("merge requested with id not matching id of passed entity");
            }
        }
        String previousFetchProfile = source.getFetchProfile();
        source.setFetchProfile("merge");
        Serializable clonedIdentifier = (Serializable)persister.getIdentifierType().deepCopy(id, source.getFactory());
        Object result = source.get(entityName, clonedIdentifier);
        source.setFetchProfile(previousFetchProfile);
        if (result == null) {
            this.entityIsTransient(event, copyCache);
        } else {
            ((EventCache)copyCache).put(entity, result, true);
            Object target = source.getPersistenceContext().unproxy(result);
            if (target == entity) {
                throw new AssertionFailure("entity was not detached");
            }
            if (!source.getEntityName(target).equals(entityName)) {
                throw new WrongClassException("class of the given object did not match class of persistent copy", event.getRequestedId(), entityName);
            }
            if (this.isVersionChanged(entity, source, persister, target)) {
                if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                    source.getFactory().getStatisticsImplementor().optimisticFailure(entityName);
                }
                throw new StaleObjectStateException(entityName, id);
            }
            this.cascadeOnMerge(source, persister, entity, copyCache);
            this.copyValues(persister, entity, target, source, copyCache);
            this.markInterceptorDirty(entity, target);
            event.setResult(result);
        }
    }

    private void markInterceptorDirty(Object entity, Object target) {
        FieldInterceptor interceptor;
        if (FieldInterceptionHelper.isInstrumented(entity) && (interceptor = FieldInterceptionHelper.extractFieldInterceptor(target)) != null) {
            interceptor.dirty();
        }
    }

    private boolean isVersionChanged(Object entity, EventSource source, EntityPersister persister, Object target) {
        if (!persister.isVersioned()) {
            return false;
        }
        boolean changed = !persister.getVersionType().isSame(persister.getVersion(target), persister.getVersion(entity));
        return changed && this.existsInDatabase(target, source, persister);
    }

    private boolean existsInDatabase(Object entity, EventSource source, EntityPersister persister) {
        Serializable id;
        EntityEntry entry = source.getPersistenceContext().getEntry(entity);
        if (entry == null && (id = persister.getIdentifier(entity, source)) != null) {
            EntityKey key = source.generateEntityKey(id, persister);
            Object managedEntity = source.getPersistenceContext().getEntity(key);
            entry = source.getPersistenceContext().getEntry(managedEntity);
        }
        return entry != null && entry.isExistsInDatabase();
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, Map copyCache) {
        Object[] copiedValues = TypeHelper.replace(persister.getPropertyValues(entity), persister.getPropertyValues(target), persister.getPropertyTypes(), source, target, copyCache);
        persister.setPropertyValues(target, copiedValues);
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, Map copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copiedValues = foreignKeyDirection == ForeignKeyDirection.FOREIGN_KEY_TO_PARENT ? TypeHelper.replaceAssociations(persister.getPropertyValues(entity), persister.getPropertyValues(target), persister.getPropertyTypes(), source, target, copyCache, foreignKeyDirection) : TypeHelper.replace(persister.getPropertyValues(entity), persister.getPropertyValues(target), persister.getPropertyTypes(), source, target, copyCache, foreignKeyDirection);
        persister.setPropertyValues(target, copiedValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeOnMerge(EventSource source, EntityPersister persister, Object entity, Map copyCache) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadeAction(), 0, source).cascade(persister, entity, copyCache);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    @Override
    protected CascadingAction getCascadeAction() {
        return CascadingAction.MERGE;
    }

    @Override
    protected Boolean getAssumedUnsaved() {
        return Boolean.FALSE;
    }

    @Override
    protected void cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, Object anything) throws HibernateException {
    }

    @Override
    protected void cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, Object anything) throws HibernateException {
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$hibernate$event$internal$AbstractSaveEventListener$EntityState;

        static {
            $SwitchMap$org$hibernate$event$internal$AbstractSaveEventListener$EntityState = new int[AbstractSaveEventListener.EntityState.values().length];
            try {
                1.$SwitchMap$org$hibernate$event$internal$AbstractSaveEventListener$EntityState[AbstractSaveEventListener.EntityState.DETACHED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$hibernate$event$internal$AbstractSaveEventListener$EntityState[AbstractSaveEventListener.EntityState.TRANSIENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$hibernate$event$internal$AbstractSaveEventListener$EntityState[AbstractSaveEventListener.EntityState.PERSISTENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

