/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.InterfaceDescription;
import org.jboss.as.controller.interfaces.ParsedInterfaceCriteria;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class InterfaceAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static final InterfaceAddHandler NAMED_INSTANCE = new InterfaceAddHandler(false);
    public static final InterfaceAddHandler SPECIFIED_INSTANCE = new InterfaceAddHandler(true);
    private final boolean specified;

    public static ModelNode getAddInterfaceOperation(ModelNode address, ModelNode criteria) {
        ModelNode op = Util.getEmptyOperation(OPERATION_NAME, address);
        op.get("criteria").set(criteria);
        return op;
    }

    protected InterfaceAddHandler(boolean specified) {
        this.specified = specified;
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) {
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress(opAddr);
        String name = address.getLastElement().getValue();
        model.get("name").set(name);
        ModelNode criteriaNode = operation.get("criteria");
        model.get("criteria").set(criteriaNode);
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String name = this.getInterfaceName(operation);
        ParsedInterfaceCriteria parsed = this.getCriteria(operation);
        if (parsed.getFailureMessage() != null) {
            throw new OperationFailedException(new ModelNode().set(parsed.getFailureMessage()));
        }
        this.performRuntime(context, operation, model, verificationHandler, newControllers, name, parsed);
    }

    protected String getInterfaceName(ModelNode operation) {
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress(opAddr);
        String name = address.getLastElement().getValue();
        return name;
    }

    protected ParsedInterfaceCriteria getCriteria(ModelNode operation) {
        ModelNode criteriaNode = operation.get("criteria");
        return ParsedInterfaceCriteria.parse(criteriaNode.clone(), this.specified);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, String name, ParsedInterfaceCriteria criteria) {
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return this.specified ? InterfaceDescription.getSpecifiedInterfaceAddOperation(locale) : InterfaceDescription.getNamedInterfaceAddOperation(locale);
    }
}

