/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.coloc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.coloc.ColocInInterceptor;
import org.apache.cxf.binding.coloc.ColocUtil;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.ChainInitiationObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColocMessageObserver
extends ChainInitiationObserver {
    private static final Logger LOG = LogUtils.getL7dLogger(ColocMessageObserver.class);
    private static final String COLOCATED = Message.class.getName() + ".COLOCATED";

    public ColocMessageObserver(Endpoint endpoint, Bus bus) {
        super(endpoint, bus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message m) {
        Bus origBus = BusFactory.getThreadDefaultBus((boolean)false);
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
            if (loader != null) {
                Thread.currentThread().setContextClassLoader(loader);
            }
            BusFactory.setThreadDefaultBus((Bus)this.bus);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Processing Message at collocated endpoint.  Request message: " + m);
            }
            ExchangeImpl ex = new ExchangeImpl();
            this.setExchangeProperties((Exchange)ex, m);
            Message inMsg = this.endpoint.getBinding().createMessage();
            MessageImpl.copyContent((Message)m, (Message)inMsg);
            inMsg.putAll((Map)m);
            inMsg.put((Object)COLOCATED, (Object)Boolean.TRUE);
            inMsg.put((Object)"org.apache.cxf.client", (Object)Boolean.FALSE);
            inMsg.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.TRUE);
            OperationInfo oi = (OperationInfo)ex.get(OperationInfo.class);
            if (oi != null) {
                inMsg.put(MessageInfo.class, (Object)oi.getInput());
            }
            ex.setInMessage(inMsg);
            inMsg.setExchange((Exchange)ex);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Build inbound interceptor chain.");
            }
            TreeSet<Phase> phases = new TreeSet<Phase>(((PhaseManager)this.bus.getExtension(PhaseManager.class)).getInPhases());
            ColocUtil.setPhases(phases, "user-logical", "invoke");
            InterceptorChain chain = ColocUtil.getInInterceptorChain((Exchange)ex, phases);
            chain.add(this.addColocInterceptors());
            inMsg.setInterceptorChain(chain);
            OperationInfo soi = (OperationInfo)m.getExchange().get(OperationInfo.class);
            if (soi != null && oi != null) {
                if (ColocUtil.isAssignableOperationInfo(soi, Source.class) && !ColocUtil.isAssignableOperationInfo(oi, Source.class)) {
                    ColocUtil.convertSourceToObject(inMsg);
                } else if (ColocUtil.isAssignableOperationInfo(oi, Source.class) && !ColocUtil.isAssignableOperationInfo(soi, Source.class)) {
                    ColocUtil.convertObjectToSource(inMsg);
                }
            }
            chain.doIntercept(inMsg);
            if (soi != null && oi != null) {
                if (ColocUtil.isAssignableOperationInfo(soi, Source.class) && !ColocUtil.isAssignableOperationInfo(oi, Source.class) && ex.getOutMessage() != null) {
                    ColocUtil.convertObjectToSource(ex.getOutMessage());
                } else if (ColocUtil.isAssignableOperationInfo(oi, Source.class) && !ColocUtil.isAssignableOperationInfo(soi, Source.class) && ex.getOutMessage() != null) {
                    ColocUtil.convertSourceToObject(ex.getOutMessage());
                }
            }
            this.setOutBoundMessage((Exchange)ex, m.getExchange());
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)origBus);
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    protected void setOutBoundMessage(Exchange from, Exchange to) {
        if (from.getOutFaultMessage() != null) {
            to.setInFaultMessage(from.getOutFaultMessage());
        } else {
            to.setInMessage(from.getOutMessage());
        }
    }

    protected void setExchangeProperties(Exchange exchange, Message m) {
        exchange.put(Bus.class, (Object)this.bus);
        exchange.put(Endpoint.class, (Object)this.endpoint);
        exchange.put(Service.class, (Object)this.endpoint.getService());
        exchange.put(Binding.class, (Object)this.endpoint.getBinding());
        QName opName = (QName)m.get((Object)"javax.xml.ws.wsdl.operation");
        BindingInfo bi = this.endpoint.getEndpointInfo().getBinding();
        BindingOperationInfo boi = bi.getOperation(opName);
        if (boi != null && boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
        }
        exchange.put(BindingInfo.class, (Object)bi);
        exchange.put(BindingOperationInfo.class, (Object)boi);
        exchange.put(OperationInfo.class, (Object)boi.getOperationInfo());
    }

    protected List<Interceptor<? extends Message>> addColocInterceptors() {
        ArrayList<Interceptor<? extends Message>> list = new ArrayList<Interceptor<? extends Message>>();
        list.add((Interceptor<? extends Message>)new ColocInInterceptor());
        return list;
    }
}

