/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.List;
import org.jboss.as.ee.component.EEResourceReferenceProcessor;
import org.jboss.as.ee.component.EEResourceReferenceProcessorRegistry;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.webservices.deployers.AspectDeploymentProcessor;
import org.jboss.as.webservices.deployers.WSDependenciesProcessor;
import org.jboss.as.webservices.deployers.WSDescriptorDeploymentProcessor;
import org.jboss.as.webservices.deployers.WSEJBIntegrationProcessor;
import org.jboss.as.webservices.deployers.WSJMSIntegrationProcessor;
import org.jboss.as.webservices.deployers.WSModelDeploymentProcessor;
import org.jboss.as.webservices.deployers.WSTypeDeploymentProcessor;
import org.jboss.as.webservices.deployers.WebServiceContextResourceProcessor;
import org.jboss.as.webservices.deployers.deployment.DeploymentAspectsProvider;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

final class WSDeploymentActivator {
    private static final Logger LOGGER = Logger.getLogger(WSDeploymentActivator.class);

    WSDeploymentActivator() {
    }

    static void activate(DeploymentProcessorTarget processorTarget) {
        processorTarget.addDeploymentProcessor(Phase.PARSE, 11264, (DeploymentUnitProcessor)new WSDescriptorDeploymentProcessor());
        processorTarget.addDeploymentProcessor(Phase.PARSE, 5889, (DeploymentUnitProcessor)new WSEJBIntegrationProcessor());
        processorTarget.addDeploymentProcessor(Phase.DEPENDENCIES, 3072, (DeploymentUnitProcessor)new WSDependenciesProcessor());
        processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 6144, (DeploymentUnitProcessor)new WSJMSIntegrationProcessor());
        processorTarget.addDeploymentProcessor(Phase.INSTALL, 1792, (DeploymentUnitProcessor)new WSTypeDeploymentProcessor());
        processorTarget.addDeploymentProcessor(Phase.INSTALL, 1793, (DeploymentUnitProcessor)new WSModelDeploymentProcessor());
        WSDeploymentActivator.addDeploymentProcessors(processorTarget, Phase.INSTALL, 1808);
        EEResourceReferenceProcessorRegistry.registerResourceReferenceProcessor((EEResourceReferenceProcessor)new WebServiceContextResourceProcessor());
    }

    private static void addDeploymentProcessors(DeploymentProcessorTarget processorTarget, Phase phase, int priority) {
        int index = 1;
        List<DeploymentAspect> aspects = DeploymentAspectsProvider.getSortedDeploymentAspects();
        boolean trace = LOGGER.isTraceEnabled();
        for (DeploymentAspect da : aspects) {
            if (trace) {
                LOGGER.tracef("Installing aspect %s", (Object)da.getClass().getName());
            }
            processorTarget.addDeploymentProcessor(phase, priority + index++, (DeploymentUnitProcessor)new AspectDeploymentProcessor(da));
        }
    }
}

