/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.util.concurrent.NotifyingFuture;

public abstract class CacheSupport<K, V>
implements Cache<K, V> {
    protected long defaultLifespan;
    protected long defaultMaxIdleTime;

    protected CacheSupport() {
        this(0L, 0L);
    }

    protected CacheSupport(long defaultLifespan, long defaultMaxIdleTime) {
        this.defaultLifespan = defaultLifespan;
        this.defaultMaxIdleTime = defaultMaxIdleTime;
    }

    @Override
    public final V put(K key, V value) {
        return this.put(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    protected abstract void set(K var1, V var2);

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(map, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<V> putAsync(K key, V value) {
        return this.putAsync(key, value, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putAsync(key, value, lifespan, unit, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.putAllAsync(data, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return this.putAllAsync(data, lifespan, unit, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<V> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsync(key, value, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsentAsync(key, value, lifespan, unit, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, value, lifespan, unit, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsync(key, oldValue, newValue, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<V> replaceAsync(K key, V value) {
        return this.replaceAsync(key, value, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, oldValue, newValue, lifespan, unit, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final V put(K key, V value, long lifespan, TimeUnit unit) {
        return this.put(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsent(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.putAll(map, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final V replace(K key, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final V replace(K key, V value) {
        return this.replace(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, oldValue, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }
}

