/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distribution.DataLocality;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.RebalanceTask;
import org.infinispan.distribution.TransactionLogger;
import org.infinispan.distribution.TransactionLoggerImpl;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashHelper;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.responses.ClusteredGetResponseValidityFilter;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;
import org.rhq.helpers.pluginAnnotations.agent.Parameter;

@MBean(objectName="DistributionManager", description="Component that handles distribution of content across a cluster")
public class DistributionManagerImpl
implements DistributionManager {
    private static final Log log = LogFactory.getLog(DistributionManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private CacheLoaderManager cacheLoaderManager;
    private Configuration configuration;
    private RpcManager rpcManager;
    private CacheManagerNotifier notifier;
    private CommandsFactory cf;
    private TransactionLogger transactionLogger;
    private DataContainer dataContainer;
    private InterceptorChain interceptorChain;
    private InvocationContextContainer icc;
    private CacheNotifier cacheNotifier;
    private final ViewChangeListener listener;
    private final ExecutorService rehashExecutor;
    private volatile ConsistentHash consistentHash;
    private volatile ConsistentHash lastSuccessfulCH;
    private Address self;
    private final CountDownLatch joinStartedLatch = new CountDownLatch(1);
    private volatile boolean rehashInProgress = false;
    private final Object rehashInProgressMonitor = new Object();
    private volatile int lastViewId = -1;
    private int lastViewIdFromPushConfirmation = -1;
    private final Map<Address, Integer> pushConfirmations = new HashMap<Address, Integer>(1);
    @ManagedAttribute(description="If true, the node has successfully joined the grid and is considered to hold state.  If false, the join process is still in progress.")
    @Metric(displayName="Is join completed?", dataType=DataType.TRAIT)
    private volatile boolean joinComplete = false;
    private final CountDownLatch joinCompletedLatch = new CountDownLatch(1);

    public DistributionManagerImpl() {
        LinkedBlockingQueue<Runnable> rehashQueue = new LinkedBlockingQueue<Runnable>(1);
        ThreadFactory tf = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("Rehasher," + DistributionManagerImpl.this.configuration.getName() + "," + DistributionManagerImpl.this.rpcManager.getTransport().getAddress());
                return t;
            }
        };
        this.rehashExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, rehashQueue, tf, new ThreadPoolExecutor.DiscardOldestPolicy());
        this.listener = new ViewChangeListener();
    }

    @Inject
    public void init(Configuration configuration, RpcManager rpcManager, CacheManagerNotifier notifier, CommandsFactory cf, DataContainer dataContainer, InterceptorChain interceptorChain, InvocationContextContainer icc, CacheLoaderManager cacheLoaderManager, InboundInvocationHandler inboundInvocationHandler, CacheNotifier cacheNotifier) {
        this.cacheLoaderManager = cacheLoaderManager;
        this.configuration = configuration;
        this.rpcManager = rpcManager;
        this.notifier = notifier;
        this.cf = cf;
        this.transactionLogger = new TransactionLoggerImpl(cf, configuration);
        this.dataContainer = dataContainer;
        this.interceptorChain = interceptorChain;
        this.icc = icc;
        this.cacheNotifier = cacheNotifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Start(priority=20)
    private void join() throws Exception {
        if (trace) {
            log.trace("starting distribution manager on " + this.getMyAddress());
        }
        this.notifier.addListener(this.listener);
        Transport t = this.rpcManager.getTransport();
        List<Address> members = t.getMembers();
        this.self = t.getAddress();
        this.lastViewId = t.getViewId();
        this.consistentHash = ConsistentHashHelper.createConsistentHash(this.configuration, members);
        this.lastSuccessfulCH = ConsistentHashHelper.createConsistentHash(this.configuration, members);
        Map<Address, Integer> map = this.pushConfirmations;
        synchronized (map) {
            this.pushConfirmations.put(t.getAddress(), -1);
        }
        this.joinStartedLatch.countDown();
        this.notifyCoordinatorPushCompleted(t.getViewId());
    }

    private int getReplCount() {
        return this.configuration.getNumOwners();
    }

    private Address getMyAddress() {
        return this.rpcManager != null ? this.rpcManager.getAddress() : null;
    }

    public RpcManager getRpcManager() {
        return this.rpcManager;
    }

    @Start(priority=1000)
    public void waitForJoinToComplete() throws Throwable {
        this.joinCompletedLatch.await();
        this.joinComplete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Stop(priority=20)
    public void stop() {
        this.notifier.removeListener(this.listener);
        Object object = this.rehashInProgressMonitor;
        synchronized (object) {
            this.rehashInProgressMonitor.notifyAll();
        }
        this.rehashExecutor.shutdownNow();
        this.joinStartedLatch.countDown();
        this.joinCompletedLatch.countDown();
        this.joinComplete = true;
    }

    @Override
    @Deprecated
    public boolean isLocal(Object key) {
        return this.getLocality(key).isLocal();
    }

    @Override
    public DataLocality getLocality(Object key) {
        boolean local = this.getConsistentHash().isKeyLocalToAddress(this.getSelf(), key, this.getReplCount());
        if (this.isRehashInProgress()) {
            if (local) {
                return DataLocality.LOCAL_UNCERTAIN;
            }
            return DataLocality.NOT_LOCAL_UNCERTAIN;
        }
        if (local) {
            return DataLocality.LOCAL;
        }
        return DataLocality.NOT_LOCAL;
    }

    @Override
    public List<Address> locate(Object key) {
        return this.getConsistentHash().locate(key, this.getReplCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForRehashToComplete(int viewId) throws InterruptedException, TimeoutException {
        long endTime = System.currentTimeMillis() + this.configuration.getRehashRpcTimeout();
        Object object = this.rehashInProgressMonitor;
        synchronized (object) {
            while (this.rehashInProgress && this.lastViewId == viewId && System.currentTimeMillis() < endTime) {
                this.rehashInProgressMonitor.wait(this.configuration.getRehashRpcTimeout());
            }
        }
        if (this.rehashInProgress) {
            if (this.lastViewId != viewId) {
                log.debug("Received a new view while waiting for cluster-wide rehash to finish");
                return false;
            }
            throw new TimeoutException("Timeout waiting for cluster-wide rehash to finish");
        }
        log.debug("Cluster-wide rehash finished successfully.");
        return true;
    }

    private void waitForJoinToStart() throws InterruptedException {
        this.joinStartedLatch.await();
    }

    @Override
    public Map<Object, List<Address>> locateAll(Collection<Object> keys) {
        return this.locateAll(keys, this.getReplCount());
    }

    @Override
    public Map<Object, List<Address>> locateAll(Collection<Object> keys, int numOwners) {
        return this.getConsistentHash().locateAll(keys, numOwners);
    }

    @Override
    public void transformForL1(CacheEntry entry) {
        if (entry.getLifespan() < 0L || entry.getLifespan() > this.configuration.getL1Lifespan()) {
            entry.setLifespan(this.configuration.getL1Lifespan());
        }
    }

    @Override
    public InternalCacheEntry retrieveFromRemoteSource(Object key, InvocationContext ctx) throws Exception {
        ClusteredGetCommand get = this.cf.buildClusteredGetCommand(key, ctx.getFlags());
        List<Address> targets = this.locate(key);
        targets.remove(this.getSelf());
        ClusteredGetResponseValidityFilter filter = new ClusteredGetResponseValidityFilter(targets);
        Map<Address, Response> responses = this.rpcManager.invokeRemotely(targets, get, ResponseMode.SYNCHRONOUS, this.configuration.getSyncReplTimeout(), false, filter);
        if (!responses.isEmpty()) {
            for (Response r : responses.values()) {
                if (!(r instanceof SuccessfulResponse)) continue;
                InternalCacheValue cacheValue = (InternalCacheValue)((SuccessfulResponse)r).getResponseValue();
                return cacheValue.toInternalCacheEntry(key);
            }
        }
        return null;
    }

    public Address getSelf() {
        return this.self;
    }

    @Override
    public ConsistentHash getConsistentHash() {
        return this.consistentHash;
    }

    @Override
    public ConsistentHash setConsistentHash(ConsistentHash consistentHash) {
        if (trace) {
            log.tracef("Installing new consistent hash %s", consistentHash);
        }
        this.cacheNotifier.notifyTopologyChanged(this.lastSuccessfulCH, consistentHash, true);
        this.consistentHash = consistentHash;
        this.cacheNotifier.notifyTopologyChanged(this.lastSuccessfulCH, consistentHash, false);
        return this.lastSuccessfulCH;
    }

    @Override
    @ManagedOperation(description="Determines whether a given key is affected by an ongoing rehash, if any.")
    @Operation(displayName="Could key be affected by rehash?")
    public boolean isAffectedByRehash(@Parameter(name="key", description="Key to check") Object key) {
        return this.isRehashInProgress() && this.consistentHash.locate(key, this.getReplCount()).contains(this.getSelf()) && !this.lastSuccessfulCH.locate(key, this.getReplCount()).contains(this.getSelf());
    }

    @Override
    public TransactionLogger getTransactionLogger() {
        return this.transactionLogger;
    }

    private Map<Object, InternalCacheValue> applyStateMap(Map<Object, InternalCacheValue> state, boolean withRetry) {
        HashMap<Object, InternalCacheValue> retry = withRetry ? new HashMap<Object, InternalCacheValue>() : null;
        for (Map.Entry<Object, InternalCacheValue> e : state.entrySet()) {
            InternalCacheValue v = e.getValue();
            InvocationContext ctx = this.icc.createInvocationContext();
            ctx.setFlags(Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD, Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_SHARED_CACHE_STORE, Flag.SKIP_LOCKING, Flag.SKIP_OWNERSHIP_CHECK);
            try {
                PutKeyValueCommand put = this.cf.buildPutKeyValueCommand(e.getKey(), v.getValue(), v.getLifespan(), v.getMaxIdle(), ctx.getFlags());
                this.interceptorChain.invoke(ctx, put);
            }
            catch (Exception ee) {
                if (withRetry) {
                    if (trace) {
                        log.tracef("Problem %s encountered when applying state for key %s. Adding entry to retry queue.", ee.getMessage(), e.getKey());
                    }
                    retry.put(e.getKey(), e.getValue());
                    continue;
                }
                log.problemApplyingStateForKey(ee.getMessage(), e.getKey());
            }
        }
        return retry;
    }

    @Override
    public void applyState(ConsistentHash consistentHash, Map<Object, InternalCacheValue> state, Address sender, int viewId) throws InterruptedException {
        this.waitForJoinToStart();
        if (viewId < this.lastViewId) {
            log.debugf("Rejecting state pushed by node %s for old rehash %d (last view id is %d)", sender, viewId, this.lastViewId);
            return;
        }
        log.debugf("Applying new state from %s: received %d keys", sender, state.size());
        if (trace) {
            log.tracef("Received keys: %s", state.keySet());
        }
        int retryCount = 3;
        Map<Object, InternalCacheValue> pendingApplications = state;
        for (int i = 0; i < retryCount && !(pendingApplications = this.applyStateMap(pendingApplications, true)).isEmpty(); ++i) {
        }
        if (!pendingApplications.isEmpty()) {
            this.applyStateMap(pendingApplications, false);
        }
        if (trace) {
            log.tracef("After applying state data container has %d keys", this.dataContainer.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markRehashCompleted(int viewId) throws InterruptedException {
        this.waitForJoinToStart();
        if (viewId < this.lastViewId) {
            if (trace) {
                log.tracef("Ignoring old rehash completed confirmation for view %d, last view is %d", viewId, this.lastViewId);
            }
            return;
        }
        if (viewId > this.lastViewId) {
            throw new IllegalStateException("Received rehash completed confirmation before confirming it ourselves");
        }
        if (trace) {
            log.tracef("Rehash completed on node %s, data container has %d keys", this.getSelf(), this.dataContainer.size());
        }
        this.rehashInProgress = false;
        Object object = this.rehashInProgressMonitor;
        synchronized (object) {
            if (trace) {
                log.tracef("Updating last rehashed CH to %s", this.lastSuccessfulCH);
            }
            this.lastSuccessfulCH = this.consistentHash;
            this.rehashInProgressMonitor.notifyAll();
        }
        this.joinCompletedLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markNodePushCompleted(int viewId, Address node) throws InterruptedException {
        this.waitForJoinToStart();
        if (trace) {
            log.tracef("Coordinator: received push completed notification for %s, view id %s", node, viewId);
        }
        if (viewId < this.lastViewId) {
            if (log.isTraceEnabled()) {
                log.tracef("Coordinator: Ignoring old push completed confirmation for view %d, last view is %d", viewId, this.lastViewId);
            }
            return;
        }
        Map<Address, Integer> map = this.pushConfirmations;
        synchronized (map) {
            if (viewId < this.lastViewIdFromPushConfirmation) {
                if (trace) {
                    log.tracef("Coordinator: Ignoring old push completed confirmation for view %d, last confirmed view is %d", viewId, this.lastViewIdFromPushConfirmation);
                }
                return;
            }
            if (viewId > this.lastViewIdFromPushConfirmation) {
                this.lastViewIdFromPushConfirmation = viewId;
            }
            this.pushConfirmations.put(node, viewId);
            if (trace) {
                log.tracef("Coordinator: updated push confirmations map %s", this.pushConfirmations);
            }
            for (Map.Entry<Address, Integer> pushNode : this.pushConfirmations.entrySet()) {
                if (pushNode.getValue() >= viewId) continue;
                return;
            }
            if (trace) {
                log.tracef("Coordinator: sending rehash completed notification for view %d, lastView %d, notifications received: %s", viewId, this.lastViewId, this.pushConfirmations);
            }
            RehashControlCommand cmd = this.cf.buildRehashControlCommand(RehashControlCommand.Type.REHASH_COMPLETED, this.getSelf(), viewId);
            this.rpcManager.broadcastRpcCommand(cmd, false);
            this.markRehashCompleted(viewId);
        }
    }

    @Override
    public void notifyCoordinatorPushCompleted(int viewId) throws Exception {
        Transport t = this.rpcManager.getTransport();
        if (t.isCoordinator()) {
            if (trace) {
                log.tracef("Node %s is the coordinator, marking push for %d as complete directly", this.self, viewId);
            }
            this.markNodePushCompleted(viewId, this.self);
        } else {
            RehashControlCommand cmd = this.cf.buildRehashControlCommand(RehashControlCommand.Type.NODE_PUSH_COMPLETED, this.self, viewId);
            Address coordinator = this.rpcManager.getTransport().getCoordinator();
            if (trace) {
                log.tracef("Node %s is not the coordinator, sending request to mark push for %d as complete to %s", this.self, viewId, coordinator);
            }
            this.rpcManager.invokeRemotely(Collections.singleton(coordinator), (ReplicableCommand)cmd, ResponseMode.SYNCHRONOUS, this.configuration.getRehashRpcTimeout());
        }
    }

    @Override
    public CacheStore getCacheStoreForRehashing() {
        if (this.cacheLoaderManager == null || !this.cacheLoaderManager.isEnabled() || this.cacheLoaderManager.isShared()) {
            return null;
        }
        return this.cacheLoaderManager.getCacheStore();
    }

    @Override
    @ManagedAttribute(description="Checks whether there is a pending rehash in the cluster.")
    @Metric(displayName="Is rehash in progress?", dataType=DataType.TRAIT)
    public boolean isRehashInProgress() {
        return this.rehashInProgress;
    }

    @Override
    public boolean isJoinComplete() {
        return this.joinComplete;
    }

    @Override
    public Collection<Address> getAffectedNodes(Collection<Object> affectedKeys) {
        if (affectedKeys == null || affectedKeys.isEmpty()) {
            if (trace) {
                log.trace("affected keys are empty");
            }
            return Collections.emptyList();
        }
        HashSet<Address> an = new HashSet<Address>();
        for (List<Address> addresses : this.locateAll(affectedKeys).values()) {
            an.addAll(addresses);
        }
        return an;
    }

    @Override
    public void applyRemoteTxLog(List<WriteCommand> commands) {
        for (WriteCommand cmd : commands) {
            try {
                this.cf.initializeReplicableCommand(cmd, true);
                InvocationContext ctx = this.icc.createInvocationContext();
                ctx.setFlags(Flag.SKIP_REMOTE_LOOKUP, Flag.CACHE_MODE_LOCAL, Flag.SKIP_SHARED_CACHE_STORE, Flag.SKIP_LOCKING);
                this.interceptorChain.invoke(ctx, cmd);
            }
            catch (Exception e) {
                log.exceptionWhenReplaying(cmd, e);
            }
        }
    }

    @ManagedOperation(description="Tells you whether a given key is local to this instance of the cache.  Only works with String keys.")
    @Operation(displayName="Is key local?")
    public boolean isLocatedLocally(@Parameter(name="key", description="Key to query") String key) {
        return this.getLocality(key).isLocal();
    }

    @ManagedOperation(description="Locates an object in a cluster.  Only works with String keys.")
    @Operation(displayName="Locate key")
    public List<String> locateKey(@Parameter(name="key", description="Key to locate") String key) {
        LinkedList<String> l = new LinkedList<String>();
        for (Address a : this.locate(key)) {
            l.add(a.toString());
        }
        return l;
    }

    public String toString() {
        return "DistributionManagerImpl[rehashInProgress=" + this.rehashInProgress + ", consistentHash=" + this.consistentHash + "]";
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Listener
    public class ViewChangeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Merged
        @ViewChanged
        public void handleViewChange(ViewChangedEvent e) {
            if (trace) {
                log.tracef("New view received: %d, type=%s, members: %s. Starting the RebalanceTask", e.getViewId(), (Object)e.getType(), e.getNewMembers());
            }
            boolean rehashInterrupted = DistributionManagerImpl.this.rehashInProgress;
            Object object = DistributionManagerImpl.this.rehashInProgressMonitor;
            synchronized (object) {
                DistributionManagerImpl.this.rehashInProgress = true;
                DistributionManagerImpl.this.lastViewId = e.getViewId();
                DistributionManagerImpl.this.rehashInProgressMonitor.notifyAll();
            }
            if (DistributionManagerImpl.this.getRpcManager().getTransport().isCoordinator()) {
                object = DistributionManagerImpl.this.pushConfirmations;
                synchronized (object) {
                    for (Address newNode : e.getNewMembers()) {
                        if (DistributionManagerImpl.this.pushConfirmations.containsKey(newNode)) continue;
                        if (trace) {
                            log.tracef("Coordinator: adding new node %s", newNode);
                        }
                        DistributionManagerImpl.this.pushConfirmations.put(newNode, -1);
                    }
                    for (Address oldNode : e.getOldMembers()) {
                        if (e.getNewMembers().contains(oldNode)) continue;
                        if (trace) {
                            log.tracef("Coordinator: removing node %s", oldNode);
                        }
                        DistributionManagerImpl.this.pushConfirmations.remove(oldNode);
                    }
                    if (trace) {
                        log.tracef("Coordinator: push confirmations list updated: %s", DistributionManagerImpl.this.pushConfirmations);
                    }
                }
            }
            RebalanceTask rebalanceTask = new RebalanceTask(DistributionManagerImpl.this.rpcManager, DistributionManagerImpl.this.cf, DistributionManagerImpl.this.configuration, DistributionManagerImpl.this.dataContainer, DistributionManagerImpl.this, DistributionManagerImpl.this.icc, DistributionManagerImpl.this.cacheNotifier, DistributionManagerImpl.this.interceptorChain, e.getViewId(), rehashInterrupted);
            DistributionManagerImpl.this.rehashExecutor.submit(rebalanceTask);
        }
    }
}

