/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class Proxies {
    public static Object newCatchThrowableProxy(Object obj) {
        return Proxy.newProxyInstance(obj.getClass().getClassLoader(), Proxies.getInterfaces(obj.getClass()), (InvocationHandler)new CatchThrowableProxy(obj));
    }

    private static Class[] getInterfaces(Class clazz) {
        Class[] interfaces = clazz.getInterfaces();
        if (interfaces.length > 0) {
            Class superClass = clazz.getSuperclass();
            if (superClass != null && superClass.getInterfaces().length > 0) {
                Class<?>[] superInterfaces = superClass.getInterfaces();
                Class[] clazzes = new Class[interfaces.length + superInterfaces.length];
                System.arraycopy(interfaces, 0, clazzes, 0, interfaces.length);
                System.arraycopy(superInterfaces, 0, clazzes, interfaces.length, superInterfaces.length);
                return clazzes;
            }
            return interfaces;
        }
        Class superclass = clazz.getSuperclass();
        if (!superclass.equals(Object.class)) {
            return superclass.getInterfaces();
        }
        return new Class[0];
    }

    static class CatchThrowableProxy
    implements InvocationHandler {
        private static final Log log = LogFactory.getLog(CatchThrowableProxy.class);
        private Object obj;

        public static Object newInstance(Object obj) {
            return Proxy.newProxyInstance(obj.getClass().getClassLoader(), obj.getClass().getInterfaces(), (InvocationHandler)new CatchThrowableProxy(obj));
        }

        private CatchThrowableProxy(Object obj) {
            this.obj = obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            Object result = null;
            try {
                result = m.invoke(this.obj, args);
            }
            catch (Throwable t) {
                log.ignoringException(m.getName(), t.getMessage(), t.getCause());
            }
            return result;
        }
    }
}

