/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.util.concurrent.locks.containers.AbstractStripedLockContainer;

@ThreadSafe
public class ReentrantStripedLockContainer
extends AbstractStripedLockContainer {
    ReentrantLock[] sharedLocks;

    public ReentrantStripedLockContainer(int concurrencyLevel) {
        this.initLocks(this.calculateNumberOfSegments(concurrencyLevel));
    }

    @Override
    protected void initLocks(int numLocks) {
        this.sharedLocks = new ReentrantLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this.sharedLocks[i] = new ReentrantLock();
        }
    }

    @Override
    public final ReentrantLock getLock(Object object) {
        return this.sharedLocks[this.hashToIndex(object)];
    }

    @Override
    public final int getNumLocksHeld() {
        int i = 0;
        for (ReentrantLock l : this.sharedLocks) {
            if (!l.isLocked()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public int size() {
        return this.sharedLocks.length;
    }

    @Override
    public final boolean ownsLock(Object object, Object owner) {
        ReentrantLock lock = this.getLock(object);
        return lock.isHeldByCurrentThread();
    }

    @Override
    public final boolean isLocked(Object object) {
        ReentrantLock lock = this.getLock(object);
        return lock.isLocked();
    }

    public String toString() {
        return "ReentrantStripedLockContainer{sharedLocks=" + (this.sharedLocks == null ? null : Arrays.asList(this.sharedLocks)) + '}';
    }
}

