/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.trust;

import java.util.List;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.security.tokenstore.MemoryTokenStore;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSSamlAssertionValidator;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Element;

public class STSTokenValidator
implements Validator {
    private STSSamlAssertionValidator samlValidator = new STSSamlAssertionValidator();
    private boolean alwaysValidateToSts;

    public STSTokenValidator() {
    }

    public STSTokenValidator(boolean alwaysValidateToSts) {
        this.alwaysValidateToSts = alwaysValidateToSts;
    }

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (this.isValidatedLocally(credential, data)) {
            return credential;
        }
        return this.validateWithSTS(credential, (Message)((SoapMessage)data.getMsgContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential validateWithSTS(Credential credential, Message message) throws WSSecurityException {
        try {
            STSClient c;
            SecurityToken recoveredToken;
            SecurityToken token = new SecurityToken();
            Element tokenElement = null;
            int hash = 0;
            if (credential.getAssertion() != null) {
                tokenElement = credential.getAssertion().getElement();
                hash = credential.getAssertion().hashCode();
            } else if (credential.getUsernametoken() != null) {
                tokenElement = credential.getUsernametoken().getElement();
                hash = credential.getUsernametoken().hashCode();
            } else if (credential.getBinarySecurityToken() != null) {
                tokenElement = credential.getBinarySecurityToken().getElement();
                hash = credential.getBinarySecurityToken().hashCode();
            }
            token.setToken(tokenElement);
            TokenStore tokenStore = STSTokenValidator.getTokenStore(message);
            if (tokenStore != null && hash != 0 && (recoveredToken = tokenStore.getTokenByAssociatedHash(hash)) != null) {
                AssertionWrapper assertion = new AssertionWrapper(recoveredToken.getToken());
                credential.setTransformedToken(assertion);
                return credential;
            }
            STSClient sTSClient = c = STSUtils.getClient(message, "sts");
            synchronized (sTSClient) {
                System.setProperty("noprint", "true");
                List<SecurityToken> tokens = c.validateSecurityToken(token);
                SecurityToken returnedToken = tokens.get(0);
                if (returnedToken != token) {
                    AssertionWrapper assertion = new AssertionWrapper(returnedToken.getToken());
                    credential.setTransformedToken(assertion);
                    if (hash != 0) {
                        returnedToken.setAssociatedHash(hash);
                        tokenStore.add(returnedToken);
                    }
                }
                return credential;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WSSecurityException(0, "invalidSAMLsecurity", null, (Throwable)e);
        }
    }

    static final TokenStore getTokenStore(Message message) {
        TokenStore tokenStore = (TokenStore)message.getContextualProperty(TokenStore.class.getName());
        if (tokenStore == null) {
            tokenStore = new MemoryTokenStore();
            ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo().setProperty(TokenStore.class.getName(), (Object)tokenStore);
        }
        return tokenStore;
    }

    protected boolean isValidatedLocally(Credential credential, RequestData data) throws WSSecurityException {
        if (!this.alwaysValidateToSts && credential.getAssertion() != null) {
            try {
                this.samlValidator.validate(credential, data);
                return this.samlValidator.isTrustVerificationSucceeded();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", null, (Throwable)e);
            }
        }
        return false;
    }
}

