/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.impl;

import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import org.jboss.as.clustering.web.BatchingManager;
import org.jboss.logging.Logger;

public class TransactionBatchingManager
implements BatchingManager {
    private static final Logger log = Logger.getLogger(TransactionBatchingManager.class);
    private final TransactionManager tm;

    public TransactionBatchingManager(TransactionManager tm) {
        this.tm = tm;
    }

    @Override
    public boolean isBatchInProgress() throws Exception {
        return this.tm.getTransaction() != null;
    }

    @Override
    public void startBatch() throws Exception {
        this.tm.begin();
    }

    @Override
    public void setBatchRollbackOnly() throws Exception {
        this.tm.setRollbackOnly();
    }

    @Override
    public void endBatch() {
        try {
            if (this.tm.getTransaction().getStatus() != 1) {
                this.tm.commit();
            } else {
                log.debug((Object)"endBatch(): rolling back batch");
                this.tm.rollback();
            }
        }
        catch (RollbackException e) {
            log.warn((Object)"endBatch(): rolling back transaction with exception", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("endTransaction(): Caught Exception ending batch: ", e);
        }
    }
}

