" Vim syntax file
" Language:     NiceShaper configuration files (/etc/niceshaper/*.conf)
" Maintainer:   Mariusz Jedwabny <mariusz@jedwabny.net>
" License:      This file is subject to the terms and conditions of the 
"               GNU General Public License. See the file COPYING in the 
"               main directory of this archive for more details.
" Last Change: 2013-03-09
" URL: http://niceshaper.jedwabny.net
if exists("b:current_syntax")
 finish
endif

" Comments
syn region nsComment start=/#/    end=/$/
syn region nsComment start=/<#/   end=/#>/

" Booleans
syn keyword nsBoolean yes no contained

" Section
syn match nsSection /^\s*<[a-zA-Z0-9_\-.]\+>\s*$/
syn match nsSection /^\s*<\/[a-zA-Z0-9_\-.]\+>\s*$/
syn match nsSection /^\s*<\/>\s*$/

" Directive format: directive value
syn match nsValue "do-not-shape" contained
syn match nsValue "standard-class" contained
syn keyword nsValue wrapper virtual contained
syn keyword nsValue pl en contained
syn region nsDirectiveRegion matchgroup=nsDirective start=/^\s*\(ceil\|hold\|lang\|low\|mode\|rate\|reload\|set-mark\|strict\|type\)\s\+/ end=/$/ contains=nsValue,nsBoolean,nsComment keepend

" Directive format: directive value [value]
syn keyword nsValue iptables iproute contained
syn region nsDirectiveRegion matchgroup=nsDirective start=/^\s*\(debug\|fallback\|mark-on-ifaces\|run\)\s\+/ end=/$/ contains=nsValue,nsBoolean,nsComment keepend

" Directive format: directive parameter value [parameter value]
syn keyword nsParameter file syslog terminal contained
syn match nsParameter "replace-classes" contained
syn match nsParameter "download-section" contained
syn match nsParameter "upload-section" contained
syn match nsParameter "iface-inet" contained
syn match nsParameter "resolve-hostname" contained
syn keyword nsParameter unit classes sum listen password file owner group mode rewrite contained
syn keyword nsParameter shape speed contained
syn match nsParameter "htb-burst" contained
syn match nsParameter "htb-cburst" contained
syn keyword nsParameter scheduler prio burst cburst contained
syn keyword nsParameter hash perturb contained
syn keyword nsParameter hook target contained
syn match nsParameter "hook-mode" contained
syn keyword nsParameter autoredirect contained
syn keyword nsParameter low ceil rate day week month file contained
syn match nsParameter "time-period" contained
syn match nsParameter "reset-hour" contained
syn match nsParameter "reset-wday" contained
syn match nsParameter "reset-mday" contained
syn match nsParameter "do-not-shape-method" contained
syn match nsParameter "fallback-rate" contained
syn keyword nsValue safe contained
syn match nsValue "full-throttle" contained
syn region nsDirectiveRegion matchgroup=nsDirective start=/^\s*\(log\|users\|stats\|section\|htb\|sfq\|esfq\|iptables\|imq\|alter\|quota\|iface-[a-z0-9+.]\+\)\s\+/ end=/$/ contains=nsParameter,nsValue,nsBoolean,nsComment keepend

" special directives: class
syn region nsDirectiveRegion matchgroup=nsDirective start=/^\s*\(class\)\s\+/ end=/$/ contains=nsComment keepend

" special directives: match and include
syn keyword nsParameter proto srcip dstip sport srcport dport dstport contained
syn keyword nsParameter length state tos ttl mark contained
syn match nsParameter "in-iface" contained
syn match nsParameter "out-iface" contained
syn match nsParameter "from-local" contained
syn match nsParameter "to-local" contained
syn match nsParameter "not-srcip" contained
syn match nsParameter "not-dstip" contained
syn match nsParameter "not-srcport" contained
syn match nsParameter "not-sport" contained
syn match nsParameter "not-dstport" contained
syn match nsParameter "not-dport" contained
syn match nsParameter "ttl-lower" contained
syn match nsParameter "ttl-greater" contained
syn match nsParameter "set-mark" contained
syn keyword nsValue new established related invalid untracked contained
syn keyword nsParameter file usersfile contained
syn region nsDirectiveRegion matchgroup=nsDirective start=/^\s*\(match\|include\)\s\+/ end=/$/ contains=nsParameter,nsValue,nsBoolean,nsComment keepend

hi def link	nsComment Comment
hi def link	nsBoolean Function
hi def link	nsSection Label
hi def link nsDirective Number
hi def link nsDirectiveRegion Cursor
hi def link	nsParameter Type
hi def link nsValue Function

let b:current_syntax = "niceshaper"

