#ifndef TCCLASS_H
#define TCCLASS_H

#include "filter.h"
#include "trigger.h"

class NsClass {
    public:
        NsClass(std::string, std::string); // ipt_my_chain, ipt_section_hook
        ~NsClass();
        int store(std::string); // buf
        int validateParams(unsigned int);
        int prepareIptRules(bool, std::vector <std::string> &);
        int prepareTcClass(unsigned int, unsigned int);
        unsigned int check(std::vector < std::string > &, struct timeval, double);
        int add();
        int del();
        int computeTcChanges(unsigned int); // working
        int applyChanges(unsigned int); // working
        std::string stats();
        std::string dumpQuotaCounters();
        void setQuotaCounters (unsigned int, unsigned int, unsigned int);
        bool work() { return Work; }
        bool sumInSection() { return SumInSection; }
        unsigned int rate() { return Rate; }
        unsigned int htbCeil() { return HtbCeil; }
        unsigned int htbBurst() { return HtbBurst; }
        unsigned int htbCBurst() { return HtbCBurst; }
        unsigned int nsLow() { return NsLow; }
        unsigned int nsCeil() { return NsCeil; }
        unsigned int hardLimit() { return HardLimit; }
        unsigned int softLimit() { return SoftLimit; }
        std::string name() { return Name; }
        void decHtbCeil( unsigned int decrease ) { HtbCeil -= decrease; }
        void incHtbCeil( unsigned int increase ) { HtbCeil += increase; }
        void setHtbCeil( unsigned int htb_ceil ) { HtbCeil = htb_ceil; }
        void setHardLimit( unsigned int hard_limit ) { HardLimit = hard_limit; }
        void computeSoftLimit() { SoftLimit = NsLow + (unsigned int)((double)(HardLimit - NsLow) * Strict); }
        void setRate( unsigned int rate ) { Rate = rate; }
    private:
        int proceedTriggers (struct timeval);
	    TriggerAlter Alter;
    	TriggerQuota Quota;
        std::string Dev;
        std::string Name;
	    std::string EsfqHash;
	    std::string IptMyChain;
        std::string IptSectionHook;
	    std::string TcClassAdd;
	    std::string TcQdiscAdd;
        std::string TcClassDel;
        std::string TcQdiscDel;
        unsigned int DevId;
        unsigned int ClassId;
        unsigned long int Alive;
        unsigned int Hold;
        unsigned int NsLow;
        unsigned int NsCeil;
        unsigned int HtbParentId;
        unsigned int HtbRate;
        unsigned int HtbCeil;
        unsigned int HtbPrio;
        unsigned int HtbBurst;
        unsigned int HtbCBurst;
        unsigned int OldHtbRate;
        unsigned int OldHtbCeil;
        unsigned int MeasureRate;
        unsigned int Rate;
        unsigned int SfqPerturb;
        unsigned int EsfqPerturb;
        unsigned int HardLimit;
        unsigned int SoftLimit;
        unsigned int SectionShape;
        double Strict; 
        bool UseIpt;  
        bool UseTcClass;
        bool UseTcFilter;
        bool SumInSection;
        bool StatsShowHtbCeil;
        bool StatsShowRate;
        bool Work;      
	    TcQdiscType Qdisc;
        std::vector <TcFilter *> TcFilters;
};

#endif
