#ifndef CONV_H
#define CONV_H

#include <string>
#include <vector>

#include "main.h"

class Conv 
{
    public:
        Conv ();
        ~Conv ();
        int convertToFpv (std::string, std::string, FileType, std::vector <unsigned int> &, std::vector <std::string> &);
        int includeToFpv (std::string, std::string, FileType, std::vector <unsigned int> &, std::vector <std::string> &);
        int convertUsersFile (std::string, std::string, std::string, std::string, std::string, bool, bool, std::vector < std::string > &); 
        std::vector <std::string> RunningSections;
        UnitType getStatsUnit () { return StatsUnit; }
        std::string getStatsListenIp () { return StatsListenIp; }
        int getStatsListenPort () { return StatsListenPort; }
        std::string getStatsPassword () { return StatsPassword; }
        std::string getStatsFilePath () { return StatsFilePath; }
        std::string getStatsFileOwner () { return StatsFileOwner; }
        std::string getStatsFileGroup () { return StatsFileGroup; }
        std::string getStatsFileMode () { return StatsFileMode; }
        int getStatsFileRewrite () { return StatsFileRewrite; }
        std::string getUsersDownloadSection () { return UsersDownloadSection; }
        std::string getUsersUploadSection () { return UsersUploadSection; }
        std::string getUsersIfaceInet () { return UsersIfaceInet; }
        bool getUsersResolveHostName () { return UsersResolveHostName; }
        bool getUsersReplaceClasses () { return UsersReplaceClasses; }
        void addRunningSection (std::string running_section) { RunningSections.push_back(running_section); }
        void setStatsUnit (UnitType stats_unit) { StatsUnit = stats_unit; }
        int setStatsListenAddr (std::string);   
        void setStatsPassword (std::string stats_password) { StatsPassword = stats_password; }
        void setStatsFilePath (std::string stats_file_path) { StatsFilePath = stats_file_path; }
        void setStatsFileOwner (std::string stats_file_owner) { StatsFileOwner = stats_file_owner; }
        void setStatsFileGroup (std::string stats_file_group) { StatsFileGroup = stats_file_group; }
        void setStatsFileMode (std::string stats_file_mode) { StatsFileMode = stats_file_mode; }
        void setStatsFileRewrite (int stats_file_rewrite) { StatsFileRewrite = stats_file_rewrite; } 
        void setUsersReplaceClasses (bool replace_classes) { UsersReplaceClasses = replace_classes; }
        void setUsersDownloadSection (std::string download_section) { UsersDownloadSection = download_section; }
        void setUsersUploadSection (std::string upload_section) { UsersUploadSection = upload_section; }
        void setUsersIfaceInet (std::string iface_inet) { UsersIfaceInet = iface_inet; }
        void setUsersResolveHostName (bool resolve_host_name) { UsersResolveHostName = resolve_host_name; }
   private:
        std::string getLine(std::ifstream &);
        int directiveSplit (std::string, std::vector < std::string > &); 
        UnitType StatsUnit;
        std::string StatsListenIp;
        int StatsListenPort;
        std::string StatsPassword;
        std::string StatsFilePath;
        std::string StatsFileOwner;
        std::string StatsFileGroup;
        std::string StatsFileMode;
        int StatsFileRewrite;
        std::string UsersDownloadSection;
        std::string UsersUploadSection;
        std::string UsersIfaceInet;
        bool UsersResolveHostName;
        bool UsersReplaceClasses;
};

#endif
