#ifndef NICESHAPER_H
#define NICESHAPER_H

#include <sys/time.h>
#include "net.h"
#include "class.h"

class NiceShaper {
    public:
        NiceShaper();
        ~NiceShaper();
        int init(std::vector <std::string> &, std::vector <std::string> &, std::vector <unsigned int> &, std::vector <std::string> &);
        int judge();    
        std::vector <std::string> stats(); 
        std::vector <std::string> dumpQuotaCounters ();
        int setQuotaCounters (std::vector <std::string> &);
        unsigned int reload() { return Reload; };
    private:
        int checkIptables();
        int applyChanges();  
        // permanent values
        unsigned int SectionHtbCeil;
        unsigned int SectionShape;
        unsigned int Reload;
        std::string IptMyParent;
        std::string IptMyParentMode;
        std::string IptMyChain;
        std::vector <std::string> SectionIfaces;
        // variable values
        unsigned int SectionRate;
        unsigned int SectionMeasureRate;
        unsigned int SectionPotentialRate;
        unsigned int SectionChangeableRate;
        unsigned int SectionHtbBurst;
        unsigned int SectionHtbCBurst;
        unsigned int Working;
        struct timeval Ltt;    
        double CrossBar;     
        std::vector <NsNet *> NsNets;
        std::vector <NsClass *> NsClasses;
        std::vector <NsClass *> WorkingClasses;
        std::vector <NsClass *> ChangeableClasses;
};

#endif


