/*
 * Copyright (C) 2006-2014 Tommy Scheunemann <net@arrishq.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 * Functions needed for producing Kahakai configuration
 */

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <strings.h>


/* Return valid menu item */
char* valid_string (char *str);

/* Outputs on stdout a kahakai-compatible configuration */
void output_kahakai (struct group *root, int level,const char *use_term)
{
    struct item *item;
    int sp;
    if (root == (struct group *)NULL) {
	return;
    }
    if (level > 0) {
	for (sp = 0; sp < level; sp++) putchar(' ');
    }
    if (level == 0) {
	printf("[title] (%s)\n", valid_string(root->name));
    } else {
	printf("[submenu] (%s)\n", valid_string(root->name));
    }
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    struct group *subgroup = (struct group *)item->data;
	    output_kahakai (subgroup, level + 1, use_term);
	} else if (item->type == ITEM_APP) {
	    struct package *app;
	    app = (struct package *)item->data;
	    /* Kahakai doesn't seem to provide restart / quit functions */
	    if (app->restart) {
		return;
	    }
	    if (app->name && app->exec && app->__package) {
		for (sp = 0; sp <= level; sp++) putchar(' ');
		printf("[item] (%s) {", valid_string(app->name));
		/* this removes ending '&' that should not be there */
		char *b;
		int l;
		 b = app->exec;
		 l = strlen(b);
		 if (app->terminal != NULL) {
			/* parse in the terminal */
			printf ("%s -e ", use_term);
		}
		while (l > 0 && b[l - 1] == ' ') {
		    l--;
		}
		if (l > 0 && b[l - 1] == '&') {
		    l--;
		}
		for (; l > 0; l--,b++) {
		    putchar(*b);
		}
		printf("}\n");
	    }
	}
	item++;
    }
    if (level > 0)
    for (sp = 0; sp < level; sp++) putchar(' ');
    printf("[end]\n");
}
