/*
 * Copyright (C) 1997 Red Hat, Inc.
 *	Cristian Gafton <gafton@redhat.com>
 *
 * Modify:  2004/07/10  Tommy Scheunemann <net@arrishq.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * WM configurator
 *
 * parser functions
 */

#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <pwd.h>

#include "wmconfig.h"

/*
 * External data access ... First things we are most concerned
 * about: groups
 */
extern struct group *root_group;

/*
 * Return a string explaining the error code
 */
const char *parse_errstr(int err_code)
{
    switch (err_code) {
	case PARSE_OK:
	    return "Parser succeeded";
	case PARSE_NOFILES:
	    return "No configuration files found";
	case PARSE_ABORT:
	    return "Critical Error parsing config file";
	default:
	    return "Unknown error code";
    };
    /* not reached */
    return "Unknown error";
}

/*
 * Yet another function to parse the config file lines...
 * it stores the parser results in the package, tag and
 * string variables respectively. I agree. It's boring.
 */

/* Few handy macros... */
#define SKIP_SPACES(c)	while (*c && isspace(*c)) c++
#define SKIP_CHARS(c)	while (*c && !isspace(*c)) c++
#define SKIP_TO(c, x)	while (*c && (*c != x)) c++
#define FINISH(code) 	{ *package=item1; *tag=item2; *string=item3; return(code); }

int parse_line(char *buffer, char **package, char **tag, char **lang, char **string)
{
    char *item1 = NULL;
    char *item2 = NULL;
    char *item3 = NULL;
    char *c;

    /* verify the line */
    c = buffer;
    SKIP_SPACES(c);

    /* skip comments */
    if (*c && (*c == '#')) {
	FINISH(-1);
    }

    /* okay, not a comment */
    item1 = c; /* the program goes first */
    SKIP_CHARS(c);
    if (*c) {
	*c++ = '\0'; /* that was the program */
    } else {
	FINISH(1);
    }

    SKIP_SPACES(c);
    if (*c) {
	item2 = c; /* try to read the tag */
    } else {
	FINISH(1);
    }

    SKIP_CHARS(c);
    if (*c) {
	*c++ = '\0'; /* that was the tag */
    } else {
	FINISH(2);
    }

    SKIP_SPACES(c);
    if (*c) {
	item3 = c;
    } else {
	FINISH(2);
    }

    if (*c == '"' || *c == '\'') {
	item3++;
	c = strrchr(item3, *c);
	if (c != NULL)
	    *c = '\0';
    }
    /* don't let the final eol in */
    c = strrchr(item3, '\n');
    if (c != NULL) {
	*c = '\0';
    }

    c = strchr (item2, '(');
    if (c == NULL) {
        *lang = NULL;
    } else {
	*c++ = '\0';
	*lang = c;
	c = strchr (c, ')');
	if (c != NULL) {
	    *c = '\0';
	} else {
	    FINISH(2);
	}
    }
    FINISH(0);
}
