/*
 * Copyright (C) 2004-2015 Tommy Scheunemann
 *
 * Modify:  2015/20/01  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2014/07/29 Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2011/01/06 Trey Williams <t_s_williams@yahoo.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Functions needed for producing an Ude (Unix Desktop Environment) configuration
 */

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <strings.h>
#include <string.h>

/*
 * Outputs on configuration stdout
 */
void output_ude (struct group *root, int level, const char *use_term)
{
    struct item *item;
    int sp;

    if (root == (struct group *)NULL) {
	return;
    }

    if (level > 0) {
	for (sp = 1; sp < level; sp++) putchar(' ');
	printf("SUBMENU \"%s\" folder {\n", (level == 0) ? "Programs" : root->name);
    }

    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    struct group *subgroup = (struct group *)item->data;
	    output_ude (subgroup, level + 1, use_term);
	} else if (item->type == ITEM_APP) {
	    struct package *app;
	    app = (struct package *)item->data;
	    if (! app->restart) {
		if (app->name && app->exec) {
		    /* this removes ending '&' that should not be there */
		    char *b;
		    int l;
		    b = app->exec;
		    l = strlen(b);

		    for (sp = 1; sp <= level; sp++) {
			putchar(' ');
		    }
		    printf("ITEM \"%s\": ", app->name);

		    /* Check for terminal */
		    if (app->terminal) {
			printf ("\"%s -e ", use_term);
		    } else {
		        putchar ('\"');
		    }
		    while (l > 0 && b[l - 1] == ' ') {
			l--;
		    }
		    if (l > 0 && b[l - 1] == '&') {
			l--;
		    }
		    for (; l > 0; l--,b++) {
			putchar(*b);
		    }
		    printf("\";\n");
		}
	    }
	}
	item++;
    }

    if (level > 0) {
	for (sp = 1; sp < level; sp++) putchar(' ');
	printf("}\n");
    }
}
