/*-
 * Copyright (c) 2004 - 2010 CTPP Team
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the CTPP Team nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      CTPP2VMSTDLib.hpp
 *
 * $CTPP$
 */
#ifndef _CTPP2_VM_STDLIB_HPP__
#define _CTPP2_VM_STDLIB_HPP__ 1

#include "CTPP2VMSyscall.hpp"

/**
  @file CTPP2VMSTDLib.hpp
  @brief Virtual machine standard library initializer
*/

namespace CTPP // C++ Template Engine
{

// FWD
class SyscallFactory;

/**
  @class STDLibInitializer CTPP2VMSTDLib.hpp <CTPP2VMSTDLib.hpp>
  @brief Initializer for standard library
*/
class CTPP2DECL STDLibInitializer
{
public:
	/**
	  @brief Get list of available functions
	  @return NULL-rerminated list
	*/
	static CCHAR_P * GetFnList();

	/**
	  @brief Initialize all functions in library
	  @param oSyscallFactory - object factory
	*/
	static void InitLibrary(SyscallFactory & oSyscallFactory);

	/**
	  @brief Destroy all functions in library
	  @param oSyscallFactory - object factory
	*/
	static void DestroyLibrary(SyscallFactory & oSyscallFactory);

	/**
	  @brief Create handler
	  @param szHandler - function name
	  @return new object of CTPP2 function
	*/
	static SyscallHandler * CreateHandler(CCHAR_P szHandler);

	/**
	  @brief Create handler
	  @param pHandler - function object
	  @return new object of CTPP2 function
	*/
	static void DestroyHandler(SyscallHandler * pHandler);
private:

	/** List of functions */
	static CCHAR_P aSTDFNList[];
};

} // namespace CTPP
#endif // _CTPP2_VM_STDLIB_HPP__
// End.
