/***************************************************************************
 *   Copyright (C) 2008 by Andrzej Rybczak   *
 *   electricityispower@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _SONG_H
#define _SONG_H

#include "libmpdclient.h"

namespace MPD {
	class Song
	{
		public:
			Song();
			~Song();
			void Clear();
			void SetData(mpd_Song *);
			void SetStartTime();
			void Submit();
			bool isStream() const;
			int & Playback();
			const mpd_Song *& Data() const;
		
		private:
			bool canBeSubmitted();
		
			mpd_Song *itsSong;
			time_t itsStartTime;
			int itsNoticedPlayback;
			bool itsIsStream;
	};
}

#endif
