
#include "config.h"

#include <schroedinger/schrotables.h>

const uint32_t schro_table_offset_3_8[61] = {
           1u,          2u,          2u,          3u,
           3u,          4u,          4u,          5u,
           6u,          7u,          9u,         10u,
          12u,         14u,         17u,         20u,
          24u,         29u,         34u,         41u,
          48u,         57u,         68u,         81u,
          96u,        114u,        136u,        162u,
         192u,        228u,        272u,        323u,
         384u,        457u,        543u,        646u,
         768u,        913u,       1086u,       1292u,
        1536u,       1827u,       2172u,       2583u,
        3072u,       3653u,       4344u,       5166u,
        6144u,       7307u,       8689u,      10333u,
       12288u,      14613u,      17378u,      20666u,
       24576u,      29226u,      34756u,      41332u,
       49152u
};

const uint32_t schro_table_offset_1_2[61] = {
           1u,          2u,          3u,          4u,
           4u,          5u,          6u,          7u,
           8u,         10u,         12u,         14u,
          16u,         19u,         23u,         27u,
          32u,         38u,         46u,         54u,
          64u,         76u,         91u,        108u,
         128u,        152u,        181u,        216u,
         256u,        305u,        362u,        431u,
         512u,        609u,        724u,        861u,
        1024u,       1218u,       1448u,       1722u,
        2048u,       2436u,       2897u,       3445u,
        4096u,       4871u,       5793u,       6889u,
        8192u,       9742u,      11585u,      13777u,
       16384u,      19484u,      23171u,      27555u,
       32768u,      38968u,      46341u,      55109u,
       65536u
};

const uint32_t schro_table_quant[61] = {
           4u,          5u,          6u,          7u,
           8u,         10u,         11u,         13u,
          16u,         19u,         23u,         27u,
          32u,         38u,         45u,         54u,
          64u,         76u,         91u,        108u,
         128u,        152u,        181u,        215u,
         256u,        304u,        362u,        431u,
         512u,        609u,        724u,        861u,
        1024u,       1218u,       1448u,       1722u,
        2048u,       2435u,       2896u,       3444u,
        4096u,       4871u,       5793u,       6889u,
        8192u,       9742u,      11585u,      13777u,
       16384u,      19484u,      23170u,      27554u,
       32768u,      38968u,      46341u,      55109u,
       65536u,      77936u,      92682u,     110218u,
      131072u
};

const uint32_t schro_table_inverse_quant[61] = {
  1073741824u,  858993459u,  715827882u,  613566756u,
   536870912u,  429496729u,  390451572u,  330382099u,
   268435456u,  226050910u,  186737708u,  159072862u,
   134217728u,  113025455u,   95443717u,   79536431u,
    67108864u,   56512727u,   47197442u,   39768215u,
    33554432u,   28256363u,   23729101u,   19976592u,
    16777216u,   14128181u,   11864550u,    9965121u,
     8388608u,    7052491u,    5932275u,    4988347u,
     4194304u,    3526245u,    2966137u,    2494173u,
     2097152u,    1763846u,    1483068u,    1247086u,
     1048576u,     881742u,     741406u,     623452u,
      524288u,     440871u,     370735u,     311749u,
      262144u,     220435u,     185367u,     155874u,
      131072u,     110217u,      92681u,      77935u,
       65536u,      55108u,      46340u,      38967u,
       32768u
};

const uint16_t schro_table_division_factor[257] = {
      0,     0, 32768, 21845,
  16384, 13107, 10923,  9362,
   8192,  7282,  6554,  5958,
   5461,  5041,  4681,  4369,
   4096,  3855,  3641,  3449,
   3277,  3121,  2979,  2849,
   2731,  2621,  2521,  2427,
   2341,  2260,  2185,  2114,
   2048,  1986,  1928,  1872,
   1820,  1771,  1725,  1680,
   1638,  1598,  1560,  1524,
   1489,  1456,  1425,  1394,
   1365,  1337,  1311,  1285,
   1260,  1237,  1214,  1192,
   1170,  1150,  1130,  1111,
   1092,  1074,  1057,  1040,
   1024,  1008,   993,   978,
    964,   950,   936,   923,
    910,   898,   886,   874,
    862,   851,   840,   830,
    819,   809,   799,   790,
    780,   771,   762,   753,
    745,   736,   728,   720,
    712,   705,   697,   690,
    683,   676,   669,   662,
    655,   649,   643,   636,
    630,   624,   618,   612,
    607,   601,   596,   590,
    585,   580,   575,   570,
    565,   560,   555,   551,
    546,   542,   537,   533,
    529,   524,   520,   516,
    512,   508,   504,   500,
    496,   493,   489,   485,
    482,   478,   475,   471,
    468,   465,   462,   458,
    455,   452,   449,   446,
    443,   440,   437,   434,
    431,   428,   426,   423,
    420,   417,   415,   412,
    410,   407,   405,   402,
    400,   397,   395,   392,
    390,   388,   386,   383,
    381,   379,   377,   374,
    372,   370,   368,   366,
    364,   362,   360,   358,
    356,   354,   352,   350,
    349,   347,   345,   343,
    341,   340,   338,   336,
    334,   333,   331,   329,
    328,   326,   324,   323,
    321,   320,   318,   317,
    315,   314,   312,   311,
    309,   308,   306,   305,
    303,   302,   301,   299,
    298,   297,   295,   294,
    293,   291,   290,   289,
    287,   286,   285,   284,
    282,   281,   280,   279,
    278,   277,   275,   274,
    273,   272,   271,   270,
    269,   267,   266,   265,
    264,   263,   262,   261,
    260,   259,   258,   257,
    256
};

#ifdef ENABLE_ENCODER
const double schro_table_error_hist_shift3_1_2[60][104] = {
  { /* 0 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
  },
  { /* 1 */
    0, 1, 0, 0, 0, 1, 0, 0, 
    0, 0, 1, 0, 0, 0, 0, 1, 
    0, 0, 0.5, 0, 0.5, 0, 0, 0.5, 
    0.25, 0, 0.25, 0.25, 0.25, 0.25, 0, 0.25, 
    0.25, 0.125, 0.25, 0.25, 0.125, 0.25, 0.125, 0.25, 
    0.1875, 0.1875, 0.25, 0.1875, 0.1875, 0.1875, 0.1875, 0.25, 
    0.1875, 0.1875, 0.21875, 0.1875, 0.21875, 0.1875, 0.1875, 0.21875, 
    0.203125, 0.1875, 0.203125, 0.203125, 0.203125, 0.203125, 0.1875, 0.203125, 
    0.203125, 0.195312, 0.203125, 0.203125, 0.195312, 0.203125, 0.195312, 0.203125, 
    0.199219, 0.199219, 0.203125, 0.199219, 0.199219, 0.199219, 0.199219, 0.203125, 
    0.199219, 0.199219, 0.201172, 0.199219, 0.201172, 0.199219, 0.199219, 0.201172, 
    0.200195, 0.199219, 0.200195, 0.200195, 0.200195, 0.200195, 0.199219, 0.200195, 
    0.200195, 0.199707, 0.200195, 0.200195, 0.199707, 0.200195, 0.199707, 0.200195, 
  },
  { /* 2 */
    0, 1, 0, 1, 0, 0, 1, 0, 
    0, 1, 0, 0, 1, 0, 0, 1, 
    0, 0.5, 0.5, 0, 0.5, 0.5, 0, 0.5, 
    0.25, 0.5, 0.25, 0.25, 0.5, 0.25, 0.25, 0.5, 
    0.25, 0.375, 0.375, 0.25, 0.375, 0.375, 0.25, 0.375, 
    0.3125, 0.375, 0.3125, 0.3125, 0.375, 0.3125, 0.3125, 0.375, 
    0.3125, 0.34375, 0.34375, 0.3125, 0.34375, 0.34375, 0.3125, 0.34375, 
    0.328125, 0.34375, 0.328125, 0.328125, 0.34375, 0.328125, 0.328125, 0.34375, 
    0.328125, 0.335938, 0.335938, 0.328125, 0.335938, 0.335938, 0.328125, 0.335938, 
    0.332031, 0.335938, 0.332031, 0.332031, 0.335938, 0.332031, 0.332031, 0.335938, 
    0.332031, 0.333984, 0.333984, 0.332031, 0.333984, 0.333984, 0.332031, 0.333984, 
    0.333008, 0.333984, 0.333008, 0.333008, 0.333984, 0.333008, 0.333008, 0.333984, 
    0.333008, 0.333496, 0.333496, 0.333008, 0.333496, 0.333496, 0.333008, 0.333496, 
  },
  { /* 3 */
    0, 1, 1, 0, 1, 0, 0, 1, 
    0, 1, 0, 1, 0, 0, 1, 0, 
    0.5, 0.5, 0.5, 0.5, 0.5, 0, 0.5, 0.5, 
    0.5, 0.5, 0.25, 0.5, 0.5, 0.25, 0.5, 0.5, 
    0.375, 0.5, 0.375, 0.5, 0.375, 0.375, 0.5, 0.375, 
    0.4375, 0.4375, 0.4375, 0.4375, 0.4375, 0.375, 0.4375, 0.4375, 
    0.4375, 0.4375, 0.40625, 0.4375, 0.4375, 0.40625, 0.4375, 0.4375, 
    0.421875, 0.4375, 0.421875, 0.4375, 0.421875, 0.421875, 0.4375, 0.421875, 
    0.429688, 0.429688, 0.429688, 0.429688, 0.429688, 0.421875, 0.429688, 0.429688, 
    0.429688, 0.429688, 0.425781, 0.429688, 0.429688, 0.425781, 0.429688, 0.429688, 
    0.427734, 0.429688, 0.427734, 0.429688, 0.427734, 0.427734, 0.429688, 0.427734, 
    0.428711, 0.428711, 0.428711, 0.428711, 0.428711, 0.427734, 0.428711, 0.428711, 
    0.428711, 0.428711, 0.428223, 0.428711, 0.428711, 0.428223, 0.428711, 0.428711, 
  },
  { /* 4 */
    0, 1, 1, 0, 1, 0, 1, 0, 
    1, 0, 1, 0, 1, 0, 1, 0, 
    0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
    0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
    0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
    0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
    0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
    0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
    0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
    0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
    0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
    0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
    0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
  },
  { /* 5 */
    0, 1, 4, 1, 0, 1, 0, 1, 
    1, 0, 1, 0, 1, 1, 0, 1, 
    0.5, 0.5, 0.5, 1, 0.5, 0.5, 0.5, 0.5, 
    0.75, 0.5, 0.75, 0.5, 0.5, 0.75, 0.5, 0.75, 
    0.5, 0.625, 0.625, 0.625, 0.625, 0.5, 0.625, 0.625, 
    0.625, 0.5625, 0.625, 0.5625, 0.625, 0.625, 0.5625, 0.625, 
    0.59375, 0.59375, 0.59375, 0.625, 0.59375, 0.59375, 0.59375, 0.59375, 
    0.609375, 0.59375, 0.609375, 0.59375, 0.59375, 0.609375, 0.59375, 0.609375, 
    0.59375, 0.601562, 0.601562, 0.601562, 0.601562, 0.59375, 0.601562, 0.601562, 
    0.601562, 0.597656, 0.601562, 0.597656, 0.601562, 0.601562, 0.597656, 0.601562, 
    0.599609, 0.599609, 0.599609, 0.601562, 0.599609, 0.599609, 0.599609, 0.599609, 
    0.600586, 0.599609, 0.600586, 0.599609, 0.599609, 0.600586, 0.599609, 0.600586, 
    0.599609, 0.600098, 0.600098, 0.600098, 0.600098, 0.599609, 0.600098, 0.600098, 
  },
  { /* 6 */
    0, 1, 4, 1, 0, 1, 1, 0, 
    1, 1, 0, 4, 1, 0, 1, 0, 
    1, 0.5, 0.5, 2.5, 0.5, 0.5, 0.5, 1, 
    1.25, 0.75, 0.5, 1.5, 0.5, 1.5, 0.5, 0.75, 
    1, 1, 0.625, 1, 1, 1.125, 0.625, 1, 
    1, 0.8125, 0.8125, 1, 0.875, 1, 0.8125, 1, 
    0.9375, 0.90625, 0.8125, 0.9375, 0.90625, 0.90625, 0.9375, 0.90625, 
    0.921875, 0.921875, 0.859375, 0.921875, 0.921875, 0.90625, 0.921875, 0.921875, 
    0.890625, 0.921875, 0.890625, 0.921875, 0.914062, 0.898438, 0.914062, 0.921875, 
    0.902344, 0.90625, 0.90625, 0.917969, 0.90625, 0.90625, 0.917969, 0.90625, 
    0.90625, 0.910156, 0.90625, 0.912109, 0.912109, 0.90625, 0.912109, 0.904297, 
    0.90918, 0.90918, 0.908203, 0.912109, 0.90918, 0.908203, 0.90918, 0.908203, 
    0.90918, 0.908691, 0.908691, 0.910645, 0.908691, 0.908691, 0.908691, 0.90918, 
  },
  { /* 7 */
    0, 1, 4, 9, 1, 0, 1, 1, 
    0, 1, 4, 1, 0, 4, 1, 0, 
    1, 0.5, 0.5, 2.5, 0.5, 2.5, 0.5, 0.5, 
    0.75, 2.25, 0.75, 0.5, 1.5, 1.5, 0.75, 1.5, 
    1, 1.5, 0.625, 1.5, 1, 1.125, 1.375, 1.125, 
    1.25, 1.0625, 1.0625, 1.0625, 1.25, 1.25, 1.0625, 1.0625, 
    1.28125, 1.0625, 1.25, 1.0625, 1.15625, 1.15625, 1.1875, 1.15625, 
    1.15625, 1.15625, 1.17188, 1.15625, 1.10938, 1.17188, 1.15625, 1.10938, 
    1.16406, 1.15625, 1.16406, 1.16406, 1.13281, 1.16406, 1.13281, 1.16406, 
    1.16016, 1.15234, 1.14844, 1.16016, 1.14844, 1.14844, 1.16406, 1.16016, 
    1.14844, 1.15625, 1.1543, 1.15039, 1.1543, 1.15625, 1.14844, 1.16211, 
    1.15234, 1.15137, 1.15527, 1.15527, 1.15234, 1.15234, 1.15527, 1.15527, 
    1.15381, 1.15381, 1.15381, 1.15332, 1.15381, 1.15381, 1.15527, 1.15234, 
  },
  { /* 8 */
    0, 1, 4, 9, 4, 1, 0, 1, 
    4, 1, 0, 1, 4, 1, 0, 1, 
    2.5, 0.5, 2.5, 0.5, 2.5, 0.5, 2.5, 0.5, 
    1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 
    1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 
    1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 
    1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 
    1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 
    1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 
    1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 
    1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 
    1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 
    1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 
  },
  { /* 9 */
    0, 1, 4, 9, 16, 4, 1, 0, 
    1, 4, 4, 1, 0, 1, 4, 4, 
    0.5, 5, 2.5, 0.5, 2.5, 0.5, 4, 0.5, 
    2.5, 3.5, 1.5, 1.5, 1.5, 2.25, 3.75, 1.5, 
    1.875, 2.5, 2, 2.5, 1.5, 2.375, 2.5, 1.5, 
    2.4375, 2, 2.25, 2.4375, 1.6875, 2.25, 2.25, 2, 
    2.34375, 2.0625, 2.125, 2.21875, 2.09375, 2.21875, 2.125, 2.0625, 
    2.23438, 2.09375, 2.23438, 2.09375, 2.15625, 2.23438, 2.09375, 2.15625, 
    2.16406, 2.16406, 2.1875, 2.125, 2.16406, 2.16406, 2.16406, 2.125, 
    2.16406, 2.14453, 2.17578, 2.14453, 2.17969, 2.14453, 2.17578, 2.14453, 
    2.1543, 2.1543, 2.16016, 2.16211, 2.16016, 2.1543, 2.16016, 2.16211, 
    2.15723, 2.15234, 2.16113, 2.1543, 2.16113, 2.15723, 2.15723, 2.16113, 
    2.15918, 2.15527, 2.15723, 2.15771, 2.15918, 2.15918, 2.15674, 2.15771, 
  },
  { /* 10 */
    0, 1, 4, 9, 16, 25, 9, 4, 
    1, 0, 1, 4, 9, 4, 1, 0, 
    2.5, 2.5, 0.5, 6.5, 2.5, 0.5, 6.5, 2.5, 
    3.5, 1.5, 2.25, 4.5, 1.5, 3.5, 4.5, 1.5, 
    3, 2.5, 3.375, 2.5, 3, 3, 2.5, 4, 
    2.4375, 2.75, 3.5, 2.9375, 2.75, 2.75, 2.9375, 3, 
    2.84375, 2.84375, 3.125, 2.84375, 2.96875, 2.75, 2.96875, 2.84375, 
    2.98438, 2.90625, 2.98438, 2.85938, 2.84375, 2.85938, 2.98438, 2.90625, 
    2.94531, 2.92188, 2.85156, 2.94531, 2.94531, 2.85156, 2.92188, 2.94531, 
    2.89844, 2.93359, 2.89844, 2.93359, 2.89844, 2.91406, 2.88672, 2.94531, 
    2.91602, 2.91602, 2.90039, 2.91602, 2.91602, 2.91602, 2.89844, 2.91602, 
    2.91602, 2.9082, 2.91602, 2.91113, 2.91602, 2.91602, 2.91113, 2.91602, 
    2.91211, 2.91162, 2.91211, 2.91357, 2.91602, 2.91357, 2.91211, 2.91162, 
  },
  { /* 11 */
    0, 1, 4, 9, 16, 25, 36, 9, 
    4, 1, 0, 1, 4, 9, 9, 4, 
    0.5, 2.5, 9, 2.5, 0.5, 10, 6.5, 0.5, 
    4.5, 1.5, 5.75, 3.5, 3.5, 7.5, 1.5, 4.5, 
    3.5, 3.625, 4.875, 4.625, 4, 4.5, 2.5, 4, 
    4.75, 3.5625, 4.25, 4.75, 3.0625, 4.75, 3.8125, 3.6875, 
    4.15625, 4.28125, 4.125, 3.90625, 4, 4.28125, 3.90625, 3.90625, 
    4.25, 3.90625, 4.32812, 3.82812, 4.21875, 4.0625, 4.09375, 3.95312, 
    4.07812, 4.07812, 4.14844, 4.02344, 4.07812, 4.07812, 4.14062, 4.02344, 
    4.07812, 4.07031, 4.07812, 4.05078, 4.07812, 4.05078, 4.09766, 4.05078, 
    4.08008, 4.08203, 4.08008, 4.07422, 4.06445, 4.06445, 4.07422, 4.08008, 
    4.08105, 4.06934, 4.07715, 4.08105, 4.06934, 4.0625, 4.08105, 4.07715, 
    4.0708, 4.0752, 4.0752, 4.07324, 4.0791, 4.06738, 4.0752, 4.0752, 
  },
  { /* 12 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    16, 9, 4, 1, 0, 1, 4, 9, 
    12.5, 2.5, 0.5, 6.5, 12.5, 2.5, 0.5, 6.5, 
    7.5, 3.5, 7.5, 3.5, 7.5, 3.5, 7.5, 3.5, 
    5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 
    5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 
    5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 
    5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 
    5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 
    5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 
    5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 
    5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 
    5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 
  },
  { /* 13 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 16, 9, 4, 1, 0, 1, 
    6.5, 20.5, 12.5, 2.5, 0.5, 6.5, 16, 6.5, 
    1.5, 16.5, 3.5, 7.5, 7.5, 3.5, 16.5, 1.5, 
    7.375, 10.5, 7, 7.5, 5.5, 6.375, 10, 7.5, 
    8.1875, 6.5, 8.75, 8.1875, 5.5, 8.1875, 8.75, 6.5, 
    8.46875, 6.59375, 8.09375, 8.09375, 6.59375, 8.46875, 7.625, 6.84375, 
    7.90625, 7.71875, 7.67188, 7.34375, 7.65625, 8.04688, 7.34375, 7.34375, 
    7.85156, 7.50781, 7.8125, 7.38281, 7.8125, 7.57031, 7.69531, 7.5, 
    7.69531, 7.59766, 7.69141, 7.59766, 7.67969, 7.59766, 7.66016, 7.59766, 
    7.61523, 7.61523, 7.62891, 7.63867, 7.64453, 7.64648, 7.64453, 7.63867, 
    7.62207, 7.60645, 7.63379, 7.64551, 7.6416, 7.62207, 7.62207, 7.6416, 
    7.63965, 7.61426, 7.64355, 7.62451, 7.63965, 7.63184, 7.62012, 7.64355, 
  },
  { /* 14 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 25, 16, 9, 4, 
    0.5, 2.5, 12.5, 25, 12.5, 2.5, 0.5, 6.5, 
    25.5, 7.5, 3.5, 23.25, 3.5, 7.5, 18.75, 1.5, 
    13.5, 11.5, 7.5, 14.5, 12, 5.5, 10.125, 17.5, 
    8.1875, 12.5625, 10, 11, 10.3125, 10, 13.25, 7.5, 
    11.625, 11.75, 11.0312, 10.1562, 10.2188, 10.6562, 10.5312, 11.75, 
    11.1406, 10.1875, 10.8281, 11.5625, 10.0156, 11.1406, 11.1406, 10.2656, 
    10.9766, 10.6016, 11.1406, 10.7891, 10.5781, 11.1953, 10.3906, 10.9766, 
    10.7891, 10.9219, 10.8242, 10.7891, 10.7461, 10.8242, 10.9648, 10.7891, 
    10.7852, 10.8555, 10.8066, 10.834, 10.8066, 10.8555, 10.7383, 10.9238, 
    10.8203, 10.8115, 10.8311, 10.8311, 10.8203, 10.8047, 10.8311, 10.8311, 
    10.8101, 10.8311, 10.8086, 10.8311, 10.8081, 10.8311, 10.8086, 10.8311, 
  },
  { /* 15 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 36, 25, 
    12.5, 2.5, 0.5, 6.5, 20.5, 42.5, 30.5, 12.5, 
    1.5, 13.5, 28.25, 3.5, 7.5, 36.5, 13.5, 1.5, 
    21.5, 7.5, 22, 15.875, 7.5, 26.5, 5.5, 19, 
    14.5, 13.1875, 18.25, 18.25, 13.1875, 14.5, 12.25, 17, 
    16.7188, 13.2188, 17.125, 15.7188, 13.375, 17.2188, 13.8438, 14.625, 
    15.6719, 15.7188, 15.6719, 14.2344, 15.2969, 16.4219, 14.9688, 14.2344, 
    15.8594, 14.8594, 15.9141, 14.5469, 15.9141, 14.8594, 15.8594, 14.6016, 
    15.4062, 15.2305, 15.418, 15.2305, 15.4219, 15.2305, 15.418, 15.2305, 
    15.3184, 15.3086, 15.2949, 15.2773, 15.2559, 15.2559, 15.2773, 15.2949, 
    15.3135, 15.3252, 15.3213, 15.3018, 15.2666, 15.2432, 15.2861, 15.3135, 
    15.3232, 15.2842, 15.2842, 15.3232, 15.2998, 15.2549, 15.3115, 15.3193, 
  },
  { /* 16 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    56.5, 30.5, 12.5, 2.5, 0.5, 6.5, 20.5, 42.5, 
    43.5, 7.5, 3.5, 31.5, 43.5, 7.5, 3.5, 31.5, 
    25.5, 17.5, 25.5, 17.5, 25.5, 17.5, 25.5, 17.5, 
    21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 
    21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 
    21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 
    21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 
    21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 
    21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 
    21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 
    21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 21.5, 
  },
  { /* 17 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 212, 72.5, 42.5, 20.5, 6.5, 0.5, 2.5, 
    21.5, 73.5, 43.5, 7.5, 3.5, 31.5, 77.25, 31.5, 
    5.5, 58.5, 11.5, 37.875, 35.5, 11.5, 58.5, 5.5, 
    35.9375, 36.5, 33.6875, 27.5, 21.5, 29.9375, 35, 36.6875, 
    32.4688, 24.5, 35.0938, 33.9688, 24.0938, 33.9688, 35.0938, 24.5, 
    34.1562, 28.1562, 32.2812, 31.9844, 28.1562, 34.1562, 29.7969, 29.0312, 
    31.5078, 32.0938, 30.7266, 29.6328, 31.7812, 31.9766, 30.2188, 30.0703, 
    31.8789, 30.1797, 31.8008, 30.2852, 31.6445, 30.4609, 31.4102, 30.707, 
    31.0605, 31.0586, 31.0527, 31.043, 31.0293, 31.0117, 30.9902, 30.9648, 
    30.9189, 30.9004, 30.9775, 31.0205, 31.0479, 31.0596, 31.0557, 31.0361, 
    30.9756, 30.917, 31.0186, 31.0576, 31.0342, 30.9482, 30.939, 31.0342, 
  },
  { /* 18 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 302.5, 90.5, 56.5, 30.5, 12.5, 
    1.5, 13.5, 57.5, 110.5, 57.5, 13.5, 1.5, 21.5, 
    89.625, 25.5, 17.5, 94.375, 17.5, 25.5, 79, 7.5, 
    61.0625, 33.5, 33.5, 62.5, 43.25, 21.5, 54.5, 57.5625, 
    35.3438, 47.2812, 43.625, 36.75, 53.375, 33.7812, 50.8438, 40.5312, 
    45.4375, 43.8125, 38.6406, 42.3125, 46.9375, 45.3281, 43.9375, 40.1875, 
    42.7578, 46.1016, 40.125, 45.0781, 44.3125, 40.7891, 46.3125, 41.8828, 
    44.0977, 43.0234, 42.4609, 44.0977, 44.0977, 42.5508, 43.0234, 44.0977, 
    43.2793, 43.5605, 43.2793, 43.5605, 43.3242, 43.5156, 43.0898, 43.7949, 
    43.3994, 43.4199, 43.4199, 43.4424, 43.3809, 43.4199, 43.4199, 43.4424, 
    43.3921, 43.4312, 43.3848, 43.4312, 43.3784, 43.4312, 43.373, 43.4312, 
  },
  { /* 19 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 436, 156.5, 110.5, 
    57.5, 13.5, 1.5, 21.5, 73.5, 157.5, 111.5, 43.5, 
    5.5, 61.5, 127.375, 17.5, 25.5, 134.5, 47.5, 7.5, 
    97.1875, 27.5, 80, 72.4375, 33.5, 96.5, 23.5, 86.1875, 
    52.5, 57.9688, 72.0938, 71.25, 57.9688, 52.5, 54.8438, 65, 
    69.2812, 53.3594, 67.4219, 62.1094, 54.2969, 71.4062, 56.4844, 58.0469, 
    62.1406, 64.8203, 62.1406, 57.2656, 62.8516, 64.7656, 61.3203, 57.5781, 
    64.0273, 59.2969, 64.1367, 59.2461, 64.1367, 59.2969, 64.0273, 59.4492, 
    61.7559, 61.7695, 61.7793, 61.7852, 61.7871, 61.7852, 61.7793, 61.7695, 
    61.7471, 61.7041, 61.6455, 61.5713, 61.4814, 61.4551, 61.5713, 61.6455, 
    61.7256, 61.7803, 61.7725, 61.7021, 61.5693, 61.4795, 61.6436, 61.7451, 
  },
  { /* 20 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    211.5, 111.5, 43.5, 7.5, 3.5, 31.5, 91.5, 183.5, 
    161.5, 25.5, 17.5, 137.5, 161.5, 25.5, 17.5, 137.5, 
    93.5, 77.5, 93.5, 77.5, 93.5, 77.5, 93.5, 77.5, 
    85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 
    85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 
    85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 
    85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 
    85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 
    85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 
    85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 85.5, 
  },
  { /* 21 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 837.5, 241.5, 133.5, 57.5, 13.5, 1.5, 21.5, 
    115.5, 290.5, 137.5, 17.5, 25.5, 161.5, 283, 95.5, 
    27.5, 230.5, 33.5, 172.75, 111.5, 63.5, 214, 21.5, 
    136.875, 142.5, 134.625, 113.25, 85.5, 108.375, 132, 142.125, 
    130.312, 94.5, 132.938, 135.188, 95.3125, 127.312, 138.562, 99.375, 
    130.312, 109.125, 128.438, 121.156, 110.438, 133.688, 113.719, 115.25, 
    121.359, 124.875, 120.578, 114.703, 122.688, 124.641, 118.781, 115.797, 
    123.898, 117.219, 123.82, 117.43, 123.43, 117.922, 122.727, 118.695, 
    120.73, 120.734, 120.723, 120.695, 120.652, 120.594, 120.52, 120.43, 
    120.264, 120.102, 120.322, 120.518, 120.65, 120.721, 120.729, 120.674, 
  },
  { /* 22 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 1221.5, 343.5, 211.5, 111.5, 43.5, 
    5.5, 61.5, 245.5, 416.875, 187.5, 35.5, 11.5, 115.5, 
    366.5, 77.5, 93.5, 343.062, 41.5, 153.5, 302.188, 23.5, 
    231.5, 166.875, 105.5, 222.75, 205.5, 87.5, 182.344, 243.875, 
    128.203, 209.359, 150.25, 164.125, 191.484, 137.875, 214.938, 132.25, 
    181.906, 179.406, 168.555, 154.719, 167.031, 178.18, 178.023, 178.531, 
    160.699, 174.156, 177.574, 160.934, 174.469, 178.23, 159.469, 175.289, 
    168.412, 176.35, 169.342, 167.34, 175.441, 170.162, 167.045, 174.23, 
    169.708, 172.958, 168.768, 171.739, 172.333, 168.221, 172.984, 170.927, 
    171.22, 169.984, 170.454, 172.185, 170.863, 169.927, 170.7, 172.24, 
  },
  { /* 23 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 1729.5, 553.5, 381.5, 
    187.5, 35.5, 11.5, 115.5, 347.5, 626.5, 385.5, 137.5, 
    21.5, 293.5, 428.25, 41.5, 153.5, 534.5, 131.5, 51.5, 
    378.375, 141.5, 275.25, 310.344, 97.5, 381.125, 127.5, 291.75, 
    211.188, 239.5, 299.312, 254.312, 203.922, 208.375, 234.938, 289.438, 
    243.219, 211.398, 282.125, 213.531, 238.844, 266.055, 205.656, 274.156, 
    225.387, 242.887, 252.906, 244.324, 224.906, 241.48, 249.918, 247.828, 
    231.881, 249.605, 231.553, 250.646, 231.021, 249.732, 233.193, 247.262, 
    240.131, 240.799, 240.087, 240.131, 240.228, 240.971, 240.506, 240.743, 
    241.324, 241.849, 241.708, 241.234, 240.548, 240.562, 240.097, 240.482, 
  },
  { /* 24 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    817.5, 425.5, 161.5, 25.5, 17.5, 137.5, 385.5, 761.5, 
    621.5, 93.5, 77.5, 573.5, 621.5, 93.5, 77.5, 573.5, 
    357.5, 325.5, 357.5, 325.5, 357.5, 325.5, 357.5, 325.5, 
    341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 
    341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 
    341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 
    341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 
    341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 
    341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 341.5, 
  },
  { /* 25 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 3368.5, 935.5, 511.5, 215.5, 47.5, 7.5, 95.5, 
    483.5, 1161.5, 527.5, 63.5, 111.5, 671.5, 1116.5, 363.5, 
    115.5, 921.5, 127.5, 707, 427.5, 267.5, 844.5, 87.5, 
    544.75, 569.5, 540.25, 457, 343.5, 427.75, 524.5, 567.25, 
    523.375, 377.5, 528.625, 542.125, 382.375, 505.375, 554.875, 400.25, 
    518.875, 436, 515.125, 481.938, 442.125, 534.625, 453.062, 462.25, 
    484.156, 499, 482.594, 458.094, 489.625, 498.219, 475.562, 462.031, 
    495.016, 468.375, 494.859, 469.078, 493.453, 470.906, 490.797, 473.859, 
    482.414, 482.438, 482.398, 482.297, 482.133, 481.906, 481.617, 481.266, 
  },
  { /* 26 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 4127.5, 1337.5, 817.5, 425.5, 161.5, 
    21.5, 261.5, 1013.5, 1658.75, 723.5, 131.5, 51.5, 483.5, 
    1427.5, 267.5, 427.5, 1336.12, 141.5, 685.5, 1204.41, 91.5, 
    926.5, 670.312, 397.5, 872.875, 860.578, 353.5, 720.938, 948.75, 
    511.094, 853.477, 580.156, 674.375, 762.383, 542, 868.383, 527.125, 
    725.816, 710.469, 679.316, 621.113, 658.906, 709.566, 718.848, 713.441, 
    643.057, 689.807, 714.207, 641.572, 697.254, 710.393, 637.197, 701.613, 
    672.968, 704.429, 673.795, 669.413, 702.007, 679.601, 667.226, 696.558, 
    676.614, 691.771, 673.942, 685.013, 689.515, 671.159, 690.491, 684.036, 
  },
  { /* 27 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 6944.5, 2167.5, 1487.5, 
    723.5, 131.5, 51.5, 483.5, 1427.5, 2505.5, 1503.5, 527.5, 
    87.5, 1207.5, 1754, 175.5, 591.5, 2137.5, 547.5, 195.5, 
    1515.75, 551.5, 1117, 1248.95, 413.5, 1528.12, 473.5, 1211.88, 
    839.562, 951.156, 1188.5, 1045.19, 850.914, 827.375, 911.75, 1121.12, 
    1016.44, 839.145, 1116.84, 895.359, 906.75, 1108.3, 837.062, 1027.06, 
    927.791, 1000.41, 1008.84, 936.229, 923.836, 1004.57, 1004.37, 940.289, 
    961.567, 974.865, 959.036, 977.704, 956.204, 980.13, 956.61, 979.627, 
    968.071, 968.37, 968.025, 967.979, 967.935, 968.37, 967.892, 967.849, 
  },
  { /* 28 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    3213.5, 1661.5, 621.5, 93.5, 77.5, 573.5, 1581.5, 3101.5, 
    2437.5, 357.5, 325.5, 2341.5, 2437.5, 357.5, 325.5, 2341.5, 
    1397.5, 1333.5, 1397.5, 1333.5, 1397.5, 1333.5, 1397.5, 1333.5, 
    1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 
    1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 
    1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 
    1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 
    1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 1365.5, 
  },
  { /* 29 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 14657.9, 3803.5, 2091.5, 891.5, 203.5, 27.5, 363.5, 
    1891.5, 4638, 2155.5, 267.5, 427.5, 2635.5, 4488, 1491.5, 
    451.5, 3682.75, 523.5, 2805.44, 1823.5, 991.5, 3435.25, 343.5, 
    2190.88, 2276.38, 2179.12, 1780.25, 1365.5, 1760.75, 2125.25, 2318.38, 
    2052.5, 1517.62, 2169.56, 2128.62, 1523.11, 2087.38, 2201.71, 1538.75, 
    2122, 1761.95, 1979.97, 2021.21, 1755.94, 2100.78, 1900.31, 1788.05, 
    1975.73, 1994.8, 1867.39, 1892.48, 2001.45, 1965.27, 1832.8, 1948.29, 
    1961.21, 1916.32, 1923.3, 1954.57, 1894.49, 1977.97, 1883.28, 1985.87, 
  },
  { /* 30 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 14993.5, 5277.5, 3213.5, 1661.5, 621.5, 
    85.5, 1077.5, 4117.5, 6716.75, 2947.5, 547.5, 195.5, 1891.5, 
    5638.33, 1043.5, 1747.5, 5417.12, 581.5, 2693.5, 4753.52, 361.5, 
    3764.5, 2645.29, 1575.5, 3545.88, 3392.26, 1421.5, 2926.44, 3738.41, 
    2070.84, 3409.44, 2297.89, 2715.38, 3063.29, 2143.21, 3474.04, 2134.12, 
    2888.54, 2856.63, 2708.36, 2486.13, 2643.51, 2825.57, 2891.27, 2840.59, 
    2576.9, 2762.39, 2856.24, 2562.38, 2787.22, 2843.53, 2553.66, 2809.01, 
    2689.27, 2818.4, 2698.59, 2674.8, 2809.32, 2721.42, 2665.89, 2788.13, 
  },
  { /* 31 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 27727.5, 8393.5, 5721.5, 
    2737.5, 465.5, 241.5, 2065.5, 5937.5, 9915.78, 5635.5, 1891.5, 
    371.5, 5171.5, 7005.75, 683.5, 2411.5, 8451.42, 2063.5, 847.5, 
    5959.26, 2357.5, 4203.62, 5251.25, 1605.5, 6026.19, 2015.5, 4603.28, 
    3342.22, 3931.5, 4747.88, 4042.27, 3437.44, 3277.72, 3690.56, 4617.38, 
    3930.98, 3407.62, 4460.79, 3506.76, 3717.23, 4339.69, 3345.77, 4251.68, 
    3630.3, 3967.72, 4037.5, 3839.25, 3609.29, 3929.43, 4053.43, 3876.32, 
    3749.2, 3982, 3733.05, 3992.3, 3723.82, 4001.85, 3711.1, 4012.3, 
  },
  { /* 32 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    12741.5, 6565.5, 2437.5, 357.5, 325.5, 2341.5, 6405.5, 12517.5, 
    9653.5, 1397.5, 1333.5, 9461.5, 9653.5, 1397.5, 1333.5, 9461.5, 
    5525.5, 5397.5, 5525.5, 5397.5, 5525.5, 5397.5, 5525.5, 5397.5, 
    5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 
    5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 
    5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 
    5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 5461.5, 
  },
  { /* 33 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 56423, 14847.5, 8095.5, 3391.5, 735.5, 127.5, 1567.5, 
    7823.5, 18574, 8351.5, 991.5, 1823.5, 10847.5, 17979.4, 5891.5, 
    1827.5, 14733.2, 2067.5, 11264.8, 7065.5, 4121.5, 13625, 1385.5, 
    8826.94, 9105.75, 8659.84, 7177.88, 5467.5, 7046.86, 8489.62, 9182, 
    8266.12, 6066.75, 8623.62, 8568.49, 6071.61, 8360.09, 8782.76, 6176.44, 
    8473.29, 7041.83, 7950.81, 8074.3, 7024.42, 8408.5, 7570.66, 7163.64, 
    7907.51, 7980.03, 7472.04, 7566.11, 8004.39, 7857.13, 7337.47, 7789.55, 
  },
  { /* 34 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 59732.4, 20677.5, 12517.5, 6405.5, 2341.5, 
    341.5, 4501.5, 16853.5, 26695.9, 11471.5, 2063.5, 847.5, 7823.5, 
    22538.8, 4017.5, 7217.5, 21533.4, 2235.5, 11067.5, 18758.3, 1421.5, 
    15049.5, 10704.4, 6217.5, 14120.4, 13637.6, 5733.5, 11588, 14967.5, 
    8286.91, 13662.8, 9140.62, 10942.4, 12168.9, 8599.21, 13888.9, 8508.39, 
    11547.8, 11431.4, 10849.5, 9950.68, 10546.9, 11286.4, 11560.5, 11369, 
    10315.3, 11029.9, 11427.8, 10253.7, 11131, 11378.8, 10215.3, 11220, 
  },
  { /* 35 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 106658, 33391.5, 22735.5, 
    10847.5, 1823.5, 991.5, 8351.5, 23903.5, 39652.2, 22393.5, 7481.5, 
    1497.5, 20825.5, 27612.6, 2625.5, 9921.5, 33759.7, 8007.5, 3527.5, 
    23955.9, 9493.5, 16744.3, 20967.9, 6331.5, 24076.8, 8217.5, 18405.1, 
    13376.8, 15709.5, 19028.6, 16147.1, 13649.7, 13118.9, 14861.7, 18479.8, 
    15707.5, 13605.9, 17875.7, 13970.1, 14930.1, 17344.4, 13342.3, 17060.1, 
    14516, 15843.3, 16151.8, 15382.6, 14433.9, 15712.2, 16192.4, 15521.1, 
  },
  { /* 36 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    50741.5, 26101.5, 9653.5, 1397.5, 1333.5, 9461.5, 25781.5, 50293.5, 
    38421.5, 5525.5, 5397.5, 38037.5, 38421.5, 5525.5, 5397.5, 38037.5, 
    21973.5, 21717.5, 21973.5, 21717.5, 21973.5, 21717.5, 21973.5, 21717.5, 
    21845.5, 21845.5, 21845.5, 21845.5, 21845.5, 21845.5, 21845.5, 21845.5, 
    21845.5, 21845.5, 21845.5, 21845.5, 21845.5, 21845.5, 21845.5, 21845.5, 
    21845.5, 21845.5, 21845.5, 21845.5, 21845.5, 21845.5, 21845.5, 21845.5, 
  },
  { /* 37 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 221249, 58663.5, 31847.5, 13223.5, 2791.5, 551.5, 6503.5, 
    31815.5, 74582.5, 33227.5, 3915.5, 7371.5, 43595.5, 71437.2, 23121.5, 
    7441.5, 59185.8, 8217.5, 45078, 27513.5, 17017.5, 54405.5, 5571.5, 
    35078.9, 36605.4, 34429, 29035.4, 21901.5, 27856, 33976.7, 36350.9, 
    33278.3, 24266.6, 34276.6, 34440.6, 24247, 33136.2, 35241.3, 24982.1, 
    33723.1, 28036.9, 32195.3, 31906.6, 28079.1, 33867.3, 29903.8, 28820.9, 
  },
  { /* 38 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 238918, 82423.5, 49847.5, 25463.5, 9271.5, 
    1367.5, 18135.5, 67671.5, 106671, 45675.5, 8171.5, 3435.5, 31467.5, 
    90147.6, 15967.5, 29023.5, 86045.2, 8883.5, 44467.5, 74864.4, 5671.5, 
    60194.3, 42901.4, 24815.5, 56441.2, 54597.8, 22967.5, 46275.2, 59881.3, 
    33151.8, 54669.9, 36530.3, 43825.2, 48621.3, 34416.3, 55552.7, 34016.7, 
    46188.6, 45730.6, 43410.7, 39808.6, 42171.5, 45137, 46240.7, 45482.4, 
  },
  { /* 39 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 418128, 133202, 90641.5, 
    43185.5, 7217.5, 4017.5, 33585.5, 95921.5, 159007, 89871.5, 30095.5, 
    5967.5, 83023.5, 110130, 10431.5, 39871.5, 135405, 32193.5, 14017.5, 
    95526.8, 38101.5, 67194.4, 83609, 25267.5, 96608.6, 32765.5, 73387.1, 
    53673.1, 62728.3, 76122.9, 64687, 54438.3, 52648, 59316.2, 73959.4, 
    62791.8, 54437.1, 71558.6, 55900.9, 59689, 69327.4, 53368, 68290.1, 
  },
  { /* 40 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    202518, 104086, 38421.5, 5525.5, 5397.5, 38037.5, 103446, 201622, 
    153302, 21973.5, 21717.5, 152534, 153302, 21973.5, 21717.5, 152534, 
    87637.5, 87125.5, 87637.5, 87125.5, 87637.5, 87125.5, 87637.5, 87125.5, 
    87381.5, 87381.5, 87381.5, 87381.5, 87381.5, 87381.5, 87381.5, 87381.5, 
    87381.5, 87381.5, 87381.5, 87381.5, 87381.5, 87381.5, 87381.5, 87381.5, 
  },
  { /* 41 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 885887, 235138, 127746, 53121.5, 11265.5, 2177.5, 25857.5, 
    126914, 298315, 133268, 15763.5, 29331.5, 173972, 285217, 92191.5, 
    29855.5, 236745, 32765.5, 180836, 110948, 67427.5, 218108, 22225.5, 
    140063, 146415, 138219, 115762, 87537.5, 111576, 136036, 146144, 
    132699, 97119.6, 137652, 137324, 97075, 132887, 140985, 99482.3, 
  },
  { /* 42 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 968862, 330268, 199836, 102172, 37275.5, 
    5467.5, 72283.5, 270172, 426899, 183124, 32851.5, 13651.5, 125524, 
    360601, 64075.5, 115788, 344352, 35651.5, 177476, 300654, 22775.5, 
    240794, 171096, 99591.5, 226001, 218417, 91541.5, 185857, 239404, 
    132563, 218608, 146570, 174519, 195472, 137315, 222413, 136439, 
  },
  { /* 43 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 1.69019e+06, 532078, 361966, 
    172334, 28717.5, 16173.5, 134702, 384302, 635945, 358892, 120044, 
    23915.5, 332652, 440014, 41585.5, 159858, 541555, 128448, 56255.5, 
    382698, 152152, 269056, 334239, 101188, 386460, 130854, 294519, 
    214601, 250666, 304544, 259190, 217936, 210515, 237126, 295274, 
  },
  { /* 44 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    809174, 415702, 153302, 21973.5, 21717.5, 152534, 414422, 807382, 
    612438, 87637.5, 87125.5, 610902, 612438, 87637.5, 87125.5, 610902, 
    350038, 349014, 350038, 349014, 350038, 349014, 350038, 349014, 
    349526, 349526, 349526, 349526, 349526, 349526, 349526, 349526, 
  },
  { /* 45 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 3.54309e+06, 937652, 508852, 211124, 44467.5, 8883.5, 104372, 
    509748, 1.19335e+06, 530928, 62447.5, 118256, 698352, 1.14106e+06, 368178, 
    119602, 947000, 130854, 723649, 442002, 270994, 871463, 89021.5, 
    560758, 585664, 552410, 463504, 350228, 446326, 544056, 583841, 
  },
  { /* 46 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 5.91765e+06, 7.22812e+06, 3.84899e+06, 1.31763e+06, 796672, 406784, 147968, 
    21887.5, 290688, 1.08378e+06, 1.70628e+06, 729968, 130416, 55151.5, 504176, 
    1.44233e+06, 255072, 464992, 1.37637e+06, 141904, 712272, 1.19888e+06, 90803.5, 
    963117, 686080, 397268, 903214, 874005, 367082, 741310, 957954, 
  },
  { /* 47 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 5.91765e+06, 7.22812e+06, 8.66965e+06, 1.02423e+07, 6.72487e+06, 2.12394e+06, 1.44426e+06, 
    686886, 113958, 65317.5, 540966, 1.5409e+06, 2.5434e+06, 1.432e+06, 478146, 
    95937.5, 1.33395e+06, 1.75709e+06, 165502, 641662, 2.16589e+06, 511834, 226138, 
    1.52909e+06, 611158, 1.07337e+06, 1.33886e+06, 403582, 1.54552e+06, 525506, 1.17409e+06, 
  },
  { /* 48 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 5.91765e+06, 7.22812e+06, 8.66965e+06, 1.02423e+07, 1.19459e+07, 1.37807e+07, 1.57465e+07, 
    3.2349e+06, 1.66153e+06, 612438, 87637.5, 87125.5, 610902, 1.65897e+06, 3.23132e+06, 
    2.44821e+06, 350038, 349014, 2.44514e+06, 2.44821e+06, 350038, 349014, 2.44514e+06, 
    1.39913e+06, 1.39708e+06, 1.39913e+06, 1.39708e+06, 1.39913e+06, 1.39708e+06, 1.39913e+06, 1.39708e+06, 
  },
  { /* 49 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 5.91765e+06, 7.22812e+06, 8.66965e+06, 1.02423e+07, 1.19459e+07, 1.37807e+07, 1.57465e+07, 
    1.89574e+07, 1.41412e+07, 3.75254e+06, 2.03683e+06, 845402, 178266, 35417.5, 416858, 
    2.03759e+06, 4.77122e+06, 2.12228e+06, 249388, 473644, 2.79505e+06, 4.56636e+06, 1.47389e+06, 
    478048, 3.78608e+06, 522998, 2.8962e+06, 1.7692e+06, 1.08312e+06, 3.48404e+06, 356168, 
  },
  { /* 50 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 5.91765e+06, 7.22812e+06, 8.66965e+06, 1.02423e+07, 1.19459e+07, 1.37807e+07, 1.57465e+07, 
    1.89574e+07, 2.36755e+07, 2.89178e+07, 1.5343e+07, 5.26366e+06, 3.18135e+06, 1.62334e+06, 589608, 
    87591.5, 1.16586e+06, 4.34129e+06, 6.82247e+06, 2.91482e+06, 519688, 221704, 2.02087e+06, 
    5.77158e+06, 1.01947e+06, 1.8612e+06, 5.50477e+06, 567148, 2.85067e+06, 4.79073e+06, 362866, 
  },
  { /* 51 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 5.91765e+06, 7.22812e+06, 8.66965e+06, 1.02423e+07, 1.19459e+07, 1.37807e+07, 1.57465e+07, 
    1.89574e+07, 2.36755e+07, 2.89178e+07, 3.46845e+07, 4.09754e+07, 2.68277e+07, 8.48704e+06, 5.76985e+06, 
    2.74265e+06, 454012, 262524, 2.16819e+06, 6.171e+06, 1.01728e+07, 5.72088e+06, 1.90853e+06, 
    384308, 5.34252e+06, 7.02699e+06, 661448, 2.56814e+06, 8.66335e+06, 2.04603e+06, 905296, 
  },
  { /* 52 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 5.91765e+06, 7.22812e+06, 8.66965e+06, 1.02423e+07, 1.19459e+07, 1.37807e+07, 1.57465e+07, 
    1.89574e+07, 2.36755e+07, 2.89178e+07, 3.46845e+07, 4.09754e+07, 4.77907e+07, 5.51302e+07, 6.2994e+07, 
    1.2936e+07, 6.64354e+06, 2.44821e+06, 350038, 349014, 2.44514e+06, 6.63842e+06, 1.29289e+07, 
    9.78978e+06, 1.39913e+06, 1.39708e+06, 9.78364e+06, 9.78978e+06, 1.39913e+06, 1.39708e+06, 9.78364e+06, 
  },
  { /* 53 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 5.91765e+06, 7.22812e+06, 8.66965e+06, 1.02423e+07, 1.19459e+07, 1.37807e+07, 1.57465e+07, 
    1.89574e+07, 2.36755e+07, 2.89178e+07, 3.46845e+07, 4.09754e+07, 4.77907e+07, 5.51302e+07, 6.2994e+07, 
    7.58383e+07, 5.65628e+07, 1.49986e+07, 8.13879e+06, 3.37616e+06, 710692, 142372, 1.6712e+06, 
    8.15876e+06, 1.90852e+07, 8.48058e+06, 995138, 1.89831e+06, 1.11901e+07, 1.82601e+07, 5.88849e+06, 
  },
  { /* 54 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 5.91765e+06, 7.22812e+06, 8.66965e+06, 1.02423e+07, 1.19459e+07, 1.37807e+07, 1.57465e+07, 
    1.89574e+07, 2.36755e+07, 2.89178e+07, 3.46845e+07, 4.09754e+07, 4.77907e+07, 5.51302e+07, 6.2994e+07, 
    7.58383e+07, 9.47116e+07, 1.15682e+08, 6.1372e+07, 2.105e+07, 1.27219e+07, 6.49081e+06, 2.35692e+06, 
    350396, 4.66553e+06, 1.73693e+07, 2.72951e+07, 1.16627e+07, 2.08007e+06, 886082, 8.08071e+06, 
  },
  { /* 55 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 5.91765e+06, 7.22812e+06, 8.66965e+06, 1.02423e+07, 1.19459e+07, 1.37807e+07, 1.57465e+07, 
    1.89574e+07, 2.36755e+07, 2.89178e+07, 3.46845e+07, 4.09754e+07, 4.77907e+07, 5.51302e+07, 6.2994e+07, 
    7.58383e+07, 9.47116e+07, 1.15682e+08, 1.3875e+08, 1.63915e+08, 1.07313e+08, 3.39423e+07, 2.30746e+07, 
    1.09673e+07, 1.81484e+06, 1.05093e+06, 8.67564e+06, 2.46889e+07, 4.06976e+07, 2.28883e+07, 7.63683e+06, 
  },
  { /* 56 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 5.91765e+06, 7.22812e+06, 8.66965e+06, 1.02423e+07, 1.19459e+07, 1.37807e+07, 1.57465e+07, 
    1.89574e+07, 2.36755e+07, 2.89178e+07, 3.46845e+07, 4.09754e+07, 4.77907e+07, 5.51302e+07, 6.2994e+07, 
    7.58383e+07, 9.47116e+07, 1.15682e+08, 1.3875e+08, 1.63915e+08, 1.91177e+08, 2.20536e+08, 2.51992e+08, 
    5.17369e+07, 2.6569e+07, 9.78978e+06, 1.39913e+06, 1.39708e+06, 9.78364e+06, 2.65588e+07, 5.17226e+07, 
  },
  { /* 57 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 5.91765e+06, 7.22812e+06, 8.66965e+06, 1.02423e+07, 1.19459e+07, 1.37807e+07, 1.57465e+07, 
    1.89574e+07, 2.36755e+07, 2.89178e+07, 3.46845e+07, 4.09754e+07, 4.77907e+07, 5.51302e+07, 6.2994e+07, 
    7.58383e+07, 9.47116e+07, 1.15682e+08, 1.3875e+08, 1.63915e+08, 1.91177e+08, 2.20536e+08, 2.51992e+08, 
    3.03371e+08, 2.26256e+08, 5.99865e+07, 3.25495e+07, 1.3501e+07, 2.84119e+06, 569956, 6.68733e+06, 
  },
  { /* 58 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 5.91765e+06, 7.22812e+06, 8.66965e+06, 1.02423e+07, 1.19459e+07, 1.37807e+07, 1.57465e+07, 
    1.89574e+07, 2.36755e+07, 2.89178e+07, 3.46845e+07, 4.09754e+07, 4.77907e+07, 5.51302e+07, 6.2994e+07, 
    7.58383e+07, 9.47116e+07, 1.15682e+08, 1.3875e+08, 1.63915e+08, 1.91177e+08, 2.20536e+08, 2.51992e+08, 
    3.03371e+08, 3.78866e+08, 4.6275e+08, 2.45291e+08, 8.4191e+07, 5.08803e+07, 2.59582e+07, 9.42468e+06, 
  },
  { /* 59 */
    0, 1, 4, 9, 16, 25, 36, 49, 
    64, 81, 100, 121, 144, 169, 196, 225, 
    272.5, 342.5, 420.5, 506.5, 600.5, 702.5, 812.5, 930.5, 
    1123.5, 1407.5, 1723.5, 2071.5, 2451.5, 2863.5, 3307.5, 3783.5, 
    4561.5, 5705.5, 6977.5, 8377.5, 9905.5, 11561.5, 13345.5, 15257.5, 
    18381.5, 22973.5, 28077.5, 33693.5, 39821.5, 46461.5, 53613.5, 61277.5, 
    73797.5, 92197.5, 112646, 135142, 159686, 186278, 214918, 245606, 
    295734, 369398, 451254, 541302, 639542, 745974, 860598, 983414, 
    1.18402e+06, 1.47881e+06, 1.80636e+06, 2.16668e+06, 2.55977e+06, 2.98562e+06, 3.44425e+06, 3.93564e+06, 
    4.73826e+06, 5.91765e+06, 7.22812e+06, 8.66965e+06, 1.02423e+07, 1.19459e+07, 1.37807e+07, 1.57465e+07, 
    1.89574e+07, 2.36755e+07, 2.89178e+07, 3.46845e+07, 4.09754e+07, 4.77907e+07, 5.51302e+07, 6.2994e+07, 
    7.58383e+07, 9.47116e+07, 1.15682e+08, 1.3875e+08, 1.63915e+08, 1.91177e+08, 2.20536e+08, 2.51992e+08, 
    3.03371e+08, 3.78866e+08, 4.6275e+08, 5.55023e+08, 6.55684e+08, 4.2898e+08, 1.35758e+08, 9.22889e+07, 
  },
};

const double schro_table_onebits_hist_shift3_1_2[60][104] = {
  { /* 0 */
    0, 0, 1, 0, 1, 1, 2, 0, 
    1, 1, 2, 1, 2, 2, 3, 0, 
    1, 1.5, 2, 2, 2, 2.5, 3, 2, 
    1.25, 2, 2.25, 2.75, 2.25, 3, 3.25, 3.25, 
    1.625, 2.5, 2.625, 3.375, 2.625, 3.5, 3.625, 4.125, 
    2.0625, 3, 3.0625, 3.9375, 3.0625, 4, 4.0625, 4.8125, 
    2.53125, 3.5, 3.53125, 4.46875, 3.53125, 4.5, 4.53125, 5.40625, 
    3.01562, 4, 4.01562, 4.98438, 4.01562, 5, 5.01562, 5.95312, 
    3.50781, 4.5, 4.50781, 5.49219, 4.50781, 5.5, 5.50781, 6.47656, 
    4.00391, 5, 5.00391, 5.99609, 5.00391, 6, 6.00391, 6.98828, 
    4.50195, 5.5, 5.50195, 6.49805, 5.50195, 6.5, 6.50195, 7.49414, 
    5.00098, 6, 6.00098, 6.99902, 6.00098, 7, 7.00098, 7.99707, 
    5.50049, 6.5, 6.50049, 7.49951, 6.50049, 7.5, 7.50049, 8.49854, 
  },
  { /* 1 */
    0, 0, 0, 1, 0, 1, 1, 1, 
    2, 0, 1, 1, 1, 2, 1, 2, 
    2, 1.5, 1, 1.5, 1.5, 2, 2, 2, 
    2.5, 2.5, 1.25, 1.75, 2, 2.5, 2.75, 2.25, 
    2.875, 3.375, 1.5, 2.25, 2.5, 2.875, 3.5, 2.5, 
    3.375, 4.0625, 1.875, 2.6875, 3, 3.375, 4.125, 2.875, 
    3.84375, 4.6875, 2.28125, 3.1875, 3.5, 3.84375, 4.71875, 3.28125, 
    4.34375, 5.25, 2.73438, 3.67188, 4, 4.34375, 5.26562, 3.73438, 
    4.83594, 5.78906, 3.20312, 4.17188, 4.5, 4.83594, 5.79688, 4.20312, 
    5.33594, 6.30859, 3.6875, 4.66797, 5, 5.33594, 6.3125, 4.6875, 
    5.83398, 6.82031, 4.17773, 5.16797, 5.5, 5.83398, 6.82227, 5.17773, 
    6.33398, 7.32617, 4.67285, 5.66699, 6, 6.33398, 7.32715, 5.67285, 
    6.8335, 7.82959, 5.16992, 6.16699, 6.5, 6.8335, 7.83008, 6.16992, 
  },
  { /* 2 */
    0, 0, 0, 1, 1, 0, 1, 1, 
    1, 2, 2, 0, 1, 1, 1, 2, 
    1.5, 2, 2.5, 1.5, 1, 1.5, 1.5, 2, 
    2.25, 2.25, 2.75, 2.75, 1.25, 1.75, 2.25, 2.25, 
    2.875, 2.5, 3.25, 3.625, 1.5, 2.25, 2.875, 2.5, 
    3.5, 2.875, 3.6875, 4.375, 1.875, 2.6875, 3.5, 2.875, 
    4.0625, 3.28125, 4.1875, 5, 2.28125, 3.1875, 4.0625, 3.28125, 
    4.60938, 3.73438, 4.67188, 5.57812, 2.73438, 3.67188, 4.60938, 3.73438, 
    5.13281, 4.20312, 5.17188, 6.11719, 3.20312, 4.17188, 5.13281, 4.20312, 
    5.64844, 4.6875, 5.66797, 6.64062, 3.6875, 4.66797, 5.64844, 4.6875, 
    6.15625, 5.17773, 6.16797, 7.15234, 4.17773, 5.16797, 6.15625, 5.17773, 
    6.66113, 5.67285, 6.66699, 7.65918, 4.67285, 5.66699, 6.66113, 5.67285, 
    7.16357, 6.16992, 7.16699, 8.1626, 5.16992, 6.16699, 7.16357, 6.16992, 
  },
  { /* 3 */
    0, 0, 0, 0, 1, 1, 0, 1, 
    1, 1, 1, 2, 2, 0, 1, 1, 
    1, 2, 1.5, 2, 2.5, 1.5, 1, 1, 
    1.75, 2.25, 2, 2.5, 2.75, 2.75, 1, 1.75, 
    2.125, 2.625, 2.5, 3, 3.25, 3.625, 1.375, 2.125, 
    2.5625, 3.125, 3.0625, 3.375, 3.75, 4.375, 1.75, 2.5625, 
    3.09375, 3.5625, 3.59375, 3.84375, 4.21875, 5.03125, 2.15625, 3.09375, 
    3.57812, 4.03125, 4.10938, 4.32812, 4.71875, 5.60938, 2.625, 3.57812, 
    4.07031, 4.52344, 4.625, 4.80469, 5.21875, 6.15625, 3.10156, 4.07031, 
    4.57422, 5.01172, 5.13281, 5.29688, 5.71484, 6.68359, 3.58594, 4.57422, 
    5.07227, 5.50586, 5.63672, 5.79297, 6.21484, 7.19727, 4.08008, 5.07227, 
    5.57129, 6.00391, 6.13965, 6.28906, 6.71484, 7.70508, 4.57617, 5.57129, 
    6.07178, 6.50195, 6.64111, 6.7876, 7.21436, 8.20947, 5.07373, 6.07178, 
  },
  { /* 4 */
    0, 0, 0, 0, 1, 1, 0, 0, 
    1, 1, 1, 1, 2, 2, 0, 0, 
    1, 1, 2, 1, 2, 2, 3, 0, 
    1, 1.5, 2, 2, 2, 2.5, 3, 2, 
    1.25, 2, 2.25, 2.75, 2.25, 3, 3.25, 3.25, 
    1.625, 2.5, 2.625, 3.375, 2.625, 3.5, 3.625, 4.125, 
    2.0625, 3, 3.0625, 3.9375, 3.0625, 4, 4.0625, 4.8125, 
    2.53125, 3.5, 3.53125, 4.46875, 3.53125, 4.5, 4.53125, 5.40625, 
    3.01562, 4, 4.01562, 4.98438, 4.01562, 5, 5.01562, 5.95312, 
    3.50781, 4.5, 4.50781, 5.49219, 4.50781, 5.5, 5.50781, 6.47656, 
    4.00391, 5, 5.00391, 5.99609, 5.00391, 6, 6.00391, 6.98828, 
    4.50195, 5.5, 5.50195, 6.49805, 5.50195, 6.5, 6.50195, 7.49414, 
    5.00098, 6, 6.00098, 6.99902, 6.00098, 7, 7.00098, 7.99707, 
  },
  { /* 5 */
    0, 0, 0, 0, 0, 1, 1, 1, 
    0, 0, 1, 1, 1, 1, 1, 2, 
    2, 0, 1, 1, 1.5, 2, 1, 2, 
    2.25, 1.5, 1, 1.75, 1.5, 2.25, 2, 2, 
    2.625, 2.625, 1.375, 1.875, 2, 2.625, 2.875, 2.375, 
    2.9375, 3.5, 1.625, 2.3125, 2.625, 2.9375, 3.625, 2.625, 
    3.46875, 4.15625, 1.96875, 2.78125, 3.125, 3.46875, 4.21875, 2.96875, 
    3.95312, 4.78125, 2.375, 3.29688, 3.59375, 3.95312, 4.8125, 3.375, 
    4.44531, 5.35156, 2.83594, 3.77344, 4.09375, 4.44531, 5.36719, 3.83594, 
    4.93359, 5.89062, 3.30469, 4.26953, 4.60156, 4.93359, 5.89844, 4.30469, 
    5.43555, 6.4082, 3.78711, 4.76758, 5.10156, 5.43555, 6.41211, 4.78711, 
    5.93457, 6.91992, 4.27734, 5.26855, 5.59961, 5.93457, 6.92188, 5.27734, 
    6.43408, 7.42627, 4.77295, 5.76709, 6.09961, 6.43408, 7.42725, 5.77295, 
  },
  { /* 6 */
    0, 0, 0, 0, 0, 0, 1, 1, 
    1, 0, 0, 1, 1, 1, 1, 1, 
    1.5, 2, 0, 1, 1, 1, 2, 1.5, 
    1.75, 2.25, 1.5, 1, 1.5, 1.5, 2, 2.75, 
    1.75, 2.75, 2.625, 1.25, 1.75, 2.125, 2.375, 3, 
    2.375, 3.0625, 3.5625, 1.5, 2.25, 2.625, 2.9375, 3.25, 
    2.9375, 3.53125, 4.25, 1.875, 2.78125, 3.09375, 3.3125, 3.71875, 
    3.48438, 4.01562, 4.85938, 2.32812, 3.20312, 3.625, 3.76562, 4.23438, 
    4, 4.5, 5.42188, 2.76562, 3.69531, 4.14844, 4.22656, 4.75, 
    4.50391, 5, 5.95312, 3.23047, 4.1875, 4.67188, 4.70703, 5.25, 
    5.00781, 5.49609, 6.47266, 3.70898, 4.68945, 5.17188, 5.20508, 5.75195, 
    5.51074, 5.99316, 6.98242, 4.19922, 5.18848, 5.67188, 5.7041, 6.25195, 
    6.01074, 6.49463, 7.48682, 4.69385, 5.68799, 6.17139, 6.20459, 6.75195, 
  },
  { /* 7 */
    0, 0, 0, 0, 0, 0, 0, 1, 
    1, 1, 0, 0, 0, 1, 1, 1, 
    1, 1, 2, 1, 0, 1, 1, 1, 
    1.75, 1.25, 2, 2.5, 0.75, 1, 1.25, 1.5, 
    1.875, 2, 2.375, 2.625, 2.25, 1.125, 1.625, 2.25, 
    2.125, 2.5625, 2.625, 3.1875, 3.25, 1.375, 2, 2.875, 
    2.53125, 3.09375, 3.03125, 3.59375, 4.125, 1.6875, 2.5, 3.21875, 
    3.07812, 3.60938, 3.48438, 4.0625, 4.8125, 2.09375, 3.01562, 3.625, 
    3.59375, 4.10938, 3.96875, 4.54688, 5.41406, 2.55469, 3.5, 4.0625, 
    4.11328, 4.61328, 4.45703, 5.03906, 5.96875, 3.02734, 3.97266, 4.55859, 
    4.61914, 5.12109, 4.94727, 5.53516, 6.49805, 3.5, 4.47266, 5.05469, 
    5.12305, 5.62305, 5.44238, 6.03418, 7.01367, 3.98633, 4.96875, 5.55566, 
    5.62598, 6.12012, 5.94336, 6.53271, 7.52246, 4.47754, 5.46875, 6.05566, 
  },
  { /* 8 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 0, 0, 0, 0, 
    1, 1, 1, 1, 2, 2, 0, 0, 
    1, 1, 2, 1, 2, 2, 3, 0, 
    1, 1.5, 2, 2, 2, 2.5, 3, 2, 
    1.25, 2, 2.25, 2.75, 2.25, 3, 3.25, 3.25, 
    1.625, 2.5, 2.625, 3.375, 2.625, 3.5, 3.625, 4.125, 
    2.0625, 3, 3.0625, 3.9375, 3.0625, 4, 4.0625, 4.8125, 
    2.53125, 3.5, 3.53125, 4.46875, 3.53125, 4.5, 4.53125, 5.40625, 
    3.01562, 4, 4.01562, 4.98438, 4.01562, 5, 5.01562, 5.95312, 
    3.50781, 4.5, 4.50781, 5.49219, 4.50781, 5.5, 5.50781, 6.47656, 
    4.00391, 5, 5.00391, 5.99609, 5.00391, 6, 6.00391, 6.98828, 
    4.50195, 5.5, 5.50195, 6.49805, 5.50195, 6.5, 6.50195, 7.49414, 
  },
  { /* 9 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 1, 1, 1, 1, 1, 0, 
    0, 0.5, 1, 1, 1, 1, 1.5, 2, 
    1, 0.5, 1, 1, 2, 1.25, 1.75, 2, 
    2.625, 0.5, 1.25, 1.5, 2, 2.375, 1.75, 2.5, 
    2.8125, 1.5, 1.625, 2.0625, 2.3125, 3.25, 1.875, 2.75, 
    3.28125, 2.3125, 1.9375, 2.65625, 2.78125, 3.46875, 2.5625, 3.1875, 
    3.73438, 2.96875, 2.39062, 3.15625, 3.3125, 3.79688, 3.125, 3.71875, 
    4.19531, 3.50781, 2.90625, 3.67188, 3.71094, 4.30469, 3.67969, 4.23438, 
    4.66406, 4.03516, 3.41016, 4.17578, 4.16406, 4.80859, 4.20703, 4.69141, 
    5.16992, 4.54492, 3.91797, 4.66992, 4.64844, 5.31055, 4.72266, 5.16992, 
    5.6748, 5.04883, 4.42285, 5.16602, 5.13965, 5.80957, 5.23145, 5.65918, 
    6.17773, 5.55176, 4.92383, 5.6626, 5.63672, 6.31055, 5.73584, 6.15283, 
  },
  { /* 10 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 1, 1, 1, 1, 
    1, 0, 0, 0.5, 1, 1, 1, 1, 
    1.25, 2, 0.5, 0.5, 1, 1, 1.5, 2, 
    1.375, 2, 2.5, 0.5, 1, 1.75, 1.625, 2.125, 
    2, 2.375, 3.125, 1.25, 1.4375, 2.3125, 1.75, 2.5625, 
    2.5, 2.9375, 3.34375, 2.1875, 1.875, 2.53125, 2.4375, 2.9375, 
    3.04688, 3.46875, 3.65625, 2.85938, 2.40625, 2.90625, 3.03125, 3.32812, 
    3.58594, 3.91406, 4.125, 3.46875, 2.89844, 3.36719, 3.48438, 3.86719, 
    4.09766, 4.35156, 4.63672, 4.00781, 3.42188, 3.85156, 3.95703, 4.38281, 
    4.60156, 4.82031, 5.14844, 4.52344, 3.92578, 4.33398, 4.46484, 4.88672, 
    5.10449, 5.30273, 5.65625, 5.0293, 4.43066, 4.81445, 4.97949, 5.38574, 
    5.60449, 5.79492, 6.15625, 5.53613, 4.93115, 5.30713, 5.48291, 5.89014, 
  },
  { /* 11 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 1, 1, 
    1, 1, 0.5, 0, 0, 0.5, 1, 1, 
    1, 1, 1.75, 2, 0, 0.5, 1, 1, 
    1.5, 1.375, 1.875, 2.125, 2.25, 0.5, 1, 1.75, 
    1.625, 2.1875, 1.875, 2.625, 3.3125, 1, 1.4375, 1.8125, 
    2.15625, 2.90625, 2.125, 3.03125, 3.5625, 2.03125, 2.03125, 2.03125, 
    2.59375, 3.5, 2.57812, 3.45312, 4, 2.75, 2.375, 2.64062, 
    3.04688, 3.90625, 3.19531, 3.92969, 4.42188, 3.375, 2.8125, 3.21094, 
    3.5, 4.38281, 3.74219, 4.43359, 4.85156, 3.96484, 3.26953, 3.73047, 
    3.98633, 4.86328, 4.27148, 4.91016, 5.33789, 4.50195, 3.75781, 4.20898, 
    4.49316, 5.35254, 4.79004, 5.39941, 5.83301, 5.01953, 4.25293, 4.69824, 
    4.99561, 5.8457, 5.2998, 5.89453, 6.33105, 5.5293, 4.75098, 5.18945, 
  },
  { /* 12 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 0, 0, 0, 0, 
    1, 1, 1, 1, 2, 2, 0, 0, 
    1, 1, 2, 1, 2, 2, 3, 0, 
    1, 1.5, 2, 2, 2, 2.5, 3, 2, 
    1.25, 2, 2.25, 2.75, 2.25, 3, 3.25, 3.25, 
    1.625, 2.5, 2.625, 3.375, 2.625, 3.5, 3.625, 4.125, 
    2.0625, 3, 3.0625, 3.9375, 3.0625, 4, 4.0625, 4.8125, 
    2.53125, 3.5, 3.53125, 4.46875, 3.53125, 4.5, 4.53125, 5.40625, 
    3.01562, 4, 4.01562, 4.98438, 4.01562, 5, 5.01562, 5.95312, 
    3.50781, 4.5, 4.50781, 5.49219, 4.50781, 5.5, 5.50781, 6.47656, 
    4.00391, 5, 5.00391, 5.99609, 5.00391, 6, 6.00391, 6.98828, 
  },
  { /* 13 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.5, 1, 1, 1, 1, 0.5, 0, 
    0, 0.5, 1, 1, 1, 1, 1.75, 2, 
    0.75, 0.5, 1, 1.125, 2, 1.125, 1.75, 2, 
    2.5, 0.5, 1.3125, 1.4375, 2, 2.3125, 1.75, 2.5625, 
    2.8125, 1.375, 1.625, 2.03125, 2.3125, 3.1875, 1.90625, 2.71875, 
    3.26562, 2.25, 1.9375, 2.60938, 2.76562, 3.48438, 2.5, 3.17188, 
    3.71094, 2.9375, 2.35938, 3.125, 3.28906, 3.78906, 3.09375, 3.6875, 
    4.17578, 3.47266, 2.87891, 3.64453, 3.69922, 4.27344, 3.64844, 4.20703, 
    4.64062, 4.00781, 3.38086, 4.15234, 4.14062, 4.7832, 4.17578, 4.67188, 
    5.14258, 4.5166, 3.89062, 4.64453, 4.62402, 5.28418, 4.69434, 5.14648, 
    5.64795, 5.02197, 4.396, 5.14062, 5.11426, 5.7832, 5.20361, 5.63428, 
  },
  { /* 14 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.5, 1, 1, 1, 1, 
    0.5, 0, 0, 0.75, 1, 1, 1, 1, 
    1.5, 1.75, 0, 0.75, 1, 1, 1.875, 1.5, 
    1.5625, 2.125, 1.6875, 0.75, 1.3125, 1.375, 1.9375, 2.5, 
    1.75, 2.5, 3.0625, 0.78125, 1.65625, 2.0625, 2.15625, 2.65625, 
    2.4375, 2.85938, 3.71875, 1.35938, 2, 2.76562, 2.34375, 3.17188, 
    2.94531, 3.32031, 4.07812, 2.14062, 2.4375, 3.38281, 2.66406, 3.5625, 
    3.47266, 3.84375, 4.48828, 2.78516, 2.92188, 3.85547, 3.11719, 4.04688, 
    3.97656, 4.37109, 4.92969, 3.35547, 3.42578, 4.27539, 3.65625, 4.53906, 
    4.48145, 4.86133, 5.41797, 3.89355, 3.93066, 4.72949, 4.16992, 5.04395, 
    4.97998, 5.35742, 5.91455, 4.4126, 4.42383, 5.21484, 4.67822, 5.5459, 
  },
  { /* 15 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.5, 1, 1, 
    1, 1, 0.25, 0, 0, 0.5, 1, 1, 
    1, 1, 1.875, 1.75, 0, 0.5, 1, 1, 
    1.5625, 1.3125, 1.875, 2.1875, 2.0625, 0.5, 1, 1.8125, 
    1.59375, 2.15625, 1.90625, 2.59375, 3.34375, 0.875, 1.4375, 1.8125, 
    2.15625, 2.85938, 2.125, 3.01562, 3.5625, 1.98438, 2, 2.03125, 
    2.57812, 3.5, 2.53906, 3.4375, 3.99219, 2.71094, 2.375, 2.60938, 
    3.03516, 3.89062, 3.16797, 3.91406, 4.41406, 3.33984, 2.80078, 3.1875, 
    3.48438, 4.36719, 3.71875, 4.41602, 4.83789, 3.94141, 3.25195, 3.7168, 
    3.9668, 4.84668, 4.25, 4.89355, 5.32031, 4.47949, 3.74023, 4.19238, 
    4.47412, 5.33496, 4.77002, 5.38184, 5.81494, 4.99951, 4.23486, 4.68066, 
  },
  { /* 16 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 0, 0, 0, 0, 
    1, 1, 1, 1, 2, 2, 0, 0, 
    1, 1, 2, 1, 2, 2, 3, 0, 
    1, 1.5, 2, 2, 2, 2.5, 3, 2, 
    1.25, 2, 2.25, 2.75, 2.25, 3, 3.25, 3.25, 
    1.625, 2.5, 2.625, 3.375, 2.625, 3.5, 3.625, 4.125, 
    2.0625, 3, 3.0625, 3.9375, 3.0625, 4, 4.0625, 4.8125, 
    2.53125, 3.5, 3.53125, 4.46875, 3.53125, 4.5, 4.53125, 5.40625, 
    3.01562, 4, 4.01562, 4.98438, 4.01562, 5, 5.01562, 5.95312, 
    3.50781, 4.5, 4.50781, 5.49219, 4.50781, 5.5, 5.50781, 6.47656, 
  },
  { /* 17 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.5, 1, 1, 1, 1, 0.25, 0, 
    0, 0.5, 1, 1, 1, 1, 1.75, 2, 
    0.625, 0.5, 1, 1.125, 2, 1.0625, 1.75, 2, 
    2.40625, 0.5, 1.3125, 1.40625, 2, 2.25, 1.75, 2.5625, 
    2.79688, 1.3125, 1.60938, 2, 2.29688, 3.14062, 1.90625, 2.70312, 
    3.24219, 2.20312, 1.92188, 2.57812, 2.74219, 3.47656, 2.46094, 3.14844, 
    3.6875, 2.90625, 2.33203, 3.09766, 3.26172, 3.77344, 3.0625, 3.66016, 
    4.15234, 3.44336, 2.85156, 3.61719, 3.67969, 4.24609, 3.61914, 4.17969, 
    4.61621, 3.98047, 3.35352, 4.12695, 4.11621, 4.75684, 4.14746, 4.64844, 
    5.11572, 4.48975, 3.86377, 4.61865, 4.59863, 5.25781, 4.66699, 5.12158, 
  },
  { /* 18 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.5, 1, 1, 1, 1, 
    0.625, 0, 0, 0.625, 1, 1, 1, 1, 
    1.4375, 2, 0, 0.625, 1, 1, 1.75, 1.6875, 
    1.46875, 2.03125, 2.0625, 0.625, 1.1875, 1.53125, 1.78125, 2.34375, 
    1.84375, 2.40625, 3.32812, 0.75, 1.5625, 2.23438, 1.84375, 2.65625, 
    2.47656, 2.83594, 3.51562, 1.79688, 1.92188, 2.80469, 2.17188, 3.00781, 
    3.01172, 3.36719, 3.875, 2.58984, 2.30078, 3.14453, 2.78906, 3.45703, 
    3.52148, 3.87695, 4.32227, 3.12305, 2.83203, 3.58984, 3.32031, 3.94727, 
    4.01074, 4.38867, 4.81055, 3.63379, 3.3418, 4.04102, 3.86914, 4.43652, 
    4.50146, 4.89795, 5.27539, 4.16846, 3.84424, 4.51709, 4.38574, 4.94092, 
  },
  { /* 19 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.5, 1, 1, 
    1, 1, 0.125, 0, 0, 0.5, 1, 1, 
    1, 1, 1.875, 1.625, 0, 0.5, 1, 1, 
    1.5625, 1.28125, 1.875, 2.1875, 1.96875, 0.5, 1, 1.8125, 
    1.57812, 2.125, 1.90625, 2.57812, 3.34375, 0.8125, 1.42188, 1.8125, 
    2.14062, 2.82812, 2.11719, 3, 3.55469, 1.94531, 1.97656, 2.02344, 
    2.5625, 3.48828, 2.51172, 3.42188, 3.97656, 2.68359, 2.36328, 2.58594, 
    3.01953, 3.875, 3.14453, 3.89648, 4.40039, 3.31445, 2.78516, 3.16602, 
    3.46777, 4.34961, 3.69824, 4.39746, 4.82227, 3.91992, 3.23438, 3.7002, 
    3.94775, 4.8291, 4.22998, 4.87598, 5.30225, 4.45947, 3.72217, 4.1748, 
  },
  { /* 20 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 0, 0, 0, 0, 
    1, 1, 1, 1, 2, 2, 0, 0, 
    1, 1, 2, 1, 2, 2, 3, 0, 
    1, 1.5, 2, 2, 2, 2.5, 3, 2, 
    1.25, 2, 2.25, 2.75, 2.25, 3, 3.25, 3.25, 
    1.625, 2.5, 2.625, 3.375, 2.625, 3.5, 3.625, 4.125, 
    2.0625, 3, 3.0625, 3.9375, 3.0625, 4, 4.0625, 4.8125, 
    2.53125, 3.5, 3.53125, 4.46875, 3.53125, 4.5, 4.53125, 5.40625, 
    3.01562, 4, 4.01562, 4.98438, 4.01562, 5, 5.01562, 5.95312, 
  },
  { /* 21 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.5, 1, 1, 1, 1, 0.25, 0, 
    0, 0.5, 1, 1, 1, 1, 1.75, 2, 
    0.625, 0.5, 1, 1.125, 2, 1.0625, 1.75, 2, 
    2.40625, 0.5, 1.3125, 1.40625, 2, 2.25, 1.75, 2.5625, 
    2.79688, 1.3125, 1.60938, 2, 2.29688, 3.14062, 1.90625, 2.70312, 
    3.24219, 2.20312, 1.92188, 2.57812, 2.74219, 3.47656, 2.46094, 3.14844, 
    3.6875, 2.90625, 2.33203, 3.09766, 3.26172, 3.77344, 3.0625, 3.66016, 
    4.15234, 3.44336, 2.85156, 3.61719, 3.67969, 4.24609, 3.61914, 4.17969, 
    4.61621, 3.98047, 3.35352, 4.12695, 4.11621, 4.75684, 4.14746, 4.64844, 
  },
  { /* 22 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.625, 1, 1, 1, 1, 
    0.5, 0, 0, 0.6875, 1, 1, 1, 1, 
    1.5, 1.8125, 0, 0.6875, 1, 1, 1.84375, 1.5625, 
    1.51562, 2.09375, 1.82812, 0.6875, 1.26562, 1.4375, 1.85938, 2.4375, 
    1.78125, 2.45312, 3.23438, 0.6875, 1.625, 2.14062, 2.00781, 2.64844, 
    2.46875, 2.82422, 3.60938, 1.54688, 1.98047, 2.84766, 2.1875, 3.08984, 
    2.95508, 3.35352, 3.96484, 2.33984, 2.42188, 3.25586, 2.66406, 3.5332, 
    3.48438, 3.85254, 4.39453, 3.00195, 2.83594, 3.68262, 3.2373, 3.97852, 
    4.01318, 4.33887, 4.8584, 3.59814, 3.27832, 4.14648, 3.78467, 4.44775, 
  },
  { /* 23 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.5, 1, 1, 
    1, 1, 0.125, 0, 0, 0.5625, 1, 1, 
    1, 1, 1.90625, 1.5625, 0, 0.5625, 1, 1, 
    1.59375, 1.25, 1.92188, 2.23438, 1.82812, 0.5625, 1, 1.84375, 
    1.60156, 2.08594, 2, 2.58594, 3.39844, 0.65625, 1.42188, 1.92188, 
    2.16406, 2.74609, 2.21484, 3.00391, 3.61328, 1.83594, 1.91406, 2.13672, 
    2.58398, 3.47852, 2.53125, 3.45508, 4.00391, 2.56836, 2.50195, 2.49414, 
    3.05664, 3.97559, 3.03125, 3.92871, 4.47656, 3.18066, 2.88672, 3.07031, 
    3.55078, 4.40137, 3.60742, 4.40137, 4.97559, 3.70508, 3.35938, 3.59473, 
  },
  { /* 24 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 0, 0, 0, 0, 
    1, 1, 1, 1, 2, 2, 0, 0, 
    1, 1, 2, 1, 2, 2, 3, 0, 
    1, 1.5, 2, 2, 2, 2.5, 3, 2, 
    1.25, 2, 2.25, 2.75, 2.25, 3, 3.25, 3.25, 
    1.625, 2.5, 2.625, 3.375, 2.625, 3.5, 3.625, 4.125, 
    2.0625, 3, 3.0625, 3.9375, 3.0625, 4, 4.0625, 4.8125, 
    2.53125, 3.5, 3.53125, 4.46875, 3.53125, 4.5, 4.53125, 5.40625, 
  },
  { /* 25 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.5, 1, 1, 1, 1, 0.25, 0, 
    0, 0.5, 1, 1, 1, 1, 1.75, 2, 
    0.625, 0.5, 1, 1.125, 2, 1.0625, 1.75, 2, 
    2.40625, 0.5, 1.3125, 1.40625, 2, 2.25, 1.75, 2.5625, 
    2.79688, 1.3125, 1.60938, 2, 2.29688, 3.14062, 1.90625, 2.70312, 
    3.24219, 2.20312, 1.92188, 2.57812, 2.74219, 3.47656, 2.46094, 3.14844, 
    3.6875, 2.90625, 2.33203, 3.09766, 3.26172, 3.77344, 3.0625, 3.66016, 
    4.15234, 3.44336, 2.85156, 3.61719, 3.67969, 4.24609, 3.61914, 4.17969, 
  },
  { /* 26 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.6875, 1, 1, 1, 1, 
    0.5, 0, 0, 0.6875, 1, 1, 1, 1, 
    1.51562, 1.8125, 0, 0.6875, 1, 1, 1.85938, 1.5625, 
    1.51562, 2.10156, 1.82812, 0.6875, 1.27344, 1.4375, 1.85938, 2.44531, 
    1.78125, 2.45703, 3.23828, 0.6875, 1.62891, 2.14453, 2.01172, 2.64844, 
    2.47266, 2.82617, 3.61328, 1.54883, 1.98242, 2.85156, 2.18945, 3.09375, 
    2.95703, 3.35645, 3.96777, 2.34277, 2.4248, 3.25879, 2.66602, 3.53613, 
    3.4873, 3.85547, 4.39697, 3.00488, 2.83887, 3.68506, 3.24023, 3.98145, 
  },
  { /* 27 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.5, 1, 1, 
    1, 1, 0.125, 0, 0, 0.53125, 1, 1, 
    1, 1, 1.89062, 1.59375, 0, 0.53125, 1, 1, 
    1.57812, 1.26562, 1.89844, 2.21094, 1.89844, 0.53125, 1, 1.84375, 
    1.58203, 2.10547, 1.95312, 2.58203, 3.37109, 0.734375, 1.42188, 1.85156, 
    2.16016, 2.78711, 2.16602, 3.00195, 3.58398, 1.89062, 1.94531, 2.06445, 
    2.58105, 3.52246, 2.48242, 3.42676, 4.00195, 2.62598, 2.43262, 2.52441, 
    3.05469, 3.90674, 3.09766, 3.90088, 4.47559, 3.2085, 2.84961, 3.10254, 
  },
  { /* 28 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 0, 0, 0, 0, 
    1, 1, 1, 1, 2, 2, 0, 0, 
    1, 1, 2, 1, 2, 2, 3, 0, 
    1, 1.5, 2, 2, 2, 2.5, 3, 2, 
    1.25, 2, 2.25, 2.75, 2.25, 3, 3.25, 3.25, 
    1.625, 2.5, 2.625, 3.375, 2.625, 3.5, 3.625, 4.125, 
    2.0625, 3, 3.0625, 3.9375, 3.0625, 4, 4.0625, 4.8125, 
  },
  { /* 29 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.46875, 1, 1, 1, 1, 0.28125, 0, 
    0, 0.484375, 1, 1, 1, 1, 1.71875, 2, 
    0.65625, 0.484375, 1, 1.10156, 2, 1.08594, 1.72656, 2, 
    2.4375, 0.484375, 1.29297, 1.40625, 2, 2.27344, 1.72656, 2.53516, 
    2.78125, 1.35938, 1.5918, 2, 2.29688, 3.16602, 1.85742, 2.70312, 
    3.22754, 2.25, 1.88965, 2.59473, 2.74316, 3.40918, 2.50684, 3.14844, 
    3.67383, 2.9209, 2.3335, 3.11523, 3.23438, 3.73633, 3.10107, 3.66895, 
  },
  { /* 30 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.6875, 1, 1, 1, 1, 
    0.484375, 0, 0, 0.6875, 1, 1, 1, 1, 
    1.51562, 1.79688, 0, 0.6875, 1, 1, 1.85938, 1.55469, 
    1.51562, 2.10156, 1.81641, 0.6875, 1.27344, 1.43359, 1.85938, 2.44531, 
    1.77734, 2.45508, 3.23047, 0.6875, 1.62695, 2.14062, 2.01172, 2.64648, 
    2.46973, 2.82324, 3.6123, 1.54297, 1.98047, 2.84766, 2.18848, 3.0918, 
    2.9541, 3.35352, 3.96582, 2.33838, 2.42236, 3.25732, 2.6626, 3.53369, 
  },
  { /* 31 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.53125, 1, 1, 
    1, 1, 0.09375, 0, 0, 0.546875, 1, 1, 
    1, 1, 1.90625, 1.54688, 0, 0.546875, 1, 1, 
    1.58984, 1.25, 1.91016, 2.22656, 1.83984, 0.546875, 1, 1.83984, 
    1.5918, 2.08984, 1.97852, 2.58008, 3.38672, 0.679688, 1.41992, 1.88867, 
    2.15918, 2.75977, 2.18945, 3, 3.59766, 1.85547, 1.9248, 2.09961, 
    2.57959, 3.49512, 2.50488, 3.43848, 4, 2.59131, 2.46582, 2.50439, 
  },
  { /* 32 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 0, 0, 0, 0, 
    1, 1, 1, 1, 2, 2, 0, 0, 
    1, 1, 2, 1, 2, 2, 3, 0, 
    1, 1.5, 2, 2, 2, 2.5, 3, 2, 
    1.25, 2, 2.25, 2.75, 2.25, 3, 3.25, 3.25, 
    1.625, 2.5, 2.625, 3.375, 2.625, 3.5, 3.625, 4.125, 
  },
  { /* 33 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.484375, 1, 1, 1, 1, 0.28125, 0, 
    0, 0.484375, 1, 1, 1, 1, 1.72656, 2, 
    0.65625, 0.484375, 1, 1.10547, 2, 1.08594, 1.72656, 2, 
    2.43945, 0.484375, 1.29492, 1.40625, 2, 2.27539, 1.72656, 2.53711, 
    2.78223, 1.35938, 1.59277, 2.00098, 2.29785, 3.16699, 1.8584, 2.70312, 
    3.22852, 2.25098, 1.89014, 2.5957, 2.74414, 3.41016, 2.50732, 3.14941, 
  },
  { /* 34 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.6875, 1, 1, 1, 1, 
    0.484375, 0, 0, 0.6875, 1, 1, 1, 1, 
    1.51562, 1.79688, 0, 0.6875, 1, 1, 1.85938, 1.55469, 
    1.51562, 2.10156, 1.81641, 0.6875, 1.27344, 1.43359, 1.85938, 2.44531, 
    1.77734, 2.45508, 3.23047, 0.6875, 1.62695, 2.14062, 2.01172, 2.64648, 
    2.46973, 2.82324, 3.6123, 1.54297, 1.98047, 2.84766, 2.18848, 3.0918, 
  },
  { /* 35 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.546875, 1, 1, 
    1, 1, 0.09375, 0, 0, 0.546875, 1, 1, 
    1, 1, 1.91016, 1.54688, 0, 0.546875, 1, 1, 
    1.5918, 1.25, 1.91016, 2.22852, 1.83984, 0.546875, 1, 1.8418, 
    1.5918, 2.09082, 1.97949, 2.58008, 3.3877, 0.679688, 1.4209, 1.88965, 
    2.15967, 2.76025, 2.18994, 3.00049, 3.59814, 1.85645, 1.92529, 2.1001, 
  },
  { /* 36 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 0, 0, 0, 0, 
    1, 1, 1, 1, 2, 2, 0, 0, 
    1, 1, 2, 1, 2, 2, 3, 0, 
    1, 1.5, 2, 2, 2, 2.5, 3, 2, 
    1.25, 2, 2.25, 2.75, 2.25, 3, 3.25, 3.25, 
  },
  { /* 37 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.484375, 1, 1, 1, 1, 0.273438, 0, 
    0, 0.488281, 1, 1, 1, 1, 1.73047, 2, 
    0.648438, 0.488281, 1, 1.10938, 2, 1.08008, 1.73242, 2, 
    2.43066, 0.488281, 1.29883, 1.40625, 2, 2.26855, 1.73242, 2.54297, 
    2.78564, 1.34766, 1.59668, 2.00049, 2.29736, 3.16016, 1.87012, 2.70312, 
  },
  { /* 38 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.6875, 1, 1, 1, 1, 
    0.484375, 0, 0, 0.6875, 1, 1, 1, 1, 
    1.51562, 1.79688, 0, 0.6875, 1, 1, 1.85938, 1.55469, 
    1.51562, 2.10156, 1.81641, 0.6875, 1.27344, 1.43359, 1.85938, 2.44531, 
    1.77734, 2.45508, 3.23047, 0.6875, 1.62695, 2.14062, 2.01172, 2.64648, 
  },
  { /* 39 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.546875, 1, 1, 
    1, 1, 0.0898438, 0, 0, 0.546875, 1, 1, 
    1, 1, 1.91016, 1.54297, 0, 0.546875, 1, 1, 
    1.5918, 1.24902, 1.91016, 2.22852, 1.83691, 0.546875, 1, 1.84082, 
    1.5918, 2.08984, 1.97949, 2.57959, 3.3877, 0.677734, 1.42041, 1.88965, 
  },
  { /* 40 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 0, 0, 0, 0, 
    1, 1, 1, 1, 2, 2, 0, 0, 
    1, 1, 2, 1, 2, 2, 3, 0, 
    1, 1.5, 2, 2, 2, 2.5, 3, 2, 
  },
  { /* 41 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.484375, 1, 1, 1, 1, 0.273438, 0, 
    0, 0.486328, 1, 1, 1, 1, 1.72852, 2, 
    0.650391, 0.486328, 1, 1.10742, 2, 1.08203, 1.72949, 2, 
    2.43359, 0.486328, 1.29688, 1.40576, 2, 2.271, 1.72949, 2.54004, 
  },
  { /* 42 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.683594, 1, 1, 1, 1, 
    0.486328, 0, 0, 0.685547, 1, 1, 1, 1, 
    1.51367, 1.80078, 0, 0.685547, 1, 1, 1.85645, 1.55762, 
    1.51416, 2.09961, 1.82227, 0.685547, 1.271, 1.43604, 1.85693, 2.44238, 
  },
  { /* 43 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.542969, 1, 1, 
    1, 1, 0.0917969, 0, 0, 0.544922, 1, 1, 
    1, 1, 1.9082, 1.54688, 0, 0.544922, 1, 1, 
    1.59033, 1.25049, 1.90869, 2.22656, 1.84277, 0.544922, 1, 1.84082, 
  },
  { /* 44 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 0, 0, 0, 0, 
    1, 1, 1, 1, 2, 2, 0, 0, 
    1, 1, 2, 1, 2, 2, 3, 0, 
  },
  { /* 45 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.486328, 1, 1, 1, 1, 0.271484, 0, 
    0, 0.486328, 1, 1, 1, 1, 1.72949, 2, 
    0.649414, 0.486328, 1, 1.10791, 2, 1.08154, 1.72949, 2, 
  },
  { /* 46 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.685547, 1, 1, 1, 1, 
    0.485352, 0, 0, 0.686523, 1, 1, 1, 1, 
    1.51465, 1.79883, 0, 0.686523, 1, 1, 1.85791, 1.55615, 
  },
  { /* 47 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.544922, 1, 1, 
    1, 1, 0.0908203, 0, 0, 0.545898, 1, 1, 
    1, 1, 1.90918, 1.54492, 0, 0.545898, 1, 1, 
  },
  { /* 48 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 0, 0, 0, 0, 
    1, 1, 1, 1, 2, 2, 0, 0, 
  },
  { /* 49 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.486328, 1, 1, 1, 1, 0.270508, 0, 
    0, 0.486328, 1, 1, 1, 1, 1.72949, 2, 
  },
  { /* 50 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.686523, 1, 1, 1, 1, 
    0.485352, 0, 0, 0.686523, 1, 1, 1, 1, 
  },
  { /* 51 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.545898, 1, 1, 
    1, 1, 0.0908203, 0, 0, 0.545898, 1, 1, 
  },
  { /* 52 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 0, 0, 0, 0, 
  },
  { /* 53 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.486328, 1, 1, 1, 1, 0.270508, 0, 
  },
  { /* 54 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.686035, 1, 1, 1, 1, 
  },
  { /* 55 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.54541, 1, 1, 
  },
  { /* 56 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
  },
  { /* 57 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
  },
  { /* 58 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
  },
  { /* 59 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
  },
};

const double schro_table_zerobits_hist_shift3_1_2[60][104] = {
  { /* 0 */
    0, 1, 0, 2, 1, 1, 0, 3, 
    2, 2, 1, 2, 1, 1, 0, 4, 
    3, 2.5, 2, 2, 2, 1.5, 1, 2.5, 
    3.75, 3, 2.75, 2.25, 2.75, 2, 1.75, 2, 
    4.375, 3.5, 3.375, 2.625, 3.375, 2.5, 2.375, 2, 
    4.9375, 4, 3.9375, 3.0625, 3.9375, 3, 2.9375, 2.25, 
    5.46875, 4.5, 4.46875, 3.53125, 4.46875, 3.5, 3.46875, 2.625, 
    5.98438, 5, 4.98438, 4.01562, 4.98438, 4, 3.98438, 3.0625, 
    6.49219, 5.5, 5.49219, 4.50781, 5.49219, 4.5, 4.49219, 3.53125, 
    6.99609, 6, 5.99609, 5.00391, 5.99609, 5, 4.99609, 4.01562, 
    7.49805, 6.5, 6.49805, 5.50195, 6.49805, 5.5, 5.49805, 4.50781, 
    7.99902, 7, 6.99902, 6.00098, 6.99902, 6, 5.99902, 5.00391, 
    8.49951, 7.5, 7.49951, 6.50049, 7.49951, 6.5, 6.49951, 5.50195, 
  },
  { /* 1 */
    0, 0, 1, 0, 2, 1, 1, 1, 
    0, 3, 2, 2, 2, 1, 2, 1, 
    1, 2, 3, 2.5, 2.5, 2, 2, 2, 
    1.5, 1.75, 3.75, 3.25, 3, 2.5, 2.25, 2.75, 
    2.125, 1.75, 4.5, 3.75, 3.5, 3.125, 2.5, 3.5, 
    2.625, 2, 5.125, 4.3125, 4, 3.625, 2.875, 4.125, 
    3.15625, 2.34375, 5.71875, 4.8125, 4.5, 4.15625, 3.28125, 4.71875, 
    3.65625, 2.76562, 6.26562, 5.32812, 5, 4.65625, 3.73438, 5.26562, 
    4.16406, 3.21875, 6.79688, 5.82812, 5.5, 5.16406, 4.20312, 5.79688, 
    4.66406, 3.69531, 7.3125, 6.33203, 6, 5.66406, 4.6875, 6.3125, 
    5.16602, 4.18164, 7.82227, 6.83203, 6.5, 6.16602, 5.17773, 6.82227, 
    5.66602, 4.6748, 8.32715, 7.33301, 7, 6.66602, 5.67285, 7.32715, 
    6.1665, 5.1709, 8.83008, 7.83301, 7.5, 7.1665, 6.16992, 7.83008, 
  },
  { /* 2 */
    0, 0, 1, 0, 0, 2, 1, 1, 
    1, 0, 0, 3, 2, 2, 2, 1, 
    1.5, 1, 0.5, 2, 3, 2.5, 2.5, 2, 
    1.75, 1.75, 1.25, 1.5, 3.75, 3.25, 2.75, 2.75, 
    2.125, 2.5, 1.75, 1.5, 4.5, 3.75, 3.125, 3.5, 
    2.5, 3.125, 2.3125, 1.6875, 5.125, 4.3125, 3.5, 4.125, 
    2.9375, 3.71875, 2.8125, 2.03125, 5.71875, 4.8125, 3.9375, 4.71875, 
    3.39062, 4.26562, 3.32812, 2.4375, 6.26562, 5.32812, 4.39062, 5.26562, 
    3.86719, 4.79688, 3.82812, 2.89062, 6.79688, 5.82812, 4.86719, 5.79688, 
    4.35156, 5.3125, 4.33203, 3.36328, 7.3125, 6.33203, 5.35156, 6.3125, 
    4.84375, 5.82227, 4.83203, 3.84961, 7.82227, 6.83203, 5.84375, 6.82227, 
    5.33887, 6.32715, 5.33301, 4.3418, 8.32715, 7.33301, 6.33887, 7.32715, 
    5.83643, 6.83008, 5.83301, 4.83789, 8.83008, 7.83301, 6.83643, 7.83008, 
  },
  { /* 3 */
    0, 0, 1, 1, 0, 0, 2, 1, 
    1, 1, 1, 0, 0, 3, 2, 2, 
    2, 1, 1.5, 1, 0.5, 2, 3, 3, 
    2.25, 1.75, 2, 1.5, 1.25, 1.5, 4, 3.25, 
    2.875, 2.375, 2.5, 2, 1.75, 1.5, 4.625, 3.875, 
    3.4375, 2.875, 2.9375, 2.625, 2.25, 1.6875, 5.25, 4.4375, 
    3.90625, 3.4375, 3.40625, 3.15625, 2.78125, 2, 5.84375, 4.90625, 
    4.42188, 3.96875, 3.89062, 3.67188, 3.28125, 2.40625, 6.375, 5.42188, 
    4.92969, 4.47656, 4.375, 4.19531, 3.78125, 2.85156, 6.89844, 5.92969, 
    5.42578, 4.98828, 4.86719, 4.70312, 4.28516, 3.32031, 7.41406, 6.42578, 
    5.92773, 5.49414, 5.36328, 5.20703, 4.78516, 3.80469, 7.91992, 6.92773, 
    6.42871, 5.99609, 5.86035, 5.71094, 5.28516, 4.2959, 8.42383, 7.42871, 
    6.92822, 6.49805, 6.35889, 6.2124, 5.78564, 4.79102, 8.92627, 7.92822, 
  },
  { /* 4 */
    0, 0, 1, 1, 0, 0, 2, 2, 
    1, 1, 1, 1, 0, 0, 3, 3, 
    2, 2, 1, 2, 1, 1, 0, 4, 
    3, 2.5, 2, 2, 2, 1.5, 1, 2.5, 
    3.75, 3, 2.75, 2.25, 2.75, 2, 1.75, 2, 
    4.375, 3.5, 3.375, 2.625, 3.375, 2.5, 2.375, 2, 
    4.9375, 4, 3.9375, 3.0625, 3.9375, 3, 2.9375, 2.25, 
    5.46875, 4.5, 4.46875, 3.53125, 4.46875, 3.5, 3.46875, 2.625, 
    5.98438, 5, 4.98438, 4.01562, 4.98438, 4, 3.98438, 3.0625, 
    6.49219, 5.5, 5.49219, 4.50781, 5.49219, 4.5, 4.49219, 3.53125, 
    6.99609, 6, 5.99609, 5.00391, 5.99609, 5, 4.99609, 4.01562, 
    7.49805, 6.5, 6.49805, 5.50195, 6.49805, 5.5, 5.49805, 4.50781, 
    7.99902, 7, 6.99902, 6.00098, 6.99902, 6, 5.99902, 5.00391, 
  },
  { /* 5 */
    0, 0, 0, 1, 1, 0, 0, 0, 
    2, 2, 1, 1, 1, 1, 1, 0, 
    0, 3, 2, 2, 1.5, 1, 2, 1, 
    0.75, 2, 3, 2.25, 2.5, 1.75, 2, 2, 
    1.375, 1.625, 3.625, 3.125, 3, 2.375, 2.125, 2.625, 
    2.0625, 1.625, 4.375, 3.6875, 3.375, 3.0625, 2.375, 3.375, 
    2.53125, 1.90625, 5.03125, 4.21875, 3.875, 3.53125, 2.78125, 4.03125, 
    3.04688, 2.25, 5.625, 4.70312, 4.40625, 4.04688, 3.1875, 4.625, 
    3.55469, 2.66406, 6.16406, 5.22656, 4.90625, 4.55469, 3.63281, 5.16406, 
    4.06641, 3.11719, 6.69531, 5.73047, 5.39844, 5.06641, 4.10156, 5.69531, 
    4.56445, 3.5957, 7.21289, 6.23242, 5.89844, 5.56445, 4.58789, 6.21289, 
    5.06543, 4.08203, 7.72266, 6.73145, 6.40039, 6.06543, 5.07812, 6.72266, 
    5.56592, 4.57471, 8.22705, 7.23291, 6.90039, 6.56592, 5.57275, 7.22705, 
  },
  { /* 6 */
    0, 0, 0, 1, 1, 1, 0, 0, 
    0, 2, 2, 1, 1, 1, 1, 1, 
    0.5, 0, 3, 2, 2, 2, 1, 1.5, 
    1.25, 0.75, 2, 3, 2.5, 2.5, 2, 1.25, 
    2.25, 1.25, 1.625, 3.75, 3.25, 2.875, 2.625, 2, 
    2.625, 1.9375, 1.5625, 4.5, 3.75, 3.375, 3.0625, 2.75, 
    3.0625, 2.46875, 1.8125, 5.125, 4.21875, 3.90625, 3.6875, 3.28125, 
    3.51562, 2.98438, 2.17188, 5.67188, 4.79688, 4.375, 4.23438, 3.76562, 
    4, 3.5, 2.59375, 6.23438, 5.30469, 4.85156, 4.77344, 4.25, 
    4.49609, 4, 3.05469, 6.76953, 5.8125, 5.32812, 5.29297, 4.75, 
    4.99219, 4.50391, 3.53125, 7.29102, 6.31055, 5.82812, 5.79492, 5.24805, 
    5.48926, 5.00684, 4.01953, 7.80078, 6.81152, 6.32812, 6.2959, 5.74805, 
    5.98926, 5.50537, 4.51416, 8.30615, 7.31201, 6.82861, 6.79541, 6.24805, 
  },
  { /* 7 */
    0, 0, 0, 0, 1, 1, 1, 0, 
    0, 0, 2, 2, 2, 1, 1, 1, 
    1, 1, 0, 1.5, 3, 2, 2, 2, 
    1.25, 1.75, 1, 0.5, 3, 3, 2.75, 2.5, 
    2.125, 2, 1.625, 1.375, 2.125, 3.875, 3.375, 2.75, 
    2.875, 2.4375, 2.375, 1.8125, 1.9375, 4.625, 4, 3.125, 
    3.46875, 2.90625, 2.96875, 2.40625, 1.96875, 5.3125, 4.5, 3.78125, 
    3.92188, 3.39062, 3.51562, 2.9375, 2.23438, 5.90625, 4.98438, 4.375, 
    4.40625, 3.89062, 4.03125, 3.45312, 2.60938, 6.44531, 5.5, 4.9375, 
    4.88672, 4.38672, 4.54297, 3.96094, 3.04297, 6.97266, 6.02734, 5.44141, 
    5.38086, 4.87891, 5.05273, 4.46484, 3.50781, 7.5, 6.52734, 5.94531, 
    5.87695, 5.37695, 5.55762, 4.96582, 3.98926, 8.01367, 7.03125, 6.44434, 
    6.37402, 5.87988, 6.05664, 5.46729, 4.479, 8.52246, 7.53125, 6.94434, 
  },
  { /* 8 */
    0, 0, 0, 0, 1, 1, 1, 1, 
    0, 0, 0, 0, 2, 2, 2, 2, 
    1, 1, 1, 1, 0, 0, 3, 3, 
    2, 2, 1, 2, 1, 1, 0, 4, 
    3, 2.5, 2, 2, 2, 1.5, 1, 2.5, 
    3.75, 3, 2.75, 2.25, 2.75, 2, 1.75, 2, 
    4.375, 3.5, 3.375, 2.625, 3.375, 2.5, 2.375, 2, 
    4.9375, 4, 3.9375, 3.0625, 3.9375, 3, 2.9375, 2.25, 
    5.46875, 4.5, 4.46875, 3.53125, 4.46875, 3.5, 3.46875, 2.625, 
    5.98438, 5, 4.98438, 4.01562, 4.98438, 4, 3.98438, 3.0625, 
    6.49219, 5.5, 5.49219, 4.50781, 5.49219, 4.5, 4.49219, 3.53125, 
    6.99609, 6, 5.99609, 5.00391, 5.99609, 5, 4.99609, 4.01562, 
    7.49805, 6.5, 6.49805, 5.50195, 6.49805, 5.5, 5.49805, 4.50781, 
  },
  { /* 9 */
    0, 0, 0, 0, 0, 1, 1, 1, 
    1, 1, 0, 0, 0, 0, 0, 2, 
    2, 1.5, 1, 1, 1, 1, 0.5, 0, 
    1.5, 2.5, 2, 2, 1, 1.75, 1.25, 1, 
    0.375, 3.5, 2.75, 2.5, 2, 1.625, 2.25, 1.5, 
    1.1875, 3.25, 3.375, 2.9375, 2.6875, 1.75, 3.125, 2.25, 
    1.71875, 3.3125, 4.0625, 3.34375, 3.21875, 2.53125, 3.4375, 2.8125, 
    2.26562, 3.59375, 4.60938, 3.84375, 3.6875, 3.20312, 3.875, 3.28125, 
    2.80469, 4.02344, 5.09375, 4.32812, 4.28906, 3.69531, 4.32031, 3.76562, 
    3.33594, 4.48047, 5.58984, 4.82422, 4.83594, 4.19141, 4.79297, 4.30859, 
    3.83008, 4.96289, 6.08203, 5.33008, 5.35156, 4.68945, 5.27734, 4.83008, 
    4.3252, 5.45508, 6.57715, 5.83398, 5.86035, 5.19043, 5.76855, 5.34082, 
    4.82227, 5.9502, 7.07617, 6.3374, 6.36328, 5.68945, 6.26416, 5.84717, 
  },
  { /* 10 */
    0, 0, 0, 0, 0, 0, 1, 1, 
    1, 1, 1, 1, 0, 0, 0, 0, 
    0, 2, 2, 1.5, 1, 1, 1, 1, 
    0.75, 0, 2.25, 2.5, 2, 2, 1.5, 1, 
    1.625, 1, 0.625, 3.5, 3, 2.25, 2.375, 1.875, 
    2, 1.625, 0.875, 3.5625, 3.5625, 2.6875, 3.25, 2.4375, 
    2.5, 2.0625, 1.65625, 3.46875, 4.125, 3.46875, 3.5625, 3.0625, 
    2.95312, 2.53125, 2.34375, 3.71875, 4.59375, 4.09375, 3.96875, 3.67188, 
    3.41406, 3.08594, 2.875, 4.07031, 5.10156, 4.63281, 4.51562, 4.13281, 
    3.90234, 3.64844, 3.36328, 4.51172, 5.57812, 5.14844, 5.04297, 4.61719, 
    4.39844, 4.17969, 3.85156, 4.98633, 6.07422, 5.66602, 5.53516, 5.11328, 
    4.89551, 4.69727, 4.34375, 5.47559, 6.56934, 6.18555, 6.02051, 5.61426, 
    5.39551, 5.20508, 4.84375, 5.96631, 7.06885, 6.69287, 6.51709, 6.10986, 
  },
  { /* 11 */
    0, 0, 0, 0, 0, 0, 0, 1, 
    1, 1, 1, 1, 1, 1, 0, 0, 
    0, 0, 1, 2, 2, 1.5, 1, 1, 
    1, 1, 0.25, 0, 3, 2.5, 2, 2, 
    1.5, 1.625, 1.125, 0.875, 1, 3.5, 3, 2.25, 
    2.375, 1.8125, 2.125, 1.375, 0.6875, 3.875, 3.5625, 3.1875, 
    2.84375, 2.09375, 2.875, 1.96875, 1.4375, 3.65625, 3.96875, 3.96875, 
    3.40625, 2.5, 3.42188, 2.54688, 2, 3.84375, 4.625, 4.35938, 
    3.95312, 3.09375, 3.80469, 3.07031, 2.57812, 4.17188, 5.1875, 4.78906, 
    4.5, 3.61719, 4.25781, 3.56641, 3.14844, 4.55859, 5.73047, 5.26953, 
    5.01367, 4.13672, 4.72852, 4.08984, 3.66211, 5.00977, 6.24219, 5.79102, 
    5.50684, 4.64746, 5.20996, 4.60059, 4.16699, 5.48633, 6.74707, 6.30176, 
    6.00439, 5.1543, 5.7002, 5.10547, 4.66895, 5.97363, 7.24902, 6.81055, 
  },
  { /* 12 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 1, 1, 1, 1, 
    0, 0, 0, 0, 2, 2, 2, 2, 
    1, 1, 1, 1, 0, 0, 3, 3, 
    2, 2, 1, 2, 1, 1, 0, 4, 
    3, 2.5, 2, 2, 2, 1.5, 1, 2.5, 
    3.75, 3, 2.75, 2.25, 2.75, 2, 1.75, 2, 
    4.375, 3.5, 3.375, 2.625, 3.375, 2.5, 2.375, 2, 
    4.9375, 4, 3.9375, 3.0625, 3.9375, 3, 2.9375, 2.25, 
    5.46875, 4.5, 4.46875, 3.53125, 4.46875, 3.5, 3.46875, 2.625, 
    5.98438, 5, 4.98438, 4.01562, 4.98438, 4, 3.98438, 3.0625, 
    6.49219, 5.5, 5.49219, 4.50781, 5.49219, 4.5, 4.49219, 3.53125, 
    6.99609, 6, 5.99609, 5.00391, 5.99609, 5, 4.99609, 4.01562, 
  },
  { /* 13 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 1, 1, 1, 1, 1, 1, 
    1, 0.5, 0, 0, 0, 0, 1, 2, 
    2, 1.5, 1, 1, 1, 1, 0.25, 0, 
    1.875, 2.5, 2, 1.875, 1, 1.875, 1.25, 1, 
    0.5625, 3.5, 2.6875, 2.5625, 2, 1.6875, 2.25, 1.4375, 
    1.1875, 3.40625, 3.375, 2.96875, 2.6875, 1.8125, 3.09375, 2.28125, 
    1.73438, 3.39062, 4.0625, 3.39062, 3.23438, 2.51562, 3.5, 2.82812, 
    2.28906, 3.63281, 4.64062, 3.875, 3.71094, 3.21094, 3.90625, 3.3125, 
    2.82422, 4.0625, 5.12109, 4.35547, 4.30078, 3.72656, 4.35156, 3.79297, 
    3.35938, 4.50977, 5.61914, 4.84766, 4.85938, 4.2168, 4.82422, 4.32812, 
    3.85742, 4.99219, 6.10938, 5.35547, 5.37598, 4.71582, 5.30566, 4.85352, 
    4.35205, 5.48242, 6.604, 5.85938, 5.88574, 5.2168, 5.79639, 5.36572, 
  },
  { /* 14 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 1, 1, 1, 1, 
    1, 1, 1, 0.5, 0, 0, 0, 0, 
    1, 2, 2, 1.25, 1, 1, 1, 1, 
    0.5, 0.375, 3, 2.25, 2, 2, 1.125, 1.5, 
    1.4375, 0.875, 1.75, 3.25, 2.6875, 2.625, 2.0625, 1.5, 
    2.25, 1.5, 1.03125, 4.21875, 3.34375, 2.9375, 2.84375, 2.34375, 
    2.5625, 2.14062, 1.28125, 4.5625, 4, 3.23438, 3.65625, 2.82812, 
    3.05469, 2.67969, 1.92188, 4.69531, 4.5625, 3.61719, 4.33594, 3.4375, 
    3.52734, 3.15625, 2.51172, 5.00781, 5.07812, 4.14453, 4.88281, 3.95312, 
    4.02344, 3.62891, 3.07031, 5.41602, 5.57422, 4.72461, 5.34375, 4.46094, 
    4.51855, 4.13867, 3.58203, 5.86719, 6.06934, 5.27051, 5.83008, 4.95605, 
    5.02002, 4.64258, 4.08545, 6.34277, 6.57617, 5.78516, 6.32178, 5.4541, 
  },
  { /* 15 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 1, 1, 
    1, 1, 1, 1, 1, 0.5, 0, 0, 
    0, 0, 1.5, 2, 2, 1.5, 1, 1, 
    1, 1, 0.125, 0.375, 3, 2.5, 2, 2, 
    1.4375, 1.6875, 1.125, 0.8125, 1.25, 3.5, 3, 2.1875, 
    2.40625, 1.84375, 2.09375, 1.40625, 0.65625, 4.03125, 3.5625, 3.1875, 
    2.84375, 2.14062, 2.875, 1.98438, 1.4375, 3.71875, 4, 3.96875, 
    3.42188, 2.5, 3.46094, 2.5625, 2.00781, 3.89062, 4.625, 4.39062, 
    3.96484, 3.10938, 3.83203, 3.08594, 2.58594, 4.21094, 5.19922, 4.8125, 
    4.51562, 3.63281, 4.28125, 3.58398, 3.16211, 4.58398, 5.74805, 5.2832, 
    5.0332, 4.15332, 4.75, 4.10645, 3.67969, 5.0332, 6.25977, 5.80762, 
    5.52588, 4.66504, 5.22998, 4.61816, 4.18506, 5.50684, 6.76514, 6.31934, 
  },
  { /* 16 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 1, 1, 1, 1, 
    0, 0, 0, 0, 2, 2, 2, 2, 
    1, 1, 1, 1, 0, 0, 3, 3, 
    2, 2, 1, 2, 1, 1, 0, 4, 
    3, 2.5, 2, 2, 2, 1.5, 1, 2.5, 
    3.75, 3, 2.75, 2.25, 2.75, 2, 1.75, 2, 
    4.375, 3.5, 3.375, 2.625, 3.375, 2.5, 2.375, 2, 
    4.9375, 4, 3.9375, 3.0625, 3.9375, 3, 2.9375, 2.25, 
    5.46875, 4.5, 4.46875, 3.53125, 4.46875, 3.5, 3.46875, 2.625, 
    5.98438, 5, 4.98438, 4.01562, 4.98438, 4, 3.98438, 3.0625, 
    6.49219, 5.5, 5.49219, 4.50781, 5.49219, 4.5, 4.49219, 3.53125, 
  },
  { /* 17 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.5, 1, 1, 1, 1, 1, 1, 
    1, 0.5, 0, 0, 0, 0, 1.5, 2, 
    2, 1.5, 1, 1, 1, 1, 0.25, 0, 
    2.0625, 2.5, 2, 1.875, 1, 1.9375, 1.25, 1, 
    0.6875, 3.5, 2.6875, 2.59375, 2, 1.75, 2.25, 1.4375, 
    1.20312, 3.48438, 3.39062, 3, 2.70312, 1.85938, 3.09375, 2.29688, 
    1.75781, 3.44531, 4.07812, 3.42188, 3.25781, 2.52344, 3.53906, 2.85156, 
    2.3125, 3.66797, 4.66797, 3.90234, 3.73828, 3.22656, 3.9375, 3.33984, 
    2.84766, 4.09375, 5.14844, 4.38281, 4.32031, 3.75391, 4.38086, 3.82031, 
    3.38379, 4.53809, 5.64648, 4.87305, 4.88379, 4.24316, 4.85254, 4.35156, 
    3.88428, 5.01953, 6.13623, 5.38135, 5.40137, 4.74219, 5.33301, 4.87842, 
  },
  { /* 18 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.5, 1, 1, 1, 1, 
    1, 1, 1, 0.5, 0, 0, 0, 0, 
    0.75, 2, 2, 1.375, 1, 1, 1, 1, 
    0.5625, 0, 3, 2.375, 2, 2, 1.25, 1.3125, 
    1.53125, 0.96875, 1.25, 3.375, 2.8125, 2.46875, 2.21875, 1.65625, 
    2.15625, 1.59375, 0.671875, 4.21875, 3.4375, 2.76562, 3.15625, 2.34375, 
    2.52344, 2.16406, 1.48438, 4, 4.07812, 3.19531, 3.82812, 2.99219, 
    2.98828, 2.63281, 2.125, 4.12109, 4.69922, 3.85547, 4.21094, 3.54297, 
    3.47852, 3.12305, 2.67773, 4.54492, 5.16797, 4.41016, 4.67969, 4.05273, 
    3.98926, 3.61133, 3.18945, 5.0127, 5.6582, 4.95898, 5.13086, 4.56348, 
    4.49854, 4.10205, 3.72461, 5.46729, 6.15576, 5.48291, 5.61426, 5.05908, 
  },
  { /* 19 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.5, 1, 1, 
    1, 1, 1, 1, 1, 0.5, 0, 0, 
    0, 0, 1.75, 2, 2, 1.5, 1, 1, 
    1, 1, 0.125, 0.5625, 3, 2.5, 2, 2, 
    1.4375, 1.71875, 1.125, 0.8125, 1.375, 3.5, 3, 2.1875, 
    2.42188, 1.875, 2.09375, 1.42188, 0.65625, 4.10938, 3.57812, 3.1875, 
    2.85938, 2.17188, 2.88281, 2, 1.44531, 3.76562, 4.02344, 3.97656, 
    3.4375, 2.51172, 3.48828, 2.57812, 2.02344, 3.92188, 4.63672, 4.41406, 
    3.98047, 3.125, 3.85547, 3.10352, 2.59961, 4.23828, 5.21484, 4.83398, 
    4.53223, 3.65039, 4.30176, 3.60254, 3.17773, 4.60645, 5.76562, 5.2998, 
    5.05225, 4.1709, 4.77002, 4.12402, 3.69775, 5.05371, 6.27783, 5.8252, 
  },
  { /* 20 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 1, 1, 1, 1, 
    0, 0, 0, 0, 2, 2, 2, 2, 
    1, 1, 1, 1, 0, 0, 3, 3, 
    2, 2, 1, 2, 1, 1, 0, 4, 
    3, 2.5, 2, 2, 2, 1.5, 1, 2.5, 
    3.75, 3, 2.75, 2.25, 2.75, 2, 1.75, 2, 
    4.375, 3.5, 3.375, 2.625, 3.375, 2.5, 2.375, 2, 
    4.9375, 4, 3.9375, 3.0625, 3.9375, 3, 2.9375, 2.25, 
    5.46875, 4.5, 4.46875, 3.53125, 4.46875, 3.5, 3.46875, 2.625, 
    5.98438, 5, 4.98438, 4.01562, 4.98438, 4, 3.98438, 3.0625, 
  },
  { /* 21 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.5, 1, 1, 1, 1, 1, 1, 
    1, 0.5, 0, 0, 0, 0, 1.5, 2, 
    2, 1.5, 1, 1, 1, 1, 0.25, 0, 
    2.0625, 2.5, 2, 1.875, 1, 1.9375, 1.25, 1, 
    0.6875, 3.5, 2.6875, 2.59375, 2, 1.75, 2.25, 1.4375, 
    1.20312, 3.48438, 3.39062, 3, 2.70312, 1.85938, 3.09375, 2.29688, 
    1.75781, 3.44531, 4.07812, 3.42188, 3.25781, 2.52344, 3.53906, 2.85156, 
    2.3125, 3.66797, 4.66797, 3.90234, 3.73828, 3.22656, 3.9375, 3.33984, 
    2.84766, 4.09375, 5.14844, 4.38281, 4.32031, 3.75391, 4.38086, 3.82031, 
    3.38379, 4.53809, 5.64648, 4.87305, 4.88379, 4.24316, 4.85254, 4.35156, 
  },
  { /* 22 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.5, 1, 1, 1, 1, 
    1, 1, 1, 0.375, 0, 0, 0, 0, 
    1, 2, 2, 1.3125, 1, 1, 1, 1, 
    0.5, 0.28125, 3, 2.3125, 2, 2, 1.15625, 1.4375, 
    1.48438, 0.90625, 1.5625, 3.3125, 2.73438, 2.5625, 2.14062, 1.5625, 
    2.21875, 1.54688, 0.804688, 4.3125, 3.375, 2.85938, 2.99219, 2.35156, 
    2.53125, 2.17578, 1.39062, 4.31641, 4.01953, 3.15234, 3.8125, 2.91016, 
    3.04492, 2.64648, 2.03516, 4.43555, 4.57812, 3.74414, 4.33594, 3.4668, 
    3.51562, 3.14746, 2.60547, 4.72949, 5.16406, 4.31738, 4.7627, 4.02148, 
    3.98682, 3.66113, 3.1416, 5.11133, 5.72168, 4.85352, 5.21533, 4.55225, 
  },
  { /* 23 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.5, 1, 1, 
    1, 1, 1, 1, 1, 0.5, 0, 0, 
    0, 0, 1.75, 2, 2, 1.4375, 1, 1, 
    1, 1, 0.09375, 0.65625, 3, 2.4375, 2, 2, 
    1.40625, 1.75, 1.07812, 0.765625, 1.5625, 3.4375, 3, 2.15625, 
    2.39844, 1.91406, 2, 1.41406, 0.601562, 4.32031, 3.57812, 3.07812, 
    2.83594, 2.25391, 2.78516, 1.99609, 1.38672, 3.93359, 4.08594, 3.86328, 
    3.41602, 2.52148, 3.46875, 2.54492, 1.99609, 4.09766, 4.49805, 4.50586, 
    3.94336, 3.02441, 3.96875, 3.07129, 2.52344, 4.43359, 5.11328, 4.92969, 
    4.44922, 3.59863, 4.39258, 3.59863, 3.02441, 4.8833, 5.64062, 5.40527, 
  },
  { /* 24 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 1, 1, 1, 1, 
    0, 0, 0, 0, 2, 2, 2, 2, 
    1, 1, 1, 1, 0, 0, 3, 3, 
    2, 2, 1, 2, 1, 1, 0, 4, 
    3, 2.5, 2, 2, 2, 1.5, 1, 2.5, 
    3.75, 3, 2.75, 2.25, 2.75, 2, 1.75, 2, 
    4.375, 3.5, 3.375, 2.625, 3.375, 2.5, 2.375, 2, 
    4.9375, 4, 3.9375, 3.0625, 3.9375, 3, 2.9375, 2.25, 
    5.46875, 4.5, 4.46875, 3.53125, 4.46875, 3.5, 3.46875, 2.625, 
  },
  { /* 25 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.5, 1, 1, 1, 1, 1, 1, 
    1, 0.5, 0, 0, 0, 0, 1.5, 2, 
    2, 1.5, 1, 1, 1, 1, 0.25, 0, 
    2.0625, 2.5, 2, 1.875, 1, 1.9375, 1.25, 1, 
    0.6875, 3.5, 2.6875, 2.59375, 2, 1.75, 2.25, 1.4375, 
    1.20312, 3.48438, 3.39062, 3, 2.70312, 1.85938, 3.09375, 2.29688, 
    1.75781, 3.44531, 4.07812, 3.42188, 3.25781, 2.52344, 3.53906, 2.85156, 
    2.3125, 3.66797, 4.66797, 3.90234, 3.73828, 3.22656, 3.9375, 3.33984, 
    2.84766, 4.09375, 5.14844, 4.38281, 4.32031, 3.75391, 4.38086, 3.82031, 
  },
  { /* 26 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.625, 1, 1, 1, 1, 
    1, 1, 1, 0.3125, 0, 0, 0, 0, 
    1, 2, 2, 1.3125, 1, 1, 1, 1, 
    0.484375, 0.28125, 3, 2.3125, 2, 2, 1.14062, 1.4375, 
    1.48438, 0.898438, 1.5625, 3.3125, 2.72656, 2.5625, 2.14062, 1.55469, 
    2.21875, 1.54297, 0.800781, 4.3125, 3.37109, 2.85547, 2.98828, 2.35156, 
    2.52734, 2.17383, 1.38672, 4.31445, 4.01758, 3.14844, 3.81055, 2.90625, 
    3.04297, 2.64355, 2.03223, 4.43262, 4.5752, 3.74121, 4.33398, 3.46387, 
    3.5127, 3.14453, 2.60303, 4.72656, 5.16113, 4.31494, 4.75977, 4.01855, 
  },
  { /* 27 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.5, 1, 1, 
    1, 1, 1, 1, 1, 0.5, 0, 0, 
    0, 0, 1.75, 2, 2, 1.46875, 1, 1, 
    1, 1, 0.109375, 0.609375, 3, 2.46875, 2, 2, 
    1.42188, 1.73438, 1.10156, 0.789062, 1.46875, 3.46875, 3, 2.15625, 
    2.41797, 1.89453, 2.04688, 1.41797, 0.628906, 4.21484, 3.57812, 3.14844, 
    2.83984, 2.21289, 2.83398, 1.99805, 1.41602, 3.84961, 4.05469, 3.93555, 
    3.41895, 2.47754, 3.51758, 2.57324, 1.99805, 4.00977, 4.56738, 4.47559, 
    3.94531, 3.09326, 3.90234, 3.09912, 2.52441, 4.375, 5.15039, 4.89746, 
  },
  { /* 28 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 1, 1, 1, 1, 
    0, 0, 0, 0, 2, 2, 2, 2, 
    1, 1, 1, 1, 0, 0, 3, 3, 
    2, 2, 1, 2, 1, 1, 0, 4, 
    3, 2.5, 2, 2, 2, 1.5, 1, 2.5, 
    3.75, 3, 2.75, 2.25, 2.75, 2, 1.75, 2, 
    4.375, 3.5, 3.375, 2.625, 3.375, 2.5, 2.375, 2, 
    4.9375, 4, 3.9375, 3.0625, 3.9375, 3, 2.9375, 2.25, 
  },
  { /* 29 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.4375, 1, 1, 1, 1, 1, 1, 
    1, 0.53125, 0, 0, 0, 0, 1.4375, 2, 
    2, 1.51562, 1, 1, 1, 1, 0.28125, 0, 
    2.01562, 2.51562, 2, 1.89844, 1, 1.91406, 1.27344, 1, 
    0.640625, 3.51562, 2.70703, 2.59375, 2, 1.72656, 2.27344, 1.46484, 
    1.21875, 3.42188, 3.4082, 3, 2.70312, 1.83398, 3.14258, 2.29688, 
    1.77246, 3.38281, 4.11035, 3.40527, 3.25684, 2.59082, 3.49316, 2.85156, 
    2.32617, 3.6377, 4.6665, 3.88477, 3.76562, 3.26367, 3.89893, 3.33105, 
  },
  { /* 30 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.6875, 1, 1, 1, 1, 
    1, 1, 1, 0.3125, 0, 0, 0, 0, 
    1.03125, 2, 2, 1.3125, 1, 1, 1, 1, 
    0.484375, 0.304688, 3, 2.3125, 2, 2, 1.14062, 1.44531, 
    1.48438, 0.898438, 1.57812, 3.3125, 2.72656, 2.56641, 2.14062, 1.55469, 
    2.22266, 1.54492, 0.810547, 4.3125, 3.37305, 2.85938, 2.98828, 2.35352, 
    2.53027, 2.17676, 1.3877, 4.32129, 4.01953, 3.15234, 3.81152, 2.9082, 
    3.0459, 2.64648, 2.03418, 4.4375, 4.57764, 3.74268, 4.3374, 3.46631, 
  },
  { /* 31 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.5, 1, 1, 
    1, 1, 1, 1, 1, 0.46875, 0, 0, 
    0, 0, 1.8125, 2, 2, 1.45312, 1, 1, 
    1, 1, 0.09375, 0.679688, 3, 2.45312, 2, 2, 
    1.41016, 1.75, 1.08984, 0.773438, 1.54688, 3.45312, 3, 2.16016, 
    2.4082, 1.91016, 2.02148, 1.41992, 0.613281, 4.28711, 3.58008, 3.11133, 
    2.84082, 2.24023, 2.81055, 2, 1.40234, 3.90137, 4.0752, 3.90039, 
    3.42041, 2.50488, 3.49512, 2.56152, 2, 4.06055, 4.53418, 4.49561, 
  },
  { /* 32 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 1, 1, 1, 1, 
    0, 0, 0, 0, 2, 2, 2, 2, 
    1, 1, 1, 1, 0, 0, 3, 3, 
    2, 2, 1, 2, 1, 1, 0, 4, 
    3, 2.5, 2, 2, 2, 1.5, 1, 2.5, 
    3.75, 3, 2.75, 2.25, 2.75, 2, 1.75, 2, 
    4.375, 3.5, 3.375, 2.625, 3.375, 2.5, 2.375, 2, 
  },
  { /* 33 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.46875, 1, 1, 1, 1, 1, 1, 
    1, 0.515625, 0, 0, 0, 0, 1.4375, 2, 
    2, 1.51562, 1, 1, 1, 1, 0.273438, 0, 
    2.01562, 2.51562, 2, 1.89453, 1, 1.91406, 1.27344, 1, 
    0.638672, 3.51562, 2.70508, 2.59375, 2, 1.72461, 2.27344, 1.46289, 
    1.21777, 3.42188, 3.40723, 2.99902, 2.70215, 1.83301, 3.1416, 2.29688, 
    1.77148, 3.38184, 4.10986, 3.4043, 3.25586, 2.58984, 3.49268, 2.85059, 
  },
  { /* 34 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.6875, 1, 1, 1, 1, 
    1, 1, 1, 0.3125, 0, 0, 0, 0, 
    1.03125, 2, 2, 1.3125, 1, 1, 1, 1, 
    0.484375, 0.304688, 3, 2.3125, 2, 2, 1.14062, 1.44531, 
    1.48438, 0.898438, 1.57812, 3.3125, 2.72656, 2.56641, 2.14062, 1.55469, 
    2.22266, 1.54492, 0.810547, 4.3125, 3.37305, 2.85938, 2.98828, 2.35352, 
    2.53027, 2.17676, 1.3877, 4.32129, 4.01953, 3.15234, 3.81152, 2.9082, 
  },
  { /* 35 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.53125, 1, 1, 
    1, 1, 1, 1, 1, 0.453125, 0, 0, 
    0, 0, 1.8125, 2, 2, 1.45312, 1, 1, 
    1, 1, 0.0898438, 0.679688, 3, 2.45312, 2, 2, 
    1.4082, 1.75, 1.08984, 0.771484, 1.54688, 3.45312, 3, 2.1582, 
    2.4082, 1.90918, 2.02051, 1.41992, 0.612305, 4.28711, 3.5791, 3.11035, 
    2.84033, 2.23975, 2.81006, 1.99951, 1.40186, 3.90039, 4.07471, 3.8999, 
  },
  { /* 36 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 1, 1, 1, 1, 
    0, 0, 0, 0, 2, 2, 2, 2, 
    1, 1, 1, 1, 0, 0, 3, 3, 
    2, 2, 1, 2, 1, 1, 0, 4, 
    3, 2.5, 2, 2, 2, 1.5, 1, 2.5, 
    3.75, 3, 2.75, 2.25, 2.75, 2, 1.75, 2, 
  },
  { /* 37 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.484375, 1, 1, 1, 1, 1, 1, 
    1, 0.515625, 0, 0, 0, 0, 1.45312, 2, 
    2, 1.51172, 1, 1, 1, 1, 0.269531, 0, 
    2.02734, 2.51172, 2, 1.89062, 1, 1.91992, 1.26758, 1, 
    0.651367, 3.51172, 2.70117, 2.59375, 2, 1.73145, 2.26758, 1.45703, 
    1.21436, 3.4375, 3.40332, 2.99951, 2.70264, 1.83984, 3.12988, 2.29688, 
  },
  { /* 38 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.6875, 1, 1, 1, 1, 
    1, 1, 1, 0.3125, 0, 0, 0, 0, 
    1.03125, 2, 2, 1.3125, 1, 1, 1, 1, 
    0.484375, 0.304688, 3, 2.3125, 2, 2, 1.14062, 1.44531, 
    1.48438, 0.898438, 1.57812, 3.3125, 2.72656, 2.56641, 2.14062, 1.55469, 
    2.22266, 1.54492, 0.810547, 4.3125, 3.37305, 2.85938, 2.98828, 2.35352, 
  },
  { /* 39 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.546875, 1, 1, 
    1, 1, 1, 1, 1, 0.453125, 0, 0, 
    0, 0, 1.82031, 2, 2, 1.45312, 1, 1, 
    1, 1, 0.0898438, 0.685547, 3, 2.45312, 2, 2, 
    1.4082, 1.75098, 1.08984, 0.771484, 1.55078, 3.45312, 3, 2.15918, 
    2.4082, 1.91016, 2.02051, 1.42041, 0.612305, 4.28955, 3.57959, 3.11035, 
  },
  { /* 40 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 1, 1, 1, 1, 
    0, 0, 0, 0, 2, 2, 2, 2, 
    1, 1, 1, 1, 0, 0, 3, 3, 
    2, 2, 1, 2, 1, 1, 0, 4, 
    3, 2.5, 2, 2, 2, 1.5, 1, 2.5, 
  },
  { /* 41 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.484375, 1, 1, 1, 1, 1, 1, 
    1, 0.515625, 0, 0, 0, 0, 1.45312, 2, 
    2, 1.51367, 1, 1, 1, 1, 0.271484, 0, 
    2.02441, 2.51367, 2, 1.89258, 1, 1.91797, 1.27051, 1, 
    0.646973, 3.51367, 2.70312, 2.59424, 2, 1.729, 2.27051, 1.45996, 
  },
  { /* 42 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.679688, 1, 1, 1, 1, 
    1, 1, 1, 0.316406, 0, 0, 0, 0, 
    1.02734, 2, 2, 1.31445, 1, 1, 1, 1, 
    0.486328, 0.298828, 3, 2.31445, 2, 2, 1.14355, 1.44238, 
    1.48584, 0.900391, 1.57031, 3.31445, 2.729, 2.56396, 2.14307, 1.55762, 
  },
  { /* 43 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.539062, 1, 1, 
    1, 1, 1, 1, 1, 0.457031, 0, 0, 
    0, 0, 1.81641, 2, 2, 1.45508, 1, 1, 
    1, 1, 0.0917969, 0.679688, 3, 2.45508, 2, 2, 
    1.40967, 1.74951, 1.09131, 0.773438, 1.54297, 3.45508, 3, 2.15918, 
  },
  { /* 44 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 1, 1, 1, 1, 
    0, 0, 0, 0, 2, 2, 2, 2, 
    1, 1, 1, 1, 0, 0, 3, 3, 
    2, 2, 1, 2, 1, 1, 0, 4, 
  },
  { /* 45 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.484375, 1, 1, 1, 1, 1, 1, 
    1, 0.513672, 0, 0, 0, 0, 1.45703, 2, 
    2, 1.51367, 1, 1, 1, 1, 0.270508, 0, 
    2.02588, 2.51367, 2, 1.89209, 1, 1.91846, 1.27051, 1, 
  },
  { /* 46 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.683594, 1, 1, 1, 1, 
    1, 1, 1, 0.314453, 0, 0, 0, 0, 
    1.0293, 2, 2, 1.31348, 1, 1, 1, 1, 
    0.485352, 0.301758, 3, 2.31348, 2, 2, 1.14209, 1.44385, 
  },
  { /* 47 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.542969, 1, 1, 
    1, 1, 1, 1, 1, 0.455078, 0, 0, 
    0, 0, 1.81836, 2, 2, 1.4541, 1, 1, 
    1, 1, 0.0908203, 0.682617, 3, 2.4541, 2, 2, 
  },
  { /* 48 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 1, 1, 1, 1, 
    0, 0, 0, 0, 2, 2, 2, 2, 
    1, 1, 1, 1, 0, 0, 3, 3, 
  },
  { /* 49 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.486328, 1, 1, 1, 1, 1, 1, 
    1, 0.513672, 0, 0, 0, 0, 1.45898, 2, 
    2, 1.51367, 1, 1, 1, 1, 0.270508, 0, 
  },
  { /* 50 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.685547, 1, 1, 1, 1, 
    1, 1, 1, 0.313477, 0, 0, 0, 0, 
    1.0293, 2, 2, 1.31348, 1, 1, 1, 1, 
  },
  { /* 51 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.544922, 1, 1, 
    1, 1, 1, 1, 1, 0.454102, 0, 0, 
    0, 0, 1.81836, 2, 2, 1.4541, 1, 1, 
  },
  { /* 52 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 1, 1, 1, 1, 
    0, 0, 0, 0, 2, 2, 2, 2, 
  },
  { /* 53 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.486328, 1, 1, 1, 1, 1, 1, 
    1, 0.513672, 0, 0, 0, 0, 1.45898, 2, 
  },
  { /* 54 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.685547, 1, 1, 1, 1, 
    1, 1, 1, 0.313965, 0, 0, 0, 0, 
  },
  { /* 55 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.544922, 1, 1, 
    1, 1, 1, 1, 1, 0.45459, 0, 0, 
  },
  { /* 56 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    1, 1, 1, 1, 1, 1, 1, 1, 
  },
  { /* 57 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0.486328, 1, 1, 1, 1, 1, 1, 
  },
  { /* 58 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.686035, 1, 1, 1, 1, 
  },
  { /* 59 */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0.54541, 1, 1, 
  },
};
#endif

