#! /usr/bin/env python
# Copyright (c) 2009 Daniel Graham <daniel.graham@duke.edu>. All rights
# reserved.
#
# License:
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 3 of the License, or (at your
# option) any later version. [http://www.gnu.org/licenses/gpl.html]
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details.

import sys

def main():
    from etm.data import main
    if len(sys.argv) >= 2 and sys.argv[1] == 'w':

        try:
            import wx
        except:
            print('Could not load wx module.')
            sys.exit()
        try:
            import wx.html
        except:
            print('Could not load wx.html module.')
            sys.exit()
        try:
            from wx.lib.expando import ExpandoTextCtrl, EVT_ETC_LAYOUT_NEEDED
        except:
            print('Could not import wx.lib.expando.')
            sys.exit()
        try:
            import wx.lib.colourdb
        except:
            print('Could not import wx.lib.colordb.')
            sys.exit()

        try:
            from etm.etm_wx import main
            main()
        except:
            print('Errors importing etm.etm_wx ')
            print(sys.exc_info())
    else:
        main()

if __name__ == "__main__":
    main()