#!/bin/sh

unset GRUBDFILES BOOTFILES GRUB2CONFF

if [ "x$PREFIX" = "x" ]; then
  PREFIX=/usr/local
fi

if [ "x$GRUBBOOT" = "x" ]; then
  GRUBBOOT=/boot/grub
fi

if [ "x$SOURCEDIR" = "x" ]; then
  SOURCEDIR="$PWD"
fi

if [ "x$ETCDIR" = "x" ]; then
  ETCDIR="$PREFIX/etc"
fi

if [ "x$DESTDIR" != "x" ]; then
  DESTDIR=$(readlink -f $DESTDIR)
fi

if [ "x$MANDIR" = "x" ]; then
  MANDIR="$PREFIX/man"
fi

if [ "$ZWTHEME" == "true" ]; then
  GRUBDFILES+=" 05_zenwalk_theme"
  BOOTFILES+=" zenwalk.png"
  cp "$SOURCEDIR/grub2config.in" "$SOURCEDIR/grub2config"
else
  sed -e "s#background_image /boot/grub/zenwalk.png##" "$SOURCEDIR/grub2config.in" >"$SOURCEDIR/grub2config"
fi

if [ "$GRUB2CONFIG" == "true" ]; then
  GRUB2CONFF="${SOURCEDIR}/grub2config"
  sed -e 's/^GRUB2CONFIG=false$/GRUB2CONFIG=true/' "${SOURCEDIR}/grub2config-launcher.in" >"${SOURCEDIR}/grub2config-launcher"
else
  cp "${SOURCEDIR}/grub2config-launcher.in" "${SOURCEDIR}/grub2config-launcher"
fi

if [ "x$GRUB_CMDLINE_LINUX" != "x" ]; then
  sed -e "s/^export GRUB_CMDLINE_LINUX=\"[^\"]\"/export GRUB_CMDLINE_LINUX=\"$GRUB_CMDLINE_LINUX\"/" <"$SOURCEDIR/sg2conf.in" >"$SOURCEDIR/sg2conf"
fi

if [ "x$GRUB_CMDLINE_LINUX_DEFAULT" != "x" ]; then
  sed -e "s/^export GRUB_CMDLINE_LINUX_DEFAULT=\"[^\"]\"/export GRUB_CMDLINE_LINUX=\"$GRUB_CMDLINE_LINUX_DEFAULT\"/" <"$SOURCEDIR/sg2conf.in" >"$SOURCEDIR/sg2conf"
fi

ETCDIR=$(eval echo $ETCDIR)
SOURCEDIR=$(readlink -f $SOURCEDIR)

sed -e "s/GRUB_DISTRIBUTOR=\"\"/GRUB_DISTRIBUTOR=\"${DISTRIBUTOR}\"/" "$SOURCEDIR/sg2conf.in" >"$SOURCEDIR/sg2conf"


install -vd \
  "${DESTDIR}${PREFIX}/share/icons/hicolor/48x48/apps/" \
  "${DESTDIR}${PREFIX}/share/applications/" \
  "${DESTDIR}${PREFIX}/sbin/" \
  "${DESTDIR}${MANDIR}/man8/"

install -v -m 755 \
  "${SOURCEDIR}/sg2conf" \
  "${SOURCEDIR}/sg2conf-gui" \
  "${SOURCEDIR}/grub2config-launcher" \
  ${GRUB2CONFF} \
  "${SOURCEDIR}/update-grub" \
    "${DESTDIR}${PREFIX}/sbin/"
install -v -m 644 \
  "${SOURCEDIR}/sg2conf.desktop" \
    "${DESTDIR}${PREFIX}/share/applications/"
install -v -m 644 \
  "${SOURCEDIR}/sg2conf.png" \
    "${DESTDIR}${PREFIX}/share/icons/hicolor/48x48/apps/"

for file in $BOOTFILES; do
  install -vD -m 644 \
    "${SOURCEDIR}/${file}" \
      "${DESTDIR}${GRUBBOOT}/${file}"
done

if [ -d "${DESTDIR}${ETCDIR}/grub.d/" ]; then
  [ -f "${DESTDIR}${ETCDIR}/grub.d/10_linux" ] \
    && [ "$ZWPATCH" == "true" ] \
    && patch -p1 -i "${SOURCEDIR}/grub2-zenwalk.patch" -d "${DESTDIR}${ETCDIR}/"
  
  for file in $GRUBDFILES; do
    install -v -m 755 \
      "${SOURCEDIR}/${file}" \
        "${DESTDIR}${ETCDIR}/grub.d/"
  done
fi

# generate man pages
HELP2MAN="`which help2man`"
if [ "x$HELP2MAN" != "x" ]; then
  LANG=C ${HELP2MAN} --no-info --section=8 -o "${DESTDIR}${MANDIR}/man8/sg2conf.8" "${DESTDIR}${PREFIX}/sbin/sg2conf"
else
  echo "Skipping man pages as \`help2man' could not be found."
fi
