%%
%% %CopyrightBegin%
%% 
%% Copyright Ericsson AB 2002-2009. All Rights Reserved.
%% 
%% The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved online at http://www.erlang.org/.
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% %CopyrightEnd%
%%
%%
-module(per_bm).

-define(DATADIR,"/clearcase/otp/erts/lib/asn1/test/asn1_SUITE_data/").
-include("bench.hrl").

-export([init/0,benchmarks/0]).
-export([encode/1,decode/1,ranap_enc/1,ranap_dec/1]).


init() ->
    ok = asn1ct:compile(?DATADIR++"H235-SECURITY-MESSAGES",[per_bin]),
    ok = asn1ct:compile(?DATADIR++"H323-MESSAGES",[per_bin]),
    ok = asn1ct:compile("RanapASN1",[per_bin]),
    ok.
    

benchmarks() ->
    {5000,[encode,decode,ranap_enc,ranap_dec]}.

ranap_dec(N) ->
    V = ranap_v2(),
    {ok,Bl} = asn1rt:encode('RanapASN1','RANAP-PDU',V),
    B = list_to_binary(Bl),
    ranap_n_dec(N,B),
    ok.

ranap_n_dec(0,_) ->
    ok;
ranap_n_dec(N,B) ->
    {ok,V}=asn1rt:decode('RanapASN1','RANAP-PDU',B),
    ranap_n_dec(N-1,B).

ranap_enc(N) ->
    V = ranap_v2(),
    ranap_n_enc(N,V),
    ok.

ranap_n_enc(0,V) ->
    ok;
ranap_n_enc(N,V) ->
    {ok,B} = asn1rt:encode('RanapASN1','RANAP-PDU',V),
    ranap_n_enc(N-1,V).


decode(N) ->
    V = v1(),
    {ok,Bl} = asn1rt:encode('H323-MESSAGES','H323-UserInformation',V),
    B = list_to_binary(Bl),
    n_decode(N,B),
    ok.

n_decode(0,_) ->
    ok;
n_decode(N,B) ->
    {ok,V}=asn1rt:decode('H323-MESSAGES','H323-UserInformation',B),
    n_decode(N-1,B).
    

v1() ->
    V = 
		  {'H323-UserInformation',
		   {'H323-UU-PDU',
		    {callProceeding,
		     {'CallProceeding-UUIE',
		      {0,
		       7,
		       180},
		      {'EndpointType',
		       {'NonStandardParameter',
			{object,
			 {0,
			  8,
			  202}},
			"O"},
		       {'VendorIdentifier',
			{'H221NonStandard',
			 55,
			 55,
			 14277},
			"OC",
			"OC"},
		       {'GatekeeperInfo',
			{'NonStandardParameter',
			 {object,
			  {0,
			   9,
			   232}},
			 "O"}},
		       {'GatewayInfo',
			[{h320,
			  {'H320Caps',
			   {'NonStandardParameter',
			    {object,
			     {0,
			      10,
			      268}},
			    "O"},
			   [{'DataRate',
			     {'NonStandardParameter',
			      {object,
			       {0,
				11,
				284}},
			      "O"},
			     1244176737,
			     75}],
			   [{'SupportedPrefix',
			     {'NonStandardParameter',
			      {object,
			       {0,
				12,
				304}},
			      "O"},
			     {'h323-ID',
			      "BM"}}]}}],
			{'NonStandardParameter',
			 {object,
			  {0,
			   13,
			   324}},
			 "O"}},
		       {'McuInfo',
			{'NonStandardParameter',
			 {object,
			  {1,
			   13,
			   346,
			   347}},
			 "OC"}},
		       {'TerminalInfo',
			{'NonStandardParameter',
			 {object,
			  {1,
			   14,
			   363,
			   363}},
			 "OC"}},
		       true,
		       true},
		      {ipxAddress,
		       {'TransportAddress_ipxAddress',
			"OCTET ",
			"OCTE",
			"OC"}},
		      {'CallIdentifier',
		       "OCTET STRINGOCTE"},
		      {noSecurity,
		       'NULL'},
		      [
% 		       {'ClearToken',
% 			1703375497,
% 			"BM",
% 			{'DHset',
% 			 [1],
% 			 [1],
% 			 [1]},
% 			"OCTET STRI",
% 			-21825559,
% 			{'TypedCertificate',
% 			 {1,
% 			  17,
% 			  424,
% 			  424},
% 			 "OC"},
% 			"BMP",
% 			{'NonStandardParameter',
% 			 {1,
% 			  17,
% 			  435,
% 			  436},
% 			 "OC"}},
		       {'ClearToken',
			1929575502,
			"BMP",
			{'DHset',
			 [1],
			 [1],
			 [1]},
			"OCTET STRI",
			-9591354,
			{'TypedCertificate',
			 {1,
			  18,
			  471,
			  471},
			 "OC"},
			"BMP",
			{'NonStandardParameter',
			 {1,
			  19,
			  482,
			  483},
			 "OC"}}],
		      [
% 		       {cryptoEPCert,
% 			{'CryptoH323Token_cryptoEPCert',
% 			 {'ClearToken',
% 			  2227304001,
% 			  "BMP",
% 			  {'DHset',
% 			   [1],
% 			   [1],
% 			   [1]},
% 			  "OCTET STRI",
% 			  9574387,
% 			  {'TypedCertificate',
% 			   {1,
% 			    21,
% 			    541,
% 			    542},
% 			   "OCT"},
% 			  "BMP",
% 			  {'NonStandardParameter',
% 			   {1,
% 			    22,
% 			    552,
% 			    553},
% 			   "OCT"}},
% 			 {1,
% 			  22,
% 			  559,
% 			  560},
% 			 {'Params',
% 			  18993485,
% 			  "OCTET ST"},
% 			 [1,
% 			  0,
% 			  1]}},
		       {cryptoEPCert,
			{'CryptoH323Token_cryptoEPCert',
			 {'ClearToken',
			  2581405450,
			  "BMPS",
			  {'DHset',
			   [1,
			    0,
			    1],
			   [1,
			    0,
			    1],
			   [1,
			    0,
			    1]},
			  "OCTET STRIN",
			  32050976,
			  {'TypedCertificate',
			   {1,
			    25,
			    625,
			    625},
			   "OCT"},
			  "BMPS",
			  {'NonStandardParameter',
			   {1,
			    25,
			    636,
			    637},
			   "OCT"}},
			 {1,
			  25,
			  644,
			  645},
			 {'Params',
			  40708757,
			  "OCTET ST"},
			 [1,
			  0,
			  1]}}],
		      ["OCT",
		       "OCT",
		       "OCT"]}},
		    {'NonStandardParameter',
		     {h221NonStandard,
		      {'H221NonStandard',
		       173,
		       173,
		       44666}},
		     "OCTE"},
		    ["OCTE",
		     "OCTE",
		     "OCTE",
		     "OCTE"],
		    true,
		    ["OCTE",
		     "OCTE",
		     "OCTE",
		     "OCTE"],
		    [
% 		     {'NonStandardParameter',
% 		      {h221NonStandard,
% 		       {'H221NonStandard',
% 			182,
% 			183,
% 			46981}},
% 		      "OCTE"},
% 		     {'NonStandardParameter',
% 		      {h221NonStandard,
% 		       {'H221NonStandard',
% 			186,
% 			187,
% 			48016}},
% 		      "OCTE"},
% 		     {'NonStandardParameter',
% 		      {h221NonStandard,
% 		       {'H221NonStandard',
% 			190,
% 			191,
% 			49026}},
% 		      "OCTE"},
		     {'NonStandardParameter',
		      {h221NonStandard,
		       {'H221NonStandard',
			195,
			196,
			50303}},
		      "OCTE"}]},
		   {'H323-UserInformation_user-data',
		    197,
		    "OCTE"}}.

encode(N) ->
    V = v1(),
    n_encode(N,V),
    ok.

n_encode(0,V) ->
    ok;
n_encode(N,V) ->
    {ok,B} = asn1rt:encode('H323-MESSAGES','H323-UserInformation',V),
    n_encode(N-1,V).


ranap_v1() ->
    {successfulOutcome,
     {'SuccessfulOutcome',
      9,
      ignore,
      {'ResetAcknowledge',
       [{'ProtocolIE-Field',3,ignore,'ps-domain'},
	{'ProtocolIE-Field',
	 86,
	 ignore,
	 {'GlobalRNC-ID',"!Ce",2}}],
       asn1_NOVALUE}}}.

ranap_v2() ->
    {initiatingMessage,{'InitiatingMessage',
			6,
			{'Criticality',reject},
			{'SecurityModeCommand',
			 [{'ProtocolIE-Field',
			   12,
			   {'Criticality',reject},
			   {'IntegrityProtectionInformation',
			    ['standard-UMTS-integrity-algorithm-UIA1'],
			    [0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     1,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0],
			    asn1_NOVALUE}},
			  {'ProtocolIE-Field',
			   11,
			   {'Criticality',ignore},
			   {'EncryptionInformation',
			    ['no-encryption',
			     'standard-UMTS-encryption-algorith-UEA1'],
			    [0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     0,
			     1],
			    asn1_NOVALUE}},
			  {'ProtocolIE-Field',
			   75,
			   {'Criticality',reject},
			   new}],
			 asn1_NOVALUE}}}.







