/**********************************************************************
 *
 *    FILE:            VolumePropertyAdjustmentCallback.cpp
 *
 *    DESCRIPTION:    Read/Write osg::VolumePropertyAdjustmentCallback in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerate
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 25.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "VolumePropertyAdjustmentCallback.h"
#include "Object.h"

using namespace ive;

void VolumePropertyAdjustmentCallback::write(DataOutputStream* out)
{
    // Write VolumePropertyAdjustmentCallback's identification.
    out->writeInt(IVEVOLUMEPROPERTYADJUSTMENTCALLBACK);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Object*  obj = dynamic_cast<osg::Object*>(this);
    if(obj)
    {
        ((ive::Object*)(obj))->write(out);
    }
    else
        out_THROW_EXCEPTION("VolumePropertyAdjustmentCallback::write(): Could not cast this osg::VolumePropertyAdjustmentCallback to an osg::Object.");
    // Write VolumePropertyAdjustmentCallback's properties.

    out->writeInt(getKeyEventCyclesForward());
    out->writeInt(getKeyEventCyclesBackward());
    out->writeInt(getKeyEventActivatesTransparencyAdjustment());
    out->writeInt(getKeyEventActivatesSampleAdjustment());
    out->writeInt(getKeyEventActivatesAlphaFuncAdjustment());

}

void VolumePropertyAdjustmentCallback::read(DataInputStream* in)
{
    // Peek on VolumePropertyAdjustmentCallback's identification.
    int id = in->peekInt();
    if(id == IVEVOLUMEPROPERTYADJUSTMENTCALLBACK)
    {
        // Read VolumePropertyAdjustmentCallback's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Object*  obj = dynamic_cast<osg::Object*>(this);
        if(obj)
        {
            ((ive::Object*)(obj))->read(in);
        }
        else
            in_THROW_EXCEPTION("VolumePropertyAdjustmentCallback::read(): Could not cast this osg::VolumePropertyAdjustmentCallback to an osg::Object.");

        // Read VolumePropertyAdjustmentCallback's properties

        setKeyEventCycleForward(in->readInt());
        setKeyEventCycleBackward(in->readInt());
        setKeyEventActivatesTransparencyAdjustment(in->readInt());
        setKeyEventActivatesSampleDensityAdjustment(in->readInt());
        setKeyEventActivatesAlphaFuncAdjustment(in->readInt());

    }
    else
    {
        in_THROW_EXCEPTION("VolumePropertyAdjustmentCallback::read(): Expected VolumePropertyAdjustmentCallback identification.");
    }
}
