.\" t
.\" @(#)asfont.3		06/18/2008
.TH asfont 1 "libAfterImage v.1.18" "Jun 18 2008" "libAfterImage image manipulation library"
.UC
.SH NAME
\fBasfont\fP\ - text drawing functionality and handling of TTF and X11 fonts
libAfterImage/asfont.h
.SH NAMEasfont


.SH DESCRIPTION
.nf
Text drawing functionality.
Text is drawn as an ASImage with only alpha channel. Since alpha
channel is 8 bit widths that allows for 256 shades to be used in
rendered glyphs. That in turn allows for smoothing and antialiasing
of the drawn text. Such an approcah allows for easy manipulation of
the drawn text, such as changing color, making it transparent,
texturizing, rotation, etc.

libAfterImage supports two types of fonts :
Fonts that could be rendered using standard Xlib functionality, and
fonts rendered by FreeType 2 library. That may include TrueType
fonts. When fonts are obtained via Xlib special processing is
performed in order to smooth its shape and leverage 256 shades
palette available.

Any font being used is has to be opened first. At that time its
properties are analysed and glyphs are cached in clients memory.
Special RLE compression method is used for font glyphs, significantly
reducing memory utilization without any effect on performance.

Font management and drawing functionality has been designed with
internatiolization in mind, althou support for locales is not
complete yet.
.fi 
.SH SEE ALSO
.nf
Structures :
         ASFontManager
         ASFont
         ASGlyph
         ASGlyphRange

Functions :
         create_font_manager(), destroy_font_manager(),
         open_freetype_font(), open_X11_font(), get_asfont(),
         destroy_font(), print_asfont(), print_asglyph(),
         draw_text(),
         get_asfont_glyph_spacing(), set_asfont_glyph_spacing()

Other libAfterImage modules :
         ascmap.h asfont.h asimage.h asvisual.h blender.h export.h
         import.h transform.h ximage.h
.fi 
.SH AUTHOR
.nf
Sasha Vasko <sasha at aftercode dot net>
.fi libAfterImage/MAX_GLYPHS_PER_FONT
.SH NAMEMAX_GLYPHS_PER_FONT
- Max value of glyphs per font allowed. We need that so we can detect and avoid broken fonts somehow.

.SH SOURCE
Source : 
.nf
#define MAX_GLYPHS_PER_FONT  2048
.fi libAfterImage/ASFontType
.SH NAMEASFontType
- Supported types of fonts - Xlib or FreeType 2 ASF_GuessWho will enable autodetection of the font type. It is attempted to be opened as FreeType font first, and if that fails - it will be opened as Xlib font.

.SH SOURCE
Source : 
.nf
typedef enum
{
    ASF_X11         = 0,
    ASF_Freetype    = (0x01<<0),
    ASF_GuessWho    = (0x01<<1),
#define ASF_TypeMask  (ASF_GuessWho|ASF_Freetype)

    /* flags below should be combined with one of the above values */
    ASF_Monospaced  = (0x01<<2),
    ASF_RightToLeft = (0x01<<3),  /* direction of the text flow */
    ASF_HasKerning  = (0x01<<4)
}ASFontType;
.fi libAfterImage/ASGlyph
.SH NAMEASGlyph


.SH DESCRIPTION
.nf
Stores glyph's image, as well as width, height and other
characteristics of the glyph.
.fi 
.SH SOURCE
Source : 
.nf
typedef struct ASGlyph
{
    CARD8          *pixmap ;        /* glyph's RLE encoded pixmap */
    short   width, height ; /* meaningfull width and height
                                     * of the glyphs pixmap */
    short  lead, step ;             /* distance pen position to glyph
                                     * beginning and to the next glyph */
                                    /* in XRender it should be used as so:
                                     * x = -lead, xOff = step
                                     */
    short  ascend, descend ;        /* distance of the top of the
                                     * glyph from the baseline */
                                    /* in XRender it should be used as so:
                                     * y = -ascend, yOff = 0
                                     */
    unsigned int font_gid ;         /* index of the glyph inside the font( TTF only ) */
    long         xrender_gid ;      /* Used only with XRender  - gid of the glyph in GlyphSet */        
}ASGlyph;
.fi libAfterImage/ASGlyphRange
.SH NAMEASGlyphRange


.SH DESCRIPTION
.nf
Organizes glyphs that belongs to the continuos range of char codes.
ASGlyphRange structures could be tied together to cover entire
codeset supported by the font.
.fi 
.SH SOURCE
Source : 
.nf
typedef struct ASGlyphRange
{
    unsigned long   min_char, max_char; /* Code range.
                                         * for some locales that would
                                         * be sufficient to simply set
                                         * range of characteres
                                         * supported by font */
    ASGlyph *glyphs;                    /* array of glyphs belonging to
                                         * that code range */
    struct ASGlyphRange *below, *above;
}ASGlyphRange;
.fi libAfterImage/ASFont
.SH NAMEASFont


.SH DESCRIPTION
.nf
Structure to contain all the font characteristics, as well as
set of glyph images. Such structure has to be created/opened prior to
being able to draw characters with any font.
.fi 
.SH SOURCE
Source : 
.nf
typedef struct ASFont
{
    unsigned long   magic ;
    int             ref_count ;

    struct ASFontManager *fontman;  /* our owner */
    char                 *name;

    ASFontType      type ;
    ASFlagType      flags ;

    ASGlyphRange   *codemap; /* linked list of glyphsets, each
                              * representing continuos range of
                              * available codes - used for ASCII 
                              * codes */
    ASHashTable    *locale_glyphs;  /* hash of locale specific glyphs */

    ASGlyph         default_glyph;  /* valid glyph to be drawn when
                                     * code is not valid */

    int             max_height;  /* maximiu height of the character
                                  * glyph */
    int             max_ascend,  /* maximum distance from the baseline
                                  * to the top of the character glyph */
                    max_descend; /* need both descend and ascend to be 
                                    able to dynamically recalculate font 
                                    height while adding new characters */
    int             space_size;  /* fixed width value to be used when
                                  * rendering spaces and tabs */
    int             spacing_x, spacing_y;
    /* If these are set to anything above 0 then all the glyphs has to be 
     * padded ( if its smaller then the cell ) or scaled down 
     * ( if its bigger then the cell )
     */                                
    int    cell_width, cell_height ;

#ifdef HAVE_FREETYPE
    FT_Face         ft_face;        /* free type font handle */
#else
    CARD32         *pad;
#endif
    
    unsigned long   xrender_glyphset ;  /* GlyphSet is the actuall datatype, 
                                         * but for easier compilation - 
                                         * we use generic which is the same */ 
}ASFont;
.fi libAfterImage/ASFontManager
.SH NAMEASFontManager


.SH DESCRIPTION
.nf
Global data identifying connection to external libraries, as well as
fonts location paths.
This structure has to be created/initialized prior to any font being
loaded.
It also holds list of fonts that are currently open, allowing for
easy access to fonts.
When ASFontManagaer object is destroyd it automagically closes all
the open fonts.
.fi 
.SH SOURCE
Source : 
.nf
typedef struct ASFontManager
{
    Display    *dpy;
    char       *font_path ;

    ASHashTable *fonts_hash ;

    size_t       unicode_used;
    CARD32      *local_unicode; /* list of unicodes from current locale
                                 * - we use it to limit number of glyphs
                                 * we load */
    Bool        ft_ok ;
#ifdef HAVE_FREETYPE
    FT_Library  ft_library;     /* free type library handle */
#else
    void       *pad ;
#endif
}ASFontManager;
.fi libAfterImage/ASText3DType
.SH NAMEASText3DType
- Available types of 3D text to be drawn.

.SH SOURCE
Source : 
.nf
typedef enum ASText3DType{
    AST_Plain =0,                              /* regular 2D text */
    AST_Embossed,
    AST_Sunken,
    AST_ShadeAbove,
    AST_ShadeBelow,
    AST_EmbossedThick,
    AST_SunkenThick,
    AST_OutlineAbove,
    AST_OutlineBelow,
    AST_OutlineFull,
    AST_3DTypes
}ASText3DType;
.fi libAfterImage/ASTextAttributes
.SH NAMEASTextAttributes
- Attributes for text rendering

.SH SOURCE
Source : 
.nf
typedef struct ASTextAttributes
{
#define ASTA_UseTabStops    (0x01<<0)   
    unsigned int version ;     
                    /* structure version, so we can implement future 
                     * extensions without breaking binary apps */             
    ASFlagType   rendition_flags ;
    ASText3DType type;
    ASCharType   char_type;
    unsigned int tab_size ;   /* tab size in chars  - defaults to 8 */
    unsigned int origin ;     /* distance from the left margin 
                               * (in pixels) */
    unsigned int *tab_stops ; /* tab stops in pixels where 
                               * left margin is 0 */                   
    unsigned int tab_stops_num ;

    ARGB32      fore_color ;   /* used with 3D type of Outlined */
  unsigned int width;
#define ASTA_VERSION_1  1

#define ASTA_VERSION_INTERNAL   ASTA_VERSION_1
}ASTextAttributes;
.fi libAfterImage/asfont/create_font_manager()
.SH NAMEcreate_font_manager()


.SH SYNOPSIS
.nf
ASFontManager *create_font_manager( Display *dpy,
                                    const char *font_path,
                                    ASFontManager *reusable_memory );
.fi 
.SH INPUTS
.IP "dpy"
- pointer to valid and opened Display.
.IP "font_path"
- string, representing colon separated list of directories to search for FreeType fonts.
.IP "reusable_memory"
- optional preallocated memory for the ASFontMagaer object

.SH RETURN VALUE
.nf
Pointer to Initialized ASFontManager object on success.
NULL otherwise.
.fi 
.SH DESCRIPTION
.nf
create_font_manager() will create new ASFontManager structure if
needed. It wioll then store copy of font_path and supplied pointer to
Display in it. At that time Hash table of loaded fonts is initialized,
and if needed FreeType library is initialized as well.
ASFontManager object returned by this functions has to be open at all
times untill text drawing is no longer needed.
.fi libAfterImage/asfont/destroy_font_manager()
.SH NAMEdestroy_font_manager()


.SH SYNOPSIS
.nf
void destroy_font_manager( ASFontManager *fontman,
                           Bool reusable );
.fi 
.SH INPUTS
.IP "fontman"
- pointer to valid ASFontManager object to be deallocated.
.IP "reusable"
- If True, then memory holding object itself will not be freed - only resources will be deallocated. That is usefull for structures created on stack.

.SH DESCRIPTION
.nf
destroy_font_manager() closes all the fonts open with this
ASFontManager. It will also close connection to FreeType library, and
deallocate all cached data. If reusable is False - then memory used
for object itself will not be freed.
.fi libAfterImage/asfont/open_freetype_font()
.SH NAMEopen_freetype_font()


.SH SYNOPSIS
.nf
ASFont *open_freetype_font( ASFontManager *fontman,
                            const char *font_string,
                            int face_no,
                            int size, Bool verbose);
.fi 
.SH INPUTS
.IP "fontman"
- pointer to previously created ASFontManager. Needed for connection to FreeType library, as well as path to search fonts in.
.IP "font_string"
- filename of the file containing font's data.
.IP "face_no"
- number of face within the font file
.IP "size"
- font size in points. Applicable only to scalable fonts, such as TrueType.
.IP "verbose"
- if True, extensive error messages will be printed if problems encountered.

.SH RETURN VALUE
.nf
pointer to Opened ASFont structure, containing all the glyphs of the
font, as well as other relevant info. On failure returns NULL.
.fi 
.SH DESCRIPTION
.nf
open_freetype_font() will attempt to find font file in any of the
directories specified in ASFontManager's font_path. If it fails to do
so - then it will check if filename has alldigit extentions. It will
then try to interpret that extention as a face number, and try and
find the file with extention stripped off.
If file was found function will atempt to read it using FreeType
library. If requested face is not available in the font - face 0 will
be used.
On success all the font's glyphs will be rendered and cached, and
needed font geometry info collected.
When FreeType Library is not available that function does nothing.
.fi libAfterImage/asfont/open_X11_font()
.SH NAMEopen_X11_font()


.SH SYNOPSIS
.nf
ASFont *open_X11_font( ASFontManager *fontman,
                       const char *font_string);
.fi 
.SH INPUTS
.IP "fontman"
- pointer to previously created ASFontManager. Needed for connection X Server.
.IP "font_string"
- name of the font as recognized by Xlib.

.SH RETURN VALUE
.nf
pointer to Opened ASFont structure, containing all the glyphs of the
font, as well as other relevant info. On failure returns NULL.
.fi 
.SH DESCRIPTION
.nf
open_X11_font() attempts to load and query font using Xlib calls.
On success it goes thgroughthe codemap of the font and renders all
the glyphs available. Glyphs then gets transfered to the client's
memory and encoded using RLE compression. At this time smoothing
filters are applied on glyph pixmaps, if its size exceeds threshold.
.fi 
.SH TODO
.nf
implement proper XFontSet support, when used with I18N enabled.
.fi libAfterImage/asfont/get_asfont()
.SH NAMEget_asfont()


.SH SYNOPSIS
.nf
ASFont *get_asfont( ASFontManager *fontman,
                    const char *font_string,
                    int face_no, int size,
                    ASFontType type );
.fi 
.SH INPUTS
.IP "fontman"
- pointer to previously created ASFontManager. Needed for connection to FreeType library, path to search fonts in, and X Server connection.
.IP "font_string"
- font name or filename of the file containing font's data.
.IP "face_no"
- number of face within the font file
.IP "size"
- font size in points. Applicable only to scalable fonts, such as TrueType.
.IP "type"
- specifies the type of the font, or GuessWho for autodetection.

.SH RETURN VALUE
.nf
pointer to Opened ASFont structure, containing all the glyphs of the
font, as well as other relevant info. On failure returns NULL.
.fi 
.SH DESCRIPTION
.nf
This function provides unified interface to font loading. It performs
search in ASFontManager's list to see if this specific font has been
loaded already, and if so - returns pointer to relevant structure.
Otherwise it tryes to load font as FreeType font first, and then
Xlib font, unless exact font type is specifyed.
.fi libAfterImage/asfont/release_font()
.SH NAMErelease_font()


.SH SYNOPSIS
.nf
void release_font( ASFont *font );
.fi 
.SH INPUTS
.IP "font"
- pointer to the valid ASFont structure containing loaded font.

.SH RETURN VALUE
.nf
returns current reference count. -1 means that object has been
destroyed.
.fi 
.SH DESCRIPTION
.nf
This function will decrement reference count on loaded font and if
reference count will be less then 0 ( meaning that release_font() has
been called more times then get_asfont() ) it will close the font,
remove it from ASFontManager's list, destroy all the glyphs and
generally free everything else used by ASFont.
Otherwise font will remain in memory for faster reuse.
.fi libAfterImage/asfont/print_asfont()
.SH NAMEprint_asfont()


.SH SYNOPSIS
.nf
void    print_asfont( FILE* stream,
                      ASFont* font);
.fi 
.SH INPUTS
.IP "stream"
- output file pointer
.IP "font"
- pointer to ASFont structure to print.

.SH DESCRIPTION
.nf
prints all the geometry information about font.
.fi libAfterImage/asfont/print_asglyph()
.SH NAMEprint_asglyph()


.SH SYNOPSIS
.nf
void    print_asglyph( FILE* stream,
                        ASFont* font, unsigned long c);
.fi 
.SH INPUTS
.IP "stream"
- output file pointer
.IP "font"
- pointer to ASFont structure to print.
.IP "c"
- character code to print glyph for

.SH DESCRIPTION
.nf
prints out contents of the cached glyph for specifyed character code.
.fi libAfterImage/asfont/draw_text()
.SH NAMEdraw_text()

draw_fancy_text()

get_text_size()

get_fancy_text_size();


.SH SYNOPSIS
.nf
ASImage *draw_text( const char *text,
                    ASFont *font, ASText3DType type,
                    int compression );
ASImage *draw_fancy_text( const void *text,
                         struct ASFont *font, ASTextAttributes *attr,
                             int compression, 
                             int length );
Bool get_text_size( const char *text,
                    ASFont *font, ASText3DType type,
                    unsigned int *width, unsigned int *height );
Bool get_fancy_text_size( const void *text,
                             struct ASFont *font, ASTextAttributes *attr,
                         unsigned int *width, unsigned int *height,
                             int length,
                             int *x_positions );        
.fi 
.SH INPUTS
.IP "text"
- actuall text to render
.IP "font"
- pointer to ASFont to render text with
.IP "type"
- one of the few available types of 3D text.
.IP "compression"
- compression level to attempt on resulting ASImage.
.IP "width"
- pointer to value to be set to text width.
.IP "height"
- pointer to value to be set to text height.

.SH RETURN VALUE
.nf
Pointer to new ASImage containing rendered text on success.
NULL on failure.
.fi 
.SH DESCRIPTION
.nf
draw_text() creates new ASImage of the size big enough to contain
entire text. It then renders the text using supplied font as an alpha
channel of ASImage.
get_text_size() can be used to determine the size of the text about
to be drawn, so that appropriate drawable can be prepared.
.fi libAfterImage/asfont/get_asfont_glyph_spacing()
.SH NAMEget_asfont_glyph_spacing()


.SH SYNOPSIS
.nf
Bool get_asfont_glyph_spacing( ASFont* font, int *x, int *y );
.fi 
.SH INPUTS
.IP "font"
- Loaded ASFont structure.
.IP "x"
- pointer to the variable to receive horizontal spacing value.
.IP "y"
- pointer to the variable to receive vertical spacing value.

.SH RETURN VALUE
.nf
True if meaningfull information has been returned.
.fi 
.SH DESCRIPTION
.nf
Returns inter-glyph spacing of specified font.
.fi libAfterImage/asfont/set_asfont_glyph_spacing()
.SH NAMEset_asfont_glyph_spacing()


.SH SYNOPSIS
.nf
Bool set_asfont_glyph_spacing( ASFont* font, int x, int y );
.fi 
.SH INPUTS
.IP "font"
- Loaded ASFont structure.
.IP "x"
- new horizontal spacing value.
.IP "y"
- new vertical spacing value.

.SH RETURN VALUE
.nf
TRue on success.
.fi 
.SH DESCRIPTION
.nf
Changes inter-glyph spacing of the specified font.
.fi 
