.\" t
.\" @(#)export.3		06/18/2008
.TH export 1 "libAfterImage v.1.18" "Jun 18 2008" "libAfterImage image manipulation library"
.UC
.SH NAME
\fBexport\fP\ - functionality for writing images into files
libAfterImage/export.h
.SH NAMEexport
- Image output into different file formats.

.SH SEE ALSO
.nf
Structures :
         ASXpmExportParams
         ASPngExportParams
         ASJpegExportParams
         ASGifExportParams
         ASImageExportParams

Functions :
        ASImage2file()

Other libAfterImage modules :
         ascmap.h asfont.h asimage.h asvisual.h blender.h export.h
         import.h transform.h ximage.h
.fi 
.SH AUTHOR
.nf
Sasha Vasko <sasha at aftercode dot net>
.fi libAfterImage/ExportFlags
.SH NAMEEXPORT_GRAYSCALE
- save image as grayscale.
EXPORT_ALPHA
- save alpha channel if format permits
EXPORT_APPEND
- if format allows multiple images - image will be appended

.SH FUNCTION
.nf
Some common flags that could be used while writing images into
different file formats.
.fi 
.SH SOURCE
Source : 
.nf
#define EXPORT_GRAYSCALE            (0x01<<0)
#define EXPORT_ALPHA                (0x01<<1)
#define EXPORT_APPEND               (0x01<<3)  /* adds subimage  */
#define EXPORT_ANIMATION_REPEATS    (0x01<<4)  /* number of loops to repeat GIF animation */
/*****/
.fi libAfterImage/ASPngExportParams
.SH NAMEASPngExportParams
- parameters for export into PNG file.

.SH SOURCE
Source : 
.nf
typedef struct
{
    ASImageFileTypes type;
    ASFlagType flags ;
    int compression ;
}ASPngExportParams ;
.fi libAfterImage/ASJpegExportParams
.SH NAMEASJpegExportParams
- parameters for export into JPEG file.

.SH SOURCE
Source : 
.nf
typedef struct
{
    ASImageFileTypes type;
    ASFlagType flags ;
    int quality ;
}ASJpegExportParams ;
.fi libAfterImage/ASGifExportParams
.SH NAMEASGifExportParams
- parameters for export into GIF file.

.SH SOURCE
Source : 
.nf
typedef struct
{
    ASImageFileTypes type;
    ASFlagType flags ;
    int dither ;
    int opaque_threshold ;
    unsigned short animate_delay ;
    unsigned short animate_repeats ;
}ASGifExportParams ;
.fi libAfterImage/ASTiffExportParams
.SH NAMEASTiffExportParams
- parameters for export into TIFF file.

.SH SOURCE
Source : 
.nf
typedef struct
{
    ASImageFileTypes type;
    ASFlagType flags ;
    CARD32 rows_per_strip ;

/* these are suitable compressions : */
#define TIFF_COMPRESSION_NONE       1
#define TIFF_COMPRESSION_OJPEG      6   /* !6.0 JPEG */
#define TIFF_COMPRESSION_JPEG       7
#define TIFF_COMPRESSION_PACKBITS   32773   /* Macintosh RLE */
#define TIFF_COMPRESSION_DEFLATE    32946   /* Deflate compression */
    /* you should be able to use other values from tiff.h as well */
    CARD32 compression_type ;
    int jpeg_quality ;

    int opaque_threshold ;
}ASTiffExportParams ;
.fi libAfterImage/ASImageExportParams
.SH NAMEASImageExportParams
- union of structures holding parameters for export into different file formats.

.SH DESCRIPTION
.nf
Treatment of this union depends on what type of export was requested.
.fi 
.SH SEE ALSO
.nf
ASImageFileTypes
.fi 
.SH SOURCE
Source : 
.nf
typedef union ASImageExportParams
{
    ASImageFileTypes   type;
    ASXpmExportParams  xpm;
    ASPngExportParams  png;
    ASJpegExportParams jpeg;
    ASGifExportParams  gif;
    ASTiffExportParams tiff;
}ASImageExportParams;
.fi libAfterImage/export/ASImage2file()
.SH NAMEASImage2file()


.SH SYNOPSIS
.nf
Bool ASImage2file( ASImage *im, const char *dir, const char *file,
              ASImageFileTypes type, ASImageExportParams *params );
.fi 
.SH INPUTS
.IP "im"
- Image to write out.
.IP "dir"
- directory name to write file into (optional, could be NULL)
.IP "file"
- file name with or without directory name.
.IP "type"
- output file format. ( see ASImageFileTypes )
.IP "params"
- pointer to ASImageExportParams union's member for the above type, with additional export parameters, such as quality, compression, etc. If NULL then all defaults will be used.

.SH RETURN VALUE
.nf
True on success. False - failure.
.fi 
.SH DESCRIPTION
.nf
ASImage2file will construct filename out of dir and file components
and then will call specific filter to write out file in requested
format.
.fi 
.SH NOTES
.nf
Some formats support compression, others support lossy compression,
yet others allows you to limit number of colors and colordepth.
Each specific filter will try to interpret those parameters in its
own way.
.fi 
.SH EXAMPLE
.nf
asmerge.c: ASMerge.3
.fi 
