.\" t
.\" @(#)ximage.3		06/18/2008
.TH ximage 1 "libAfterImage v.1.18" "Jun 18 2008" "libAfterImage image manipulation library"
.UC
.SH NAME
\fBximage\fP\ - functionality for displaying ASImages on X display
libAfterImage/ximage.h
.SH NAMEximage
- Defines conversion to and from XImages and Pixmaps.

.SH DESCRIPTION
.nf
ximage2asimage()    - convert XImage structure into ASImage
pixmap2asimage()    - convert X11 pixmap into ASImage
asimage2ximage()    - convert ASImage into XImage
asimage2mask_ximage() - convert alpha channel of ASImage into XImage
asimage2pixmap()    - convert ASImage into Pixmap ( possibly using
                      precreated XImage )
asimage2mask()  - convert alpha channel of ASImage into 1 bit
                      mask Pixmap.
.fi 
.SH SEE ALSO
.nf
Other libAfterImage modules :
         ascmap.h asfont.h asimage.h asvisual.h blender.h export.h
         import.h transform.h ximage.h
.fi 
.SH AUTHOR
.nf
Sasha Vasko <sasha at aftercode dot net>
.fi libAfterImage/picture_ximage2asimage()
.SH NAMEpicture_ximage2asimage()


.SH SYNOPSIS
.nf
ASImage *picture_ximage2asimage ( struct ASVisual *asv,
                                  XImage * xim, XImage *alpha_xim,
                                  unsigned int compression );
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "xim"
- source XImage
.IP "alpha_xim"
- source XImage for Alpha channel
.IP "compression"
- degree of compression of resulting ASImage.

.SH RETURN VALUE
.nf
pointer to newly allocated ASImage, containing encoded data, on
success. NULL on failure.
.fi 
.SH DESCRIPTION
.nf
picture_ximage2asimage will attempt to create new ASImage with the same
dimensions as supplied XImage. If both XImages are supplied - they must
have same dimentions. XImage will be decoded based on
supplied ASVisual, and resulting scanlines will be encoded into
ASImage.
.fi libAfterImage/ximage2asimage()
.SH NAMEximage2asimage()
- same as picture_ximage2asimage with alpha_ximage set to NULL. Supplied for compatibility with older versions and for convinience.

.SH SYNOPSIS
.nf
ASImage *ximage2asimage ( struct ASVisual *asv, XImage * xim,
                          unsigned int compression );
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "xim"
- source XImage
.IP "compression"
- degree of compression of resulting ASImage.

.SH RETURN VALUE
.nf
pointer to newly allocated ASImage, containing encoded data, on
success. NULL on failure.
.fi 
.SH DESCRIPTIONlibAfterImage/pixmap2asimage()
.SH NAMEpixmap2asimage()


.SH SYNOPSIS
.nf
ASImage *pixmap2ximage( ASVisual *asv, Pixmap p, int x, int y,
                        unsigned int width, unsigned int height,
                           unsigned long plane_mask,
                        unsigned int compression);
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "p"
- source Pixmap
.IP "x,"
y,
.IP "width,"
height- rectangle on Pixmap to be encoded into ASImage.
.IP "plane_mask"
- limits color planes to be copied from Pixmap.
.IP "keep_cache"
- indicates if we should keep XImage, used to copy image data from the X server, and attached it to ximage member of resulting ASImage.
.IP "compression"
- degree of compression of resulting ASImage.

.SH RETURN VALUE
.nf
pointer to newly allocated ASImage, containing data in XImage format, 
on success. NULL on failure.
.fi 
.SH DESCRIPTION
.nf
pixmap2ximage will obtain XImage of the requested area of the
X Pixmap, and it will attach it to newly created ASImage using 
alt.ximage member. After that newly created ASImage could be used 
in any transformations.
.fi libAfterImage/pixmap2asimage()
.SH NAMEpixmap2asimage()


.SH SYNOPSIS
.nf
ASImage *pixmap2asimage ( struct ASVisual *asv, Pixmap p,
                          int x, int y,
                          unsigned int width,
                          unsigned int height,
                          unsigned long plane_mask,
                          Bool keep_cache,
                          unsigned int compression );
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "p"
- source Pixmap
.IP "x,"
y,
.IP "width,"
height- rectangle on Pixmap to be encoded into ASImage.
.IP "plane_mask"
- limits color planes to be copied from Pixmap.
.IP "keep_cache"
- indicates if we should keep XImage, used to copy image data from the X server, and attached it to ximage member of resulting ASImage.
.IP "compression"
- degree of compression of resulting ASImage.

.SH RETURN VALUE
.nf
pointer to newly allocated ASImage, containing encoded data, on
success. NULL on failure.
.fi 
.SH DESCRIPTION
.nf
same as picture2asimage() with alpha pixmap set to None. Supplied for
compatibility and convinience.
.fi libAfterImage/picture2asimage()
.SH NAMEpicture2asimage()


.SH SYNOPSIS
.nf
ASImage *picture2asimage (struct ASVisual *asv,
                          Pixmap rgb, Pixmap a,
                          int x, int y,
                          unsigned int width,
                          unsigned int height,
                          unsigned long plane_mask,
                          Bool keep_cache,
                          unsigned int compression );
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "rgb"
- source Pixmap for red, green and blue channels
.IP "a"
- source Pixmap for the alpha channel
.IP "x,"
y,
.IP "width,"
height- rectangle on Pixmap to be encoded into ASImage.
.IP "plane_mask"
- limits color planes to be copied from Pixmap.
.IP "keep_cache"
- indicates if we should keep XImage, used to copy image data from the X server, and attached it to ximage member of resulting ASImage.
.IP "compression"
- degree of compression of resulting ASImage.

.SH RETURN VALUE
.nf
pointer to newly allocated ASImage, containing encoded data, on
success. NULL on failure.
.fi 
.SH DESCRIPTION
.nf
picture2asimage will obtain XImage of the requested area of the
X Pixmap, If alpha channel pixmap is supplied - it will be used to 
encode ASImage's alpha channel. Alpha channel pixmap must be either
8 or 1 bit deep, and it must have the same dimentions as main Pixmap.
.fi libAfterImage/asimage2ximage()
.SH NAMEasimage2ximage()


.SH SYNOPSIS
.nf
XImage  *asimage2ximage  (struct ASVisual *asv, ASImage *im);
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "im"
- source ASImage

.SH RETURN VALUE
.nf
On success returns newly created and encoded XImage of the same
colordepth as the supplied ASVisual. NULL on failure.
.fi 
.SH DESCRIPTION
.nf
asimage2ximage() creates new XImage of the exact same size as
supplied ASImage, and depth of supplied ASVisual. REd, Green and
Blue channels of ASImage then gets decoded, and encoded into XImage.
Missing scanlines get filled with black color.
.fi 
.SH NOTES
.nf
Returned pointer to XImage will also be stored in im->alt.ximage,
and It will be destroyed when XImage is destroyed, or reused in any
subsequent calls to asimage2ximage(). If any other behaviour is
desired - make sure you set im->alt.ximage to NULL, to dissociate
XImage object from ASImage.
.fi 
.SH SEE ALSO
.nf
create_visual_ximage()
.fi libAfterImage/asimage2alpha_ximage()
.SH NAMEasimage2alpha_ximage()


.SH SYNOPSIS
.nf
XImage  *asimage2alpha_ximage (struct ASVisual *asv, 
                               ASImage *im, Bool bitmap);
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "im"
- source ASImage
.IP "bitmap"
- if True resulting XImage will have depth of 1 bit - traditional X mask; otherwise it will have depth of 8 (usefull for XFree86 RENDER extension)

.SH RETURN VALUE
.nf
On success returns newly created and encoded XImage of the depth 1 or 8.
NULL on failure.
.fi 
.SH DESCRIPTION
.nf
asimage2alpha_ximage() creates new XImage of the exact same size as
supplied ASImage, and depth 1 or 8. Alpha channels of ASImage then gets
decoded, and encoded into XImage. In case requested depth is 1 then
alpha channel is interpreted like so: 127 or greater is encoded as 1,
otherwise as 0.
Missing scanlines get filled with 1s as they signify absence of mask.
.fi 
.SH NOTES
.nf
Returned pointer to XImage will also be stored in im->alt.mask_ximage,
and It will be destroyed when XImage is destroyed, or reused in any
subsequent calls to asimage2mask_ximage(). If any other behaviour is
desired - make sure you set im->alt.mask_ximage to NULL, to dissociate
XImage object from ASImage.
.fi libAfterImage/asimage2mask_ximage()
.SH NAMEasimage2mask_ximage()
- same as asimage2alpha_ximage(). Supplied for convinience and compatibility with older versions.

.SH SYNOPSIS
.nf
XImage  *asimage2mask_ximage (struct ASVisual *asv, ASImage *im);
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "im"
- source ASImage

.SH RETURN VALUE
.nf
On success returns newly created and encoded XImage of the depth 1.
NULL on failure.
.fi libAfterImage/asimage2pixmap()
.SH NAMEasimage2pixmap()


.SH SYNOPSIS
.nf
Bool     asimage2drawable( struct ASVisual *asv, Drawable d, ASImage *im,
                        GC gc,
                       int src_x, int src_y, int dest_x, int dest_y,
                       unsigned int width, unsigned int height,
                           Bool use_cached);
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "d"
- destination drawable - Pixmap or Window
.IP "im"
- source ASImage
.IP "gc"
- precreated GC to use for XImage transfer. If NULL, asimage2drawable() will use DefaultGC.
.IP "src_x"
- Specifies the offset in X from the left edge of the image defined by the ASImage structure.
.IP "src_y"
- Specifies the offset in Y from the top edge of the image defined by the ASImage structure.
.IP "dest_x,dest_y-"
Specify the x and y coordinates, which are relative to the origin of the drawable and are the coordinates of the subimage.
.IP "width,height"
- Specify the width and height of the subimage, which define the dimensions of the rectangle.
.IP "use_cached"
- If True will make asimage2pixmap() to use XImage attached to ASImage, instead of creating new one. Only works if ASImage->ximage data member is not NULL.

.SH RETURN VALUE
.nf
On success returns True.
.fi 
.SH DESCRIPTION
.nf
asimage2drawable() creates will copy portion of ASImage onto the X
Drawable. It checks if it needs to encode XImage
from ASImage data, and calls asimage2ximage() if yes, it has to.
It then supplied gc or DefaultGC of the screen to transfer
XImage to the server.
Missing scanlines get filled with black color.
.fi 
.SH SEE ALSO
.nf
asimage2ximage()
asimage2pixmap()
create_visual_pixmap()
.fi libAfterImage/asimage2pixmap()
.SH NAMEasimage2pixmap()


.SH SYNOPSIS
.nf
Pixmap   asimage2pixmap  ( struct ASVisual *asv, Window root,
                           ASImage *im, GC gc, Bool use_cached);
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "root"
- root window of destination screen
.IP "im"
- source ASImage
.IP "gc"
- precreated GC to use for XImage transfer. If NULL, asimage2pixmap() will use DefaultGC.
.IP "use_cached"
- If True will make asimage2pixmap() to use XImage attached to ASImage, instead of creating new one. Only works if ASImage->ximage data member is not NULL.

.SH RETURN VALUE
.nf
On success returns newly pixmap of the same colordepth as ASVisual.
None on failure.
.fi 
.SH DESCRIPTION
.nf
asimage2pixmap() creates new pixmap of exactly same size as
supplied ASImage. It then calls asimage2drawable to copy entire content
of the ASImage onto that created pixmap.
.fi 
.SH EXAMPLE
.nf
asview.c: ASView.5
.fi 
.SH SEE ALSO
.nf
asimage2ximage()
asimage2drawable()
create_visual_pixmap()
.fi libAfterImage/asimage2mask()
.SH NAMEasimage2mask()


.SH SYNOPSIS
.nf
Pixmap   asimage2mask ( struct ASVisual *asv, Window root,
                        ASImage *im, GC gc, Bool use_cached);
asv        - pointer to valid ASVisual structure
root       - root window of destination screen
im         - source ASImage
gc         - precreated GC for 1 bit deep drawables to use for
             XImage transfer. If NULL, asimage2mask() will create one.
use_cached - If True will make asimage2mask() to use mask XImage
            attached to ASImage, instead of creating new one. Only
            works if ASImage->alt.mask_ximage data member is not NULL.
.fi 
.SH RETURN VALUE
.nf
On success returns newly created pixmap of the colordepth 1.
None on failure.
.fi 
.SH DESCRIPTION
.nf
asimage2mask() creates new pixmap of exactly same size as
supplied ASImage. It then calls asimage2mask_ximage().
It then uses supplied gc, or creates new gc, to transfer
XImage to the server and put it on Pixmap.
Missing scanlines get filled with 1s.
.fi 
.SH SEE ALSO
.nf
asimage2mask_ximage()
.fi 
