/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.bittorrent.BTUploader;
import com.limegroup.bittorrent.BTUploaderFactory;
import com.limegroup.bittorrent.LimeWireTorrentManager;
import com.limegroup.gnutella.ActivityCallback;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentFileEntry;
import org.limewire.bittorrent.TorrentInfo;
import org.limewire.core.settings.BittorrentSettings;
import org.limewire.inject.LazySingleton;
import org.limewire.libtorrent.LibTorrentParams;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.FileUtils;
import org.limewire.util.GenericsUtils;

@LazySingleton
public class TorrentUploadManager
implements BTUploaderFactory {
    private static final Log LOG = LogFactory.getLog(TorrentUploadManager.class);
    private final Provider<ActivityCallback> activityCallback;
    private final Provider<LimeWireTorrentManager> torrentManager;

    @Inject
    public TorrentUploadManager(Provider<LimeWireTorrentManager> torrentManager, Provider<ActivityCallback> activityCallback) {
        this.torrentManager = torrentManager;
        this.activityCallback = activityCallback;
    }

    public void loadSavedUploads() {
        File[] uploadMementos;
        File uploadsDirectory = BittorrentSettings.TORRENT_UPLOADS_FOLDER.get();
        if (uploadsDirectory.exists() && (uploadMementos = uploadsDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return "memento".equals(FileUtils.getFileExtension(file));
            }
        })) != null) {
            for (File mementoFile : uploadMementos) {
                Map<String, Object> memento = null;
                try {
                    memento = this.readMemento(mementoFile);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Error reading memento for: " + mementoFile, e);
                }
                catch (IOException e) {
                    LOG.error("Error reading memento for: " + mementoFile, e);
                }
                catch (ClassNotFoundException e) {
                    LOG.error("Error reading memento for: " + mementoFile, e);
                }
                if (memento == null) continue;
                long mementoModifiedTime = mementoFile.lastModified();
                File torrentFile = (File)memento.get("torrentFile");
                File fastResumeFile = (File)memento.get("fastResumeFile");
                File torrentDataFile = (File)memento.get("torrentDataFile");
                String sha1 = (String)memento.get("sha1");
                String trackerURL = (String)memento.get("trackerURL");
                String name = (String)memento.get("name");
                boolean torrentAdded = false;
                boolean torrentLoaded = false;
                Torrent torrent = null;
                if (torrentDataFile.exists() && fastResumeFile != null && fastResumeFile.exists() && this.torrentManager.get().isValid() && !this.torrentManager.get().isDownloadingTorrent(mementoFile)) {
                    try {
                        LibTorrentParams params = new LibTorrentParams(torrentDataFile.getParentFile(), name, sha1);
                        params.setTrackerURL(trackerURL);
                        params.setFastResumeFile(fastResumeFile);
                        params.setTorrentFile(torrentFile);
                        params.setTorrentDataFile(torrentDataFile);
                        torrent = this.torrentManager.get().seedTorrent(params);
                        if (torrent != null) {
                            torrentAdded = true;
                            if (torrent.hasMetaData()) {
                                TorrentInfo torrentInfo = torrent.getTorrentInfo();
                                boolean filesOk = true;
                                for (TorrentFileEntry entry : torrentInfo.getTorrentFileEntries()) {
                                    int priority = entry.getPriority();
                                    if (priority <= 0) continue;
                                    File torrentFileEntry = torrent.getTorrentDataFile(entry);
                                    boolean exists = torrentFileEntry.exists();
                                    long fileModifiedTime = torrentFileEntry.lastModified();
                                    if (exists && fileModifiedTime <= mementoModifiedTime) continue;
                                    filesOk = false;
                                    break;
                                }
                                if (filesOk) {
                                    this.createBTUploader(torrent);
                                    torrent.setAutoManaged(true);
                                    torrent.start();
                                    torrentLoaded = true;
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        LOG.error("Error initializing memento from: " + mementoFile, e);
                    }
                }
                if (torrentLoaded) continue;
                this.cleanup(mementoFile, torrentFile, fastResumeFile);
                if (torrent == null || !torrentAdded) continue;
                this.torrentManager.get().removeTorrent(torrent);
            }
        }
    }

    private void cleanup(File mementoFile, File torrentFile, File fastResumeFile) {
        if (torrentFile != null) {
            FileUtils.delete(torrentFile, false);
        }
        if (fastResumeFile != null) {
            FileUtils.delete(fastResumeFile, false);
        }
        if (mementoFile != null) {
            FileUtils.delete(mementoFile, false);
        }
    }

    private Map<String, Object> readMemento(File mementoFile) throws IOException, ClassNotFoundException, IllegalArgumentException {
        Object mementoObject = FileUtils.readObject(mementoFile);
        Map<String, Object> memento = GenericsUtils.scanForMap(mementoObject, String.class, Object.class, GenericsUtils.ScanMode.EXCEPTION);
        return memento;
    }

    public void writeMemento(Torrent torrent) throws IOException {
        File torrentMomento = this.getMementoFile(torrent);
        torrentMomento.getParentFile().mkdirs();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("torrentDataFile", torrent.getTorrentDataFile().getAbsoluteFile());
        map.put("torrentFile", torrent.getTorrentFile().getAbsoluteFile());
        map.put("fastResumeFile", torrent.getFastResumeFile().getAbsoluteFile());
        map.put("sha1", torrent.getSha1());
        map.put("trackerURL", torrent.getTrackerURL());
        map.put("name", torrent.getName());
        FileUtils.writeObject(torrentMomento, map);
    }

    private File getMementoFile(Torrent torrent) {
        File torrentMomento = new File(BittorrentSettings.TORRENT_UPLOADS_FOLDER.get(), torrent.getName() + ".memento");
        return torrentMomento;
    }

    public void removeMemento(Torrent torrent) {
        File torrentMomento = this.getMementoFile(torrent);
        FileUtils.forceDelete(torrentMomento);
        if (torrent.getTorrentFile().getParentFile().equals(BittorrentSettings.TORRENT_UPLOADS_FOLDER.get())) {
            FileUtils.forceDelete(torrent.getTorrentFile());
        }
        if (torrent.getFastResumeFile().getParentFile().equals(BittorrentSettings.TORRENT_UPLOADS_FOLDER.get())) {
            FileUtils.forceDelete(torrent.getFastResumeFile());
        }
    }

    @Override
    public BTUploader createBTUploader(Torrent torrent) {
        BTUploader btUploader = new BTUploader(torrent, this.activityCallback.get(), this, this.torrentManager.get());
        btUploader.registerTorrentListener();
        this.activityCallback.get().addUpload(btUploader);
        return btUploader;
    }
}

