/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSortedSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.settings.LibrarySettings;
import org.limewire.setting.StringArraySetting;
import org.limewire.util.FileUtils;

@Singleton
class CategoryManagerImpl
implements CategoryManager {
    private final Map<InternalCategory, Collection<String>> builtInExtensionMap = new EnumMap<InternalCategory, Collection<String>>(InternalCategory.class);
    private final Map<InternalCategory, AtomicReference<Collection<String>>> extensionMap;
    private final Map<InternalCategory, Predicate<String>> predicateMap;
    private final Map<InternalCategory, StringArraySetting> settingMap;

    CategoryManagerImpl() {
        this.builtInExtensionMap.put(InternalCategory.DOCUMENT, ((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(String.CASE_INSENSITIVE_ORDER).add(new String[]{"123", "abw", "accdb", "accde", "accdr", "accdt", "ans", "asc", "asp", "bdr", "chm", "css", "csv", "dat", "db", "dif", "diz", "doc", "docm", "docx", "dotm", "dotx", "dvi", "eml", "eps", "epsf", "fm", "grv", "gsa", "gts", "hlp", "htm", "html", "idb", "idx", "iif", "info", "js", "jsp", "kfl", "kwd", "latex", "lif", "lit", "log", "man", "mcw", "mht", "mhtml", "mny", "msg", "obi", "odp", "ods", "odt", "ofx", "one", "onepkg", "ost", "pages", "pdf", "php", "pot", "potm", "potx", "pps", "ppsm", "ppsx", "ppt", "pptm", "pptx", "ps", "pub", "qba", "qbb", "qdb", "qbi", "qbm", "qbw", "qbx", "qdf", "qel", "qfp", "qpd", "qph", "qmd", "qsd", "rtf", "scd", "sdc", "sdd", "sdp", "sdw", "shw", "sldx", "sxc", "sxd", "sxp", "sxw", "t01", "t02", "t03", "t04", "t05", "t06", "t07", "t08", "t09", "t98", "t99", "ta0", "ta1", "ta2", "ta3", "ta4", "ta5", "ta6", "ta7", "ta8", "ta9", "tax", "tax2008", "tex", "texi", "toc", "tsv", "tvl", "txf", "txt", "wk1", "wk3", "wk4", "wks", "wp", "wp5", "wpd", "wps", "wri", "xhtml", "xlam", "xls", "xlsb", "xlsm", "xlsx", "xltm", "xltx", "xml", "xsf", "xsn", "qfx", "qif", "bud", "ofc", "pst", "mbf", "mn1", "mn2", "mn3", "mn4", "mn5", "mn6", "mn7", "mn8", "mn9", "m10", "m11", "m12", "m13", "m14", "m15", "m16", "boe", "box", "bri", "cnm", "dbx", "eml", "emlx", "idb", "idx", "maildb", "mbg", "mbs", "mbx", "mht", "msb", "msf", "msg", "nws", "pmi", "pmm", "pmx", "tbb", "toc", "vfb", "zmc", "stw", "odm", "ott", "wpt"})).build());
        this.builtInExtensionMap.put(InternalCategory.AUDIO, ((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(String.CASE_INSENSITIVE_ORDER).add(new String[]{"mp3", "mpa", "mp1", "mpga", "mp2", "ra", "rm", "ram", "rmj", "wma", "wav", "m4a", "m4p", "lqt", "ogg", "med", "aif", "aiff", "aifc", "au", "snd", "s3m", "aud", "mid", "midi", "rmi", "mod", "kar", "ac3", "shn", "fla", "flac", "cda", "mka"})).build());
        this.builtInExtensionMap.put(InternalCategory.VIDEO, ((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(String.CASE_INSENSITIVE_ORDER).add(new String[]{"mpg", "mpeg", "mpe", "mng", "mpv", "m1v", "vob", "mpv2", "mp2v", "m2p", "m2v", "mpgv", "vcd", "mp4", "dv", "dvd", "div", "divx", "dvx", "smi", "smil", "rv", "rmm", "rmvb", "avi", "asf", "asx", "wmv", "qt", "mov", "fli", "flc", "flx", "flv", "wml", "vrml", "swf", "dcr", "jve", "nsv", "mkv", "ogm", "cdg", "srt", "sub", "flv"})).build());
        this.builtInExtensionMap.put(InternalCategory.IMAGE, ((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(String.CASE_INSENSITIVE_ORDER).add(new String[]{"gif", "png", "bmp", "jpg", "jpeg", "jpe", "jif", "jiff", "jfif", "tif", "tiff", "iff", "lbm", "ilbm", "mac", "drw", "pct", "img", "bmp", "dib", "rle", "ico", "ani", "icl", "cur", "emf", "wmf", "pcx", "pcd", "tga", "pic", "fig", "psd", "wpg", "dcx", "cpt", "mic", "pbm", "pnm", "ppm", "xbm", "xpm", "xwd", "sgi", "fax", "rgb", "ras"})).build());
        this.builtInExtensionMap.put(InternalCategory.PROGRAM_OSX_LINUX, ((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(String.CASE_INSENSITIVE_ORDER).add(new String[]{"app", "bin", "mdb", "sh", "csh", "awk", "pl", "rpm", "deb", "gz", "gzip", "z", "bz2", "zoo", "tar", "tgz", "taz", "shar", "hqx", "sit", "dmg", "7z", "jar", "zip", "nrg", "cue", "iso", "jnlp", "rar", "sh"})).build());
        this.builtInExtensionMap.put(InternalCategory.PROGRAM_WINDOWS, ((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(String.CASE_INSENSITIVE_ORDER).add(new String[]{"mdb", "exe", "zip", "jar", "cab", "msi", "msp", "arj", "rar", "ace", "lzh", "lha", "bin", "nrg", "cue", "iso", "jnlp", "bat", "lnk", "vbs"})).build());
        this.extensionMap = new EnumMap<InternalCategory, AtomicReference<Collection<String>>>(InternalCategory.class);
        for (InternalCategory category : InternalCategory.values()) {
            if (category == InternalCategory.OTHER) continue;
            this.extensionMap.put(category, new AtomicReference());
        }
        this.predicateMap = new EnumMap<InternalCategory, Predicate<String>>(InternalCategory.class);
        for (Map.Entry<InternalCategory, AtomicReference<Collection<String>>> entry : this.extensionMap.entrySet()) {
            this.predicateMap.put(entry.getKey(), new CollectionPredicate(entry.getValue()));
        }
        this.predicateMap.put(InternalCategory.OTHER, new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return CategoryManagerImpl.this.getCategoryForExtension(input) == Category.OTHER;
            }
        });
        this.settingMap = new EnumMap<InternalCategory, StringArraySetting>(InternalCategory.class);
        this.settingMap.put(InternalCategory.AUDIO, LibrarySettings.ADDITIONAL_AUDIO_EXTS);
        this.settingMap.put(InternalCategory.DOCUMENT, LibrarySettings.ADDITIONAL_DOCUMENT_EXTS);
        this.settingMap.put(InternalCategory.IMAGE, LibrarySettings.ADDITIONAL_IMAGE_EXTS);
        this.settingMap.put(InternalCategory.PROGRAM_OSX_LINUX, LibrarySettings.ADDITIONAL_PROGRAM_OSX_LINUX_EXTS);
        this.settingMap.put(InternalCategory.PROGRAM_WINDOWS, LibrarySettings.ADDITIONAL_PROGRAM_WINDOWS_EXTS);
        this.settingMap.put(InternalCategory.VIDEO, LibrarySettings.ADDITIONAL_VIDEO_EXTS);
        this.rebuildExtensions();
    }

    @Inject
    void register(SimppManager simppManager) {
        simppManager.addListener(new SimppListener(){

            @Override
            public void simppUpdated() {
                CategoryManagerImpl.this.rebuildExtensions();
            }
        });
    }

    private void rebuildExtensions() {
        for (Map.Entry<InternalCategory, StringArraySetting> entry : this.settingMap.entrySet()) {
            InternalCategory category = entry.getKey();
            StringArraySetting remote = entry.getValue();
            AtomicReference<Collection<String>> combinedMap = this.extensionMap.get((Object)category);
            assert (combinedMap != null && remote != null && category != null);
            combinedMap.set(this.combineAndCleanup(category, remote.get()));
        }
        this.extensionMap.get((Object)InternalCategory.PROGRAM_ALL).set(((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(String.CASE_INSENSITIVE_ORDER).addAll(this.extensionMap.get((Object)InternalCategory.PROGRAM_OSX_LINUX).get())).addAll(this.extensionMap.get((Object)InternalCategory.PROGRAM_WINDOWS).get())).build());
    }

    private Collection<String> combineAndCleanup(InternalCategory category, String[] remote) {
        TreeSet<String> remoteSet = new TreeSet<String>(Arrays.asList(remote));
        for (Collection<String> collection : this.builtInExtensionMap.values()) {
            remoteSet.removeAll(collection);
        }
        for (Map.Entry entry : this.settingMap.entrySet()) {
            if (category.getCategory() == ((InternalCategory)((Object)entry.getKey())).getCategory()) continue;
            remoteSet.removeAll(Arrays.asList(((StringArraySetting)entry.getValue()).get()));
        }
        Collection<String> builtIn = this.builtInExtensionMap.get((Object)category);
        assert (builtIn != null);
        return ((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(String.CASE_INSENSITIVE_ORDER).addAll(builtIn)).addAll(remoteSet)).build();
    }

    @Override
    public Category getCategoryForExtension(String extension) {
        for (Map.Entry<InternalCategory, AtomicReference<Collection<String>>> entry : this.extensionMap.entrySet()) {
            Collection<String> collection = entry.getValue().get();
            if (!collection.contains(extension)) continue;
            return entry.getKey().getCategory();
        }
        return Category.OTHER;
    }

    @Override
    public Category getCategoryForFilename(String filename) {
        String extension = FileUtils.getFileExtension(filename);
        return this.getCategoryForExtension(extension);
    }

    @Override
    public Category getCategoryForFile(File file) {
        String extension = FileUtils.getFileExtension(file);
        return this.getCategoryForExtension(extension);
    }

    @Override
    public Collection<String> getExtensionsForCategory(Category category) {
        AtomicReference<Collection<String>> ref = this.extensionMap.get((Object)InternalCategory.fromCategory(category));
        if (ref != null) {
            return ref.get();
        }
        assert (category == Category.OTHER);
        return Collections.emptySet();
    }

    @Override
    public Predicate<String> getExtensionFilterForCategory(Category category) {
        return this.predicateMap.get((Object)InternalCategory.fromCategory(category));
    }

    @Override
    public Predicate<String> getOsxAndLinuxProgramsFilter() {
        return this.predicateMap.get((Object)InternalCategory.PROGRAM_OSX_LINUX);
    }

    @Override
    public Predicate<String> getWindowsProgramsFilter() {
        return this.predicateMap.get((Object)InternalCategory.PROGRAM_WINDOWS);
    }

    private static final class CollectionPredicate
    implements Predicate<String> {
        private final AtomicReference<Collection<String>> delegate;

        public CollectionPredicate(AtomicReference<Collection<String>> set) {
            this.delegate = set;
        }

        @Override
        public boolean apply(String input) {
            return this.delegate.get().contains(input);
        }
    }

    private static enum InternalCategory {
        AUDIO(Category.AUDIO),
        VIDEO(Category.VIDEO),
        IMAGE(Category.IMAGE),
        DOCUMENT(Category.DOCUMENT),
        PROGRAM_OSX_LINUX(Category.PROGRAM),
        PROGRAM_WINDOWS(Category.PROGRAM),
        PROGRAM_ALL(Category.PROGRAM),
        OTHER(Category.OTHER);

        private final Category category;

        private InternalCategory(Category category) {
            this.category = category;
        }

        Category getCategory() {
            return this.category;
        }

        static InternalCategory fromCategory(Category category) {
            switch (category) {
                case AUDIO: {
                    return AUDIO;
                }
                case DOCUMENT: {
                    return DOCUMENT;
                }
                case IMAGE: {
                    return IMAGE;
                }
                case PROGRAM: {
                    return PROGRAM_ALL;
                }
                case VIDEO: {
                    return VIDEO;
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalArgumentException(category.toString());
        }
    }
}

