/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UniqueHostPinger;
import com.limegroup.gnutella.bootstrap.Bootstrapper;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.util.ClassCNetworks;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.BucketQueue;
import org.limewire.collection.Cancellable;
import org.limewire.collection.FixedSizeSortedList;
import org.limewire.collection.IntSet;
import org.limewire.collection.ListPartitioner;
import org.limewire.collection.RandomAccessMap;
import org.limewire.collection.RandomOrderHashMap;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.Connectable;
import org.limewire.io.GUID;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.util.CommonUtils;

@EagerSingleton
public class HostCatcher
implements Service,
Bootstrapper.Listener {
    private static final Log LOG = LogFactory.getLog(HostCatcher.class);
    static final int GOOD_SIZE = 1000;
    static final int NORMAL_SIZE = 400;
    private static final int GOOD_PRIORITY = 1;
    private static final int NORMAL_PRIORITY = 0;
    private static final int PONG_MASK = -256;
    static final long STALE_HOST_FILE = 1209600000L;
    private static final Comparator<ExtendedEndpoint> DHT_COMPARATOR = new Comparator<ExtendedEndpoint>(){

        @Override
        public int compare(ExtendedEndpoint e1, ExtendedEndpoint e2) {
            DHTManager.DHTMode mode1 = e1.getDHTMode();
            DHTManager.DHTMode mode2 = e2.getDHTMode();
            if (mode1.equals((Object)DHTManager.DHTMode.ACTIVE) && !mode2.equals((Object)DHTManager.DHTMode.ACTIVE) || mode1.equals((Object)DHTManager.DHTMode.PASSIVE) && mode2.equals((Object)DHTManager.DHTMode.INACTIVE)) {
                return -1;
            }
            if (mode2.equals((Object)DHTManager.DHTMode.ACTIVE) && !mode1.equals((Object)DHTManager.DHTMode.ACTIVE) || mode2.equals((Object)DHTManager.DHTMode.PASSIVE) && mode1.equals((Object)DHTManager.DHTMode.INACTIVE)) {
                return 1;
            }
            return 0;
        }
    };
    private final BucketQueue<ExtendedEndpoint> ENDPOINT_QUEUE = new BucketQueue(new int[]{400, 1000});
    private final Map<ExtendedEndpoint, ExtendedEndpoint> ENDPOINT_SET = new HashMap<ExtendedEndpoint, ExtendedEndpoint>();
    private final RandomAccessMap<ExtendedEndpoint, ExtendedEndpoint> FREE_ULTRAPEER_SLOTS_SET = new RandomOrderHashMap<ExtendedEndpoint, ExtendedEndpoint>(200);
    private final RandomAccessMap<ExtendedEndpoint, ExtendedEndpoint> FREE_LEAF_SLOTS_SET = new RandomOrderHashMap<ExtendedEndpoint, ExtendedEndpoint>(200);
    private final Map<String, Set<ExtendedEndpoint>> LOCALE_SET_MAP = new HashMap<String, Set<ExtendedEndpoint>>();
    private static final int LOCALE_SET_SIZE = 100;
    private final FixedSizeSortedList<ExtendedEndpoint> permanentHosts = new FixedSizeSortedList<ExtendedEndpoint>(ExtendedEndpoint.priorityComparator(), 400);
    private final Set<ExtendedEndpoint> permanentHostsSet = new HashSet<ExtendedEndpoint>();
    private boolean dirty = false;
    private final List<ExtendedEndpoint> restoredHosts = new FixedSizeSortedList<ExtendedEndpoint>(ExtendedEndpoint.priorityComparator(), 400);
    private final ListPartitioner<ExtendedEndpoint> uptimePartitions = new ListPartitioner<ExtendedEndpoint>(this.restoredHosts, 3);
    private final Set<Endpoint> EXPIRED_HOSTS = new HashSet<Endpoint>();
    protected static final int EXPIRED_HOSTS_SIZE = 500;
    private final Set<Endpoint> PROBATION_HOSTS = new HashSet<Endpoint>();
    protected static final int PROBATION_HOSTS_SIZE = 500;
    private static long PROBATION_RECOVERY_WAIT_TIME = 60000L;
    private static long PROBATION_RECOVERY_TIME = 60000L;
    private final List<EndpointObserver> _catchersWaiting = new LinkedList<EndpointObserver>();
    private static final long PONG_RANKING_EXPIRE_TIME = 20000L;
    private volatile long lastAllowedPongRankTime = 0L;
    private static final int MAX_CONNECTIONS = 5;
    private final Random RND = new Random();
    private ScheduledFuture probationFuture;
    private ScheduledFuture bootstrapperFuture;
    private ScheduledFuture clearPingedHostsFuture;
    @InspectablePrimitive(value="deleted host file")
    private boolean deletedHostFile = false;
    @InspectablePrimitive(value="restored host file")
    private boolean loadedHostFile = false;
    private final ScheduledExecutorService backgroundExecutor;
    private final ConnectionServices connectionServices;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<UDPService> udpService;
    private final Provider<DHTManager> dhtManager;
    private final Provider<QueryUnicaster> queryUnicaster;
    private final Provider<IPFilter> ipFilter;
    private final UniqueHostPinger uniqueHostPinger;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final Bootstrapper bootstrapper;
    static boolean DEBUG = false;

    @Inject
    protected HostCatcher(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, ConnectionServices connectionServices, Provider<ConnectionManager> connectionManager, Provider<UDPService> udpService, Provider<DHTManager> dhtManager, Provider<QueryUnicaster> queryUnicaster, Provider<IPFilter> ipFilter, UniqueHostPinger uniqueHostPinger, NetworkInstanceUtils networkInstanceUtils, Bootstrapper bootstrapper) {
        this.backgroundExecutor = backgroundExecutor;
        this.connectionServices = connectionServices;
        this.connectionManager = connectionManager;
        this.udpService = udpService;
        this.dhtManager = dhtManager;
        this.queryUnicaster = queryUnicaster;
        this.ipFilter = ipFilter;
        this.uniqueHostPinger = uniqueHostPinger;
        this.networkInstanceUtils = networkInstanceUtils;
        this.bootstrapper = bootstrapper;
    }

    @Override
    public void start() {
        Runnable probationRestorer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList toAdd;
                HostCatcher hostCatcher = HostCatcher.this;
                synchronized (hostCatcher) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Restoring " + HostCatcher.this.PROBATION_HOSTS.size() + " probated hosts");
                    }
                    toAdd = new ArrayList(HostCatcher.this.PROBATION_HOSTS);
                    HostCatcher.this.PROBATION_HOSTS.clear();
                }
                for (Endpoint e : toAdd) {
                    HostCatcher.this.add(e, false);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace(HostCatcher.this.ENDPOINT_SET.size() + " ordinary, " + HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.size() + " UP slots, " + HostCatcher.this.FREE_LEAF_SLOTS_SET.size() + " leaf slots, " + HostCatcher.this.LOCALE_SET_MAP.size() + " locales, " + HostCatcher.this.permanentHostsSet.size() + " permanent, " + HostCatcher.this.restoredHosts.size() + " restored, " + HostCatcher.this.EXPIRED_HOSTS.size() + " expired, " + HostCatcher.this.PROBATION_HOSTS.size() + " on probation, " + HostCatcher.this._catchersWaiting.size() + " waiting");
                }
            }
        };
        this.probationFuture = this.backgroundExecutor.scheduleWithFixedDelay(probationRestorer, PROBATION_RECOVERY_WAIT_TIME, PROBATION_RECOVERY_TIME, TimeUnit.MILLISECONDS);
        this.bootstrapperFuture = this.backgroundExecutor.scheduleWithFixedDelay(this.bootstrapper, 0L, 2000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Peer Locator");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void stop() {
        if (this.probationFuture != null) {
            this.probationFuture.cancel(true);
        }
        if (this.bootstrapperFuture != null) {
            this.bootstrapperFuture.cancel(true);
        }
        if (this.clearPingedHostsFuture != null) {
            this.clearPingedHostsFuture.cancel(true);
        }
        this.write();
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        ArrayList<ExtendedEndpoint> hosts;
        this.lastAllowedPongRankTime = System.currentTimeMillis() + 20000L;
        Runnable clearPingedHosts = new Runnable(){

            @Override
            public void run() {
                HostCatcher.this.uniqueHostPinger.resetData();
            }
        };
        this.clearPingedHostsFuture = this.backgroundExecutor.schedule(clearPingedHosts, 20000L, TimeUnit.MILLISECONDS);
        this.bootstrapper.reset();
        this.read();
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            hosts = new ArrayList<ExtendedEndpoint>(this.ENDPOINT_SET.size() + this.restoredHosts.size());
            hosts.addAll(this.ENDPOINT_SET.keySet());
            hosts.addAll(this.restoredHosts);
        }
        Collections.shuffle(hosts);
        this.rank(hosts);
    }

    private void rank(Collection<? extends IpPort> hosts) {
        if (this.needsPongRanking()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Sending " + hosts.size() + " hosts to pinger");
            }
            this.uniqueHostPinger.rank(hosts, new Cancellable(){

                @Override
                public boolean isCancelled() {
                    return !HostCatcher.this.needsPongRanking();
                }
            });
        }
    }

    public void sendMessageToAllHosts(Message m, MessageListener listener, Cancellable c) {
        this.uniqueHostPinger.rank(this.getAllHosts(), listener, c, m);
    }

    private synchronized Collection<ExtendedEndpoint> getAllHosts() {
        LinkedHashSet<ExtendedEndpoint> hosts = new LinkedHashSet<ExtendedEndpoint>(this.getNumHosts());
        hosts.addAll(this.FREE_ULTRAPEER_SLOTS_SET.keySet());
        hosts.addAll(this.FREE_LEAF_SLOTS_SET.keySet());
        hosts.addAll(this.ENDPOINT_SET.keySet());
        hosts.addAll(this.restoredHosts);
        return hosts;
    }

    public synchronized List<ExtendedEndpoint> getDHTSupportEndpoint(int minVersion) {
        ArrayList<ExtendedEndpoint> hosts = new ArrayList<ExtendedEndpoint>();
        IntSet masked = new IntSet();
        boolean filter = ConnectionSettings.FILTER_CLASS_C.getValue();
        for (ExtendedEndpoint host : this.getAllHosts()) {
            if (!host.supportsDHT() || host.getDHTVersion() < minVersion) continue;
            int ip = NetworkUtils.getMaskedIP(host.getInetAddress(), -256);
            if (filter && !masked.add(ip)) continue;
            hosts.add(host);
        }
        Collections.sort(hosts, DHT_COMPARATOR);
        return hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean needsPongRanking() {
        boolean needsPongRanking;
        int size;
        HostCatcher hostCatcher;
        if (this.connectionServices.isFullyConnected()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Pong ranking not needed - fully connected");
            }
            return false;
        }
        int have = this.connectionManager.get().getInitializedConnections().size();
        if (have >= 5) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Pong ranking not needed - have max connections");
            }
            return false;
        }
        long now = System.currentTimeMillis();
        if (now > this.lastAllowedPongRankTime) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Pong ranking not allowed - last time has passed");
            }
            return false;
        }
        if (this.connectionServices.isSupernode()) {
            hostCatcher = this;
            synchronized (hostCatcher) {
                size = this.FREE_ULTRAPEER_SLOTS_SET.size();
            }
        }
        hostCatcher = this;
        synchronized (hostCatcher) {
            size = this.FREE_LEAF_SLOTS_SET.size();
        }
        int preferred = this.connectionManager.get().getPreferredConnectionCount();
        boolean bl = needsPongRanking = size < preferred - have;
        if (!needsPongRanking) {
            LOG.trace("Pong ranking not needed - have enough hosts to try");
        }
        return needsPongRanking;
    }

    private void read() {
        block2: {
            try {
                this.read(this.getHostsFile());
            }
            catch (IOException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info("Exception reading host file " + this.getHostsFile(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(File hostFile) throws FileNotFoundException, IOException {
        LOG.trace("Reading host file");
        long now = System.currentTimeMillis();
        long lastModified = hostFile.lastModified();
        if (now - lastModified > 1209600000L) {
            if (lastModified > 0L) {
                LOG.info("Deleting stale host file");
                hostFile.delete();
                this.deletedHostFile = true;
            }
            return;
        }
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(hostFile));
            while ((line = in.readLine()) != null) {
                try {
                    ExtendedEndpoint e = ExtendedEndpoint.read(line);
                    if (e.isUDPHostCache()) {
                        this.bootstrapper.addUDPHostCache(e);
                        continue;
                    }
                    if (this.isValidHost(e)) {
                        HostCatcher hostCatcher = this;
                        synchronized (hostCatcher) {
                            this.addPermanent(e);
                            this.restoredHosts.add(e);
                            this.loadedHostFile = true;
                        }
                        this.endpointAdded();
                        continue;
                    }
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("File contains invalid host: " + line);
                }
                catch (ParseException pe) {
                    LOG.info("Exception parsing host file", pe);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                LOG.info("Exception closing host file", e);
            }
        }
    }

    protected void write() {
        block2: {
            try {
                this.write(this.getHostsFile());
            }
            catch (IOException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info("Exception writing host file " + this.getHostsFile(), e);
            }
        }
    }

    protected synchronized void write(File hostFile) throws IOException {
        this.checkInvariants();
        LOG.trace("Writing host file");
        if (this.dirty || this.bootstrapper.isWriteDirty()) {
            FileWriter out = new FileWriter(hostFile);
            this.bootstrapper.write(out);
            for (ExtendedEndpoint e : this.permanentHosts) {
                e.write(out);
            }
            out.close();
        }
    }

    private File getHostsFile() {
        return new File(CommonUtils.getUserSettingsDir(), "gnutella.net");
    }

    public boolean add(PingReply pr) {
        ExtendedEndpoint ee;
        GUID g;
        byte[] source;
        boolean isLocalOrPrivate;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Pong from " + pr.getAddress() + ":" + pr.getPort());
        }
        boolean bl = isLocalOrPrivate = this.networkInstanceUtils.isVeryCloseIP(source = pr.getInetAddress().getAddress()) || this.networkInstanceUtils.isPrivateAddress(source);
        if (pr.isUDP() && !isLocalOrPrivate && !(g = new GUID(pr.getGUID())).equals(PingRequest.UDP_GUID) && !g.equals(this.udpService.get().getSolicitedGUID())) {
            LOG.info("Discarding UDP pong with unknown GUID");
            return false;
        }
        ExtendedEndpoint endpoint = pr.getDailyUptime() != -1 ? new ExtendedEndpoint(pr.getAddress(), pr.getPort(), pr.getDailyUptime()) : new ExtendedEndpoint(pr.getAddress(), pr.getPort());
        if (!pr.getClientLocale().equals("")) {
            endpoint.setClientLocale(pr.getClientLocale());
        }
        if (pr.isUDPHostCache()) {
            endpoint.setHostname(pr.getUDPCacheAddress());
            endpoint.setUDPHostCache(true);
        }
        if (pr.isTLSCapable()) {
            endpoint.setTLSCapable(true);
        }
        if (!this.isValidHost(endpoint) && !isLocalOrPrivate) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Discarding pong from invalid host " + endpoint);
            }
            return false;
        }
        Collection<IpPort> packed = pr.getPackedIPPorts();
        if (ConnectionSettings.FILTER_CLASS_C.getValue()) {
            packed = NetworkUtils.filterOnePerClassC(packed);
        }
        if (LOG.isTraceEnabled() && !packed.isEmpty()) {
            LOG.trace("Pong contains " + packed.size() + " packed endpoints");
        }
        HashSet<ExtendedEndpoint> valid = new HashSet<ExtendedEndpoint>();
        boolean addedPacked = false;
        for (IpPort ipp : packed) {
            if (ipp instanceof ExtendedEndpoint) {
                ee = (ExtendedEndpoint)ipp;
            } else {
                ee = new ExtendedEndpoint(ipp.getAddress(), ipp.getPort());
                if (ipp instanceof Connectable) {
                    ee.setTLSCapable(((Connectable)ipp).isTLSCapable());
                }
            }
            if (this.isValidHost(ee)) {
                addedPacked |= this.add(ee, 1);
                valid.add(ee);
                continue;
            }
            if (!LOG.isInfoEnabled()) continue;
            LOG.info("Not adding invalid host " + ee);
        }
        if (!valid.isEmpty()) {
            this.rank(valid);
        }
        packed = pr.getPackedUDPHostCaches();
        if (LOG.isTraceEnabled() && !packed.isEmpty()) {
            LOG.trace("Pong contains " + packed.size() + " packed UHCs");
        }
        for (IpPort ipp : packed) {
            ee = new ExtendedEndpoint(ipp.getAddress(), ipp.getPort());
            ee.setUDPHostCache(true);
            if (!this.isValidHost(ee)) continue;
            this.bootstrapper.addUDPHostCache(ee);
        }
        if (!this.isValidHost(endpoint)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Not adding invalid host " + endpoint);
            }
            return addedPacked;
        }
        if (endpoint.isUDPHostCache()) {
            LOG.trace("Adding host as UHC");
            return this.bootstrapper.addUDPHostCache(endpoint) || addedPacked;
        }
        int dhtVersion = pr.getDHTVersion();
        if (dhtVersion > -1) {
            DHTManager.DHTMode mode = pr.getDHTMode();
            endpoint.setDHTVersion(dhtVersion);
            endpoint.setDHTMode(mode);
            if (this.dhtManager.get().isRunning()) {
                InetSocketAddress address;
                if (mode.equals((Object)DHTManager.DHTMode.ACTIVE)) {
                    address = new InetSocketAddress(endpoint.getAddress(), endpoint.getPort());
                    this.dhtManager.get().addActiveDHTNode(address);
                } else if (mode.equals((Object)DHTManager.DHTMode.PASSIVE)) {
                    address = new InetSocketAddress(endpoint.getAddress(), endpoint.getPort());
                    this.dhtManager.get().addPassiveDHTNode(address);
                }
            }
        }
        if (pr.supportsUnicast()) {
            this.queryUnicaster.get().addUnicastEndpoint(pr.getInetAddress(), pr.getPort());
        }
        boolean addedSource = false;
        if (pr.isUltrapeer()) {
            if (pr.hasFreeLeafSlots()) {
                LOG.trace("Adding host to free leaf slot set");
                this.addToFreeSlotSet(endpoint, this.FREE_LEAF_SLOTS_SET);
                addedSource = true;
            }
            String myLocale = ApplicationSettings.LANGUAGE.get();
            if (pr.hasFreeUltrapeerSlots() || myLocale.equals(pr.getClientLocale()) && pr.getNumFreeLocaleSlots() > 0) {
                LOG.trace("Adding host to free UP slot set");
                this.addToFreeSlotSet(endpoint, this.FREE_ULTRAPEER_SLOTS_SET);
                addedSource = true;
            }
            if (!addedSource) {
                LOG.trace("Adding host with good priority");
                addedSource = this.add(endpoint, 1);
            }
        } else {
            LOG.trace("Adding host with normal priority");
            addedSource = this.add(endpoint, 0);
        }
        return addedPacked || addedSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFreeSlotSet(ExtendedEndpoint host, Map<? super ExtendedEndpoint, ? super ExtendedEndpoint> hosts) {
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            hosts.put(host, host);
            this.addPermanent(host);
        }
        this.endpointAdded();
    }

    private void addToLocaleMap(ExtendedEndpoint ee) {
        String locale = ee.getClientLocale();
        Set<ExtendedEndpoint> s = this.LOCALE_SET_MAP.get(locale);
        if (s == null) {
            s = new HashSet<ExtendedEndpoint>();
            this.LOCALE_SET_MAP.put(locale, s);
        }
        s.add(ee);
        if (s.size() > 100) {
            s.remove(s.iterator().next());
        }
    }

    public int add(Collection<? extends Endpoint> endpoints) {
        this.rank(endpoints);
        int added = 0;
        for (Endpoint endpoint : endpoints) {
            if (!this.add(endpoint, true)) continue;
            ++added;
        }
        return added;
    }

    public boolean add(Endpoint e, boolean forceHighPriority) {
        if (!this.isValidHost(e)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Not adding invalid host " + e);
            }
            return false;
        }
        if (forceHighPriority) {
            return this.add(e, 1);
        }
        return this.add(e, 0);
    }

    public boolean add(Endpoint e, boolean forceHighPriority, String locale) {
        if (!this.isValidHost(e)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Not adding invalid host " + e);
            }
            return false;
        }
        if (forceHighPriority) {
            return this.add(new ExtendedEndpoint(e.getAddress(), e.getPort(), locale), 1);
        }
        return this.add(new ExtendedEndpoint(e.getAddress(), e.getPort(), locale), 0);
    }

    private boolean add(Endpoint host, int priority) {
        if (host instanceof ExtendedEndpoint) {
            return this.add((ExtendedEndpoint)host, priority);
        }
        return this.add(new ExtendedEndpoint(host.getAddress(), host.getPort()), priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(ExtendedEndpoint e, int priority) {
        this.checkInvariants();
        if (e.isUDPHostCache()) {
            LOG.trace("Adding host as UHC");
            return this.bootstrapper.addUDPHostCache(e);
        }
        boolean added = false;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            this.addPermanent(e);
            if (this.ENDPOINT_SET.containsKey(e)) {
                LOG.trace("Not adding duplicate host");
                return false;
            }
            ExtendedEndpoint removed = this.ENDPOINT_QUEUE.insert(e, priority);
            if (removed != e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Adding host " + e);
                }
                this.ENDPOINT_SET.put(e, e);
                if (removed != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Ejected host " + removed);
                    }
                    this.ENDPOINT_SET.remove(removed);
                }
                added = true;
            }
        }
        if (added) {
            this.endpointAdded();
        }
        this.checkInvariants();
        return added;
    }

    private boolean addPermanent(ExtendedEndpoint e) {
        if (this.networkInstanceUtils.isPrivateAddress(e.getInetAddress())) {
            LOG.trace("Not permanently adding host with private address");
            return false;
        }
        if (this.permanentHostsSet.contains(e)) {
            LOG.trace("Not permanently adding duplicate host");
            return false;
        }
        this.addToLocaleMap(e);
        ExtendedEndpoint removed = this.permanentHosts.insert(e);
        if (removed != e) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Permanently adding host " + e);
            }
            this.permanentHostsSet.add(e);
            if (removed != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Ejected permanent host " + removed);
                }
                this.permanentHostsSet.remove(removed);
            }
            this.dirty = true;
            return true;
        }
        LOG.trace("Not permanently adding host with low uptime");
        return false;
    }

    private boolean removePermanent(ExtendedEndpoint e) {
        boolean removed1 = this.permanentHosts.remove(e);
        boolean removed2 = this.permanentHostsSet.remove(e);
        assert (removed1 == removed2) : "Queue " + removed1 + " but set " + removed2;
        if (removed1) {
            this.dirty = true;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Removed permanent host " + e);
            }
        }
        return removed1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidHost(Endpoint host) {
        byte[] addr;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Validating host " + host);
        }
        try {
            addr = host.getHostBytes();
        }
        catch (UnknownHostException uhe) {
            LOG.trace("Host is invalid: unknown host");
            return false;
        }
        if (this.networkInstanceUtils.isPrivateAddress(addr)) {
            LOG.trace("Host is invalid: private address");
            return false;
        }
        if (this.networkInstanceUtils.isMe(addr, host.getPort())) {
            LOG.trace("Host is invalid: own address");
            return false;
        }
        if (!this.ipFilter.get().allow(addr)) {
            LOG.trace("Host is invalid: blacklisted");
            return false;
        }
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (this.EXPIRED_HOSTS.contains(host)) {
                LOG.trace("Host is invalid: expired");
                return false;
            }
            if (this.PROBATION_HOSTS.contains(host)) {
                LOG.trace("Host is invalid: on probation");
                return false;
            }
        }
        LOG.trace("Host is valid");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHostTLSCapable(IpPort ipp) {
        ExtendedEndpoint ee;
        if (ipp instanceof Connectable) {
            boolean capable = ((Connectable)ipp).isTLSCapable();
            if (LOG.isTraceEnabled()) {
                LOG.trace(ipp + (capable ? " is" : " is not") + " TLS capable");
            }
            return capable;
        }
        Endpoint p = new Endpoint(ipp.getAddress(), ipp.getPort());
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            ee = this.ENDPOINT_SET.get(p);
            if (ee == null) {
                ee = (ExtendedEndpoint)this.FREE_ULTRAPEER_SLOTS_SET.get(p);
            }
            if (ee == null) {
                ee = (ExtendedEndpoint)this.FREE_LEAF_SLOTS_SET.get(p);
            }
        }
        if (ee == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(ipp + " is not known to be TLS capable");
            }
            return false;
        }
        boolean capable = ee.isTLSCapable();
        if (LOG.isTraceEnabled()) {
            LOG.trace(ipp + (capable ? " is" : " is not") + " TLS capable");
        }
        return capable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endpointAdded() {
        EndpointObserver observer;
        ExtendedEndpoint p;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (this._catchersWaiting.isEmpty()) {
                LOG.trace("No observers waiting");
                return;
            }
            p = this.getAnEndpointInternal();
            if (p == null) {
                LOG.trace("No hosts available");
                return;
            }
            observer = this._catchersWaiting.remove(0);
        }
        LOG.trace("Returning a host to a waiting observer");
        observer.handleEndpoint(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAnEndpoint(EndpointObserver observer) {
        ExtendedEndpoint p;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            p = this.getAnEndpointInternal();
            if (p == null) {
                LOG.trace("Couldn't get a host immediately; waiting");
                this._catchersWaiting.add(observer);
            }
        }
        if (p != null) {
            observer.handleEndpoint(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getAnEndpointImmediate(EndpointObserver observer) {
        ExtendedEndpoint p;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            p = this.getAnEndpointInternal();
            if (p == null && observer != null) {
                LOG.trace("Couldn't get a host immediately; waiting");
                this._catchersWaiting.add(observer);
            }
        }
        return p;
    }

    public synchronized void removeEndpointObserver(EndpointObserver observer) {
        LOG.trace("Removing waiting observer");
        this._catchersWaiting.remove(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Endpoint getAnEndpoint() throws InterruptedException {
        BlockingObserver observer = new BlockingObserver();
        this.getAnEndpoint(observer);
        try {
            BlockingObserver blockingObserver = observer;
            synchronized (blockingObserver) {
                if (observer.getEndpoint() == null) {
                    observer.wait();
                }
                return observer.getEndpoint();
            }
        }
        catch (InterruptedException ie) {
            HostCatcher hostCatcher = this;
            synchronized (hostCatcher) {
                LOG.trace("Removing waiting observer");
                this._catchersWaiting.remove(observer);
                throw ie;
            }
        }
    }

    public synchronized void doneWithConnect(Endpoint e, boolean success) {
        if (!(e instanceof ExtendedEndpoint)) {
            LOG.warn("Endpoint in doneWithConnect() is not ExtendedEndpoint");
            return;
        }
        ExtendedEndpoint ee = (ExtendedEndpoint)e;
        this.removePermanent(ee);
        if (success) {
            ee.recordConnectionSuccess();
        } else {
            ee.recordConnectionFailure();
        }
        this.addPermanent(ee);
    }

    protected ExtendedEndpoint getAnEndpointInternal() {
        if (this.connectionServices.isSupernode()) {
            if (!this.FREE_ULTRAPEER_SLOTS_SET.isEmpty()) {
                LOG.trace("UP: returning host with free UP slots");
                return this.preferenceWithLocale(this.FREE_ULTRAPEER_SLOTS_SET);
            }
            if (!this.FREE_LEAF_SLOTS_SET.isEmpty()) {
                LOG.trace("UP: returning host with free leaf slots");
                return this.preferenceWithLocale(this.FREE_LEAF_SLOTS_SET);
            }
        } else {
            if (!this.FREE_LEAF_SLOTS_SET.isEmpty()) {
                LOG.trace("Returning host with free leaf slots");
                return this.preferenceWithLocale(this.FREE_LEAF_SLOTS_SET);
            }
            if (!this.FREE_ULTRAPEER_SLOTS_SET.isEmpty()) {
                LOG.trace("Returning host with free UP slots");
                return this.preferenceWithLocale(this.FREE_ULTRAPEER_SLOTS_SET);
            }
        }
        if (!this.ENDPOINT_QUEUE.isEmpty()) {
            LOG.trace("Returning ordinary host");
            ExtendedEndpoint removed1 = this.ENDPOINT_QUEUE.extractMax();
            ExtendedEndpoint removed2 = this.ENDPOINT_SET.remove(removed1);
            assert (removed1 == removed2) : "Invariant for HostCatcher broken";
            return removed1;
        }
        if (!this.restoredHosts.isEmpty()) {
            LOG.trace("Returning restored host with high uptime");
            List<ExtendedEndpoint> best = this.uptimePartitions.getLastPartition();
            ExtendedEndpoint ee = best.remove((int)(Math.random() * (double)best.size()));
            return ee;
        }
        LOG.trace("No hosts to return");
        return null;
    }

    private ExtendedEndpoint preferenceWithLocale(RandomAccessMap<ExtendedEndpoint, ExtendedEndpoint> base) {
        String loc = ApplicationSettings.LANGUAGE.get();
        ExtendedEndpoint ret = null;
        if (!this.connectionManager.get().isLocaleMatched() && this.LOCALE_SET_MAP.containsKey(loc)) {
            Set<ExtendedEndpoint> locales = this.LOCALE_SET_MAP.get(loc);
            for (ExtendedEndpoint e : base.keySet()) {
                if (!locales.contains(e)) continue;
                LOG.trace("Found a host with matching locale");
                locales.remove(e);
                ret = e;
                break;
            }
        }
        if (ret == null) {
            LOG.trace("Did not find a host with matching locale");
            ret = base.getKeyAt(this.RND.nextInt(base.size()));
        }
        Object removed = base.remove(ret);
        assert (ret == removed) : "Key: " + ret + ", value: " + removed;
        return ret;
    }

    public synchronized int getNumHosts() {
        int hosts = this.ENDPOINT_QUEUE.size() + this.FREE_LEAF_SLOTS_SET.size() + this.FREE_ULTRAPEER_SLOTS_SET.size() + this.restoredHosts.size();
        if (LOG.isTraceEnabled()) {
            LOG.trace(hosts + " hosts");
        }
        return hosts;
    }

    protected synchronized int getNumUltrapeerHosts() {
        return this.ENDPOINT_QUEUE.size(1) + this.FREE_LEAF_SLOTS_SET.size() + this.FREE_ULTRAPEER_SLOTS_SET.size();
    }

    protected Iterator<ExtendedEndpoint> getPermanentHosts() {
        return this.permanentHosts.iterator();
    }

    public synchronized Collection<IpPort> getUltrapeersWithFreeUltrapeerSlots(String locale, int num) {
        return this.getPreferencedCollection(this.FREE_ULTRAPEER_SLOTS_SET, locale, num);
    }

    public synchronized Collection<IpPort> getUltrapeersWithFreeLeafSlots(String locale, int num) {
        return this.getPreferencedCollection(this.FREE_LEAF_SLOTS_SET, locale, num);
    }

    private Collection<IpPort> getPreferencedCollection(Map<? extends ExtendedEndpoint, ? extends ExtendedEndpoint> base, String loc, int num) {
        int ip;
        if (loc == null || loc.equals("")) {
            loc = ApplicationSettings.DEFAULT_LOCALE.get();
        }
        HashSet<IpPort> hosts = new HashSet<IpPort>(num);
        IntSet masked = new IntSet();
        Set<ExtendedEndpoint> locales = this.LOCALE_SET_MAP.get(loc);
        boolean filter = ConnectionSettings.FILTER_CLASS_C.getValue();
        if (locales != null) {
            for (ExtendedEndpoint extendedEndpoint : locales) {
                if (hosts.size() >= num) break;
                if (!base.containsKey(extendedEndpoint)) continue;
                ip = NetworkUtils.getMaskedIP(extendedEndpoint.getInetAddress(), -256);
                if (filter && !masked.add(ip)) continue;
                hosts.add(extendedEndpoint);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found " + hosts.size() + " locale-matched hosts");
            }
        }
        for (ExtendedEndpoint extendedEndpoint : base.keySet()) {
            if (hosts.size() >= num) break;
            ip = NetworkUtils.getMaskedIP(extendedEndpoint.getInetAddress(), -256);
            if (filter && !masked.add(ip)) continue;
            hosts.add(extendedEndpoint);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Found " + hosts.size() + " hosts");
        }
        return hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noInternetConnection() {
        LOG.trace("Resetting failures caused by no internet connection");
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            this.PROBATION_HOSTS.clear();
            this.EXPIRED_HOSTS.clear();
            this.bootstrapper.reset();
            this.restoredHosts.clear();
            this.uniqueHostPinger.resetData();
        }
        this.read();
    }

    public synchronized void reset() {
        LOG.trace("Clearing hosts");
        this.FREE_LEAF_SLOTS_SET.clear();
        this.FREE_ULTRAPEER_SLOTS_SET.clear();
        this.LOCALE_SET_MAP.clear();
        this.ENDPOINT_QUEUE.clear();
        this.ENDPOINT_SET.clear();
        this.restoredHosts.clear();
        this.PROBATION_HOSTS.clear();
        this.EXPIRED_HOSTS.clear();
        this.permanentHosts.clear();
        this.permanentHostsSet.clear();
        this.bootstrapper.reset();
        this.uniqueHostPinger.resetData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInvariants() {
        if (DEBUG) {
            HostCatcher hostCatcher = this;
            synchronized (hostCatcher) {
                for (ExtendedEndpoint ee : this.ENDPOINT_QUEUE) {
                    assert (this.ENDPOINT_SET.containsKey(ee));
                }
                assert (this.ENDPOINT_QUEUE.size() == this.ENDPOINT_SET.size());
                for (ExtendedEndpoint ee : this.permanentHosts) {
                    assert (this.permanentHostsSet.contains(ee));
                }
                assert (this.permanentHosts.size() == this.permanentHostsSet.size());
            }
        }
    }

    public synchronized void putHostOnProbation(Endpoint host) {
        LOG.trace("Putting a host on probation");
        this.PROBATION_HOSTS.add(host);
        if (this.PROBATION_HOSTS.size() > 500) {
            this.PROBATION_HOSTS.remove(this.PROBATION_HOSTS.iterator().next());
        }
    }

    public synchronized void expireHost(Endpoint host) {
        LOG.trace("Expiring a host");
        this.EXPIRED_HOSTS.add(host);
        if (this.EXPIRED_HOSTS.size() > 500) {
            this.EXPIRED_HOSTS.remove(this.EXPIRED_HOSTS.iterator().next());
        }
    }

    @Override
    public boolean needsHosts() {
        return this.getNumHosts() == 0;
    }

    @Override
    public int handleHosts(Collection<? extends Endpoint> hosts) {
        return this.add(hosts);
    }

    @InspectableContainer
    private class HCInspectables {
        @InspectionPoint(value="known hosts by class C")
        public final Inspectable top10classC = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object inspect() {
                HashMap<String, Object> ret = new HashMap<String, Object>();
                ret.put("ver", 1);
                ClassCNetworks permanent = new ClassCNetworks();
                ClassCNetworks restored = new ClassCNetworks();
                ClassCNetworks freeLeaf = new ClassCNetworks();
                ClassCNetworks freeUp = new ClassCNetworks();
                ClassCNetworks all = new ClassCNetworks();
                HostCatcher hostCatcher = HostCatcher.this;
                synchronized (hostCatcher) {
                    IpPortSet everybody = new IpPortSet();
                    everybody.addAll(HostCatcher.this.permanentHostsSet);
                    everybody.addAll(HostCatcher.this.restoredHosts);
                    everybody.addAll(HostCatcher.this.FREE_LEAF_SLOTS_SET.keySet());
                    everybody.addAll(HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.keySet());
                    everybody.addAll(HostCatcher.this.ENDPOINT_SET.keySet());
                    for (IpPort ip : HostCatcher.this.permanentHostsSet) {
                        permanent.add(ip.getInetAddress(), 1);
                    }
                    for (IpPort ip : HostCatcher.this.restoredHosts) {
                        restored.add(ip.getInetAddress(), 1);
                    }
                    for (IpPort ip : HostCatcher.this.FREE_LEAF_SLOTS_SET.keySet()) {
                        freeLeaf.add(ip.getInetAddress(), 1);
                    }
                    for (IpPort ip : HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.keySet()) {
                        freeUp.add(ip.getInetAddress(), 1);
                    }
                    for (IpPort ip : everybody) {
                        all.add(ip.getInetAddress(), 1);
                    }
                }
                ret.put("perm", permanent.getTopInspectable(10));
                ret.put("rest", restored.getTopInspectable(10));
                ret.put("fl", freeLeaf.getTopInspectable(10));
                ret.put("fu", freeUp.getTopInspectable(10));
                ret.put("all", all.getTopInspectable(10));
                return ret;
            }
        };
        @InspectionPoint(value="tls stats of known hosts")
        public final Inspectable tlsStats = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object inspect() {
                int futls;
                int fltls;
                int resttls;
                int permtls;
                int fu;
                int fl;
                int rest;
                int perm;
                HashMap<String, Integer> ret = new HashMap<String, Integer>();
                ret.put("ver", 1);
                HostCatcher hostCatcher = HostCatcher.this;
                synchronized (hostCatcher) {
                    perm = HostCatcher.this.permanentHostsSet.size();
                    rest = HostCatcher.this.restoredHosts.size();
                    fl = HostCatcher.this.FREE_LEAF_SLOTS_SET.size();
                    fu = HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.size();
                    permtls = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.permanentHostsSet) {
                        permtls += e.isTLSCapable() ? 1 : 0;
                    }
                    resttls = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.restoredHosts) {
                        resttls += e.isTLSCapable() ? 1 : 0;
                    }
                    fltls = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.FREE_LEAF_SLOTS_SET.keySet()) {
                        fltls += e.isTLSCapable() ? 1 : 0;
                    }
                    futls = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.keySet()) {
                        futls += e.isTLSCapable() ? 1 : 0;
                    }
                }
                ret.put("perm", perm);
                ret.put("permtls", permtls);
                ret.put("rest", rest);
                ret.put("resttls", resttls);
                ret.put("fl", fl);
                ret.put("fltls", fltls);
                ret.put("fu", fu);
                ret.put("futls", futls);
                return ret;
            }
        };
        @InspectionPoint(value="dht stats of known hosts")
        public final Inspectable dhtStats = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object inspect() {
                int fudht;
                int fldht;
                int restdht;
                int permdht;
                int fu;
                int fl;
                int rest;
                int perm;
                HashMap<String, Integer> ret = new HashMap<String, Integer>();
                ret.put("ver", 1);
                HostCatcher hostCatcher = HostCatcher.this;
                synchronized (hostCatcher) {
                    perm = HostCatcher.this.permanentHostsSet.size();
                    rest = HostCatcher.this.restoredHosts.size();
                    fl = HostCatcher.this.FREE_LEAF_SLOTS_SET.size();
                    fu = HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.size();
                    permdht = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.permanentHostsSet) {
                        permdht += e.supportsDHT() ? 1 : 0;
                    }
                    restdht = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.restoredHosts) {
                        restdht += e.supportsDHT() ? 1 : 0;
                    }
                    fldht = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.FREE_LEAF_SLOTS_SET.keySet()) {
                        fldht += e.supportsDHT() ? 1 : 0;
                    }
                    fudht = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.keySet()) {
                        fudht += e.supportsDHT() ? 1 : 0;
                    }
                }
                ret.put("perm", perm);
                ret.put("permdht", permdht);
                ret.put("rest", rest);
                ret.put("restdht", restdht);
                ret.put("fl", fl);
                ret.put("fldht", fldht);
                ret.put("fu", fu);
                ret.put("fudht", fudht);
                return ret;
            }
        };

        private HCInspectables() {
        }
    }

    private static class BlockingObserver
    implements EndpointObserver {
        private Endpoint endpoint;

        private BlockingObserver() {
        }

        @Override
        public synchronized void handleEndpoint(Endpoint p) {
            this.endpoint = p;
            this.notify();
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }
    }

    public static interface EndpointObserver {
        public void handleEndpoint(Endpoint var1);
    }
}

