/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.ConnectionStats;
import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.connection.OutputRunner;
import com.limegroup.gnutella.connection.SentMessageHandler;
import com.limegroup.gnutella.messages.Message;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.limewire.io.ByteBufferOutputStream;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;

public class MessageWriter
implements ChannelWriter,
OutputRunner {
    private final MessageQueue queue;
    private final ByteBufferOutputStream out;
    private final ConnectionStats stats;
    private final SentMessageHandler sendHandler;
    private InterestWritableByteChannel channel;
    private boolean flipped = false;
    private boolean shutdown = false;
    private Message message;

    public MessageWriter(ConnectionStats stats, MessageQueue queue, SentMessageHandler sendHandler) {
        this(stats, queue, sendHandler, null);
    }

    public MessageWriter(ConnectionStats stats, MessageQueue queue, SentMessageHandler sendHandler, InterestWritableByteChannel sink) {
        this.stats = stats;
        this.queue = queue;
        this.sendHandler = sendHandler;
        this.channel = sink;
        this.out = new ByteBufferOutputStream();
    }

    @Override
    public synchronized InterestWritableByteChannel getWriteChannel() {
        return this.channel;
    }

    @Override
    public synchronized void setWriteChannel(InterestWritableByteChannel channel) {
        this.channel = channel;
        channel.interestWrite(this, true);
    }

    @Override
    public synchronized void send(Message m) {
        if (this.shutdown) {
            return;
        }
        this.stats.addSent(m);
        this.queue.add(m);
        int dropped = this.queue.resetDropped();
        this.stats.addSentDropped(dropped);
        if (this.channel != null) {
            this.channel.interestWrite(this, true);
        }
    }

    @Override
    public synchronized boolean handleWrite() throws IOException {
        if (this.channel == null) {
            throw new IllegalStateException("writing with no source.");
        }
        if (this.writeRemaining()) {
            return true;
        }
        if (this.message != null) {
            this.sendHandler.processSentMessage(this.message);
            this.message = null;
        }
        while (true) {
            Message m = this.queue.removeNext();
            int dropped = this.queue.resetDropped();
            this.stats.addSentDropped(dropped);
            if (m == null) {
                this.channel.interestWrite(this, false);
                return false;
            }
            m.writeQuickly(this.out);
            if (this.writeRemaining()) {
                this.message = m;
                return true;
            }
            this.sendHandler.processSentMessage(m);
            this.message = null;
        }
    }

    private boolean writeRemaining() throws IOException {
        if (this.shutdown) {
            throw new IOException("connection shut down.");
        }
        ByteBuffer buffer = this.out.getBuffer();
        if (this.flipped || buffer.position() > 0) {
            if (!this.flipped) {
                buffer.flip();
                this.flipped = true;
            }
            this.channel.write(buffer);
            if (buffer.hasRemaining()) {
                return true;
            }
            this.flipped = false;
            buffer.clear();
        }
        return false;
    }

    @Override
    public synchronized void shutdown() {
        this.shutdown = true;
    }

    @Override
    public void handleIOException(IOException x) {
        throw new RuntimeException("Unsupported", x);
    }

    @Override
    public Object inspect() {
        return this.queue.getDroppedStats();
    }
}

