/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.daap;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.daap.LimeDaapServerNIO;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.FileViewChangeEvent;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.library.IncompleteFileDesc;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.LibraryStatusEvent;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import de.kapsi.net.daap.AutoCommitTransaction;
import de.kapsi.net.daap.DaapAuthenticator;
import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapFilter;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapStreamSource;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.Database;
import de.kapsi.net.daap.Playlist;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.Transaction;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.core.settings.DaapSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.lifecycle.Asynchronous;
import org.limewire.lifecycle.Join;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.lifecycle.ServiceStage;
import org.limewire.listener.EventListener;
import org.limewire.service.MessageService;
import org.limewire.util.FileUtils;

@EagerSingleton
public class DaapManager {
    private static final Log LOG = LogFactory.getLog(DaapManager.class);
    private final ScheduledExecutorService backgroundExecutor;
    private final Library coreLibrary;
    private final FileView gnutellaFileView;
    private final Provider<IPFilter> ipFilter;
    private final Provider<NetworkInstanceUtils> networkInstanceUtils;
    private final Provider<ActivityCallback> activityCallback;
    private static final ExecutorService DAAP_EVENT_QUEUE = ExecutorsHelper.newProcessingQueue("DAAPQUEUE");
    private de.kapsi.net.daap.Library library;
    private Database database;
    private Playlist masterPlaylist;
    private Playlist whatsNew;
    private Playlist creativecommons;
    private Playlist videos;
    private DaapServer server;
    private BonjourService bonjour;
    private AutoCommitTransaction autoCommitTxn;
    private boolean enabled = false;
    private int maxPlaylistSize;
    private Map<URN, Song> urnToSong;

    @Inject
    public DaapManager(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<IPFilter> ipFilter, Provider<NetworkInstanceUtils> networkInstanceUtils, Provider<ActivityCallback> activityCallback, @GnutellaFiles FileView gnutellaFileView, Library coreLibrary) {
        this.backgroundExecutor = backgroundExecutor;
        this.coreLibrary = coreLibrary;
        this.ipFilter = ipFilter;
        this.networkInstanceUtils = networkInstanceUtils;
        this.activityCallback = activityCallback;
        this.gnutellaFileView = gnutellaFileView;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(new Service(){

            @Override
            @Asynchronous(join=Join.NONE)
            public void start() {
                if (DaapSettings.DAAP_ENABLED.getValue()) {
                    try {
                        DaapManager.this.start();
                    }
                    catch (IOException err) {
                        LOG.debug("error starting DAAP", err);
                        MessageService.showError(I18nMarker.marktr("LimeWire was unable to start the Digital Audio Access Protocol Service (for sharing files in iTunes). This feature will be turned off. You can turn it back on in options, under Advanced -> Files -> iTunes."));
                        DaapSettings.DAAP_ENABLED.setValue(false);
                    }
                }
            }

            @Override
            @Asynchronous(daemon=false)
            public void stop() {
                DaapManager.this.stop();
            }

            @Override
            public void initialize() {
                DaapManager.this.coreLibrary.addManagedListStatusListener(new EventListener<LibraryStatusEvent>(){

                    @Override
                    public void handleEvent(LibraryStatusEvent event) {
                        DaapManager.this.handleManagedListStatusEvent(event);
                    }
                });
                DaapManager.this.gnutellaFileView.addListener(new EventListener<FileViewChangeEvent>(){

                    @Override
                    public void handleEvent(FileViewChangeEvent event) {
                        DaapManager.this.handleFileListEvent(event);
                    }
                });
            }

            @Override
            public String getServiceName() {
                return "DAAP";
            }
        }).in(ServiceStage.VERY_LATE);
    }

    public synchronized void start() throws IOException {
        if (!this.isServerRunning()) {
            try {
                InetAddress addr = NetworkUtils.getLocalAddress();
                this.bonjour = new BonjourService(addr);
                this.urnToSong = new HashMap<URN, Song>();
                this.maxPlaylistSize = DaapSettings.DAAP_MAX_LIBRARY_SIZE.getValue();
                String name = DaapSettings.DAAP_LIBRARY_NAME.get();
                this.library = new de.kapsi.net.daap.Library(name);
                this.autoCommitTxn = new AutoCommitTransaction(this.library);
                this.database = new Database(name);
                this.whatsNew = new Playlist(this.activityCallback.get().translate(I18nMarker.marktr("What's New")));
                this.creativecommons = new Playlist(this.activityCallback.get().translate(I18nMarker.marktr("Creative Commons")));
                this.videos = new Playlist(this.activityCallback.get().translate(I18nMarker.marktr("Video")));
                this.library.addDatabase(null, this.database);
                this.database.addPlaylist(null, this.creativecommons);
                this.database.addPlaylist(null, this.whatsNew);
                this.creativecommons.setSmartPlaylist(null, true);
                this.whatsNew.setSmartPlaylist(null, true);
                this.masterPlaylist = this.database.getMasterPlaylist();
                LimeConfig config = new LimeConfig(addr);
                if (DaapSettings.DAAP_REQUIRES_PASSWORD.getValue()) {
                    if (DaapSettings.DAAP_REQUIRES_USERNAME.getValue()) {
                        config.setAuthenticationMethod(DaapConfig.USERNAME_AND_PASSWORD);
                        config.setAuthenticationScheme(DaapConfig.DIGEST_SCHEME);
                    } else {
                        config.setAuthenticationMethod(DaapConfig.PASSWORD);
                        config.setAuthenticationScheme(DaapConfig.BASIC_SCHEME);
                    }
                } else {
                    config.setAuthenticationMethod(DaapConfig.NO_PASSWORD);
                    config.setAuthenticationScheme(DaapConfig.BASIC_SCHEME);
                }
                this.server = new LimeDaapServerNIO(this.library, config, this.backgroundExecutor);
                this.server.setAuthenticator(new LimeAuthenticator());
                this.server.setStreamSource(new LimeStreamSource());
                this.server.setFilter(new LimeFilter());
                int maxAttempts = 10;
                for (int i = 0; i < 10; ++i) {
                    try {
                        this.server.bind();
                        break;
                    }
                    catch (BindException bindErr) {
                        if (i >= 9) {
                            throw bindErr;
                        }
                        config.nextPort();
                        continue;
                    }
                }
                this.server.run();
                this.bonjour.registerService();
            }
            catch (IOException err) {
                this.stop();
                throw err;
            }
        }
        if (this.isServerRunning()) {
            this.setEnabled(this.enabled);
        }
    }

    public synchronized void stop() {
        if (this.bonjour != null) {
            this.bonjour.close();
        }
        if (this.server != null) {
            this.server.stop();
        }
        if (this.urnToSong != null) {
            this.urnToSong.clear();
        }
        this.bonjour = null;
        this.server = null;
        this.urnToSong = null;
        this.library = null;
        this.whatsNew = null;
        this.creativecommons = null;
        this.database = null;
        this.autoCommitTxn = null;
    }

    public synchronized void restart() throws IOException {
        if (this.isServerRunning()) {
            this.stop();
        }
        this.start();
    }

    public void doFinalize() {
        this.stop();
    }

    public synchronized void updateService() throws IOException {
        if (this.isServerRunning()) {
            this.bonjour.updateService();
            Transaction txn = this.library.beginTransaction();
            String name = DaapSettings.DAAP_LIBRARY_NAME.get();
            this.library.setName(txn, name);
            this.masterPlaylist.setName(txn, name);
            this.database.setName(txn, name);
            DaapConfig config = this.server.getConfig();
            if (DaapSettings.DAAP_REQUIRES_PASSWORD.getValue()) {
                if (DaapSettings.DAAP_REQUIRES_USERNAME.getValue()) {
                    config.setAuthenticationMethod(DaapConfig.USERNAME_AND_PASSWORD);
                    config.setAuthenticationScheme(DaapConfig.DIGEST_SCHEME);
                } else {
                    config.setAuthenticationMethod(DaapConfig.PASSWORD);
                    config.setAuthenticationScheme(DaapConfig.BASIC_SCHEME);
                }
            } else {
                config.setAuthenticationMethod(DaapConfig.NO_PASSWORD);
                config.setAuthenticationScheme(DaapConfig.BASIC_SCHEME);
            }
            txn.commit();
        }
    }

    public synchronized void disconnectAll() {
        if (this.isServerRunning()) {
            this.server.disconnectAll();
        }
    }

    public synchronized boolean isServerRunning() {
        if (this.server != null) {
            return this.server.isRunning();
        }
        return false;
    }

    private static boolean isSupportedAudioFormat(String name) {
        return DaapManager.isSupportedFormat(DaapSettings.DAAP_SUPPORTED_AUDIO_FILE_TYPES.get(), name);
    }

    private static boolean isSupportedVideoFormat(String name) {
        return DaapManager.isSupportedFormat(DaapSettings.DAAP_SUPPORTED_VIDEO_FILE_TYPES.get(), name);
    }

    private static boolean isSupportedFormat(String[] types, String name) {
        for (String type : types) {
            if (!name.endsWith(type)) continue;
            return true;
        }
        return false;
    }

    private synchronized void handleChangeEvent(FileViewChangeEvent evt) {
        Song song = this.urnToSong.remove(evt.getOldValue().getSHA1Urn());
        if (song != null) {
            this.urnToSong.put(evt.getFileDesc().getSHA1Urn(), song);
            boolean rename = evt.getOldValue().getSHA1Urn().equals(evt.getFileDesc().getSHA1Urn());
            if (rename) {
                song.setAttachment(evt.getFileDesc());
            } else {
                String name = evt.getFileDesc().getFileName().toLowerCase(Locale.US);
                if (DaapManager.isSupportedAudioFormat(name)) {
                    this.updateSongAudioMeta(this.autoCommitTxn, song, evt.getFileDesc());
                } else if (DaapManager.isSupportedVideoFormat(name)) {
                    this.updateSongVideoMeta(this.autoCommitTxn, song, evt.getFileDesc());
                } else {
                    this.database.removeSong(this.autoCommitTxn, song);
                }
            }
        }
    }

    private synchronized void handleMetaChangeEvent(FileViewChangeEvent evt) {
        URN urn = evt.getFileDesc().getSHA1Urn();
        Song song = this.urnToSong.get(urn);
        if (song != null) {
            String name = evt.getFileDesc().getFileName().toLowerCase(Locale.US);
            if (DaapManager.isSupportedAudioFormat(name)) {
                this.updateSongAudioMeta(this.autoCommitTxn, song, evt.getFileDesc());
            } else if (DaapManager.isSupportedVideoFormat(name)) {
                this.updateSongVideoMeta(this.autoCommitTxn, song, evt.getFileDesc());
            } else {
                this.database.removeSong(this.autoCommitTxn, song);
            }
        } else {
            this.handleAddEvent(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleAddEvent(FileViewChangeEvent evt) {
        de.kapsi.net.daap.Library library = this.library;
        synchronized (library) {
            if (this.database.getSongCount() >= this.maxPlaylistSize) {
                return;
            }
        }
        FileDesc fileDesc = evt.getFileDesc();
        if (!(fileDesc instanceof IncompleteFileDesc)) {
            String name = fileDesc.getFileName().toLowerCase(Locale.US);
            Song song = null;
            if (DaapManager.isSupportedAudioFormat(name)) {
                song = this.createSong(fileDesc, true);
            } else if (DaapManager.isSupportedVideoFormat(name)) {
                song = this.createSong(fileDesc, false);
            }
            if (song != null) {
                this.urnToSong.put(fileDesc.getSHA1Urn(), song);
                this.database.getMasterPlaylist().addSong(this.autoCommitTxn, song);
                this.whatsNew.addSong(this.autoCommitTxn, song);
                if (fileDesc.isLicensed()) {
                    this.creativecommons.addSong(this.autoCommitTxn, song);
                }
                if (DaapManager.isSupportedVideoFormat(name)) {
                    this.videos.addSong(this.autoCommitTxn, song);
                }
            }
        }
    }

    private synchronized void handleRemoveEvent(FileViewChangeEvent evt) {
        Song song = this.urnToSong.remove(evt.getFileDesc().getSHA1Urn());
        if (song != null) {
            this.database.removeSong(this.autoCommitTxn, song);
            song.setAttachment(null);
        }
    }

    private synchronized void handleClearEvent() {
        for (Song song : this.urnToSong.values()) {
            if (song == null) continue;
            this.database.removeSong(this.autoCommitTxn, song);
            song.setAttachment(null);
        }
        this.urnToSong.clear();
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled || !this.isServerRunning()) {
            return;
        }
        HashMap<URN, Song> tmpUrnToSong = new HashMap<URN, Song>();
        int size = this.masterPlaylist.getSongCount();
        Transaction txn = this.library.beginTransaction();
        this.gnutellaFileView.getReadLock().lock();
        try {
            for (FileDesc fd : this.gnutellaFileView) {
                String name = fd.getFileName().toLowerCase(Locale.US);
                boolean audio = DaapManager.isSupportedAudioFormat(name);
                if (!audio && !DaapManager.isSupportedVideoFormat(name)) continue;
                URN urn = fd.getSHA1Urn();
                Song song = this.urnToSong.remove(urn);
                if (tmpUrnToSong.containsKey(urn)) continue;
                if (song != null) {
                    tmpUrnToSong.put(urn, song);
                    if (audio) {
                        this.updateSongAudioMeta(txn, song, fd);
                        continue;
                    }
                    this.updateSongVideoMeta(txn, song, fd);
                    continue;
                }
                if (size >= this.maxPlaylistSize) continue;
                song = this.createSong(fd, audio);
                tmpUrnToSong.put(urn, song);
                this.database.getMasterPlaylist().addSong(txn, song);
                if (fd.isLicensed()) {
                    this.creativecommons.addSong(txn, song);
                }
                if (DaapManager.isSupportedVideoFormat(name)) {
                    this.videos.addSong(txn, song);
                }
                ++size;
            }
        }
        finally {
            this.gnutellaFileView.getReadLock().unlock();
        }
        for (Song song : this.urnToSong.values()) {
            this.database.removeSong(txn, song);
            song.setAttachment(null);
        }
        this.urnToSong.clear();
        this.urnToSong = tmpUrnToSong;
        txn.commit();
    }

    private Song createSong(FileDesc desc, boolean audio) {
        Song song = new Song(desc.getFileName());
        song.setSize(null, desc.getFileSize() & 0xFFFFFFFFL);
        song.setDateAdded(null, System.currentTimeMillis() / 1000L);
        File file = desc.getFile();
        String ext = FileUtils.getFileExtension(file);
        if (!audio) {
            song.setHasVideo(null, true);
        }
        if (!ext.isEmpty()) {
            if (!(ext = ext.toLowerCase(Locale.US)).endsWith("mp3")) {
                song.setFormat(null, ext);
            }
            if (audio) {
                this.updateSongAudioMeta(null, song, desc);
            } else {
                this.updateSongVideoMeta(null, song, desc);
            }
        } else {
            song.setAttachment(desc);
        }
        return song;
    }

    private boolean updateSongVideoMeta(Transaction txn, Song song, FileDesc desc) {
        String currentTitle;
        song.setAttachment(desc);
        LimeXMLDocument doc = desc.getXMLDocument("http://www.limewire.com/schemas/video.xsd");
        if (doc == null) {
            return false;
        }
        boolean update2 = false;
        String title = doc.getValue("videos__video__title__");
        String year = doc.getValue("videos__video__year__");
        String rating = doc.getValue("videos__video__rating__");
        String length = doc.getValue("videos__video__length__");
        String license = doc.getValue("videos__video__license__");
        String bitrate = doc.getValue("videos__video__bitrate__");
        String director = doc.getValue("videos__video__director__");
        if (!(title == null || (currentTitle = song.getName()) != null && title.equals(currentTitle))) {
            update2 = true;
            song.setName(txn, title);
        }
        int currentBitrate = song.getBitrate();
        if (bitrate != null) {
            try {
                int num = Integer.parseInt(bitrate);
                if (num > 0 && num != currentBitrate) {
                    update2 = true;
                    song.setBitrate(txn, num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentBitrate != 0) {
            update2 = true;
            song.setBitrate(txn, 0);
        }
        long currentLength = song.getTime();
        if (length != null) {
            try {
                int num = (int)((long)Integer.parseInt(length) * 1000L);
                if (num > 0 && (long)num != currentLength) {
                    update2 = true;
                    song.setTime(txn, num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentLength != 0L) {
            update2 = true;
            song.setTime(txn, 0L);
        }
        int currentYear = song.getYear();
        if (year != null) {
            try {
                int num = Integer.parseInt(year);
                if (num > 0 && num != currentYear) {
                    update2 = true;
                    song.setYear(txn, num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentYear != 0) {
            update2 = true;
            song.setYear(txn, 0);
        }
        String currentGenre = song.getGenre();
        if (license != null) {
            if (currentGenre == null || !license.equals(currentGenre)) {
                update2 = true;
                song.setGenre(txn, license);
            }
        } else if (currentGenre != null) {
            update2 = true;
            song.setGenre(txn, null);
        }
        String currentArtist = song.getArtist();
        if (director != null) {
            if (currentArtist == null || !director.equals(currentArtist)) {
                update2 = true;
                song.setArtist(txn, director);
            }
        } else if (currentArtist != null) {
            update2 = true;
            song.setArtist(txn, null);
        }
        String currentAlbum = song.getAlbum();
        if (rating != null) {
            if (currentAlbum == null || !rating.equals(currentAlbum)) {
                update2 = true;
                song.setAlbum(txn, rating);
            }
        } else if (currentAlbum != null) {
            update2 = true;
            song.setAlbum(txn, null);
        }
        return update2;
    }

    private boolean updateSongAudioMeta(Transaction txn, Song song, FileDesc desc) {
        String currentTitle;
        song.setAttachment(desc);
        LimeXMLDocument doc = desc.getXMLDocument("http://www.limewire.com/schemas/audio.xsd");
        if (doc == null) {
            return false;
        }
        boolean update2 = false;
        String title = doc.getValue("audios__audio__title__");
        String track = doc.getValue("audios__audio__track__");
        String artist = doc.getValue("audios__audio__artist__");
        String album = doc.getValue("audios__audio__album__");
        String genre = doc.getValue("audios__audio__genre__");
        String bitrate = doc.getValue("audios__audio__bitrate__");
        String time = doc.getValue("audios__audio__seconds__");
        String year = doc.getValue("audios__audio__year__");
        if (!(title == null || (currentTitle = song.getName()) != null && title.equals(currentTitle))) {
            update2 = true;
            song.setName(txn, title);
        }
        int currentTrack = song.getTrackNumber();
        if (track != null) {
            try {
                int num = Integer.parseInt(track);
                if (num > 0 && num != currentTrack) {
                    update2 = true;
                    song.setTrackNumber(txn, num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentTrack != 0) {
            update2 = true;
            song.setTrackNumber(txn, 0);
        }
        String currentArtist = song.getArtist();
        if (artist != null) {
            if (currentArtist == null || !artist.equals(currentArtist)) {
                update2 = true;
                song.setArtist(txn, artist);
            }
        } else if (currentArtist != null) {
            update2 = true;
            song.setArtist(txn, null);
        }
        String currentAlbum = song.getAlbum();
        if (album != null) {
            if (currentAlbum == null || !album.equals(currentAlbum)) {
                update2 = true;
                song.setAlbum(txn, album);
            }
        } else if (currentAlbum != null) {
            update2 = true;
            song.setAlbum(txn, null);
        }
        String currentGenre = song.getGenre();
        if (genre != null) {
            if (currentGenre == null || !genre.equals(currentGenre)) {
                update2 = true;
                song.setGenre(txn, genre);
            }
        } else if (currentGenre != null) {
            update2 = true;
            song.setGenre(txn, null);
        }
        int currentBitrate = song.getBitrate();
        if (bitrate != null) {
            try {
                int num = Integer.parseInt(bitrate);
                if (num > 0 && num != currentBitrate) {
                    update2 = true;
                    song.setBitrate(txn, num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentBitrate != 0) {
            update2 = true;
            song.setBitrate(txn, 0);
        }
        long currentTime = song.getTime();
        if (time != null) {
            try {
                long num = (long)Integer.parseInt(time) * 1000L;
                if (num > 0L && num != currentTime) {
                    update2 = true;
                    song.setTime(txn, num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentTime != 0L) {
            update2 = true;
            song.setTime(txn, 0L);
        }
        int currentYear = song.getYear();
        if (year != null) {
            try {
                int num = Integer.parseInt(year);
                if (num > 0 && num != currentYear) {
                    update2 = true;
                    song.setYear(txn, num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentYear != 0) {
            update2 = true;
            song.setYear(txn, 0);
        }
        int mod = (int)(desc.lastModified() / 1000L);
        if (song.getDateModified() != (long)mod) {
            update2 = true;
            song.setDateModified(txn, mod);
        }
        return update2;
    }

    private void handleManagedListStatusEvent(final LibraryStatusEvent evt) {
        DAAP_EVENT_QUEUE.execute(new Runnable(){

            @Override
            public void run() {
                switch (evt.getType()) {
                    case LOAD_COMPLETE: {
                        DaapManager.this.setEnabled(true);
                    }
                }
            }
        });
    }

    private void handleFileListEvent(final FileViewChangeEvent evt) {
        if (!DaapSettings.DAAP_ENABLED.getValue()) {
            return;
        }
        DAAP_EVENT_QUEUE.execute(new Runnable(){

            @Override
            public void run() {
                if (!DaapManager.this.isEnabled() || !DaapManager.this.isServerRunning()) {
                    return;
                }
                switch (evt.getType()) {
                    case FILE_CHANGED: {
                        DaapManager.this.handleChangeEvent(evt);
                        break;
                    }
                    case FILE_ADDED: {
                        DaapManager.this.handleAddEvent(evt);
                        break;
                    }
                    case FILE_REMOVED: {
                        DaapManager.this.handleRemoveEvent(evt);
                        break;
                    }
                    case FILES_CLEARED: {
                        DaapManager.this.handleClearEvent();
                        break;
                    }
                    case FILE_META_CHANGED: {
                        DaapManager.this.handleMetaChangeEvent(evt);
                    }
                }
            }
        });
    }

    private static final class BonjourService {
        private static final String VERSION = "Version";
        private static final String MACHINE_NAME = "Machine Name";
        private static final String PASSWORD = "Password";
        private final JmDNS zeroConf;
        private ServiceInfo serviceInfo;

        public BonjourService(InetAddress addr) throws IOException {
            this.zeroConf = new JmDNS(addr);
        }

        public boolean isRegistered() {
            return this.serviceInfo != null;
        }

        private ServiceInfo createServiceInfo() {
            String type = DaapSettings.DAAP_TYPE_NAME.get();
            String name = DaapSettings.DAAP_SERVICE_NAME.get();
            int port = DaapSettings.DAAP_PORT.getValue();
            int weight = DaapSettings.DAAP_WEIGHT.getValue();
            int priority = DaapSettings.DAAP_PRIORITY.getValue();
            boolean password = DaapSettings.DAAP_REQUIRES_PASSWORD.getValue();
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put(VERSION, Integer.toString(196608));
            props.put(MACHINE_NAME, name);
            props.put(PASSWORD, Boolean.toString(password));
            String qualifiedName = null;
            qualifiedName = password ? name + "_PW." + type : name + "." + type;
            return new ServiceInfo(type, qualifiedName, port, weight, priority, props);
        }

        public void registerService() throws IOException {
            if (this.isRegistered()) {
                throw new IOException();
            }
            ServiceInfo serviceInfo = this.createServiceInfo();
            this.zeroConf.registerService(serviceInfo);
            this.serviceInfo = serviceInfo;
        }

        public void unregisterService() {
            if (!this.isRegistered()) {
                return;
            }
            this.zeroConf.unregisterService(this.serviceInfo);
            this.serviceInfo = null;
        }

        public void updateService() throws IOException {
            if (!this.isRegistered()) {
                throw new IOException();
            }
            if (this.serviceInfo.getPort() != DaapSettings.DAAP_PORT.getValue()) {
                this.unregisterService();
            }
            ServiceInfo serviceInfo = this.createServiceInfo();
            this.zeroConf.registerService(serviceInfo);
            this.serviceInfo = serviceInfo;
        }

        public void close() {
            this.unregisterService();
            this.zeroConf.close();
        }
    }

    private static final class LimeConfig
    extends DaapConfig {
        private InetAddress addr;

        public LimeConfig(InetAddress addr) {
            this.addr = addr;
            DaapSettings.DAAP_PORT.revertToDefault();
        }

        @Override
        public String getServerName() {
            return LimeWireUtils.getHttpServer();
        }

        public void nextPort() {
            int port = DaapSettings.DAAP_PORT.getValue();
            DaapSettings.DAAP_PORT.setValue(port + 1);
        }

        @Override
        public int getBacklog() {
            return 0;
        }

        @Override
        public InetSocketAddress getInetSocketAddress() {
            int port = DaapSettings.DAAP_PORT.getValue();
            return new InetSocketAddress(this.addr, port);
        }

        @Override
        public int getMaxConnections() {
            return DaapSettings.DAAP_MAX_CONNECTIONS.getValue();
        }
    }

    private final class LimeFilter
    implements DaapFilter {
        private LimeFilter() {
        }

        @Override
        public boolean accept(InetAddress address) {
            try {
                return (((NetworkInstanceUtils)DaapManager.this.networkInstanceUtils.get()).isVeryCloseIP(address) || ((NetworkInstanceUtils)DaapManager.this.networkInstanceUtils.get()).isPrivateAddress(address)) && ((IPFilter)DaapManager.this.ipFilter.get()).allow(address.getAddress());
            }
            catch (IllegalArgumentException err) {
                LOG.error(err);
                return false;
            }
        }
    }

    private static final class LimeAuthenticator
    implements DaapAuthenticator {
        private LimeAuthenticator() {
        }

        @Override
        public boolean authenticate(String username, String password, String uri, String nonce) {
            if (uri == null && nonce == null) {
                return DaapSettings.DAAP_PASSWORD.equals(password);
            }
            if (uri != null && nonce != null) {
                String ha1 = DaapSettings.DAAP_PASSWORD.get();
                if (ha1.startsWith("MD5/")) {
                    ha1 = ha1.substring(4);
                }
                String ha2 = DaapUtil.calculateHA2(uri);
                String digest = DaapUtil.digest(ha1, ha2, nonce);
                return digest.equalsIgnoreCase(password);
            }
            if (LOG.isErrorEnabled()) {
                LOG.error("Unknown scheme!");
            }
            return false;
        }
    }

    private static final class LimeStreamSource
    implements DaapStreamSource {
        private LimeStreamSource() {
        }

        @Override
        public Object getSource(Song song) throws IOException {
            FileDesc fileDesc = (FileDesc)song.getAttachment();
            if (fileDesc != null) {
                return new FileInputStream(fileDesc.getFile());
            }
            return null;
        }
    }
}

